package info.scce.dime.profile.editor.graphiti.features.move;

class MoveFeatureGUIPrimitiveOutputPortReferencingOutputPort extends de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoMoveShapeFeature {
	
	var de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK
	
	/**
	 * Call of the Superclass
	 * @param fp: Fp is the parameter of the Superclass-Call
	*/
	new(org.eclipse.graphiti.features.IFeatureProvider fp) {
		super(fp)
	}
	
	/**
	 * Checks if a shape is moveable
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @param apiCall : Apicall shows if the Cinco Api is used
	 * @return Returns true if a shape can be moved and false if not
	*/
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context, boolean apiCall) {
		if (apiCall) {
			val source = context.sourceContainer.businessObjectForPictogramElement
			val target = context.targetContainer.businessObjectForPictogramElement
			if (target instanceof graphmodel.internal.InternalModelElementContainer) {
				if (target == source) {
					return true
				}
				if (target.canContain(info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort)) {
					return true
				}
			}
			if (error === de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK) {
				error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.INVALID_CONTAINER
			}
			return false
		}
		return false
	}
	
	/**
	 * Checks if a shape is moveable by using the method 'canMoveShape(context,apiCall)'
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @return Returns true if a shape can be moved and false if not
	 */
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return canMoveShape(context, false)
	}
	
	/**
	 * Moves a Shape by removing the shape at the source and adding it at the target
	 * @param context : Contains the information, needed to let a feature move a shape
	 */
	override void moveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		val o = context.shape.businessObjectForPictogramElement as info.scce.dime.profile.profile.internal.InternalGUIPrimitiveOutputPortReferencingOutputPort
		val target = context.targetContainer.businessObjectForPictogramElement as graphmodel.internal.InternalModelElementContainer
		
		super.moveShape(context)
		
		if (o.element instanceof info.scce.dime.profile.editor.graphiti.api.CGUIPrimitiveOutputPortReferencingOutputPort) {
			if(!moveContainer(target, o.element as info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort, context)) {
				(o.element as info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort)
					.moveTo(target.containerElement, context.x, context.y)
			}
		}
	}
	
	def dispatch moveContainer(graphmodel.internal.InternalModelElementContainer target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return false
	}
	
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalProfile target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.Profile, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.Branch, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalReplacementBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.ReplacementBranch, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalBranchReferencingBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.BranchReferencingBranch, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalButtonReferencingBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.ButtonReferencingBranch, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalEndSIBReferencingBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.EndSIBReferencingBranch, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalOutputReferencingBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.OutputReferencingBranch, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.profile.profile.internal.InternalBlueprintBranch target, info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.profile.profile.BlueprintBranch, context.x, context.y)
		return true
	}
	
	/**
	 * Get-method for an error
	 * @return Returns an 'error' in which 'error' is  'ECincoError.OK'
	 */
	override de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError getError() {
		return error
	}
	
	/**
	 * Set-method for an error
	 * @param error : Error is a value of the enum: MAX_CARDINALITY, MAX_IN, MAX_OUT, INVALID_SOURCE, INVALID_TARGET, INVALID_CONTAINER, INVALID_CLONE_TARGET, OK
	 */
	def void setError(de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error) {
		this.error = error
	}
	
}
