package info.scce.dime.process.editor.graphiti.features.move;

class MoveFeaturePrimitiveAttributePort extends de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoMoveShapeFeature {
	
	var de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK
	
	/**
	 * Call of the Superclass
	 * @param fp: Fp is the parameter of the Superclass-Call
	*/
	new(org.eclipse.graphiti.features.IFeatureProvider fp) {
		super(fp)
	}
	
	/**
	 * Checks if a shape is moveable
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @param apiCall : Apicall shows if the Cinco Api is used
	 * @return Returns true if a shape can be moved and false if not
	*/
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context, boolean apiCall) {
		if (apiCall) {
			val source = context.sourceContainer.businessObjectForPictogramElement
			val target = context.targetContainer.businessObjectForPictogramElement
			if (target instanceof graphmodel.internal.InternalModelElementContainer) {
				if (target == source) {
					return true
				}
				if (target.canContain(info.scce.dime.process.process.PrimitiveAttributePort)) {
					return true
				}
			}
			if (error === de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK) {
				error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.INVALID_CONTAINER
			}
			return false
		}
		return false
	}
	
	/**
	 * Checks if a shape is moveable by using the method 'canMoveShape(context,apiCall)'
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @return Returns true if a shape can be moved and false if not
	 */
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return canMoveShape(context, false)
	}
	
	/**
	 * Moves a Shape by removing the shape at the source and adding it at the target
	 * @param context : Contains the information, needed to let a feature move a shape
	 */
	override void moveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		val o = context.shape.businessObjectForPictogramElement as info.scce.dime.process.process.internal.InternalPrimitiveAttributePort
		val target = context.targetContainer.businessObjectForPictogramElement as graphmodel.internal.InternalModelElementContainer
		
		super.moveShape(context)
		
		if (o.element instanceof info.scce.dime.process.editor.graphiti.api.CPrimitiveAttributePort) {
			if(!moveContainer(target, o.element as info.scce.dime.process.process.PrimitiveAttributePort, context)) {
				(o.element as info.scce.dime.process.process.PrimitiveAttributePort)
					.moveTo(target.containerElement, context.x, context.y)
			}
		}
	}
	
	def dispatch moveContainer(graphmodel.internal.InternalModelElementContainer target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return false
	}
	
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalDummyContainer target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.DummyContainer, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalDataFlowTarget target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.DataFlowTarget, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalEndSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.EndSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalEventListener target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.EventListener, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.SIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalSearchSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.SearchSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalCreateSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.CreateSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalTransientCreateSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.TransientCreateSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalCreateUserSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.CreateUserSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalAbstractContainsSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.AbstractContainsSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalContainsSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.ContainsSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.ContainsJavaNativeSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.ContainsPrimitiveSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalIsOfTypeSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.IsOfTypeSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalAbstractIterateSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.AbstractIterateSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalIterateSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.IterateSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.IterateJavaNativeSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.IteratePrimitiveSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalPutComplexToContextSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.PutComplexToContextSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalPutToContextSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.PutToContextSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalTriggerEventSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.TriggerEventSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.RetrieveOfTypeSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.RetrieveCurrentUserSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalSwitchToUserSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.SwitchToUserSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGetOriginalUserSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GetOriginalUserSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.SwitchToOriginalUserSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalDeleteSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.DeleteSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalRemoveFromListSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.RemoveFromListSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.PutPrimitiveToContextSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalLinkProcessSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.LinkProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalEnumSwitchSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.EnumSwitchSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.RetrieveEnumLiteralSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalSetAttributeValueSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.SetAttributeValueSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.UnsetAttributeValueSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalAtomicSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.AtomicSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalProcessSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.ProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGenericSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GenericSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.ProcessPlaceholderSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGUISIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GUISIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGuardContainer target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GuardContainer, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGuardedProcessSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GuardedProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalEntryPointProcessSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.EntryPointProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGuardProcessSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GuardProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalBlueprintSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.BlueprintSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalProcessBlueprintSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.ProcessBlueprintSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalGUIBlueprintSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.GUIBlueprintSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalNativeFrontendSIB target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.NativeFrontendSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference target, info.scce.dime.process.process.PrimitiveAttributePort oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.NativeFrontendSIBReference, context.x, context.y)
		return true
	}
	
	/**
	 * Get-method for an error
	 * @return Returns an 'error' in which 'error' is  'ECincoError.OK'
	 */
	override de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError getError() {
		return error
	}
	
	/**
	 * Set-method for an error
	 * @param error : Error is a value of the enum: MAX_CARDINALITY, MAX_IN, MAX_OUT, INVALID_SOURCE, INVALID_TARGET, INVALID_CONTAINER, INVALID_CLONE_TARGET, OK
	 */
	def void setError(de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error) {
		this.error = error
	}
	
}
