package info.scce.dime.process.editor.graphiti.features.move;

class MoveFeatureLongRunningProcess extends de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoMoveShapeFeature {
	
	var de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK
	
	/**
	 * Call of the Superclass
	 * @param fp: Fp is the parameter of the Superclass-Call
	*/
	new(org.eclipse.graphiti.features.IFeatureProvider fp) {
		super(fp)
	}
	
	/**
	 * Checks if a shape is moveable
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @param apiCall : Apicall shows if the Cinco Api is used
	 * @return Returns true if a shape can be moved and false if not
	*/
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context, boolean apiCall) {
		if (apiCall) {
			val source = context.sourceContainer.businessObjectForPictogramElement
			val target = context.targetContainer.businessObjectForPictogramElement
			if (target instanceof graphmodel.internal.InternalModelElementContainer) {
				if (target == source) {
					return true
				}
				if (target.canContain(info.scce.dime.process.process.LongRunningProcess)) {
					return true
				}
			}
			if (error === de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK) {
				error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.INVALID_CONTAINER
			}
			return false
		}
		return false
	}
	
	/**
	 * Checks if a shape is moveable by using the method 'canMoveShape(context,apiCall)'
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @return Returns true if a shape can be moved and false if not
	 */
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return canMoveShape(context, true)
	}
	
	/**
	 * Moves a Shape by removing the shape at the source and adding it at the target
	 * @param context : Contains the information, needed to let a feature move a shape
	 */
	override void moveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		val o = context.shape.businessObjectForPictogramElement as info.scce.dime.process.process.internal.InternalLongRunningProcess
		val target = context.targetContainer.businessObjectForPictogramElement as graphmodel.internal.InternalModelElementContainer
		
		super.moveShape(context)
		
		if (o.element instanceof info.scce.dime.process.editor.graphiti.api.CLongRunningProcess) {
			if(!moveContainer(target, o.element as info.scce.dime.process.process.LongRunningProcess, context)) {
				(o.element as info.scce.dime.process.process.LongRunningProcess)
					.moveTo(target.containerElement, context.x, context.y)
			}
		}
	}
	
	def dispatch moveContainer(graphmodel.internal.InternalModelElementContainer target, info.scce.dime.process.process.LongRunningProcess oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return false
	}
	
	def dispatch moveContainer(info.scce.dime.process.process.internal.InternalProcess target, info.scce.dime.process.process.LongRunningProcess oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.process.process.Process, context.x, context.y)
		return true
	}
	
	/**
	 * Get-method for an error
	 * @return Returns an 'error' in which 'error' is  'ECincoError.OK'
	 */
	override de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError getError() {
		return error
	}
	
	/**
	 * Set-method for an error
	 * @param error : Error is a value of the enum: MAX_CARDINALITY, MAX_IN, MAX_OUT, INVALID_SOURCE, INVALID_TARGET, INVALID_CONTAINER, INVALID_CLONE_TARGET, OK
	 */
	def void setError(de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error) {
		this.error = error
	}
	
}
