package info.scce.dime.gui.editor.graphiti.features.move;

class MoveFeatureMoveUp extends de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoMoveShapeFeature {
	
	var de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK
	
	/**
	 * Call of the Superclass
	 * @param fp: Fp is the parameter of the Superclass-Call
	*/
	new(org.eclipse.graphiti.features.IFeatureProvider fp) {
		super(fp)
	}
	
	/**
	 * Checks if a shape is moveable
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @param apiCall : Apicall shows if the Cinco Api is used
	 * @return Returns true if a shape can be moved and false if not
	*/
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context, boolean apiCall) {
		if (apiCall) {
			val source = context.sourceContainer.businessObjectForPictogramElement
			val target = context.targetContainer.businessObjectForPictogramElement
			if (target instanceof graphmodel.internal.InternalModelElementContainer) {
				if (target == source) {
					return true
				}
				if (target.canContain(info.scce.dime.gui.gui.MoveUp)) {
					return true
				}
			}
			if (error === de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.OK) {
				error = de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError.INVALID_CONTAINER
			}
			return false
		}
		return false
	}
	
	/**
	 * Checks if a shape is moveable by using the method 'canMoveShape(context,apiCall)'
	 * @param context : Contains the information, needed to let a feature move a shape
	 * @return Returns true if a shape can be moved and false if not
	 */
	override boolean canMoveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return canMoveShape(context, false)
	}
	
	/**
	 * Moves a Shape by removing the shape at the source and adding it at the target
	 * @param context : Contains the information, needed to let a feature move a shape
	 */
	override void moveShape(org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		val o = context.shape.businessObjectForPictogramElement as info.scce.dime.gui.gui.internal.InternalMoveUp
		val target = context.targetContainer.businessObjectForPictogramElement as graphmodel.internal.InternalModelElementContainer
		
		super.moveShape(context)
		
		if (o.element instanceof info.scce.dime.gui.editor.graphiti.api.CMoveUp) {
			if(!moveContainer(target, o.element as info.scce.dime.gui.gui.MoveUp, context)) {
				(o.element as info.scce.dime.gui.gui.MoveUp)
					.moveTo(target.containerElement, context.x, context.y)
			}
		}
	}
	
	def dispatch moveContainer(graphmodel.internal.InternalModelElementContainer target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		return false
	}
	
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalMovableContainer target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.MovableContainer, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalBaseElement target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.BaseElement, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalProcessSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.ProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.SIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalControlSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.ControlSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalIFSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.IFSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalISSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.ISSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalFORSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.FORSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalSecuritySIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.SecuritySIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalGUISIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.GUISIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalDispatchedGUISIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.DispatchedGUISIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalGuardSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.GuardSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalGUIPlugin target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.GUIPlugin, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalArgument target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Argument, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalPlaceholder target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Placeholder, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalRow target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Row, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalSpecialElement target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.SpecialElement, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalTODOList target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.TODOList, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalCol target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Col, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalHeadline target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Headline, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalText target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Text, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalListing target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Listing, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalDescription target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Description, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalListentry target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Listentry, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalDescriptionentry target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Descriptionentry, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalTable target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Table, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalTableEntry target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.TableEntry, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalForm target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Form, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalFormEntry target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.FormEntry, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalInput target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Input, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalFile target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.File, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalField target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Field, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalSelect target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Select, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalRadio target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Radio, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalCombobox target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Combobox, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalCheckbox target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Checkbox, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalButton target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Button, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalLinkSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.LinkSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalLinkProcessSIB target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.LinkProcessSIB, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalButtonToolbar target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.ButtonToolbar, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalButtonGroup target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.ButtonGroup, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalDropdown target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Dropdown, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalImage target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Image, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalThumbnail target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Thumbnail, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalAlert target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Alert, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalPageUp target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.PageUp, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalProgressBar target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.ProgressBar, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalJumbotron target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Jumbotron, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalEmbedded target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Embedded, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalPanel target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Panel, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalBox target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Box, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalBadge target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Badge, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalTabbing target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Tabbing, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalTab target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Tab, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalBar target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.Bar, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalTopNavBar target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.TopNavBar, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalBottomNavBar target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.BottomNavBar, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalNavBarPart target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.NavBarPart, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalRightNavBarPart target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.RightNavBarPart, context.x, context.y)
		return true
	}
	def dispatch moveContainer(info.scce.dime.gui.gui.internal.InternalLeftNavBarPart target, info.scce.dime.gui.gui.MoveUp oe, org.eclipse.graphiti.features.context.IMoveShapeContext context) {
		oe.moveTo(target.containerElement as info.scce.dime.gui.gui.LeftNavBarPart, context.x, context.y)
		return true
	}
	
	/**
	 * Get-method for an error
	 * @return Returns an 'error' in which 'error' is  'ECincoError.OK'
	 */
	override de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError getError() {
		return error
	}
	
	/**
	 * Set-method for an error
	 * @param error : Error is a value of the enum: MAX_CARDINALITY, MAX_IN, MAX_OUT, INVALID_SOURCE, INVALID_TARGET, INVALID_CONTAINER, INVALID_CLONE_TARGET, OK
	 */
	def void setError(de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError error) {
		this.error = error
	}
	
}
