/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
/*
* generated by Xtext
*/
package de.jabc.cinco.meta.core.mgl.ui.quickfix

import de.jabc.cinco.meta.core.mgl.validation.MGLValidator
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.jdt.core.IJavaProject
import org.eclipse.jdt.core.IType
import org.eclipse.jdt.core.JavaCore
import org.eclipse.xtext.ui.editor.model.edit.IModification
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider
import org.eclipse.xtext.ui.editor.quickfix.Fix
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor
import org.eclipse.xtext.validation.Issue
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext

/**
 * Custom quickfixes.
 *
 * see http://www.eclipse.org/Xtext/documentation.html#quickfixes
 */
class MGLQuickfixProvider extends DefaultQuickfixProvider {

	@Fix(MGLValidator::NOT_EXPORTED)
	def exportPackage(Issue issue, IssueResolutionAcceptor acceptor) {
		acceptor.accept(issue, 'Export the corresponding package', 'Export the corresponding package', null, new IModification{
			
			override apply(IModificationContext context) throws Exception {
				var IssueModificationContext iContext 
				if (context instanceof IssueModificationContext)
					iContext = context
				val length = iContext.issue.length
				val offset = iContext.issue.offset
				val package = context.xtextDocument.get(offset, length).replace("\"", "")
				val correctFile = findClass(package)  
				if(correctFile !== null){
					if(correctFile.exists ){ 
						val packageExport = correctFile.packageFragment.elementName  
						val root = ResourcesPlugin.getWorkspace().getRoot();
						val projects = root.getProjects();
						for(IProject project : projects){
							val correctPackage = findPackage(package)
							if(correctPackage !== null){
								if(project.getName().equals(correctPackage.elementName)){
									val project1 = project;
									ProjectCreator.exportPackage(project1, packageExport); 
								}
							}
						}
					}
					
				}
			}
		
		})
	}
	def findPackage(String parameter) { 
		var IType javaClass = null
		val root = ResourcesPlugin.workspace.root
		val projects = root.projects
		for(project : projects){
			var jproject = JavaCore.create(project) as IJavaProject
			if(jproject.exists){
				try {
						javaClass = jproject.findType(parameter)
						if (javaClass !== null) {
							return jproject
						}
					} catch (Exception e) {}
		}
		
		}
		return null;
	}
	
	def findClass(String parameter){
		var IType javaClass = null
		val root = ResourcesPlugin.workspace.root
		val projects = root.projects
		for(project : projects){
			var jproject = JavaCore.create(project) as IJavaProject
			if(jproject.exists){
				try {
						javaClass = jproject.findType(parameter)
						if (javaClass !== null) {
							return javaClass 
						}
					} catch (Exception e) {}
		}
		
		}
		return javaClass
	
	}
}
