/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
/*
 * generated by Xtext
 */
package de.jabc.cinco.meta.core.mgl.ui.contentassist

import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistryEntry
import de.jabc.cinco.meta.core.pluginregistry.impl.PluginRegistryEntryImpl
import de.jabc.cinco.meta.core.utils.CincoUtil
import de.jabc.cinco.meta.core.utils.MGLUtil
import de.jabc.cinco.meta.core.utils.xtext.ChooseFileTextApplier
import de.jabc.cinco.meta.core.utils.xtext.ChooseWizard
import java.util.ArrayList
import java.util.LinkedList
import java.util.Set
import mgl.Annotation
import mgl.Attribute
import mgl.ComplexAttribute
import mgl.Edge
import mgl.EdgeElementConnection
import mgl.GraphModel
import mgl.GraphicalElementContainment
import mgl.MGLModel
import mgl.ModelElement
import mgl.Node
import mgl.NodeContainer
import mgl.ReferencedEClass
import mgl.ReferencedModelElement
import mgl.ReferencedType
import mgl.Type
import mgl.UserDefinedType
import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.RuleCall
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor
import de.jabc.cinco.meta.util.xapi.WorkspaceExtension
import style.EdgeStyle
import style.NodeStyle
import style.Style

/**
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#contentAssist on how to customize content assistant
 */
class MGLProposalProvider extends AbstractMGLProposalProvider {
	extension WorkspaceExtension wse = new WorkspaceExtension()
	
	val registry = PluginRegistry::instance
	
	override completeAnnotation_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
	}
	
	override complete_Annotation(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		val semanticElement = context.currentNode.semanticElement
		if(semanticElement!=model && !(semanticElement instanceof Annotation)){
			(registry.getAnnotations(PluginRegistryEntryImpl::GENERAL_ANNOTATION)).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			if(semanticElement instanceof GraphModel){
				(registry.getAnnotations(PluginRegistryEntryImpl::GRAPH_MODEL_ANNOTATION)).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}else if(semanticElement instanceof NodeContainer){
				registry.getAnnotations(PluginRegistryEntryImpl::NODE_CONTAINER_ANNOTATION).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}else if(semanticElement instanceof Node){
				registry.getAnnotations(PluginRegistryEntryImpl::NODE_ANNOTATION).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}else if(semanticElement instanceof Edge){
				registry.getAnnotations(PluginRegistryEntryImpl::EDGE_ANNOTATION).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}else if(semanticElement instanceof Attribute){
				registry.getAnnotations(PluginRegistryEntryImpl::ATTRIBUTE_ANNOTATION).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}else if(semanticElement instanceof ReferencedType){
				registry.getAnnotations(PluginRegistryEntryImpl::PRIME_ANNOTATION).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}else if(semanticElement instanceof UserDefinedType){
				registry.getAnnotations(PluginRegistryEntryImpl::TYPE_ANNOTATION).forEach[a|acceptor.accept(createCompletionProposal("@"+a,context))]
			}
		}
	}
	
	
	override completeGraphModel_IconPath(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		var proposal = createCompletionProposal("Choose File...", context);
		if (proposal instanceof ConfigurableCompletionProposal) {
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseFileTextApplier(model))
		}
		acceptor.accept(proposal)
	}

	override completeGraphicalElementContainment_Types(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var mglModel = MGLUtil.mglModel(model)
		if(model instanceof GraphicalElementContainment) {
			
			val refImport = (model as GraphicalElementContainment).referencedImport
			if(refImport !== null) {
				mglModel = MGLUtil.mglModel(refImport)
			}
			
			for(node:mglModel.nodes){
				acceptor.accept(createCompletionProposal(node.name,context))
			}
		} else {
			val lastNodeText = context.lastCompleteNode.text
			if(lastNodeText == "::") {
				val refMGLImportText = context.lastCompleteNode.previousSibling.text
				val refMGLImport = mglModel.imports.findFirst[name == refMGLImportText]
				if(refMGLImport !== null) {
					mglModel = MGLUtil.mglModel(refMGLImport)
				}
			}
			for(node:mglModel.nodes){
				acceptor.accept(createCompletionProposal(node.name,context))
			}
		}
	}
	
	override completeIncomingEdgeElementConnection_ConnectingEdges(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		completeEdgeElementConnection_ConnectingEdges(model, assignment, context, acceptor)
	}
	override completeOutgoingEdgeElementConnection_ConnectingEdges(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		completeEdgeElementConnection_ConnectingEdges(model, assignment, context, acceptor)
	}
	
	def private completeEdgeElementConnection_ConnectingEdges(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var mglModel = MGLUtil.mglModel(model)
		if(model instanceof EdgeElementConnection) {
			
			val refImport = (model as EdgeElementConnection).referencedImport
			if(refImport !== null) {
				mglModel = MGLUtil.mglModel(refImport)
			}
			
			for(node:mglModel.edges){
				acceptor.accept(createCompletionProposal(node.name,context))
			}
		} else {
			val lastNodeText = context.lastCompleteNode.text
			if(lastNodeText == "::") {
				val refMGLImportText = context.lastCompleteNode.previousSibling.text
				val refMGLImport = mglModel.imports.findFirst[name == refMGLImportText]
				if(refMGLImport !== null) {
					mglModel = MGLUtil.mglModel(refMGLImport)
				}
			}
			for(node:mglModel.edges){
				acceptor.accept(createCompletionProposal(node.name,context))
			}
		}
	}
	
	override completeAnnotation_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var annot = null as Annotation
		var parentModel = null as EObject
		var metaPlugins = null as Set<PluginRegistryEntry>
		if (model instanceof Annotation) {
			annot = model as Annotation
			parentModel = annot.parent
			metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::GENERAL_ANNOTATION)
			
			if(metaPlugins===null){
			if(parentModel instanceof Node) 
				metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::NODE_ANNOTATION)
				
			if(parentModel instanceof UserDefinedType)
				metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::TYPE_ANNOTATION)
				
			if(parentModel instanceof ReferencedType)
				metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::PRIME_ANNOTATION)
				
			if(parentModel instanceof Attribute)
					metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::ATTRIBUTE_ANNOTATION)
				
			if(parentModel instanceof Edge)
				metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::EDGE_ANNOTATION)
				
			if(parentModel instanceof GraphModel)
				metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::GRAPH_MODEL_ANNOTATION)
			if(parentModel instanceof NodeContainer)
				metaPlugins = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::NODE_CONTAINER_ANNOTATION)
			
			}else{
				if(parentModel instanceof Node){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::NODE_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}
			if(parentModel instanceof UserDefinedType){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::TYPE_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}
			if(parentModel instanceof ReferencedType){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::PRIME_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}
			if(parentModel instanceof Attribute){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::ATTRIBUTE_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}
			if(parentModel instanceof Edge){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::EDGE_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}
			if(parentModel instanceof GraphModel){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::GRAPH_MODEL_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}
			if(parentModel instanceof NodeContainer){
					var mp = registry.getSuitableMetaPlugins(annot.name,PluginRegistryEntryImpl::NODE_CONTAINER_ANNOTATION)
					if(mp!==null)
						metaPlugins += mp
				}		
			}	
			if(metaPlugins!==null){
				for(mp: metaPlugins){
					var myAcceptor = mp.acceptor
					if(myAcceptor!==null){
						for(acc: myAcceptor.getAcceptedStrings(annot)){
							var proposal = createCompletionProposal(acc, context);
							if (proposal instanceof ConfigurableCompletionProposal) {
								var configProp = proposal as ConfigurableCompletionProposal
								configProp.setTextApplier(myAcceptor.getTextApplier(annot))
							}			
							acceptor.accept(proposal)
						}
					}
				}
			}
			if(checkAnnotations(annot.name)){
				var proposal = createCompletionProposal("New Class...", context);
				acceptor.accept(proposal)
				if (proposal instanceof ConfigurableCompletionProposal) {
					var configProp = proposal as ConfigurableCompletionProposal
					configProp.setTextApplier(new ChooseWizard(annot))
				}
			}
		}
	}
	
	def createAnnotations(){
		var annotationsForClasses = new LinkedList <String>
		annotationsForClasses.add("contextMenuAction")
		annotationsForClasses.add("doubleClickAction")
		annotationsForClasses.add("preDelete")
		annotationsForClasses.add("postCreate")
		annotationsForClasses.add("postAttributeValueChange")
		annotationsForClasses.add("postDelete")
		annotationsForClasses.add("postMove")
		annotationsForClasses.add("postResize")
		annotationsForClasses.add("postSelect")
		
		return annotationsForClasses
	}
	
	def checkAnnotations(String annotionname){
		var annotations = createAnnotations()
		for (var i = 0; i < annotations.size; i++){
			if(annotionname.equals(annotations.get(i))){
				return true
			}
		}
		return false
	}
	
	override completeReferencedModelElement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		val refType = model as ReferencedModelElement
		if(refType.local){
			var pNode = refType.eContainer as Node
			val mglModel = MGLUtil::mglModel(pNode)
			var types = new ArrayList<Type>()
			types += mglModel.types.unmodifiableView + mglModel.nodes.unmodifiableView + mglModel.edges.unmodifiableView + mglModel.graphModels.unmodifiableView
			
			for(obj: types){
				acceptor.accept(createCompletionProposal(obj.name,context))
			}	
		}else{
			val res = CincoUtil::getResource(refType.imprt.importURI, refType.eResource)
			if(res!==null){
				for(m: res.allContents.toList.filter[d| d instanceof ModelElement]){
					acceptor.accept(createCompletionProposal((m as ModelElement).name,context))
				}
			}
		}
	}
	
	override completeReferencedEClass_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		var res = null as Resource
		if(model instanceof Node){
			if(context.lastCompleteNode.hasPreviousSibling){
				val uri = MGLUtil::mglModel(model).imports.filter[context.lastCompleteNode.previousSibling.text==name].head.importURI
				res = CincoUtil::getResource(uri,model.eResource)
			}
			
		}else
		if(model instanceof ReferencedEClass){
			res = CincoUtil::getResource(model.imprt.importURI, model.eResource)
		}
		res?.allContents.filter(EClass).forEach[acceptor.accept(createCompletionProposal((it as EClass).name,context))]
	}
	
	// Attributes
	override completeComplexAttribute_Type(EObject it, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		if(it instanceof ComplexAttribute)
			MGLUtil::mglModel(modelElement).attributeTypeNames.forEach[acceptor.accept(createCompletionProposal(it,context))]
		else if(it instanceof ModelElement)
			MGLUtil::mglModel(it).attributeTypeNames.forEach[acceptor.accept(createCompletionProposal(it,context))]
	}
	
	override completeReferencedEClass_Imprt(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		super.completeReferencedEClass_Imprt(model,assignment,context,acceptor)
	}
	
	override completeMGLModel_StylePath(EObject it, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		findFilesInWorkspace("style").forEach[file |
			val projectRelativePath = file.projectRelativePath.toString
			if(!projectRelativePath.startsWith("bin/")) {
				acceptor.accept(createCompletionProposal('"' + file.projectRelativePath.toString + '"', context))
			}
		]
	}
	
	override completeEdge_UsedStyle(EObject it, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		CincoUtil.getStyles((it.eContainer as MGLModel)).styles.filter(EdgeStyle).forEach[
			createStyleCompletionProposals(it, context, acceptor)
		]
	}
	
	override completeNode_UsedStyle(EObject it, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		CincoUtil.getStyles((it.eContainer as MGLModel)).styles.filter(NodeStyle).forEach[
			createStyleCompletionProposals(it, context, acceptor)
		]
	}
	
	override completeNodeContainer_UsedStyle(EObject it, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		completeNode_UsedStyle(it, assignment, context, acceptor)
	}
	
	private def createStyleCompletionProposals(Style style, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var suffix = ""
			if(style.parameterCount > 0) {
				suffix = "()"
			}
			acceptor.accept(createCompletionProposal(style.name + suffix, context))
	}
	
	def attributeTypeNames(MGLModel it){
		(edges+nodes+types+graphModels).map[name]
	}
	
	def GraphModel getGraphModel(ModelElement element){
		switch(element){
			GraphModel: return element
			default: return element.eContainer as GraphModel
		}
	}
	
}
