package info.scce.dime.data.data.gratext.scoping

import graphmodel.internal.InternalIdentifiableElement
import info.scce.dime.data.data.gratext.*

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

import static extension org.eclipse.xtext.EcoreUtil2.getRootContainer
import static extension org.eclipse.xtext.scoping.Scopes.scopeFor

/**
 * This class contains custom scoping description.
 */
class DataGratextScopeProvider extends AbstractDeclarativeScopeProvider {
	
	override getScope(EObject context, EReference reference) {
		getScope(context, reference.name) ?: super.getScope(context, reference)
	}
	
	dispatch def IScope getScope(EObject element, String refName) {
		null
	}
	
	dispatch def IScope getScope(^GratextInternalUserAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "dataType": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalUserType,
				info.scce.dime.data.data.internal.InternalEnumType
			)
			
			case "oppositeAttribute": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalReferencedBidirectionalAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "dataType": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalUserType,
				info.scce.dime.data.data.internal.InternalEnumType
			)
			
			case "oppositeAttribute": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalReferencedComplexAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "dataType": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalUserType,
				info.scce.dime.data.data.internal.InternalEnumType
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalReferencedPrimitiveAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalPrimitiveAttribute,
				info.scce.dime.data.data.internal.InternalReferencedPrimitiveAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "dataType": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalUserType,
				info.scce.dime.data.data.internal.InternalEnumType
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalReferencedUserAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "dataType": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalUserType,
				info.scce.dime.data.data.internal.InternalEnumType
			)
			
			case "oppositeAttribute": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalPrimitiveAttribute,
				info.scce.dime.data.data.internal.InternalReferencedPrimitiveAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalBidirectionalAttribute element, String refName) {
		switch refName {
			case "superAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "dataType": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalUserType,
				info.scce.dime.data.data.internal.InternalEnumType
			)
			
			case "oppositeAttribute": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalAssociation element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalInheritorType,
				info.scce.dime.data.data.internal.InternalEnumType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalUserType
				 )
			case "sourceAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalInheritance element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalInheritorType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalAbstractType
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalUserAssociation element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalInheritorType,
				info.scce.dime.data.data.internal.InternalEnumType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalUserType
				 )
			case "sourceAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "targetAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalBidirectionalAssociation element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalReferencedUserType,
				info.scce.dime.data.data.internal.InternalInheritorType,
				info.scce.dime.data.data.internal.InternalEnumType,
				info.scce.dime.data.data.internal.InternalReferencedEnumType,
				info.scce.dime.data.data.internal.InternalConcreteType,
				info.scce.dime.data.data.internal.InternalReferencedType,
				info.scce.dime.data.data.internal.InternalAbstractType,
				info.scce.dime.data.data.internal.InternalUserType
				 )
			case "sourceAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
			
			case "targetAttr": element.scopeForContents(
				info.scce.dime.data.data.internal.InternalComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedComplexAttribute,
				info.scce.dime.data.data.internal.InternalReferencedBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalReferencedUserAttribute,
				info.scce.dime.data.data.internal.InternalBidirectionalAttribute,
				info.scce.dime.data.data.internal.InternalUserAttribute
			)
		}
	}
	def scopeForContents(EObject obj, Class<?>... types) {
		obj.rootContainer.contents
			.filter(anyTypeOf(types))
			.filter(InternalIdentifiableElement)
			.toScope
	}
	
	def getContents(EObject obj) {
		val Iterable<EObject> iterable = [obj.eAllContents]
		return iterable
	}
	
	def anyTypeOf(Class<?>... types) {
		[Object obj | types.stream.anyMatch[isInstance(obj)]]
	}
	
	def IScope toScope(Iterable<InternalIdentifiableElement> elements) {
		scopeFor(elements, [QualifiedName::create(id)], IScope.NULLSCOPE)
	}
}
