/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel

class RunTemplate extends MainTemplate {
	
	new(ExecutableGraphmodel graphmodel) {
		super(graphmodel)
	}
	
	override fileName() {
		return "Run.java"
	}
	
	override create(ExecutableGraphmodel graphmodel)
	'''
	package «graphmodel.tracerPackage».runner.model;
	
	import java.util.List;
	
	import «graphmodel.tracerPackage».extension.AbstractContext;
	import «graphmodel.tracerPackage».extension.AbstractSemantic;
	import «graphmodel.tracerPackage».match.model.Match;
	
	/**
	 * Compound class to store information needed for one run.
	 * A run is defined by a name for the visual representation
	 * as well as the semantic, context and the elements to start
	 * the run from.
	 * @author zweihoff
	 *
	 */
	public final class Run {
		
		private String name;
		
		private List<Match> startingElements;
		
		private AbstractSemantic semantic;
		
		private AbstractContext context;
		
		public Run(List<Match> startingElements,AbstractSemantic semantic,AbstractContext context,String name)
		{
			this.startingElements = startingElements;
			this.context = context;
			this.semantic = semantic;
			this.name = name;
		}
	
		public final List<Match> getStartingElements() {
			return startingElements;
		}
	
		public final void setStartingElements(List<Match> startingElements) {
			this.startingElements = startingElements;
		}
	
		public final AbstractSemantic getSemantic() {
			return semantic;
		}
	
		public final void setSemantic(AbstractSemantic semantic) {
			this.semantic = semantic;
		}
	
		public final AbstractContext getContext() {
			return context;
		}
	
		public final void setContext(AbstractContext context) {
			this.context = context;
		}
	
		public final String getName() {
			return name;
		}
	
		public final void setName(String name) {
			this.name = name;
		}
		
		public final String toString()
		{
			return this.name;
		}
		
	}
	
	'''
	
}
