/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer

import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel
import mgl.MGLModel

class ManifestTemplate extends MainTemplate {
	
	new(ExecutableGraphmodel graphmodel) {
		super(graphmodel)
	}
	
	override fileName() {
		return "MANIFEST.MF"
	}
	
	override create(ExecutableGraphmodel graphmodel)
	'''
	Manifest-Version: 1.0
	Bundle-ManifestVersion: 2
	Bundle-Name: Tracer
	Bundle-SymbolicName: «graphmodel.tracerPackage»;singleton:=true
	Bundle-Version: 1.0.0.qualifier
	Bundle-Activator: «graphmodel.tracerPackage».Activator
	Require-Bundle: org.eclipse.ui,
	 org.eclipse.core.runtime,
	 org.eclipse.core.resources,
	 org.eclipse.ui,
	 org.eclipse.core.runtime,
	 org.eclipse.ui.workbench,
	 org.eclipse.e4.core.di,
	 org.eclipse.emf,
	 org.eclipse.emf.edit.ui,
	 com.google.gson,
	 org.eclipse.ui.views.properties.tabbed,
	 org.eclipse.gef,
	 de.jabc.cinco.meta.core.utils,
	 de.jabc.cinco.meta.util,
	 org.eclipse.graphiti.mm,
	 org.eclipse.graphiti,
	 de.jabc.cinco.meta.core.ge.style.generator.runtime,
	 «(graphmodel.graphModel.eContainer as MGLModel).package».plugin.esdsl
	Bundle-RequiredExecutionEnvironment: JavaSE-11
	Bundle-ActivationPolicy: lazy
	Import-Package: de.jabc.cinco.meta.core.referenceregistry,
«««	 de.jabc.cinco.meta.core.ui.highlight,
«««	 de.jabc.cinco.meta.core.utils,
«««	 de.jabc.cinco.meta.core.utils.job,
	 de.jabc.cinco.meta.runtime.xapi,
«««	 graphicalgraphmodel,
	 graphmodel,
«««	 «graphmodel.sourceCApiPackage»,
«««	 «graphmodel.sourceCApiPackage».util,
«««	 «graphmodel.graphModel.package».esdsl.api.c«graphmodel.graphModel.name.toLowerCase»es,
	 «(graphmodel.graphModel.eContainer as MGLModel)».esdsl.«graphmodel.graphModel.name.toLowerCase»es,
	 «(graphmodel.graphModel.eContainer as MGLModel)».«graphmodel.graphModel.name.toLowerCase»,
«««	 «graphmodel.graphModel.package».graphiti,
	 org.eclipse.emf.common.util,
	 org.eclipse.emf.ecore,
	 org.eclipse.emf.ecore.resource,
	 org.eclipse.emf.ecore.resource.impl,
	 org.eclipse.pde.internal.ui.util,
	 org.eclipse.ui.model
	Export-Package: «graphmodel.tracerPackage»,
	 «graphmodel.tracerPackage».extension,
	 «graphmodel.tracerPackage».match.model,
	 «graphmodel.tracerPackage».runner.model,
	 «graphmodel.tracerPackage».stepper.model,
	 «graphmodel.tracerPackage».stepper.utils
	'''
	
}
