package info.scce.dime.search.search.gratext.scoping

import graphmodel.internal.InternalIdentifiableElement
import info.scce.dime.search.search.gratext.*

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

import static extension org.eclipse.xtext.EcoreUtil2.getRootContainer
import static extension org.eclipse.xtext.scoping.Scopes.scopeFor

/**
 * This class contains custom scoping description.
 */
class SearchGratextScopeProvider extends AbstractDeclarativeScopeProvider {
	
	override getScope(EObject context, EReference reference) {
		getScope(context, reference.name) ?: super.getScope(context, reference)
	}
	
	dispatch def IScope getScope(EObject element, String refName) {
		null
	}
	
	dispatch def IScope getScope(^GratextInternalDataEdge element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.search.search.internal.InternalPrimitiveVariable,
				info.scce.dime.search.search.internal.InternalBooleanCompareOperator,
				info.scce.dime.search.search.internal.InternalRealCompareOperator,
				info.scce.dime.search.search.internal.InternalIntegerCompareOperator,
				info.scce.dime.search.search.internal.InternalVariable,
				info.scce.dime.search.search.internal.InternalCompareOperator,
				info.scce.dime.search.search.internal.InternalInputParameter,
				info.scce.dime.search.search.internal.InternalTextCompareOperator,
				info.scce.dime.search.search.internal.InternalTimestampCompareOperator,
				info.scce.dime.search.search.internal.InternalPrimitiveInputParameter
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalConditionEdge element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.search.search.internal.InternalOrOperator,
				info.scce.dime.search.search.internal.InternalAndOperator,
				info.scce.dime.search.search.internal.InternalSearchInterface,
				info.scce.dime.search.search.internal.InternalSearchOperator,
				info.scce.dime.search.search.internal.InternalSearchConditional
				 )
		}
	}
	def scopeForContents(EObject obj, Class<?>... types) {
		obj.rootContainer.contents
			.filter(anyTypeOf(types))
			.filter(InternalIdentifiableElement)
			.toScope
	}
	
	def getContents(EObject obj) {
		val Iterable<EObject> iterable = [obj.eAllContents]
		return iterable
	}
	
	def anyTypeOf(Class<?>... types) {
		[Object obj | types.stream.anyMatch[isInstance(obj)]]
	}
	
	def IScope toScope(Iterable<InternalIdentifiableElement> elements) {
		scopeFor(elements, [QualifiedName::create(id)], IScope.NULLSCOPE)
	}
}
