package info.scce.dime.search.search.gratext

import graphmodel.internal.InternalGraphModel

import de.jabc.cinco.meta.core.utils.registry.NonEmptyIdentityRegistry
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.GratextResource

import info.scce.dime.search.search.gratext.generator.SearchGratextTransformer

class SearchGratextResource extends GratextResource {
	
	public static val transformers = new NonEmptyIdentityRegistry<InternalGraphModel,SearchGratextTransformer> [
		new SearchGratextTransformer
	]
	
	val lastTransformers = new NonEmptyIdentityRegistry<InternalGraphModel,SearchGratextTransformer> [
		new SearchGratextTransformer
	]

	override getTransformer(InternalGraphModel model) {
		transformers.get(model)
	}

	override getLastTransformer(InternalGraphModel model) {
		lastTransformers.get(model)
	}

	override removeTransformer(InternalGraphModel model) {
		lastTransformers.put(model, transformers.remove(model))
	}

	override isSortGratext() {
		false
	}
}
