package info.scce.dime.process.process.gratext.scoping

import graphmodel.internal.InternalIdentifiableElement
import info.scce.dime.process.process.gratext.*

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

import static extension org.eclipse.xtext.EcoreUtil2.getRootContainer
import static extension org.eclipse.xtext.scoping.Scopes.scopeFor

/**
 * This class contains custom scoping description.
 */
class ProcessGratextScopeProvider extends AbstractDeclarativeScopeProvider {
	
	override getScope(EObject context, EReference reference) {
		getScope(context, reference.name) ?: super.getScope(context, reference)
	}
	
	dispatch def IScope getScope(EObject element, String refName) {
		null
	}
	
	dispatch def IScope getScope(^GratextInternalProcessBlueprintSIB element, String refName) {
		switch refName {
			case "defaultBranch": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalBranchBlueprint
			)
			
			case "majorBranch": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalAbstractBranch,
				info.scce.dime.process.process.internal.InternalBranch,
				info.scce.dime.process.process.internal.InternalBranchBlueprint,
				info.scce.dime.process.process.internal.InternalNativeFrontendBranch
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalGUIBlueprintSIB element, String refName) {
		switch refName {
			case "defaultBranch": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalBranchBlueprint
			)
			
			case "majorBranch": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalAbstractBranch,
				info.scce.dime.process.process.internal.InternalBranch,
				info.scce.dime.process.process.internal.InternalBranchBlueprint,
				info.scce.dime.process.process.internal.InternalNativeFrontendBranch
			)
			
			case "defaultContent": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalSIB,
				info.scce.dime.process.process.internal.InternalSearchSIB,
				info.scce.dime.process.process.internal.InternalCreateSIB,
				info.scce.dime.process.process.internal.InternalTransientCreateSIB,
				info.scce.dime.process.process.internal.InternalCreateUserSIB,
				info.scce.dime.process.process.internal.InternalContainsSIB,
				info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB,
				info.scce.dime.process.process.internal.InternalIsOfTypeSIB,
				info.scce.dime.process.process.internal.InternalIterateSIB,
				info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB,
				info.scce.dime.process.process.internal.InternalPutComplexToContextSIB,
				info.scce.dime.process.process.internal.InternalPutToContextSIB,
				info.scce.dime.process.process.internal.InternalTriggerEventSIB,
				info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB,
				info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB,
				info.scce.dime.process.process.internal.InternalSwitchToUserSIB,
				info.scce.dime.process.process.internal.InternalGetOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalDeleteSIB,
				info.scce.dime.process.process.internal.InternalRemoveFromListSIB,
				info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB,
				info.scce.dime.process.process.internal.InternalLinkProcessSIB,
				info.scce.dime.process.process.internal.InternalEnumSwitchSIB,
				info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB,
				info.scce.dime.process.process.internal.InternalSetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalAtomicSIB,
				info.scce.dime.process.process.internal.InternalProcessSIB,
				info.scce.dime.process.process.internal.InternalGenericSIB,
				info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB,
				info.scce.dime.process.process.internal.InternalGUISIB,
				info.scce.dime.process.process.internal.InternalGuardContainer,
				info.scce.dime.process.process.internal.InternalGuardedProcessSIB,
				info.scce.dime.process.process.internal.InternalEntryPointProcessSIB,
				info.scce.dime.process.process.internal.InternalGuardProcessSIB,
				info.scce.dime.process.process.internal.InternalProcessBlueprintSIB,
				info.scce.dime.process.process.internal.InternalGUIBlueprintSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalGUISIB element, String refName) {
		switch refName {
			case "defaultContent": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalSIB,
				info.scce.dime.process.process.internal.InternalSearchSIB,
				info.scce.dime.process.process.internal.InternalCreateSIB,
				info.scce.dime.process.process.internal.InternalTransientCreateSIB,
				info.scce.dime.process.process.internal.InternalCreateUserSIB,
				info.scce.dime.process.process.internal.InternalContainsSIB,
				info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB,
				info.scce.dime.process.process.internal.InternalIsOfTypeSIB,
				info.scce.dime.process.process.internal.InternalIterateSIB,
				info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB,
				info.scce.dime.process.process.internal.InternalPutComplexToContextSIB,
				info.scce.dime.process.process.internal.InternalPutToContextSIB,
				info.scce.dime.process.process.internal.InternalTriggerEventSIB,
				info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB,
				info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB,
				info.scce.dime.process.process.internal.InternalSwitchToUserSIB,
				info.scce.dime.process.process.internal.InternalGetOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalDeleteSIB,
				info.scce.dime.process.process.internal.InternalRemoveFromListSIB,
				info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB,
				info.scce.dime.process.process.internal.InternalLinkProcessSIB,
				info.scce.dime.process.process.internal.InternalEnumSwitchSIB,
				info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB,
				info.scce.dime.process.process.internal.InternalSetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalAtomicSIB,
				info.scce.dime.process.process.internal.InternalProcessSIB,
				info.scce.dime.process.process.internal.InternalGenericSIB,
				info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB,
				info.scce.dime.process.process.internal.InternalGUISIB,
				info.scce.dime.process.process.internal.InternalGuardContainer,
				info.scce.dime.process.process.internal.InternalGuardedProcessSIB,
				info.scce.dime.process.process.internal.InternalEntryPointProcessSIB,
				info.scce.dime.process.process.internal.InternalGuardProcessSIB,
				info.scce.dime.process.process.internal.InternalProcessBlueprintSIB,
				info.scce.dime.process.process.internal.InternalGUIBlueprintSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference
			)
			
			case "majorBranch": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalAbstractBranch,
				info.scce.dime.process.process.internal.InternalBranch,
				info.scce.dime.process.process.internal.InternalBranchBlueprint,
				info.scce.dime.process.process.internal.InternalNativeFrontendBranch
			)
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveRead element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalPrimitiveListAttribute,
				info.scce.dime.process.process.internal.InternalPrimitiveAttribute,
				info.scce.dime.process.process.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.process.process.internal.InternalPrimitiveInputPort,
				info.scce.dime.process.process.internal.InternalPrimitiveVariable
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalJavaNativeRead element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalJavaNativeInputPort,
				info.scce.dime.process.process.internal.InternalJavaNativeVariable
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalControlFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalTransientCreateSIB,
				info.scce.dime.process.process.internal.InternalCreateUserSIB,
				info.scce.dime.process.process.internal.InternalContainsSIB,
				info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB,
				info.scce.dime.process.process.internal.InternalGuardContainer,
				info.scce.dime.process.process.internal.InternalEndSIB,
				info.scce.dime.process.process.internal.InternalStartSIB,
				info.scce.dime.process.process.internal.InternalSearchSIB,
				info.scce.dime.process.process.internal.InternalProcessSIB,
				info.scce.dime.process.process.internal.InternalDeleteSIB,
				info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB,
				info.scce.dime.process.process.internal.InternalRemoveFromListSIB,
				info.scce.dime.process.process.internal.InternalAbstractIterateSIB,
				info.scce.dime.process.process.internal.InternalSetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalIterateSIB,
				info.scce.dime.process.process.internal.InternalGuardProcessSIB,
				info.scce.dime.process.process.internal.InternalAbstractContainsSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference,
				info.scce.dime.process.process.internal.InternalPutToContextSIB,
				info.scce.dime.process.process.internal.InternalCreateSIB,
				info.scce.dime.process.process.internal.InternalIsOfTypeSIB,
				info.scce.dime.process.process.internal.InternalEnumSwitchSIB,
				info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB,
				info.scce.dime.process.process.internal.InternalTriggerEventSIB,
				info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB,
				info.scce.dime.process.process.internal.InternalGenericSIB,
				info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalBlueprintSIB,
				info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB,
				info.scce.dime.process.process.internal.InternalBranchBlueprint,
				info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalEntryPointProcessSIB,
				info.scce.dime.process.process.internal.InternalDummyContainer,
				info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB,
				info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalBranch,
				info.scce.dime.process.process.internal.InternalAbstractBranch,
				info.scce.dime.process.process.internal.InternalSwitchToUserSIB,
				info.scce.dime.process.process.internal.InternalProcessBlueprintSIB,
				info.scce.dime.process.process.internal.InternalPutComplexToContextSIB,
				info.scce.dime.process.process.internal.InternalGetOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendBranch,
				info.scce.dime.process.process.internal.InternalSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIB,
				info.scce.dime.process.process.internal.InternalLinkProcessSIB,
				info.scce.dime.process.process.internal.InternalAtomicSIB,
				info.scce.dime.process.process.internal.InternalGuardedProcessSIB,
				info.scce.dime.process.process.internal.InternalGUIBlueprintSIB,
				info.scce.dime.process.process.internal.InternalEventListener,
				info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB,
				info.scce.dime.process.process.internal.InternalGUISIB
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalJavaNativeUpdate element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalJavaNativeVariable,
				info.scce.dime.process.process.internal.InternalJavaNativeOutputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalRegistration element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalTriggerEventSIB,
				info.scce.dime.process.process.internal.InternalEventListener
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveDirectDataFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalPrimitiveInputPort,
				info.scce.dime.process.process.internal.InternalPrimitiveOutputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexRead element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalComplexExtensionAttribute,
				info.scce.dime.process.process.internal.InternalComplexInputPort,
				info.scce.dime.process.process.internal.InternalComplexListAttribute,
				info.scce.dime.process.process.internal.InternalComplexVariable,
				info.scce.dime.process.process.internal.InternalComplexAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexListAttributeConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalComplexVariable
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalJavaNativeDirectDataFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalJavaNativeInputPort,
				info.scce.dime.process.process.internal.InternalJavaNativeOutputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalEventConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalEventListener,
				info.scce.dime.process.process.internal.InternalGUISIB
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexAttributeConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalComplexVariable
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalBranchConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalTransientCreateSIB,
				info.scce.dime.process.process.internal.InternalCreateUserSIB,
				info.scce.dime.process.process.internal.InternalContainsSIB,
				info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB,
				info.scce.dime.process.process.internal.InternalGuardContainer,
				info.scce.dime.process.process.internal.InternalSearchSIB,
				info.scce.dime.process.process.internal.InternalProcessSIB,
				info.scce.dime.process.process.internal.InternalDeleteSIB,
				info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB,
				info.scce.dime.process.process.internal.InternalRemoveFromListSIB,
				info.scce.dime.process.process.internal.InternalAbstractIterateSIB,
				info.scce.dime.process.process.internal.InternalSetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalIterateSIB,
				info.scce.dime.process.process.internal.InternalGuardProcessSIB,
				info.scce.dime.process.process.internal.InternalAbstractContainsSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference,
				info.scce.dime.process.process.internal.InternalPutToContextSIB,
				info.scce.dime.process.process.internal.InternalCreateSIB,
				info.scce.dime.process.process.internal.InternalIsOfTypeSIB,
				info.scce.dime.process.process.internal.InternalEnumSwitchSIB,
				info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB,
				info.scce.dime.process.process.internal.InternalTriggerEventSIB,
				info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB,
				info.scce.dime.process.process.internal.InternalGenericSIB,
				info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalBlueprintSIB,
				info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB,
				info.scce.dime.process.process.internal.InternalBranchBlueprint,
				info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalEntryPointProcessSIB,
				info.scce.dime.process.process.internal.InternalDummyContainer,
				info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB,
				info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalBranch,
				info.scce.dime.process.process.internal.InternalAbstractBranch,
				info.scce.dime.process.process.internal.InternalSwitchToUserSIB,
				info.scce.dime.process.process.internal.InternalProcessBlueprintSIB,
				info.scce.dime.process.process.internal.InternalPutComplexToContextSIB,
				info.scce.dime.process.process.internal.InternalGetOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendBranch,
				info.scce.dime.process.process.internal.InternalSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIB,
				info.scce.dime.process.process.internal.InternalLinkProcessSIB,
				info.scce.dime.process.process.internal.InternalAtomicSIB,
				info.scce.dime.process.process.internal.InternalGuardedProcessSIB,
				info.scce.dime.process.process.internal.InternalGUIBlueprintSIB,
				info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB,
				info.scce.dime.process.process.internal.InternalGUISIB
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexDirectDataFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalComplexInputPort,
				info.scce.dime.process.process.internal.InternalComplexOutputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexUpdate element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalComplexVariable,
				info.scce.dime.process.process.internal.InternalComplexOutputPort,
				info.scce.dime.process.process.internal.InternalComplexAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveUpdate element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalPrimitiveAttribute,
				info.scce.dime.process.process.internal.InternalPrimitiveVariable,
				info.scce.dime.process.process.internal.InternalPrimitiveOutputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalGUISIBOptions element, String refName) {
		switch refName {
			case "defaultContent": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalSIB,
				info.scce.dime.process.process.internal.InternalSearchSIB,
				info.scce.dime.process.process.internal.InternalCreateSIB,
				info.scce.dime.process.process.internal.InternalTransientCreateSIB,
				info.scce.dime.process.process.internal.InternalCreateUserSIB,
				info.scce.dime.process.process.internal.InternalContainsSIB,
				info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB,
				info.scce.dime.process.process.internal.InternalIsOfTypeSIB,
				info.scce.dime.process.process.internal.InternalIterateSIB,
				info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB,
				info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB,
				info.scce.dime.process.process.internal.InternalPutComplexToContextSIB,
				info.scce.dime.process.process.internal.InternalPutToContextSIB,
				info.scce.dime.process.process.internal.InternalTriggerEventSIB,
				info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB,
				info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB,
				info.scce.dime.process.process.internal.InternalSwitchToUserSIB,
				info.scce.dime.process.process.internal.InternalGetOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB,
				info.scce.dime.process.process.internal.InternalDeleteSIB,
				info.scce.dime.process.process.internal.InternalRemoveFromListSIB,
				info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB,
				info.scce.dime.process.process.internal.InternalLinkProcessSIB,
				info.scce.dime.process.process.internal.InternalEnumSwitchSIB,
				info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB,
				info.scce.dime.process.process.internal.InternalSetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB,
				info.scce.dime.process.process.internal.InternalAtomicSIB,
				info.scce.dime.process.process.internal.InternalProcessSIB,
				info.scce.dime.process.process.internal.InternalGenericSIB,
				info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB,
				info.scce.dime.process.process.internal.InternalGUISIB,
				info.scce.dime.process.process.internal.InternalGuardContainer,
				info.scce.dime.process.process.internal.InternalGuardedProcessSIB,
				info.scce.dime.process.process.internal.InternalEntryPointProcessSIB,
				info.scce.dime.process.process.internal.InternalGuardProcessSIB,
				info.scce.dime.process.process.internal.InternalProcessBlueprintSIB,
				info.scce.dime.process.process.internal.InternalGUIBlueprintSIB,
				info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference
			)
			
			case "majorBranch": element.scopeForContents(
				info.scce.dime.process.process.internal.InternalAbstractBranch,
				info.scce.dime.process.process.internal.InternalBranch,
				info.scce.dime.process.process.internal.InternalBranchBlueprint,
				info.scce.dime.process.process.internal.InternalNativeFrontendBranch
			)
		}
	}
	def scopeForContents(EObject obj, Class<?>... types) {
		obj.rootContainer.contents
			.filter(anyTypeOf(types))
			.filter(InternalIdentifiableElement)
			.toScope
	}
	
	def getContents(EObject obj) {
		val Iterable<EObject> iterable = [obj.eAllContents]
		return iterable
	}
	
	def anyTypeOf(Class<?>... types) {
		[Object obj | types.stream.anyMatch[isInstance(obj)]]
	}
	
	def IScope toScope(Iterable<InternalIdentifiableElement> elements) {
		scopeFor(elements, [QualifiedName::create(id)], IScope.NULLSCOPE)
	}
}
