/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
/*
 * generated by Xtext
 */
package de.jabc.cinco.meta.core.ge.style.ui.contentassist

import de.jabc.cinco.meta.core.utils.xtext.ChooseFileTextApplier
import de.jabc.cinco.meta.core.utils.xtext.ChooseFontStyle
import de.jabc.cinco.meta.core.utils.xtext.ChooseWizardAppearance
import de.jabc.cinco.meta.core.utils.xtext.PickColorApplier
import java.awt.GraphicsEnvironment
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.RuleCall
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class StyleProposalProvider extends AbstractStyleProposalProvider {
	
	override completeImage_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var proposal = createCompletionProposal("Choose File...", context);
		if (proposal instanceof ConfigurableCompletionProposal) {
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseFileTextApplier(model))
		}
		acceptor.accept(proposal)
		
		super.completeImage_Path(model, assignment, context, acceptor)
	}
	
	override complete_Color(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var proposal = createCompletionProposal("Pick color...", context);
		if (proposal instanceof ConfigurableCompletionProposal) {
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new PickColorApplier("("))
		}
		
		acceptor.accept(proposal)
		super.complete_Color(model, ruleCall, context, acceptor)
	}
	
	override completeColor_R(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var proposal = createCompletionProposal("Pick color...", context);
		if (proposal instanceof ConfigurableCompletionProposal) {
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new PickColorApplier(""))
		}
		
		acceptor.accept(proposal)
		
		super.completeColor_R(model, assignment, context, acceptor)
		
	}
	
	override completeAppearance_Font(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var proposal = createCompletionProposal("Choose Font", context);
		if (proposal instanceof ConfigurableCompletionProposal){
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseFontStyle("("))
		}
		
		acceptor.accept(proposal)
		super.completeAppearance_Font(model, assignment, context, acceptor)
	}

	override completeInlineAppearance_Font(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var proposal = createCompletionProposal("Choose Font", context);
		if (proposal instanceof ConfigurableCompletionProposal){
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseFontStyle("("))
		}
		
		acceptor.accept(proposal)
		super.completeAppearance_Font(model, assignment, context, acceptor)
	}

	override completeFont_FontName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		/**
		 * Generates the Choose Font dialog
		 */
		var proposal = createCompletionProposal("Choose Font", context);
		if (proposal instanceof ConfigurableCompletionProposal){
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseFontStyle("("))
		}
		acceptor.accept(proposal)
		
		
		/**
		 * Adds all possible fonts to context menu
		 */
		var proposals = GraphicsEnvironment.localGraphicsEnvironment.allFonts;
		proposals.forEach[prop | acceptor.accept(createCompletionProposal("\""+prop.fontName+"\"", context))]
		super.completeFont_FontName(model, assignment, context, acceptor)
	}

	override completeFont_IsBold(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal("BOLD", context));
		super.completeFont_IsBold(model, assignment, context, acceptor)
	}

	override completeFont_IsItalic(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal("BOLD", context));
		super.completeFont_IsItalic(model, assignment, context, acceptor)
	}

	override completeNodeStyle_AppearanceProvider(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var proposal = createCompletionProposal("New Class...", context)
		if(proposal instanceof ConfigurableCompletionProposal){
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseWizardAppearance(model))
		}
		acceptor.accept(proposal)
		super.completeNodeStyle_AppearanceProvider(model, assignment, context, acceptor)
	}
	
	override completeEdgeStyle_AppearanceProvider(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor){
		var proposal = createCompletionProposal("New Class...", context)
		if(proposal instanceof ConfigurableCompletionProposal){
			var configProp = proposal as ConfigurableCompletionProposal
			configProp.setTextApplier(new ChooseWizardAppearance(model))
		}
		acceptor.accept(proposal)
		super.completeEdgeStyle_AppearanceProvider(model,assignment,context,acceptor)
	}
}
