/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.generator.extensions;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.mgl.generator.elements.ElementEClasses;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import java.io.IOException;
import java.util.Arrays;
import mgl.Edge;
import mgl.GraphModel;
import mgl.GraphicalModelElement;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.Type;
import mgl.UserDefinedType;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FactoryGeneratorExtensions {
    @Extension
    private static GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();

    public static CharSequence createFactory(MGLModel model, Iterable<ElementEClasses> elmClasses) {
        return FactoryGeneratorExtensions.createFactory(model, elmClasses, null);
    }

    public static CharSequence createFactory(MGLModel model, Iterable<ElementEClasses> elmClasses, Iterable<MGLModel> referencedMGLs) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = model.getPackage();
        _builder.append(_package);
        _builder.append(".factory");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import static extension org.eclipse.emf.ecore.util.EcoreUtil.*");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import ");
        String _package_1 = model.getPackage();
        _builder.append(_package_1);
        _builder.append(".");
        String _lowerCase = _generatorUtils.getFileName(model).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _firstUpper = StringExtensions.toFirstUpper((String)_generatorUtils.getFileName(model).toLowerCase());
        _builder.append(_firstUpper);
        _builder.append("Package");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _package_2 = model.getPackage();
        _builder.append(_package_2);
        _builder.append(".");
        String _lowerCase_1 = _generatorUtils.getFileName(model).toLowerCase();
        _builder.append(_lowerCase_1);
        _builder.append(".impl.");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_generatorUtils.getFileName(model).toLowerCase());
        _builder.append(_firstUpper_1);
        _builder.append("FactoryImpl");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _package_3 = model.getPackage();
        _builder.append(_package_3);
        _builder.append(".");
        String _lowerCase_2 = _generatorUtils.getFileName(model).toLowerCase();
        _builder.append(_lowerCase_2);
        _builder.append(".internal.InternalFactory");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _package_4 = model.getPackage();
        _builder.append(_package_4);
        _builder.append(".");
        String _lowerCase_3 = _generatorUtils.getFileName(model).toLowerCase();
        _builder.append(_lowerCase_3);
        _builder.append(".internal.InternalPackage");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import ");
        String _package_5 = model.getPackage();
        _builder.append(_package_5);
        _builder.append(".");
        String _lowerCase_4 = _generatorUtils.getFileName(model).toLowerCase();
        _builder.append(_lowerCase_4);
        _builder.append(".adapter.*");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalModelElement");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalModelElementContainer");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalGraphModel");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalContainer");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalNode");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalEdge");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalType");
        _builder.newLine();
        _builder.append("import graphmodel.internal.InternalIdentifiableElement");
        _builder.newLine();
        _builder.append("import graphmodel.ModelElement");
        _builder.newLine();
        _builder.append("import graphmodel.IdentifiableElement");
        _builder.newLine();
        _builder.append("import graphmodel.GraphModel");
        _builder.newLine();
        _builder.append("import graphmodel.Type");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.EClass");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.EPackage");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.plugin.EcorePlugin");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _fileName = _generatorUtils.getFileName(model);
        _builder.append(_fileName);
        _builder.append("Factory extends ");
        CharSequence _factoryName = FactoryGeneratorExtensions.factoryName(model);
        _builder.append((Object)_factoryName);
        _builder.append("Impl {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final extension InternalFactory = InternalFactory.eINSTANCE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static ");
        String _fileName_1 = _generatorUtils.getFileName(model);
        _builder.append(_fileName_1, "\t");
        _builder.append("Factory eINSTANCE = ");
        String _fileName_2 = _generatorUtils.getFileName(model);
        _builder.append(_fileName_2, "\t");
        _builder.append("Factory.init");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("extension ");
        String _name = WorkbenchExtension.class.getName();
        _builder.append(_name, "\t");
        _builder.append(" = new ");
        String _name_1 = WorkbenchExtension.class.getName();
        _builder.append(_name_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static def ");
        String _fileName_3 = _generatorUtils.getFileName(model);
        _builder.append(_fileName_3, "\t");
        _builder.append("Factory init() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("val fct = EPackage::Registry.INSTANCE.getEFactory(");
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_generatorUtils.getFileName(model).toLowerCase());
        _builder.append(_firstUpper_2, "\t\t\t");
        _builder.append("Package.eNS_URI) as ");
        String _fileName_4 = _generatorUtils.getFileName(model);
        _builder.append(_fileName_4, "\t\t\t");
        _builder.append("Factory");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (fct !== null)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return fct as ");
        String _fileName_5 = _generatorUtils.getFileName(model);
        _builder.append(_fileName_5, "\t\t\t\t");
        _builder.append("Factory");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("catch (Exception exception) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("EcorePlugin.INSTANCE.log(exception);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("new ");
        String _fileName_6 = _generatorUtils.getFileName(model);
        _builder.append(_fileName_6, "\t\t");
        _builder.append("Factory");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _specificCreateMethods = FactoryGeneratorExtensions.specificCreateMethods(elmClasses);
        _builder.append(_specificCreateMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private def <T extends IdentifiableElement> setInternal(T elm, InternalIdentifiableElement internal) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elm => [");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (id.isNullOrEmpty)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ID = generateUUID");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("switch elm {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("GraphModel: elm.setInternalElement_(internal as InternalGraphModel)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ModelElement: elm.setInternalElement_(internal as InternalModelElement)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Type: elm.setInternalElement_(internal as InternalType)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)model.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel graphmodel : _filter) {
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("* This method creates a new ");
            String _fuName = _generatorUtils.fuName((ModelElement)graphmodel);
            _builder.append(_fuName, "\t");
            _builder.append(" object with an underlying ");
            String _name_2 = Resource.class.getName();
            _builder.append(_name_2, "\t");
            _builder.append(". Thus you can ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("* simply call the ");
            String _fuName_1 = _generatorUtils.fuName((ModelElement)graphmodel);
            _builder.append(_fuName_1, "\t");
            _builder.append("'s save method to save your changes.");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("def ");
            CharSequence _fqBeanName = _generatorUtils.fqBeanName((EObject)graphmodel);
            _builder.append((Object)_fqBeanName, "\t");
            _builder.append(" create");
            String _fuName_2 = _generatorUtils.fuName((ModelElement)graphmodel);
            _builder.append(_fuName_2, "\t");
            _builder.append("(");
            String _name_3 = String.class.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" path, ");
            String _name_4 = String.class.getName();
            _builder.append(_name_4, "\t");
            _builder.append(" fileName) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("var filePath = new ");
            String _name_5 = Path.class.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("(path).append(fileName).addFileExtension(\"");
            String _lowerCase_5 = graphmodel.getName().toLowerCase();
            _builder.append(_lowerCase_5, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("var uri = ");
            String _name_6 = URI.class.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(".createPlatformResourceURI(filePath.toOSString(), true);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("var res = new ");
            String _name_7 = ResourceSetImpl.class.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("().createResource(uri);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("var graph = ");
            CharSequence _fqFactoryName = _generatorUtils.fqFactoryName((ModelElement)graphmodel);
            _builder.append((Object)_fqFactoryName, "\t\t");
            _builder.append(".eINSTANCE.create");
            String _fuName_3 = _generatorUtils.fuName((ModelElement)graphmodel);
            _builder.append(_fuName_3, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _name_8 = EcoreUtil.class.getName();
            _builder.append(_name_8, "\t\t");
            _builder.append(".setID(graph, ");
            String _name_9 = EcoreUtil.class.getName();
            _builder.append(_name_9, "\t\t");
            _builder.append(".generateUUID());");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("res.getContents().add(graph.getInternalElement_());");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            boolean _hasPostCreateHook = MGLUtil.hasPostCreateHook((ModelElement)graphmodel);
            if (_hasPostCreateHook) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("postCreates(graph);");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("try {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("res.save(null);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("} catch (");
            String _name_10 = IOException.class.getName();
            _builder.append(_name_10, "\t\t");
            _builder.append(" e) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("e.printStackTrace();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return graph;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _postCreateHooks = MGLUtil.getPostCreateHooks((MGLModel)model);
        _builder.append(_postCreateHooks, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence factoryName(MGLModel model) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper((String)_generatorUtils.getFileName(model).toLowerCase());
        _builder.append(_firstUpper);
        _builder.append("Factory");
        return _builder;
    }

    public static String specificCreateMethods(Iterable<ElementEClasses> elementEClasses) {
        Functions.Function1<ElementEClasses, ModelElement> _function = new Functions.Function1<ElementEClasses, ModelElement>(){

            public ModelElement apply(ElementEClasses it) {
                return it.getModelElement();
            }
        };
        Functions.Function1<ModelElement, Boolean> _function_1 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                boolean _switchResult = false;
                boolean _matched = false;
                if (it instanceof GraphModel) {
                    _matched = true;
                    _switchResult = true;
                }
                if (!_matched && it instanceof Node) {
                    _matched = true;
                    _switchResult = true;
                }
                if (!_matched && it instanceof Edge) {
                    _matched = true;
                    _switchResult = true;
                }
                if (!_matched && it instanceof UserDefinedType) {
                    _matched = true;
                    _switchResult = true;
                }
                if (!_matched) {
                    _switchResult = false;
                }
                return _switchResult;
            }
        };
        Functions.Function1<ModelElement, Boolean> _function_2 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                return it.isIsAbstract();
            }
        };
        Functions.Function1<ModelElement, CharSequence> _function_3 = new Functions.Function1<ModelElement, CharSequence>(){

            public CharSequence apply(ModelElement it) {
                return FactoryGeneratorExtensions.specificCreateMethod(it);
            }
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.reject((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(elementEClasses, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
    }

    public static String specificCreateMethodsImported(final MGLModel mgl) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                boolean _switchResult = false;
                boolean _matched = false;
                if (it instanceof Node) {
                    _matched = true;
                    _switchResult = true;
                }
                if (!_matched && it instanceof Edge) {
                    _matched = true;
                    _switchResult = true;
                }
                if (!_matched) {
                    _switchResult = false;
                }
                return _switchResult;
            }
        };
        Functions.Function1<GraphicalModelElement, Boolean> _function_1 = new Functions.Function1<GraphicalModelElement, Boolean>(){

            public Boolean apply(GraphicalModelElement it) {
                return it.isIsAbstract();
            }
        };
        Functions.Function1<GraphicalModelElement, CharSequence> _function_2 = new Functions.Function1<GraphicalModelElement, CharSequence>(){

            public CharSequence apply(GraphicalModelElement it) {
                return FactoryGeneratorExtensions.specificCreateMethod(it, mgl);
            }
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.reject((Iterable)Iterables.filter((Iterable)IterableExtensions.filter((Iterable)_generatorUtils.modelElements(mgl), (Functions.Function1)_function), GraphicalModelElement.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    protected static CharSequence _specificCreateMethod(GraphModel it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name = it.getName();
        _builder.append(_name, " ");
        _builder.append(" with the given id.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ID: The id for the new element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* element of the created element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param hook: Indicates, if the post create hook should be executed");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append("(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super.create");
        String _name_2 = it.getName();
        _builder.append(_name_2, "\t");
        _builder.append(" => [ ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setID(ID)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("internal = ime ?: createInternal");
        String _name_3 = it.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append(" => [");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setID(ID + \"_INTERNAL\")");
        _builder.newLine();
        if (!(it instanceof Type)) {
            _builder.append("\t\t\t");
            _builder.append("container = parent");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("eAdapters.add(new ");
        String _package = MGLUtil.getMglModel((ModelElement)it).getPackage();
        _builder.append(_package, "\t\t\t");
        _builder.append(".adapter.");
        String _name_4 = it.getName();
        _builder.append(_name_4, "\t\t\t");
        _builder.append("EContentAdapter)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _postCreateHook = MGLUtil.postCreateHook((ModelElement)it);
        _builder.append((Object)_postCreateHook, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_5 = it.getName();
        _builder.append(_name_5, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_6 = it.getName();
        _builder.append(_name_6);
        _builder.append("(String ID){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_7 = it.getName();
        _builder.append(_name_7, "\t");
        _builder.append("(ID,null,null,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_8 = it.getName();
        _builder.append(_name_8, " ");
        _builder.append(" with the given id. Post create hook will be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_9 = it.getName();
        _builder.append(_name_9);
        _builder.append("(InternalModelElementContainer parent){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_10 = it.getName();
        _builder.append(_name_10, "\t");
        _builder.append("(generateUUID,null,parent,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_11 = it.getName();
        _builder.append(_name_11, " ");
        _builder.append(" with the given id. Post create hook will be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_12 = it.getName();
        _builder.append(_name_12);
        _builder.append("(String ID, InternalModelElementContainer parent){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_13 = it.getName();
        _builder.append(_name_13, "\t");
        _builder.append("(ID,null,parent,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("def create");
        String _name_14 = it.getName();
        _builder.append(_name_14);
        _builder.append("(String ID, InternalModelElement ime, InternalModelElementContainer parent){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_15 = it.getName();
        _builder.append(_name_15, "\t");
        _builder.append("(ID,ime,parent,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_16 = it.getName();
        _builder.append(_name_16, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_17 = it.getName();
        _builder.append(_name_17);
        _builder.append("(InternalModelElement ime) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_18 = it.getName();
        _builder.append(_name_18, "\t");
        _builder.append("(generateUUID,ime,null,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("override create");
        String _name_19 = it.getName();
        _builder.append(_name_19);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_20 = it.getName();
        _builder.append(_name_20, "\t");
        _builder.append("(generateUUID)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected static CharSequence _specificCreateMethod(Node it) {
        return FactoryGeneratorExtensions.specificCreateMethod((GraphicalModelElement)it, null);
    }

    protected static CharSequence _specificCreateMethod(Node it, MGLModel originMgl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name = it.getName();
        _builder.append(_name, " ");
        _builder.append(" with the given id.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ID: The id for the new element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* element of the created element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param hook: Indicates, if the post create hook should be executed");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append("(String ID, InternalModelElement ime, InternalModelElementContainer parent, boolean hook){");
        _builder.newLineIfNotEmpty();
        if (originMgl == null) {
            _builder.append("\t");
            _builder.append("super.create");
            String _name_2 = it.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" => [");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            String _lowerCase = _generatorUtils.getFileName(originMgl).toLowerCase();
            _builder.append(_lowerCase, "\t");
            _builder.append("Factory.create");
            String _name_3 = it.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" => [");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("setID(ID)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("internal = ime ?: ");
        if (originMgl != null) {
            String _lowerCase_1 = _generatorUtils.getFileName(originMgl).toLowerCase();
            _builder.append(_lowerCase_1, "\t\t");
            _builder.append("InternalFactory.");
        }
        _builder.append("createInternal");
        String _name_4 = it.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append(" => [");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setID(ID + \"_INTERNAL\")");
        _builder.newLine();
        if (!(it instanceof Type)) {
            _builder.append("\t\t\t");
            _builder.append("container = parent");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("container = parent");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("eAdapters.add(new ");
        String _package = MGLUtil.getMglModel((ModelElement)it).getPackage();
        _builder.append(_package, "\t\t\t");
        _builder.append(".adapter.");
        String _name_5 = it.getName();
        _builder.append(_name_5, "\t\t\t");
        _builder.append("EContentAdapter)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _postCreateHook = MGLUtil.postCreateHook((ModelElement)it);
        _builder.append((Object)_postCreateHook, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_6 = it.getName();
        _builder.append(_name_6, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_7 = it.getName();
        _builder.append(_name_7);
        _builder.append("(String ID){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_8 = it.getName();
        _builder.append(_name_8, "\t");
        _builder.append("(ID,null,null,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_9 = it.getName();
        _builder.append(_name_9, " ");
        _builder.append(" with the given id. Post create hook will be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_10 = it.getName();
        _builder.append(_name_10);
        _builder.append("(InternalModelElementContainer parent){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_11 = it.getName();
        _builder.append(_name_11, "\t");
        _builder.append("(generateUUID,null,parent,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_12 = it.getName();
        _builder.append(_name_12, " ");
        _builder.append(" with the given id. Post create hook will be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_13 = it.getName();
        _builder.append(_name_13);
        _builder.append("(String ID, InternalModelElementContainer parent){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_14 = it.getName();
        _builder.append(_name_14, "\t");
        _builder.append("(ID,null,parent,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("def create");
        String _name_15 = it.getName();
        _builder.append(_name_15);
        _builder.append("(String ID, InternalModelElement ime, InternalModelElementContainer parent){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_16 = it.getName();
        _builder.append(_name_16, "\t");
        _builder.append("(ID,ime,parent,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_17 = it.getName();
        _builder.append(_name_17, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_18 = it.getName();
        _builder.append(_name_18);
        _builder.append("(InternalModelElement ime) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_19 = it.getName();
        _builder.append(_name_19, "\t");
        _builder.append("(generateUUID,ime,null,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (originMgl != null) {
            _builder.append("def");
        } else {
            _builder.append("override");
        }
        _builder.append(" create");
        String _name_20 = it.getName();
        _builder.append(_name_20);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_21 = it.getName();
        _builder.append(_name_21, "\t");
        _builder.append("(generateUUID)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected static CharSequence _specificCreateMethod(Edge it) {
        return FactoryGeneratorExtensions.specificCreateMethod((GraphicalModelElement)it, null);
    }

    protected static CharSequence _specificCreateMethod(Edge it, MGLModel originMgl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def create");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("(String ID, InternalModelElement ime, InternalNode source, InternalNode target, boolean hook) {");
        _builder.newLineIfNotEmpty();
        if (originMgl == null) {
            _builder.append("\t");
            _builder.append("super.create");
            String _name_1 = it.getName();
            _builder.append(_name_1, "\t");
            _builder.append(" => [");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            String _lowerCase = _generatorUtils.getFileName(originMgl).toLowerCase();
            _builder.append(_lowerCase, "\t");
            _builder.append("Factory.create");
            String _name_2 = it.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" => [");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("setID(ID)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("internal = ime ?: ");
        if (originMgl != null) {
            String _lowerCase_1 = _generatorUtils.getFileName(originMgl).toLowerCase();
            _builder.append(_lowerCase_1, "\t\t");
            _builder.append("InternalFactory.");
        }
        _builder.append("createInternal");
        String _name_3 = it.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append(" => [");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("(it as InternalEdge).set_sourceElement(source)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("(it as InternalEdge).set_targetElement(target)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("container = source?.rootElement ?: target?.rootElement");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("setID(ID + \"_INTERNAL\")");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("eAdapters.add(new ");
        String _package = MGLUtil.getMglModel((ModelElement)it).getPackage();
        _builder.append(_package, "\t\t\t");
        _builder.append(".adapter.");
        String _name_4 = it.getName();
        _builder.append(_name_4, "\t\t\t");
        _builder.append("EContentAdapter)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _postCreateHook = MGLUtil.postCreateHook((ModelElement)it);
        _builder.append((Object)_postCreateHook, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_5 = it.getName();
        _builder.append(_name_5, " ");
        _builder.append(" with the given id. Post create hook will be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_6 = it.getName();
        _builder.append(_name_6);
        _builder.append("(String ID, InternalNode source, InternalNode target){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_7 = it.getName();
        _builder.append(_name_7, "\t");
        _builder.append("(ID,null,source,target,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_8 = it.getName();
        _builder.append(_name_8, " ");
        _builder.append(" with generated id. Post create hook will be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_9 = it.getName();
        _builder.append(_name_9);
        _builder.append("(InternalNode source, InternalNode target){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_10 = it.getName();
        _builder.append(_name_10, "\t");
        _builder.append("(generateUUID,null,source,target,true)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_11 = it.getName();
        _builder.append(_name_11, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_12 = it.getName();
        _builder.append(_name_12);
        _builder.append("(String ID){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_13 = it.getName();
        _builder.append(_name_13, "\t");
        _builder.append("(ID,null,null,null,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_14 = it.getName();
        _builder.append(_name_14, " ");
        _builder.append(" with a generated id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        if (originMgl != null) {
            _builder.append("def");
        } else {
            _builder.append("override");
        }
        _builder.append(" create");
        String _name_15 = it.getName();
        _builder.append(_name_15);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_16 = it.getName();
        _builder.append(_name_16, "\t");
        _builder.append("(generateUUID)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected static CharSequence _specificCreateMethod(UserDefinedType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name = it.getName();
        _builder.append(_name, " ");
        _builder.append(" with the given id.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ID: The id for the new element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* element of the created element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param hook: Indicates, if the post create hook should be executed");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        _builder.append("(String ID, InternalModelElement ime, boolean hook){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super.create");
        String _name_2 = it.getName();
        _builder.append(_name_2, "\t");
        _builder.append(" => [ ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setID(ID)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("internal = ime ?: createInternal");
        String _name_3 = it.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append(" => [");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setID(ID + \"_INTERNAL\")");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("eAdapters.add(new ");
        String _package = MGLUtil.getMglModel((ModelElement)it).getPackage();
        _builder.append(_package, "\t\t\t");
        _builder.append(".adapter.");
        String _name_4 = it.getName();
        _builder.append(_name_4, "\t\t\t");
        _builder.append("EContentAdapter)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _postCreateHook = MGLUtil.postCreateHook((ModelElement)it);
        _builder.append((Object)_postCreateHook, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_5 = it.getName();
        _builder.append(_name_5, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_6 = it.getName();
        _builder.append(_name_6);
        _builder.append("(String ID){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_7 = it.getName();
        _builder.append(_name_7, "\t");
        _builder.append("(ID,null,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This method creates an ");
        String _name_8 = it.getName();
        _builder.append(_name_8, " ");
        _builder.append(" with the given id. Post create hook won't be triggered.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("def create");
        String _name_9 = it.getName();
        _builder.append(_name_9);
        _builder.append("(InternalModelElement ime) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_10 = it.getName();
        _builder.append(_name_10, "\t");
        _builder.append("(generateUUID,ime,false)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("override create");
        String _name_11 = it.getName();
        _builder.append(_name_11);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("create");
        String _name_12 = it.getName();
        _builder.append(_name_12, "\t");
        _builder.append("(generateUUID)");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence specificCreateMethod(ModelElement it) {
        if (it instanceof Edge) {
            return FactoryGeneratorExtensions._specificCreateMethod((Edge)it);
        }
        if (it instanceof Node) {
            return FactoryGeneratorExtensions._specificCreateMethod((Node)it);
        }
        if (it instanceof GraphModel) {
            return FactoryGeneratorExtensions._specificCreateMethod((GraphModel)it);
        }
        if (it instanceof UserDefinedType) {
            return FactoryGeneratorExtensions._specificCreateMethod((UserDefinedType)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public static CharSequence specificCreateMethod(GraphicalModelElement it, MGLModel originMgl) {
        if (it instanceof Edge) {
            return FactoryGeneratorExtensions._specificCreateMethod((Edge)it, originMgl);
        }
        if (it instanceof Node) {
            return FactoryGeneratorExtensions._specificCreateMethod((Node)it, originMgl);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, originMgl).toString());
    }
}

