/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.mgl.generator.elements.ElementEClasses;
import de.jabc.cinco.meta.core.mgl.generator.extensions.EcoreExtensions;
import de.jabc.cinco.meta.core.mgl.generator.extensions.NodeMethodsGeneratorExtensions;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension;
import de.jabc.cinco.meta.plugin.event.api.util.EventEnum;
import de.jabc.cinco.meta.util.xapi.CollectionExtension;
import graphmodel.GraphmodelPackage;
import graphmodel.ModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.ComplexAttribute;
import mgl.ContainingElement;
import mgl.EDataTypeType;
import mgl.Edge;
import mgl.EdgeElementConnection;
import mgl.Enumeration;
import mgl.GraphModel;
import mgl.GraphicalElementContainment;
import mgl.GraphicalModelElement;
import mgl.IncomingEdgeElementConnection;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.OutgoingEdgeElementConnection;
import mgl.PrimitiveAttribute;
import mgl.ReferencedEClass;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import mgl.Type;
import mgl.UserDefinedType;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import productDefinition.CincoProduct;

public class MGLEcoreGenerator {
    @Extension
    private CollectionExtension _collectionExtension = new CollectionExtension();
    @Extension
    private GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();
    @Extension
    private NodeMethodsGeneratorExtensions _nodeMethodsGeneratorExtensions = new NodeMethodsGeneratorExtensions();
    @Extension
    private EventApiExtension _eventApiExtension = new EventApiExtension();
    public final HashSet<ElementEClasses> allElementEClasses = new HashSet();
    private final HashMap<Enumeration, EEnum> eEnumMap = new HashMap();

    public EPackage generateEcoreModels(Iterable<MGLModel> mglModels, Map<MGLModel, Resource> importedExternalMGLs, Map<EModelElement, MGLModel> packageMGLModelMap, CincoProduct cp) {
        this.checkExternalMGLsHaveBeenGenerated(importedExternalMGLs);
        EPackage rootPackage = this.createEPackage(cp.getName(), cp.getName(), "info.scce.cinco.product");
        for (MGLModel mglModel : mglModels) {
            final EPackage mglEPackage = this.createEPackage(this._generatorUtils.getFileName(mglModel), this._generatorUtils.getFileName(mglModel), MGLUtil.nsURI((Annotatable)mglModel));
            packageMGLModelMap.put((EModelElement)mglEPackage, mglModel);
            EList _eSubpackages = rootPackage.getESubpackages();
            _eSubpackages.add((Object)mglEPackage);
            String _fileName = this._generatorUtils.getFileName(mglModel);
            String _plus = String.valueOf(_fileName) + "-internal";
            String _nsURI = MGLUtil.nsURI((Annotatable)mglModel);
            String _plus_1 = String.valueOf(_nsURI) + "/internal";
            final EPackage mglInternalEPackage = this.createEPackage("internal", _plus, _plus_1);
            EList _eSubpackages_1 = mglEPackage.getESubpackages();
            _eSubpackages_1.add((Object)mglInternalEPackage);
            String _fileName_1 = this._generatorUtils.getFileName(mglModel);
            String _plus_2 = String.valueOf(_fileName_1) + "-views";
            String _nsURI_1 = MGLUtil.nsURI((Annotatable)mglModel);
            String _plus_3 = String.valueOf(_nsURI_1) + "/views";
            final EPackage mglViewsEPackage = this.createEPackage("views", _plus_2, _plus_3);
            EList _eSubpackages_2 = mglEPackage.getESubpackages();
            _eSubpackages_2.add((Object)mglViewsEPackage);
            Functions.Function1<ModelElement, ElementEClasses> _function = new Functions.Function1<ModelElement, ElementEClasses>(){

                public ElementEClasses apply(ModelElement it) {
                    return new ElementEClasses(it);
                }
            };
            Consumer<ElementEClasses> _function_1 = new Consumer<ElementEClasses>(){

                @Override
                public void accept(ElementEClasses it) {
                    MGLEcoreGenerator.this.allElementEClasses.add(it);
                    EList _eClassifiers = mglEPackage.getEClassifiers();
                    EClass _mainEClass = it.getMainEClass();
                    _eClassifiers.add((Object)_mainEClass);
                    EList _eClassifiers_1 = mglInternalEPackage.getEClassifiers();
                    EClass _internalEClass = it.getInternalEClass();
                    _eClassifiers_1.add((Object)_internalEClass);
                    EList _eClassifiers_2 = mglViewsEPackage.getEClassifiers();
                    EClass _mainView = it.getMainView();
                    _eClassifiers_2.add((Object)_mainView);
                }
            };
            ListExtensions.map((List)this._generatorUtils.modelElements(mglModel), (Functions.Function1)_function).forEach(_function_1);
            Functions.Function1<UserDefinedType, ElementEClasses> _function_2 = new Functions.Function1<UserDefinedType, ElementEClasses>(){

                public ElementEClasses apply(UserDefinedType it) {
                    return new ElementEClasses((ModelElement)it);
                }
            };
            Consumer<ElementEClasses> _function_3 = new Consumer<ElementEClasses>(){

                @Override
                public void accept(ElementEClasses it) {
                    MGLEcoreGenerator.this.allElementEClasses.add(it);
                    EList _eClassifiers = mglEPackage.getEClassifiers();
                    EClass _mainEClass = it.getMainEClass();
                    _eClassifiers.add((Object)_mainEClass);
                    EList _eClassifiers_1 = mglInternalEPackage.getEClassifiers();
                    EClass _internalEClass = it.getInternalEClass();
                    _eClassifiers_1.add((Object)_internalEClass);
                    EList _eClassifiers_2 = mglViewsEPackage.getEClassifiers();
                    EClass _mainView = it.getMainView();
                    _eClassifiers_2.add((Object)_mainView);
                }
            };
            IterableExtensions.map((Iterable)Iterables.filter((Iterable)mglModel.getTypes(), UserDefinedType.class), (Functions.Function1)_function_2).forEach(_function_3);
            Consumer<Enumeration> _function_4 = new Consumer<Enumeration>(){

                @Override
                public void accept(Enumeration it) {
                    EEnum eEnum = MGLEcoreGenerator.this.createEnumeration(it);
                    MGLEcoreGenerator.this.eEnumMap.put(it, eEnum);
                    EList _eClassifiers = mglEPackage.getEClassifiers();
                    _eClassifiers.add((Object)eEnum);
                }
            };
            Iterables.filter((Iterable)mglModel.getTypes(), Enumeration.class).forEach(_function_4);
        }
        this.addAttributesToInternalEClasses(this.allElementEClasses);
        this.populateAll(this.allElementEClasses);
        this.populateModelElementEClasses(this.allElementEClasses);
        this.populateContainingElementEClasses(this.allElementEClasses);
        this.populateGraphModelEClasses(this.allElementEClasses);
        this.populateNodeEClasses(this.allElementEClasses);
        this.populateEdgeEClasses(this.allElementEClasses);
        this.setSuperTypes(this.allElementEClasses);
        this.referenceAndPopulateMainView(this.allElementEClasses);
        return rootPackage;
    }

    private void checkExternalMGLsHaveBeenGenerated(Map<MGLModel, Resource> importedExternalMGLs) {
        try {
            Set<Map.Entry<MGLModel, Resource>> _entrySet = importedExternalMGLs.entrySet();
            for (Map.Entry<MGLModel, Resource> externalMGLEntry : _entrySet) {
                Resource mglEcore = externalMGLEntry.getValue();
                mglEcore.load(null);
                final Iterable ecoreEClasses = Iterables.filter((Iterable)IteratorExtensions.toList((Iterator)mglEcore.getAllContents()), EClass.class);
                Consumer<ModelElement> _function = new Consumer<ModelElement>(){

                    @Override
                    public void accept(final ModelElement it) {
                        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                            public Boolean apply(EClass eObj) {
                                String _name = eObj.getName();
                                String _name_1 = it.getName();
                                return Objects.equal((Object)_name, (Object)_name_1);
                            }
                        };
                        EClass eClass = (EClass)IterableExtensions.findFirst((Iterable)ecoreEClasses, (Functions.Function1)_function);
                        Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

                            public Boolean apply(EClass eObj) {
                                String _name = eObj.getName();
                                String _name_1 = it.getName();
                                String _plus = "Internal" + _name_1;
                                return Objects.equal((Object)_name, (Object)_plus);
                            }
                        };
                        EClass internalEClass = (EClass)IterableExtensions.findFirst((Iterable)ecoreEClasses, (Functions.Function1)_function_1);
                        Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

                            public Boolean apply(EClass eObj) {
                                String _name = eObj.getName();
                                String _name_1 = it.getName();
                                String _plus = String.valueOf(_name_1) + "View";
                                return Objects.equal((Object)_name, (Object)_plus);
                            }
                        };
                        EClass mainView = (EClass)IterableExtensions.findFirst((Iterable)ecoreEClasses, (Functions.Function1)_function_2);
                        if (eClass == null || internalEClass == null || mainView == null) {
                            String _name = it.getName();
                            String _plus = "The ecore representation of " + _name;
                            String _plus_1 = String.valueOf(_plus) + " could not be found.";
                            throw new RuntimeException(_plus_1);
                        }
                    }
                };
                this._generatorUtils.modelElements(externalMGLEntry.getKey()).forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private EPackage createEPackage(String name, String prefix, String nsURI) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name.toLowerCase());
        ePackage.setNsPrefix(prefix.toLowerCase());
        ePackage.setNsURI(nsURI);
        return ePackage;
    }

    private EEnum createEnumeration(Enumeration enumeration) {
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        eEnum.setName(enumeration.getName());
        final ArrayList literals = new ArrayList();
        Procedures.Procedure2<String, Integer> _function = new Procedures.Procedure2<String, Integer>(){

            public void apply(String literal, Integer index) {
                EEnumLiteral eLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                eLiteral.setLiteral(literal);
                eLiteral.setName(literal);
                eLiteral.setValue(index.intValue());
                literals.add(eLiteral);
            }
        };
        IterableExtensions.forEach((Iterable)enumeration.getLiterals(), (Procedures.Procedure2)_function);
        EList _eLiterals = eEnum.getELiterals();
        Iterables.addAll((Collection)_eLiterals, literals);
        return eEnum;
    }

    private void addAttributesToInternalEClasses(Set<ElementEClasses> elementEClasses) {
        for (ElementEClasses eec : elementEClasses) {
            Iterable _allAttributes = MGLUtil.allAttributes((ModelElement)eec.getModelElement(), (boolean)false);
            for (final Attribute attribute : _allAttributes) {
                Type _type;
                boolean _matched = false;
                if (attribute instanceof ComplexAttribute && (_type = ((ComplexAttribute)attribute).getType()) instanceof Enumeration) {
                    _matched = true;
                    EcoreExtensions.createEAttribute(eec.getInternalEClass(), ((ComplexAttribute)attribute).getName(), (EClassifier)this.eEnumMap.get(((ComplexAttribute)attribute).getType()), ((ComplexAttribute)attribute).getLowerBound(), ((ComplexAttribute)attribute).getUpperBound()).setDefaultValue((Object)((ComplexAttribute)attribute).getDefaultValue());
                }
                if (!_matched && attribute instanceof ComplexAttribute) {
                    _matched = true;
                    Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                        public Boolean apply(ElementEClasses it) {
                            return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ComplexAttribute)attribute).getType());
                        }
                    };
                    Type _type2 = ((ComplexAttribute)attribute).getType();
                    EcoreExtensions.createReference(eec.getInternalEClass(), ((ComplexAttribute)attribute).getName(), ((ElementEClasses)IterableExtensions.findFirst(elementEClasses, (Functions.Function1)_function)).getMainEClass(), ((ComplexAttribute)attribute).getLowerBound(), ((ComplexAttribute)attribute).getUpperBound(), _type2 instanceof UserDefinedType, null);
                }
                if (_matched || !(attribute instanceof PrimitiveAttribute)) continue;
                _matched = true;
                EcoreExtensions.createEAttribute(eec.getInternalEClass(), ((PrimitiveAttribute)attribute).getName(), (EClassifier)this.getEDataType(((PrimitiveAttribute)attribute).getType()), ((PrimitiveAttribute)attribute).getLowerBound(), ((PrimitiveAttribute)attribute).getUpperBound()).setDefaultValue((Object)((PrimitiveAttribute)attribute).getDefaultValue());
            }
        }
    }

    private void populateAll(Set<ElementEClasses> elementEClasses) {
        Consumer<ElementEClasses> _function = new Consumer<ElementEClasses>(){

            @Override
            public void accept(final ElementEClasses it) {
                Consumer<Attribute> _function = new Consumer<Attribute>(){

                    @Override
                    public void accept(Attribute attribute) {
                        boolean _notEquals;
                        MGLEcoreGenerator.this.createGetter(it.getMainEClass(), it, attribute);
                        MGLEcoreGenerator.this.createSetter(it.getMainEClass(), it, attribute);
                        Integer _upperBound = attribute.getUpperBound();
                        boolean bl = _notEquals = _upperBound != 1;
                        if (_notEquals) {
                            MGLEcoreGenerator.this.createAdder(it.getMainEClass(), it, attribute);
                            MGLEcoreGenerator.this.createRemove(it.getMainEClass(), it, attribute);
                        }
                    }
                };
                MGLUtil.nonConflictingAttributes((ModelElement)it.getModelElement()).forEach(_function);
                EClass _mainEClass = it.getMainEClass();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("getInternal");
                String _name = it.getModelElement().getName();
                _builder.append(_name);
                EClass _internalEClass = it.getInternalEClass();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("return (");
                CharSequence _fqInternalBeanName = MGLEcoreGenerator.this._generatorUtils.fqInternalBeanName((Type)it.getModelElement());
                _builder_1.append((Object)_fqInternalBeanName);
                _builder_1.append(") getInternalElement_();");
                EcoreExtensions.createEOperation(_mainEClass, _builder.toString(), (EClassifier)_internalEClass, 0, 1, (CharSequence)_builder_1, new EParameter[0]);
                EClass _mainEClass_1 = it.getMainEClass();
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("isExactly");
                String _name_1 = it.getModelElement().getName();
                _builder_2.append(_name_1);
                EcoreExtensions.createEOperation(_mainEClass_1, _builder_2.toString(), (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), 0, 1, "return true;", new EParameter[0]);
            }
        };
        elementEClasses.forEach(_function);
    }

    private void populateModelElementEClasses(final Set<ElementEClasses> elementEClasses) {
        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

            public Boolean apply(ElementEClasses it) {
                return it.getModelElement() instanceof ModelElement && !(it.getModelElement() instanceof UserDefinedType);
            }
        };
        Consumer<ElementEClasses> _function_1 = new Consumer<ElementEClasses>(){

            @Override
            public void accept(ElementEClasses it) {
                final GraphModel mostCommonGraphModel = MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.mostCommonGraphModel(it.getModelElement(), elementEClasses);
                EClass _mainEClass = it.getMainEClass();
                StringConcatenation _builder = new StringConcatenation();
                Annotation preDeleteAnnotation = MGLUtil.getAnnotation((ModelElement)it.getModelElement(), (String)"preDelete");
                _builder.newLineIfNotEmpty();
                if (preDeleteAnnotation != null) {
                    _builder.append("new ");
                    String _get = (String)preDeleteAnnotation.getValue().get(0);
                    _builder.append(_get);
                    _builder.append("().preDelete(this);");
                    _builder.newLineIfNotEmpty();
                }
                String _notifyCallJava = EventEnum.PRE_DELETE.getNotifyCallJava(it.getModelElement(), new String[]{"this"});
                _builder.append(_notifyCallJava);
                _builder.newLineIfNotEmpty();
                EcoreExtensions.createEOperation(_mainEClass, "preDelete", null, 1, 1, (CharSequence)_builder, new EParameter[0]);
                EClass _mainEClass_1 = it.getMainEClass();
                EClass _runnable = GraphmodelPackage.eINSTANCE.getRunnable();
                StringConcatenation _builder_1 = new StringConcatenation();
                Annotation postDeleteAnnotation = MGLUtil.getAnnotation((ModelElement)it.getModelElement(), (String)"postDelete");
                _builder_1.newLineIfNotEmpty();
                if (postDeleteAnnotation != null) {
                    _builder_1.append("de.jabc.cinco.meta.runtime.hook.CincoPostDeleteHook<? super ");
                    CharSequence _fqBeanName = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)it.getModelElement());
                    _builder_1.append((Object)_fqBeanName);
                    _builder_1.append("> postDeleteHook = new ");
                    String _get_1 = (String)postDeleteAnnotation.getValue().get(0);
                    _builder_1.append(_get_1);
                    _builder_1.append("();");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("return postDeleteHook.getPostDeleteFunction(this);");
                    _builder_1.newLine();
                } else {
                    _builder_1.append("return () -> {};");
                    _builder_1.newLine();
                }
                EcoreExtensions.createEOperation(_mainEClass_1, "getPostDeleteFunction", (EClassifier)_runnable, 1, 1, (CharSequence)_builder_1, new EParameter[0]);
                EClass _mainEClass_2 = it.getMainEClass();
                EClass _runnable_1 = GraphmodelPackage.eINSTANCE.getRunnable();
                StringConcatenation _builder_2 = new StringConcatenation();
                if (MGLEcoreGenerator.this._eventApiExtension.isEventEnabled(it.getModelElement()) && EventEnum.POST_DELETE.accepts(it.getModelElement())) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("postDelete");
                    String _fuName = MGLEcoreGenerator.this._generatorUtils.fuName(it.getModelElement());
                    _builder_3.append(_fuName);
                    _builder_3.append("Runnable");
                    String _notifyCallJava_1 = EventEnum.POST_DELETE.getNotifyCallJava(_builder_3.toString(), it.getModelElement(), new String[]{"this"});
                    _builder_2.append(_notifyCallJava_1);
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("if (postDelete");
                    String _fuName_1 = MGLEcoreGenerator.this._generatorUtils.fuName(it.getModelElement());
                    _builder_2.append(_fuName_1);
                    _builder_2.append("Runnable == null) {");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("\t");
                    _builder_2.append("return () -> {};");
                    _builder_2.newLine();
                    _builder_2.append("}");
                    _builder_2.newLine();
                    _builder_2.append("else {");
                    _builder_2.newLine();
                    _builder_2.append("\t");
                    _builder_2.append("return postDelete");
                    String _fuName_2 = MGLEcoreGenerator.this._generatorUtils.fuName(it.getModelElement());
                    _builder_2.append(_fuName_2, "\t");
                    _builder_2.append("Runnable;");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("}");
                    _builder_2.newLine();
                } else {
                    _builder_2.append("return () -> {};");
                    _builder_2.newLine();
                }
                EcoreExtensions.createEOperation(_mainEClass_2, "getPostDeleteEvent", (EClassifier)_runnable_1, 1, 1, (CharSequence)_builder_2, new EParameter[0]);
                EcoreExtensions.createEOperation(it.getMainEClass(), "preSave", null, 1, 1, MGLEcoreGenerator.this._generatorUtils.writeMethodCallPreSave(it.getModelElement(), "this.getRootElement()"), new EParameter[0]);
                EcoreExtensions.createEOperation(it.getMainEClass(), "postSave", null, 1, 1, MGLEcoreGenerator.this._generatorUtils.writeMethodCallPostSave(it.getModelElement(), "this.getRootElement()"), new EParameter[0]);
                EClass _mainEClass_3 = it.getMainEClass();
                EClass _elvis = null;
                Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)mostCommonGraphModel);
                    }
                };
                ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                EClass _mainEClass_4 = null;
                if (_findFirst != null) {
                    _mainEClass_4 = _findFirst.getMainEClass();
                }
                if (_mainEClass_4 != null) {
                    _elvis = _mainEClass_4;
                } else {
                    EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("GraphModel");
                    _elvis = _eClassifier;
                }
                StringConcatenation _builder_4 = new StringConcatenation();
                ModelElement _modelElement = it.getModelElement();
                if (_modelElement instanceof GraphModel) {
                    _builder_4.append("return this;");
                    _builder_4.newLine();
                } else {
                    _builder_4.newLine();
                    _builder_4.append("if (this.getInternalElement_() != null && this.getInternalElement_().getRootElement() != null) {");
                    _builder_4.newLine();
                    _builder_4.append("\t");
                    _builder_4.append("return (");
                    if (mostCommonGraphModel != null) {
                        CharSequence _fqBeanName_1 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)mostCommonGraphModel);
                        _builder_4.append((Object)_fqBeanName_1, "\t");
                    } else {
                        _builder_4.append("graphmodel.GraphModel");
                    }
                    _builder_4.append(") this.getInternalElement_().getRootElement().getElement();");
                    _builder_4.newLineIfNotEmpty();
                    _builder_4.append("}");
                    _builder_4.newLine();
                    _builder_4.append("return null;");
                    _builder_4.newLine();
                }
                EcoreExtensions.createEOperation(_mainEClass_3, "getRootElement", (EClassifier)_elvis, 0, 1, (CharSequence)_builder_4, new EParameter[0]);
            }
        };
        IterableExtensions.filter(elementEClasses, (Functions.Function1)_function).forEach(_function_1);
    }

    private void populateContainingElementEClasses(final Set<ElementEClasses> elementEClasses) {
        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

            public Boolean apply(ElementEClasses it) {
                ModelElement _modelElement = it.getModelElement();
                return _modelElement instanceof ContainingElement;
            }
        };
        Consumer<ElementEClasses> _function_1 = new Consumer<ElementEClasses>(){

            @Override
            public void accept(final ElementEClasses it) {
                ModelElement _modelElement = it.getModelElement();
                Functions.Function1<Node, Iterable<Node>> _function = new Functions.Function1<Node, Iterable<Node>>(){

                    public Iterable<Node> apply(Node cn) {
                        Iterable _filter = Iterables.filter((Iterable)(this).MGLEcoreGenerator.this._generatorUtils.allNodeSubTypes(cn), Node.class);
                        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Node[]{cn})), (Iterable)_filter);
                    }
                };
                Iterable containingElements = Iterables.filter((Iterable)MGLUtil.removeDuplicateModelElements((Iterable)IterableExtensions.flatMap((Iterable)MGLUtil.getContainableNodes((ContainingElement)((ContainingElement)_modelElement)), (Functions.Function1)_function)), Node.class);
                EClass _mainEClass = it.getMainEClass();
                EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return org.eclipse.emf.common.util.ECollections.unmodifiableEList(getInternalContainerElement().getModelElements()");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append(".stream().filter(me -> me instanceof graphmodel.internal.InternalNode).map(me -> (graphmodel.Node)me.getElement()).");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("collect(java.util.stream.Collectors.toList()));");
                _builder.newLine();
                EcoreExtensions.createGenericListEOperation(_mainEClass, "getNodes", _eClassifier, 0, -1, (CharSequence)_builder, new EParameter[0]);
                EClass _internalEClass = it.getInternalEClass();
                EClass _containmentConstraint = GraphmodelPackage.eINSTANCE.getContainmentConstraint();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(" ");
                _builder_1.append("org.eclipse.emf.common.util.BasicEList<ContainmentConstraint>constraints =");
                _builder_1.newLine();
                _builder_1.append("\t");
                _builder_1.append("new org.eclipse.emf.common.util.BasicEList<ContainmentConstraint>();");
                _builder_1.newLine();
                ModelElement _modelElement_1 = it.getModelElement();
                Functions.Function1<GraphicalElementContainment, Boolean> _function_1 = new Functions.Function1<GraphicalElementContainment, Boolean>(){

                    public Boolean apply(GraphicalElementContainment it) {
                        int _size = it.getTypes().size();
                        return _size > 0;
                    }
                };
                Iterable _filter = IterableExtensions.filter(MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.getAllContainmentConstraints((ContainingElement)_modelElement_1), (Functions.Function1)_function_1);
                for (GraphicalElementContainment containmentConstraint : _filter) {
                    CharSequence _containmentConstraint_1 = MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.containmentConstraint(containmentConstraint);
                    _builder_1.append((Object)_containmentConstraint_1);
                    _builder_1.newLineIfNotEmpty();
                }
                _builder_1.append("return constraints;");
                _builder_1.newLine();
                EcoreExtensions.createEOperation(_internalEClass, "getContainmentConstraints", (EClassifier)_containmentConstraint, 0, -1, (CharSequence)_builder_1, new EParameter[0]);
                Consumer<Node> _function_2 = new Consumer<Node>(){

                    @Override
                    public void accept(final Node containableNode) {
                        boolean _not;
                        EClass _mainEClass = it.getMainEClass();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("get");
                        String _fuName = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                        _builder.append(_fuName);
                        _builder.append("s");
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass_1 = null;
                        if (_findFirst != null) {
                            _mainEClass_1 = _findFirst.getMainEClass();
                        }
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("return getModelElements(");
                        CharSequence _fqBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                        _builder_1.append((Object)_fqBeanName);
                        _builder_1.append(".class);");
                        EcoreExtensions.createEOperation(_mainEClass, _builder.toString(), (EClassifier)_mainEClass_1, 0, -1, (CharSequence)_builder_1, new EParameter[0]);
                        boolean _isIsAbstract = containableNode.isIsAbstract();
                        boolean bl = _not = !_isIsAbstract;
                        if (_not) {
                            EClass _mainEClass_2 = it.getMainEClass();
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append("canNew");
                            String _fuName_1 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                            _builder_2.append(_fuName_1);
                            EDataType _eBoolean = EcorePackage.eINSTANCE.getEBoolean();
                            StringConcatenation _builder_3 = new StringConcatenation();
                            _builder_3.append("return this.canContain(");
                            CharSequence _fqBeanName_1 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                            _builder_3.append((Object)_fqBeanName_1);
                            _builder_3.append(".class);");
                            EcoreExtensions.createEOperation(_mainEClass_2, _builder_2.toString(), (EClassifier)_eBoolean, 1, 1, (CharSequence)_builder_3, new EParameter[0]);
                            boolean _isPrime = (this).MGLEcoreGenerator.this._generatorUtils.isPrime(containableNode);
                            if (_isPrime) {
                                StringConcatenation _builder_4 = new StringConcatenation();
                                _builder_4.append("return new");
                                String _fuName_2 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_4.append(_fuName_2);
                                _builder_4.append("(");
                                String _primeName = (this).MGLEcoreGenerator.this._generatorUtils.primeName(containableNode);
                                _builder_4.append(_primeName);
                                _builder_4.append(",x,y,-1,-1);");
                                String newPrimeNodeSimpleMethodContent = _builder_4.toString();
                                StringConcatenation _builder_5 = new StringConcatenation();
                                _builder_5.append("if (this.canContain(");
                                CharSequence _fqBeanName_2 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                                _builder_5.append((Object)_fqBeanName_2);
                                _builder_5.append(".class)) {");
                                _builder_5.newLineIfNotEmpty();
                                _builder_5.append("\t");
                                CharSequence _fqBeanName_3 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                                _builder_5.append((Object)_fqBeanName_3, "\t");
                                _builder_5.append(" node = ");
                                CharSequence _fqFactoryName = (this).MGLEcoreGenerator.this._generatorUtils.fqFactoryName((ModelElement)containableNode);
                                _builder_5.append((Object)_fqFactoryName, "\t");
                                _builder_5.append(".eINSTANCE.create");
                                String _fuName_3 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_5.append(_fuName_3, "\t");
                                _builder_5.append("();");
                                _builder_5.newLineIfNotEmpty();
                                _builder_5.append("\t");
                                _builder_5.append("this.getInternalContainerElement().getModelElements().add(node.getInternalElement_());");
                                _builder_5.newLine();
                                _builder_5.append("\t");
                                _builder_5.append("((");
                                CharSequence _fqInternalBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqInternalBeanName((Type)containableNode);
                                _builder_5.append((Object)_fqInternalBeanName, "\t");
                                _builder_5.append(") node.getInternalElement_())");
                                _builder_5.newLineIfNotEmpty();
                                _builder_5.append("\t\t");
                                _builder_5.append(".setLibraryComponentUID(org.eclipse.emf.ecore.util.EcoreUtil.getID(");
                                String _primeName_1 = (this).MGLEcoreGenerator.this._generatorUtils.primeName(containableNode);
                                _builder_5.append(_primeName_1, "\t\t");
                                _builder_5.append("));");
                                _builder_5.newLineIfNotEmpty();
                                _builder_5.append("\t");
                                _builder_5.append("node.move(x, y);");
                                _builder_5.newLine();
                                _builder_5.append("\t");
                                _builder_5.append("node.resize(width, height);");
                                _builder_5.newLine();
                                boolean _hasPostCreateHook = MGLUtil.hasPostCreateHook((ModelElement)containableNode);
                                if (_hasPostCreateHook) {
                                    _builder_5.append("\t");
                                    CharSequence _fqFactoryName_1 = (this).MGLEcoreGenerator.this._generatorUtils.fqFactoryName((ModelElement)containableNode);
                                    _builder_5.append((Object)_fqFactoryName_1, "\t");
                                    _builder_5.append(".eINSTANCE.postCreates(node);");
                                    _builder_5.newLineIfNotEmpty();
                                }
                                _builder_5.append("\t");
                                _builder_5.append("return node;");
                                _builder_5.newLine();
                                _builder_5.append("} else throw new ");
                                String _name = RuntimeException.class.getName();
                                _builder_5.append(_name);
                                _builder_5.append("(");
                                _builder_5.newLineIfNotEmpty();
                                _builder_5.append("\t");
                                String _name_1 = String.class.getName();
                                _builder_5.append(_name_1, "\t");
                                _builder_5.append(".format(\"Cannot add node %s to %s\", ");
                                String _fuName_4 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_5.append(_fuName_4, "\t");
                                _builder_5.append(".class, this.getClass()));");
                                _builder_5.newLineIfNotEmpty();
                                String newPrimeNodeMethodContent = _builder_5.toString();
                                EClass _mainEClass_3 = it.getMainEClass();
                                StringConcatenation _builder_6 = new StringConcatenation();
                                _builder_6.append("new");
                                String _fuName_5 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_6.append(_fuName_5);
                                EClass _elvis = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_1 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_1 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_1);
                                EClass _mainEClass_4 = null;
                                if (_findFirst_1 != null) {
                                    _mainEClass_4 = _findFirst_1.getMainEClass();
                                }
                                if (_mainEClass_4 != null) {
                                    _elvis = _mainEClass_4;
                                } else {
                                    EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis = _eClassifier;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_3, _builder_6.toString(), (EClassifier)_elvis, 1, 1, newPrimeNodeSimpleMethodContent, EcoreExtensions.createEObjectParameter((this).MGLEcoreGenerator.this._generatorUtils.primeName(containableNode), 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                                EClass _mainEClass_5 = it.getMainEClass();
                                StringConcatenation _builder_7 = new StringConcatenation();
                                _builder_7.append("new");
                                String _fuName_6 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_7.append(_fuName_6);
                                EClass _elvis_1 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_2 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_2 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_2);
                                EClass _mainEClass_6 = null;
                                if (_findFirst_2 != null) {
                                    _mainEClass_6 = _findFirst_2.getMainEClass();
                                }
                                if (_mainEClass_6 != null) {
                                    _elvis_1 = _mainEClass_6;
                                } else {
                                    EClassifier _eClassifier_1 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_1 = _eClassifier_1;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_5, _builder_7.toString(), (EClassifier)_elvis_1, 1, 1, newPrimeNodeSimpleMethodContent, EcoreExtensions.createEObjectParameter((this).MGLEcoreGenerator.this._generatorUtils.primeName(containableNode), 1, 1), EcoreExtensions.createEStringParameter("id", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                                EClass _mainEClass_7 = it.getMainEClass();
                                StringConcatenation _builder_8 = new StringConcatenation();
                                _builder_8.append("new");
                                String _fuName_7 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_8.append(_fuName_7);
                                EClass _elvis_2 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_3 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_3 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_3);
                                EClass _mainEClass_8 = null;
                                if (_findFirst_3 != null) {
                                    _mainEClass_8 = _findFirst_3.getMainEClass();
                                }
                                if (_mainEClass_8 != null) {
                                    _elvis_2 = _mainEClass_8;
                                } else {
                                    EClassifier _eClassifier_2 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_2 = _eClassifier_2;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_7, _builder_8.toString(), (EClassifier)_elvis_2, 1, 1, newPrimeNodeMethodContent, EcoreExtensions.createEObjectParameter((this).MGLEcoreGenerator.this._generatorUtils.primeName(containableNode), 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1), EcoreExtensions.createEIntParameter("width", 1, 1), EcoreExtensions.createEIntParameter("height", 1, 1));
                                EClass _mainEClass_9 = it.getMainEClass();
                                StringConcatenation _builder_9 = new StringConcatenation();
                                _builder_9.append("new");
                                String _fuName_8 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_9.append(_fuName_8);
                                EClass _elvis_3 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_4 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_4 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_4);
                                EClass _mainEClass_10 = null;
                                if (_findFirst_4 != null) {
                                    _mainEClass_10 = _findFirst_4.getMainEClass();
                                }
                                if (_mainEClass_10 != null) {
                                    _elvis_3 = _mainEClass_10;
                                } else {
                                    EClassifier _eClassifier_3 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_3 = _eClassifier_3;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_9, _builder_9.toString(), (EClassifier)_elvis_3, 1, 1, newPrimeNodeMethodContent, EcoreExtensions.createEObjectParameter((this).MGLEcoreGenerator.this._generatorUtils.primeName(containableNode), 1, 1), EcoreExtensions.createEStringParameter("id", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1), EcoreExtensions.createEIntParameter("width", 1, 1), EcoreExtensions.createEIntParameter("height", 1, 1));
                            } else {
                                StringConcatenation _builder_10 = new StringConcatenation();
                                _builder_10.append("return new");
                                String _fuName_9 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_10.append(_fuName_9);
                                _builder_10.append("(x, y, -1, -1);");
                                String newNodeSimpleMethodContent = _builder_10.toString();
                                StringConcatenation _builder_11 = new StringConcatenation();
                                _builder_11.append("if (this.canContain(");
                                CharSequence _fqBeanName_4 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                                _builder_11.append((Object)_fqBeanName_4);
                                _builder_11.append(".class)) {");
                                _builder_11.newLineIfNotEmpty();
                                _builder_11.append("\t");
                                CharSequence _fqBeanName_5 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                                _builder_11.append((Object)_fqBeanName_5, "\t");
                                _builder_11.append(" node = ");
                                CharSequence _fqFactoryName_2 = (this).MGLEcoreGenerator.this._generatorUtils.fqFactoryName((ModelElement)containableNode);
                                _builder_11.append((Object)_fqFactoryName_2, "\t");
                                _builder_11.append(".eINSTANCE.create");
                                String _fuName_10 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_11.append(_fuName_10, "\t");
                                _builder_11.append("((graphmodel.internal.InternalModelElementContainer) this.getInternalElement_());");
                                _builder_11.newLineIfNotEmpty();
                                _builder_11.append("\t");
                                _builder_11.append("this.getInternalContainerElement().getModelElements().add(node.getInternalElement_());");
                                _builder_11.newLine();
                                _builder_11.append("\t");
                                _builder_11.append("node.move(x, y);");
                                _builder_11.newLine();
                                _builder_11.append("\t");
                                _builder_11.append("node.resize(width, height);");
                                _builder_11.newLine();
                                _builder_11.append("\t");
                                _builder_11.append("return node;");
                                _builder_11.newLine();
                                _builder_11.append("} else throw new ");
                                String _name_2 = RuntimeException.class.getName();
                                _builder_11.append(_name_2);
                                _builder_11.append("(");
                                _builder_11.newLineIfNotEmpty();
                                _builder_11.append("\t");
                                String _name_3 = String.class.getName();
                                _builder_11.append(_name_3, "\t");
                                _builder_11.append(".format(\"Cannot add node %s to %s\", ");
                                CharSequence _fqBeanName_6 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)containableNode);
                                _builder_11.append((Object)_fqBeanName_6, "\t");
                                _builder_11.append(".class, this.getClass()));");
                                _builder_11.newLineIfNotEmpty();
                                String newNodeMethodContent = _builder_11.toString();
                                EClass _mainEClass_11 = it.getMainEClass();
                                StringConcatenation _builder_12 = new StringConcatenation();
                                _builder_12.append("new");
                                String _fuName_11 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_12.append(_fuName_11);
                                EClass _elvis_4 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_5 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_5 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_5);
                                EClass _mainEClass_12 = null;
                                if (_findFirst_5 != null) {
                                    _mainEClass_12 = _findFirst_5.getMainEClass();
                                }
                                if (_mainEClass_12 != null) {
                                    _elvis_4 = _mainEClass_12;
                                } else {
                                    EClassifier _eClassifier_4 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_4 = _eClassifier_4;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_11, _builder_12.toString(), (EClassifier)_elvis_4, 1, 1, newNodeSimpleMethodContent, EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                                EClass _mainEClass_13 = it.getMainEClass();
                                StringConcatenation _builder_13 = new StringConcatenation();
                                _builder_13.append("new");
                                String _fuName_12 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_13.append(_fuName_12);
                                EClass _elvis_5 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_6 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_6 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_6);
                                EClass _mainEClass_14 = null;
                                if (_findFirst_6 != null) {
                                    _mainEClass_14 = _findFirst_6.getMainEClass();
                                }
                                if (_mainEClass_14 != null) {
                                    _elvis_5 = _mainEClass_14;
                                } else {
                                    EClassifier _eClassifier_5 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_5 = _eClassifier_5;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_13, _builder_13.toString(), (EClassifier)_elvis_5, 1, 1, newNodeSimpleMethodContent, EcoreExtensions.createEStringParameter("id", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                                EClass _mainEClass_15 = it.getMainEClass();
                                StringConcatenation _builder_14 = new StringConcatenation();
                                _builder_14.append("new");
                                String _fuName_13 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_14.append(_fuName_13);
                                EClass _elvis_6 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_7 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_7 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_7);
                                EClass _mainEClass_16 = null;
                                if (_findFirst_7 != null) {
                                    _mainEClass_16 = _findFirst_7.getMainEClass();
                                }
                                if (_mainEClass_16 != null) {
                                    _elvis_6 = _mainEClass_16;
                                } else {
                                    EClassifier _eClassifier_6 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_6 = _eClassifier_6;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_15, _builder_14.toString(), (EClassifier)_elvis_6, 1, 1, newNodeMethodContent, EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1), EcoreExtensions.createEIntParameter("width", 1, 1), EcoreExtensions.createEIntParameter("height", 1, 1));
                                EClass _mainEClass_17 = it.getMainEClass();
                                StringConcatenation _builder_15 = new StringConcatenation();
                                _builder_15.append("new");
                                String _fuName_14 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)containableNode);
                                _builder_15.append(_fuName_14);
                                EClass _elvis_7 = null;
                                Functions.Function1<ElementEClasses, Boolean> _function_8 = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)containableNode);
                                    }
                                };
                                ElementEClasses _findFirst_8 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_8);
                                EClass _mainEClass_18 = null;
                                if (_findFirst_8 != null) {
                                    _mainEClass_18 = _findFirst_8.getMainEClass();
                                }
                                if (_mainEClass_18 != null) {
                                    _elvis_7 = _mainEClass_18;
                                } else {
                                    EClassifier _eClassifier_7 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                                    _elvis_7 = _eClassifier_7;
                                }
                                EcoreExtensions.createEOperation(_mainEClass_17, _builder_15.toString(), (EClassifier)_elvis_7, 1, 1, newNodeMethodContent, EcoreExtensions.createEStringParameter("id", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1), EcoreExtensions.createEIntParameter("width", 1, 1), EcoreExtensions.createEIntParameter("height", 1, 1));
                            }
                        }
                    }
                };
                containingElements.forEach(_function_2);
            }
        };
        IterableExtensions.filter(elementEClasses, (Functions.Function1)_function).forEach(_function_1);
    }

    private void populateGraphModelEClasses(Set<ElementEClasses> elementEClasses) {
        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

            public Boolean apply(ElementEClasses it) {
                ModelElement _modelElement = it.getModelElement();
                return _modelElement instanceof GraphModel;
            }
        };
        Consumer<ElementEClasses> _function_1 = new Consumer<ElementEClasses>(){

            @Override
            public void accept(ElementEClasses it) {
                EClass _mainEClass = it.getMainEClass();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("new");
                String _fuName = MGLEcoreGenerator.this._generatorUtils.fuName(it.getModelElement());
                _builder.append(_fuName);
                EClass _mainEClass_1 = it.getMainEClass();
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name = IPath.class.getName();
                _builder_1.append(_name);
                _builder_1.append(" filePath = new ");
                String _name_1 = Path.class.getName();
                _builder_1.append(_name_1);
                _builder_1.append("(path).append(fileName).addFileExtension(\"");
                String _lowerCase = it.getModelElement().getName().toLowerCase();
                _builder_1.append(_lowerCase);
                _builder_1.append("\");");
                _builder_1.newLineIfNotEmpty();
                String _name_2 = URI.class.getName();
                _builder_1.append(_name_2);
                _builder_1.append(" uri = ");
                String _name_3 = URI.class.getName();
                _builder_1.append(_name_3);
                _builder_1.append(".createPlatformResourceURI(filePath.toOSString(), true);");
                _builder_1.newLineIfNotEmpty();
                String _name_4 = IFile.class.getName();
                _builder_1.append(_name_4);
                _builder_1.append(" file = ");
                String _name_5 = ResourcesPlugin.class.getName();
                _builder_1.append(_name_5);
                _builder_1.append(".getWorkspace().getRoot().getFile(filePath);");
                _builder_1.newLineIfNotEmpty();
                String _name_6 = Resource.class.getName();
                _builder_1.append(_name_6);
                _builder_1.append(" res = new ");
                String _name_7 = ResourceSetImpl.class.getName();
                _builder_1.append(_name_7);
                _builder_1.append("().createResource(uri);");
                _builder_1.newLineIfNotEmpty();
                CharSequence _fqBeanName = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)it.getModelElement());
                _builder_1.append((Object)_fqBeanName);
                _builder_1.append(" graph = ");
                CharSequence _fqFactoryName = MGLEcoreGenerator.this._generatorUtils.fqFactoryName(it.getModelElement());
                _builder_1.append((Object)_fqFactoryName);
                _builder_1.append(".eINSTANCE.create");
                String _fuName_1 = MGLEcoreGenerator.this._generatorUtils.fuName(it.getModelElement());
                _builder_1.append(_fuName_1);
                _builder_1.append("();");
                _builder_1.newLineIfNotEmpty();
                _builder_1.newLine();
                String _name_8 = EcoreUtil.class.getName();
                _builder_1.append(_name_8);
                _builder_1.append(".setID(graph, ");
                String _name_9 = EcoreUtil.class.getName();
                _builder_1.append(_name_9);
                _builder_1.append(".generateUUID());");
                _builder_1.newLineIfNotEmpty();
                _builder_1.newLine();
                _builder_1.append("res.getContents().add(graph.getInternalElement_());");
                _builder_1.newLine();
                _builder_1.newLine();
                boolean _hasPostCreateHook = MGLUtil.hasPostCreateHook((ModelElement)it.getModelElement());
                if (_hasPostCreateHook) {
                    _builder_1.append("if (postCreateHook)");
                    _builder_1.newLine();
                    _builder_1.append("\t");
                    CharSequence _fqFactoryName_1 = MGLEcoreGenerator.this._generatorUtils.fqFactoryName(it.getModelElement());
                    _builder_1.append((Object)_fqFactoryName_1, "\t");
                    _builder_1.append(".eINSTANCE.postCreates((");
                    CharSequence _fqBeanName_1 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)it.getModelElement());
                    _builder_1.append((Object)_fqBeanName_1, "\t");
                    _builder_1.append(") graph);");
                    _builder_1.newLineIfNotEmpty();
                }
                _builder_1.append("try {");
                _builder_1.newLine();
                _builder_1.append("\t");
                _builder_1.append("res.save(null);");
                _builder_1.newLine();
                _builder_1.append("} catch (");
                String _name_10 = IOException.class.getName();
                _builder_1.append(_name_10);
                _builder_1.append(" e) {");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("e.printStackTrace();");
                _builder_1.newLine();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.newLine();
                _builder_1.append("return graph;");
                _builder_1.newLine();
                EcoreExtensions.createEOperation(_mainEClass, _builder.toString(), (EClassifier)_mainEClass_1, 1, 1, (CharSequence)_builder_1, EcoreExtensions.createEStringParameter("path", 1, 1), EcoreExtensions.createEStringParameter("fileName", 1, 1), EcoreExtensions.createEBooleanParameter("postCreateHook", 1, 1));
            }
        };
        IterableExtensions.filter(elementEClasses, (Functions.Function1)_function).forEach(_function_1);
    }

    private void populateNodeEClasses(final Set<ElementEClasses> elementEClasses) {
        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

            public Boolean apply(ElementEClasses it) {
                ModelElement _modelElement = it.getModelElement();
                return _modelElement instanceof Node;
            }
        };
        Consumer<ElementEClasses> _function_1 = new Consumer<ElementEClasses>(){

            @Override
            public void accept(final ElementEClasses it) {
                ModelElement _modelElement_19;
                boolean _isPrime;
                ModelElement _modelElement_16;
                int _size_1;
                boolean _greaterThan_1;
                boolean _greaterThan;
                boolean _isNullOrEmpty_1;
                boolean _not_1;
                boolean _not;
                ModelElement _modelElement = it.getModelElement();
                ModelElement _modelElement_1 = it.getModelElement();
                Iterable _allNodeSubTypes = MGLEcoreGenerator.this._generatorUtils.allNodeSubTypes((Node)_modelElement_1);
                Functions.Function1<Node, Set<Edge>> _function = new Functions.Function1<Node, Set<Edge>>(){

                    public Set<Edge> apply(Node it) {
                        Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>> _function = new Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>>(){

                            public EList<Edge> apply(OutgoingEdgeElementConnection co) {
                                return co.getConnectingEdges();
                            }
                        };
                        return (this).MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.allEdgesSuperTypesAndSubTypes(IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)it.getOutgoingEdgeConnections(), (Functions.Function1)_function)));
                    }
                };
                Iterable outgoingEdges = Iterables.filter((Iterable)MGLUtil.removeDuplicateModelElements((Iterable)IterableExtensions.flatMap((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Node[]{(Node)_modelElement})), (Iterable)_allNodeSubTypes), (Functions.Function1)_function)), Edge.class);
                ModelElement _modelElement_2 = it.getModelElement();
                ModelElement _modelElement_3 = it.getModelElement();
                Iterable _allNodeSubTypes_1 = MGLEcoreGenerator.this._generatorUtils.allNodeSubTypes((Node)_modelElement_3);
                Functions.Function1<Node, Set<Edge>> _function_1 = new Functions.Function1<Node, Set<Edge>>(){

                    public Set<Edge> apply(Node it) {
                        Functions.Function1<IncomingEdgeElementConnection, EList<Edge>> _function = new Functions.Function1<IncomingEdgeElementConnection, EList<Edge>>(){

                            public EList<Edge> apply(IncomingEdgeElementConnection co) {
                                return co.getConnectingEdges();
                            }
                        };
                        return (this).MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.allEdgesSuperTypesAndSubTypes(IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)it.getIncomingEdgeConnections(), (Functions.Function1)_function)));
                    }
                };
                Iterable incomingEdges = Iterables.filter((Iterable)MGLUtil.removeDuplicateModelElements((Iterable)IterableExtensions.flatMap((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Node[]{(Node)_modelElement_2})), (Iterable)_allNodeSubTypes_1), (Functions.Function1)_function_1)), Edge.class);
                final Edge mostCommonOutgoing = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperEdge(outgoingEdges);
                final Edge mostCommonIncoming = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperEdge(incomingEdges);
                EClass _elvis = null;
                Functions.Function1<ElementEClasses, Boolean> _function_2 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)mostCommonOutgoing);
                    }
                };
                ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_2);
                EClass _mainEClass = null;
                if (_findFirst != null) {
                    _mainEClass = _findFirst.getMainEClass();
                }
                if (_mainEClass != null) {
                    _elvis = _mainEClass;
                } else {
                    EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Edge");
                    _elvis = _eClassifier;
                }
                EClass mostCommonOutgoingEClass = _elvis;
                EClass _elvis_1 = null;
                Functions.Function1<ElementEClasses, Boolean> _function_3 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)mostCommonIncoming);
                    }
                };
                ElementEClasses _findFirst_1 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_3);
                EClass _mainEClass_1 = null;
                if (_findFirst_1 != null) {
                    _mainEClass_1 = _findFirst_1.getMainEClass();
                }
                if (_mainEClass_1 != null) {
                    _elvis_1 = _mainEClass_1;
                } else {
                    EClassifier _eClassifier_1 = GraphmodelPackage.eINSTANCE.getEClassifier("Edge");
                    _elvis_1 = _eClassifier_1;
                }
                EClass mostCommonIncomingEClass = _elvis_1;
                ModelElement _modelElement_4 = it.getModelElement();
                Iterable<ContainingElement> allContainingElements = MGLEcoreGenerator.this.allContainingElements((GraphicalModelElement)((Node)_modelElement_4));
                ModelElement _modelElement_5 = it.getModelElement();
                Set possibleContainers = MGLUtil.getPossibleContainers((Node)((Node)_modelElement_5));
                ModelElement _modelElement_6 = it.getModelElement();
                Set possiblePredecessors = IterableExtensions.toSet(MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.possiblePredecessors((Node)_modelElement_6));
                ModelElement _modelElement_7 = it.getModelElement();
                Set possibleSuccessors = IterableExtensions.toSet(MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.possibleSuccessors((Node)_modelElement_7));
                ModelElement _modelElement_8 = it.getModelElement();
                final Node lowestMutualPredecessorNode = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperNode(MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.possiblePredecessors((Node)_modelElement_8));
                ModelElement _modelElement_9 = it.getModelElement();
                final Node lowestMutualSuccessorNode = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperNode(MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.possibleSuccessors((Node)_modelElement_9));
                EClass _elvis_2 = null;
                Functions.Function1<ElementEClasses, Boolean> _function_4 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)lowestMutualPredecessorNode);
                    }
                };
                ElementEClasses _findFirst_2 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_4);
                EClass _mainEClass_2 = null;
                if (_findFirst_2 != null) {
                    _mainEClass_2 = _findFirst_2.getMainEClass();
                }
                if (_mainEClass_2 != null) {
                    _elvis_2 = _mainEClass_2;
                } else {
                    EClassifier _eClassifier_2 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                    _elvis_2 = _eClassifier_2;
                }
                EClass lowestMutualPredecessorNodeEClass = _elvis_2;
                EClass _elvis_3 = null;
                Functions.Function1<ElementEClasses, Boolean> _function_5 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)lowestMutualSuccessorNode);
                    }
                };
                ElementEClasses _findFirst_3 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_5);
                EClass _mainEClass_3 = null;
                if (_findFirst_3 != null) {
                    _mainEClass_3 = _findFirst_3.getMainEClass();
                }
                if (_mainEClass_3 != null) {
                    _elvis_3 = _mainEClass_3;
                } else {
                    EClassifier _eClassifier_3 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                    _elvis_3 = _eClassifier_3;
                }
                EClass lowestMutualSuccessorNodeEClass = _elvis_3;
                ModelElement _modelElement_10 = it.getModelElement();
                Functions.Function1<Edge, Iterable<Edge>> _function_6 = new Functions.Function1<Edge, Iterable<Edge>>(){

                    public Iterable<Edge> apply(Edge it) {
                        Iterable _subTypes = MGLUtil.subTypes((ModelElement)it);
                        return Iterables.concat((Iterable)_subTypes, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{it})));
                    }
                };
                Functions.Function1<Edge, Boolean> _function_7 = new Functions.Function1<Edge, Boolean>(){

                    public Boolean apply(Edge it) {
                        boolean _isIsAbstract = it.isIsAbstract();
                        return !_isIsAbstract;
                    }
                };
                Set outgoingConnectingEdges = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)MGLUtil.getOutgoingConnectingEdges((Node)((Node)_modelElement_10), (boolean)false), (Functions.Function1)_function_6)), (Functions.Function1)_function_7));
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)outgoingEdges);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    EClass _mainEClass_4 = it.getMainEClass();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("EList<graphmodel.internal.InternalEdge> out = ((graphmodel.internal.Internal");
                    ModelElement _modelElement_11 = it.getModelElement();
                    if (_modelElement_11 instanceof NodeContainer) {
                        _builder.append("Container");
                    } else {
                        _builder.append("Node");
                    }
                    _builder.append(")getInternalElement_()).getOutgoing();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("return org.eclipse.emf.common.util.ECollections.unmodifiableEList(out");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".stream().map(me -> (");
                    CharSequence _elvis_4 = null;
                    CharSequence _fqBeanName = null;
                    if (mostCommonOutgoing != null) {
                        _fqBeanName = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)mostCommonOutgoing);
                    }
                    _elvis_4 = _fqBeanName != null ? _fqBeanName : "graphmodel.Edge";
                    _builder.append((Object)_elvis_4, "\t");
                    _builder.append(")me.getElement()).");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("collect(java.util.stream.Collectors.toList()));");
                    _builder.newLine();
                    EcoreExtensions.createGenericListEOperation(_mainEClass_4, "getOutgoing", (EClassifier)mostCommonOutgoingEClass, 0, -1, (CharSequence)_builder, new EParameter[0]);
                    EClass _mainEClass_5 = it.getMainEClass();
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("return ((graphmodel.Node)this).getSuccessors(");
                    CharSequence _elvis_5 = null;
                    CharSequence _fqBeanName_1 = null;
                    if (lowestMutualSuccessorNode != null) {
                        _fqBeanName_1 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)lowestMutualSuccessorNode);
                    }
                    _elvis_5 = _fqBeanName_1 != null ? _fqBeanName_1 : "graphmodel.Node";
                    _builder_1.append((Object)_elvis_5);
                    _builder_1.append(".class);");
                    EcoreExtensions.createGenericListEOperation(_mainEClass_5, "getSuccessors", (EClassifier)lowestMutualSuccessorNodeEClass, _builder_1.toString(), new EParameter[0]);
                }
                boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)incomingEdges));
                if (_not_1) {
                    EClass _mainEClass_6 = it.getMainEClass();
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("EList<graphmodel.internal.InternalEdge> in = ((graphmodel.internal.Internal");
                    ModelElement _modelElement_12 = it.getModelElement();
                    if (_modelElement_12 instanceof NodeContainer) {
                        _builder_2.append("Container");
                    } else {
                        _builder_2.append("Node");
                    }
                    _builder_2.append(")getInternalElement_()).getIncoming();");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("return org.eclipse.emf.common.util.ECollections.unmodifiableEList(in");
                    _builder_2.newLine();
                    _builder_2.append("\t");
                    _builder_2.append(".stream().map(me -> (");
                    CharSequence _elvis_6 = null;
                    CharSequence _fqBeanName_2 = null;
                    if (mostCommonIncoming != null) {
                        _fqBeanName_2 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)mostCommonIncoming);
                    }
                    _elvis_6 = _fqBeanName_2 != null ? _fqBeanName_2 : "graphmodel.Edge";
                    _builder_2.append((Object)_elvis_6, "\t");
                    _builder_2.append(")me.getElement()).");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("\t\t");
                    _builder_2.append("collect(java.util.stream.Collectors.toList()));");
                    _builder_2.newLine();
                    EcoreExtensions.createGenericListEOperation(_mainEClass_6, "getIncoming", (EClassifier)mostCommonIncomingEClass, 0, -1, (CharSequence)_builder_2, new EParameter[0]);
                    EClass _mainEClass_7 = it.getMainEClass();
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("return ((graphmodel.Node)this).getPredecessors(");
                    CharSequence _elvis_7 = null;
                    CharSequence _fqBeanName_3 = null;
                    if (lowestMutualPredecessorNode != null) {
                        _fqBeanName_3 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)lowestMutualPredecessorNode);
                    }
                    _elvis_7 = _fqBeanName_3 != null ? _fqBeanName_3 : "graphmodel.Node";
                    _builder_3.append((Object)_elvis_7);
                    _builder_3.append(".class);");
                    EcoreExtensions.createGenericListEOperation(_mainEClass_7, "getPredecessors", (EClassifier)lowestMutualPredecessorNodeEClass, _builder_3.toString(), new EParameter[0]);
                }
                EcoreExtensions.createEOperation(it.getMainEClass(), "s_moveTo", null, 1, 1, "", EcoreExtensions.createEParameter(GraphmodelPackage.Literals.MODEL_ELEMENT_CONTAINER, "container", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                EcoreExtensions.createEOperation(it.getMainEClass(), "preMove", null, 1, 1, MGLEcoreGenerator.this._generatorUtils.writeMethodCallPreMove(it.getModelElement(), "this", "newContainer", "newX", "newY"), EcoreExtensions.createEParameter(GraphmodelPackage.eINSTANCE.getModelElementContainer(), "newContainer", 1, 1), EcoreExtensions.createEIntParameter("newX", 1, 1), EcoreExtensions.createEIntParameter("newY", 1, 1));
                EcoreExtensions.createEOperation(it.getMainEClass(), "postMove", null, 1, 1, MGLEcoreGenerator.this._generatorUtils.writeMethodCallPostMove(it.getModelElement(), "this", "source", "target", "x", "y", "deltaX", "deltaY"), EcoreExtensions.createEParameter(GraphmodelPackage.eINSTANCE.getModelElementContainer(), "source", 1, 1), EcoreExtensions.createEParameter(GraphmodelPackage.eINSTANCE.getModelElementContainer(), "target", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1), EcoreExtensions.createEIntParameter("deltaX", 1, 1), EcoreExtensions.createEIntParameter("deltaY", 1, 1));
                EcoreExtensions.createEOperation(it.getMainEClass(), "preResize", null, 1, 1, MGLEcoreGenerator.this._generatorUtils.writeMethodCallPreResize(it.getModelElement(), "this", "newWidth", "newHeight", "newX", "newY", "direction"), EcoreExtensions.createEIntParameter("newWidth", 1, 1), EcoreExtensions.createEIntParameter("newHeight", 1, 1), EcoreExtensions.createEIntParameter("newX", 1, 1), EcoreExtensions.createEIntParameter("newY", 1, 1), EcoreExtensions.createEParameter((EDataType)GraphmodelPackage.eINSTANCE.getDirection(), "direction", 1, 1));
                EcoreExtensions.createEOperation(it.getMainEClass(), "postResize", null, 1, 1, MGLEcoreGenerator.this._generatorUtils.writeMethodCallPostResize(it.getModelElement(), "this", "oldWidth", "oldHeight", "oldX", "oldY", "direction"), EcoreExtensions.createEIntParameter("oldWidth", 1, 1), EcoreExtensions.createEIntParameter("oldHeight", 1, 1), EcoreExtensions.createEIntParameter("oldX", 1, 1), EcoreExtensions.createEIntParameter("oldY", 1, 1), EcoreExtensions.createEParameter((EDataType)GraphmodelPackage.eINSTANCE.getDirection(), "direction", 1, 1));
                Consumer<Edge> _function_8 = new Consumer<Edge>(){

                    @Override
                    public void accept(final Edge edge) {
                        EClass _mainEClass = it.getMainEClass();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("getOutgoing");
                        String _name = edge.getName();
                        _builder.append(_name);
                        _builder.append("s");
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)edge);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass_1 = null;
                        if (_findFirst != null) {
                            _mainEClass_1 = _findFirst.getMainEClass();
                        }
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("return this.getOutgoing(");
                        CharSequence _fqBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)edge);
                        _builder_1.append((Object)_fqBeanName);
                        _builder_1.append(".class);");
                        EcoreExtensions.createEOperation(_mainEClass, _builder.toString(), (EClassifier)_mainEClass_1, 0, -1, (CharSequence)_builder_1, new EParameter[0]);
                    }
                };
                outgoingEdges.forEach(_function_8);
                Consumer<Edge> _function_9 = new Consumer<Edge>(){

                    @Override
                    public void accept(final Edge edge) {
                        EClass _mainEClass = it.getMainEClass();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("getIncoming");
                        String _name = edge.getName();
                        _builder.append(_name);
                        _builder.append("s");
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)edge);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass_1 = null;
                        if (_findFirst != null) {
                            _mainEClass_1 = _findFirst.getMainEClass();
                        }
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("return this.getIncoming(");
                        CharSequence _fqBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)edge);
                        _builder_1.append((Object)_fqBeanName);
                        _builder_1.append(".class);");
                        EcoreExtensions.createEOperation(_mainEClass, _builder.toString(), (EClassifier)_mainEClass_1, 0, -1, (CharSequence)_builder_1, new EParameter[0]);
                    }
                };
                incomingEdges.forEach(_function_9);
                ModelElement _modelElement_13 = it.getModelElement();
                int _size = ((Node)_modelElement_13).getIncomingEdgeConnections().size();
                boolean bl3 = _greaterThan = _size > 0;
                if (_greaterThan) {
                    EClass _internalEClass = it.getInternalEClass();
                    EClassifier _eClassifier_4 = GraphmodelPackage.eINSTANCE.getEClassifier("ConnectionConstraint");
                    StringConcatenation _builder_4 = new StringConcatenation();
                    ModelElement _modelElement_14 = it.getModelElement();
                    Iterable _indexed = IterableExtensions.indexed((Iterable)((Node)_modelElement_14).getIncomingEdgeConnections());
                    for (Pair pair : _indexed) {
                        _builder_4.append("ConnectionConstraint cons");
                        Integer _key = (Integer)pair.getKey();
                        _builder_4.append((Object)_key);
                        _builder_4.append(" = new ConnectionConstraint(false, ");
                        int _lowerBound = ((IncomingEdgeElementConnection)pair.getValue()).getLowerBound();
                        _builder_4.append((Object)_lowerBound);
                        _builder_4.append(", ");
                        int _upperBound = ((IncomingEdgeElementConnection)pair.getValue()).getUpperBound();
                        _builder_4.append((Object)_upperBound);
                        _builder_4.append(", ");
                        String _edgesList = MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.edgesList((Iterable<Edge>)((IncomingEdgeElementConnection)pair.getValue()).getConnectingEdges());
                        _builder_4.append(_edgesList);
                        _builder_4.append(");");
                        _builder_4.newLineIfNotEmpty();
                    }
                    _builder_4.append("org.eclipse.emf.common.util.BasicEList<ConnectionConstraint>eList = new org.eclipse.emf.common.util.BasicEList<ConnectionConstraint>();");
                    _builder_4.newLine();
                    _builder_4.append("eList.addAll(com.google.common.collect.Lists.newArrayList(");
                    ModelElement _modelElement_15 = it.getModelElement();
                    String _constraintVariables = MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.constraintVariables((Iterable<? extends EdgeElementConnection>)((Node)_modelElement_15).getIncomingEdgeConnections());
                    _builder_4.append(_constraintVariables);
                    _builder_4.append("));");
                    _builder_4.newLineIfNotEmpty();
                    _builder_4.append("eList.addAll(super.getIncomingConstraints());");
                    _builder_4.newLine();
                    _builder_4.append("return eList;");
                    _builder_4.newLine();
                    EcoreExtensions.createEOperation(_internalEClass, "getIncomingConstraints", _eClassifier_4, 0, -1, (CharSequence)_builder_4, new EParameter[0]);
                }
                boolean bl4 = _greaterThan_1 = (_size_1 = ((Node)(_modelElement_16 = it.getModelElement())).getOutgoingEdgeConnections().size()) > 0;
                if (_greaterThan_1) {
                    EClass _internalEClass_1 = it.getInternalEClass();
                    EClassifier _eClassifier_5 = GraphmodelPackage.eINSTANCE.getEClassifier("ConnectionConstraint");
                    StringConcatenation _builder_5 = new StringConcatenation();
                    ModelElement _modelElement_17 = it.getModelElement();
                    Iterable _indexed_1 = IterableExtensions.indexed((Iterable)((Node)_modelElement_17).getOutgoingEdgeConnections());
                    for (Pair pair_1 : _indexed_1) {
                        _builder_5.append("ConnectionConstraint cons");
                        Integer _key_1 = (Integer)pair_1.getKey();
                        _builder_5.append((Object)_key_1);
                        _builder_5.append(" = new ConnectionConstraint(true, ");
                        int _lowerBound_1 = ((OutgoingEdgeElementConnection)pair_1.getValue()).getLowerBound();
                        _builder_5.append((Object)_lowerBound_1);
                        _builder_5.append(", ");
                        int _upperBound_1 = ((OutgoingEdgeElementConnection)pair_1.getValue()).getUpperBound();
                        _builder_5.append((Object)_upperBound_1);
                        _builder_5.append(", ");
                        String _edgesList_1 = MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.edgesList((Iterable<Edge>)((OutgoingEdgeElementConnection)pair_1.getValue()).getConnectingEdges());
                        _builder_5.append(_edgesList_1);
                        _builder_5.append(");");
                        _builder_5.newLineIfNotEmpty();
                    }
                    _builder_5.append("org.eclipse.emf.common.util.BasicEList<ConnectionConstraint>eList = new org.eclipse.emf.common.util.BasicEList<ConnectionConstraint>();");
                    _builder_5.newLine();
                    _builder_5.append("eList.addAll(com.google.common.collect.Lists.newArrayList(");
                    ModelElement _modelElement_18 = it.getModelElement();
                    String _constraintVariables_1 = MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.constraintVariables((Iterable<? extends EdgeElementConnection>)((Node)_modelElement_18).getOutgoingEdgeConnections());
                    _builder_5.append(_constraintVariables_1);
                    _builder_5.append("));");
                    _builder_5.newLineIfNotEmpty();
                    _builder_5.append("eList.addAll(super.getOutgoingConstraints());");
                    _builder_5.newLine();
                    _builder_5.append("return eList;");
                    _builder_5.newLine();
                    EcoreExtensions.createEOperation(_internalEClass_1, "getOutgoingConstraints", _eClassifier_5, 0, -1, (CharSequence)_builder_5, new EParameter[0]);
                }
                Consumer<Node> _function_10 = new Consumer<Node>(){

                    @Override
                    public void accept(final Node predecessorNode) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("get");
                        String _firstUpper = StringExtensions.toFirstUpper((String)predecessorNode.getName());
                        _builder.append(_firstUpper);
                        _builder.append("Predecessors");
                        String methodName = _builder.toString();
                        EClass _elvis = null;
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)predecessorNode);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass = null;
                        if (_findFirst != null) {
                            _mainEClass = _findFirst.getMainEClass();
                        }
                        if (_mainEClass != null) {
                            _elvis = _mainEClass;
                        } else {
                            EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                            _elvis = _eClassifier;
                        }
                        EClass predecessorNodeEClass = _elvis;
                        EClass _mainEClass_1 = it.getMainEClass();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("return ((graphmodel.Node)this).getPredecessors(");
                        CharSequence _fqBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)predecessorNode);
                        _builder_1.append((Object)_fqBeanName);
                        _builder_1.append(".class);");
                        EcoreExtensions.createEOperation(_mainEClass_1, methodName, (EClassifier)predecessorNodeEClass, 0, -1, (CharSequence)_builder_1, new EParameter[0]);
                        EClass _internalEClass = it.getInternalEClass();
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("return ((graphmodel.Node)this.getElement()).getPredecessors(");
                        CharSequence _fqBeanName_1 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)predecessorNode);
                        _builder_2.append((Object)_fqBeanName_1);
                        _builder_2.append(".class);");
                        EcoreExtensions.createEOperation(_internalEClass, methodName, (EClassifier)predecessorNodeEClass, 0, -1, (CharSequence)_builder_2, new EParameter[0]);
                    }
                };
                possiblePredecessors.forEach(_function_10);
                Consumer<Node> _function_11 = new Consumer<Node>(){

                    @Override
                    public void accept(final Node successorNode) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("get");
                        String _firstUpper = StringExtensions.toFirstUpper((String)successorNode.getName());
                        _builder.append(_firstUpper);
                        _builder.append("Successors");
                        String methodName = _builder.toString();
                        EClass _elvis = null;
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)successorNode);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass = null;
                        if (_findFirst != null) {
                            _mainEClass = _findFirst.getMainEClass();
                        }
                        if (_mainEClass != null) {
                            _elvis = _mainEClass;
                        } else {
                            EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                            _elvis = _eClassifier;
                        }
                        EClass successorNodeEClass = _elvis;
                        EClass _mainEClass_1 = it.getMainEClass();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("return ((graphmodel.Node)this).getSuccessors(");
                        CharSequence _fqBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)successorNode);
                        _builder_1.append((Object)_fqBeanName);
                        _builder_1.append(".class);");
                        EcoreExtensions.createEOperation(_mainEClass_1, methodName, (EClassifier)successorNodeEClass, 0, -1, (CharSequence)_builder_1, new EParameter[0]);
                        EClass _internalEClass = it.getInternalEClass();
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("return ((graphmodel.Node)this.getElement()).getSuccessors(");
                        CharSequence _fqBeanName_1 = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)successorNode);
                        _builder_2.append((Object)_fqBeanName_1);
                        _builder_2.append(".class);");
                        EcoreExtensions.createEOperation(_internalEClass, methodName, (EClassifier)successorNodeEClass, 0, -1, (CharSequence)_builder_2, new EParameter[0]);
                    }
                };
                possibleSuccessors.forEach(_function_11);
                Consumer<Edge> _function_12 = new Consumer<Edge>(){

                    @Override
                    public void accept(final Edge outgoingConnectingEdge) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("canNew");
                        String _fuName = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)outgoingConnectingEdge);
                        _builder.append(_fuName);
                        final String canNewMethodName = _builder.toString();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("new");
                        String _fuName_1 = (this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)outgoingConnectingEdge);
                        _builder_1.append(_fuName_1);
                        final String newMethodName = _builder_1.toString();
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)outgoingConnectingEdge);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass = null;
                        if (_findFirst != null) {
                            _mainEClass = _findFirst.getMainEClass();
                        }
                        final EClass outgoingConnectingEdgeEClass = _mainEClass;
                        Consumer<Node> _function_1 = new Consumer<Node>(){

                            @Override
                            public void accept(final Node outgoingConnectingEdgeTarget) {
                                Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                                    public Boolean apply(ElementEClasses it) {
                                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)outgoingConnectingEdgeTarget);
                                    }
                                };
                                ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                                EClass _mainEClass = null;
                                if (_findFirst != null) {
                                    _mainEClass = _findFirst.getMainEClass();
                                }
                                EClass targetEClass = _mainEClass;
                                EClass _mainEClass_1 = it.getMainEClass();
                                EDataType _eBoolean = EcorePackage.eINSTANCE.getEBoolean();
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("return this.canStart(");
                                CharSequence _fqBeanName = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder.append((Object)_fqBeanName);
                                _builder.append(".class) && target.canEnd(");
                                CharSequence _fqBeanName_1 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder.append((Object)_fqBeanName_1);
                                _builder.append(".class);");
                                EcoreExtensions.createEOperation(_mainEClass_1, canNewMethodName, (EClassifier)_eBoolean, 0, 1, (CharSequence)_builder, EcoreExtensions.createEParameter(targetEClass, "target", 1, 1));
                                EClass _mainEClass_2 = it.getMainEClass();
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append("if (!this.canStart(");
                                CharSequence _fqBeanName_2 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_1.append((Object)_fqBeanName_2);
                                _builder_1.append(".class))");
                                _builder_1.newLineIfNotEmpty();
                                _builder_1.append("\t");
                                _builder_1.append("throw new ");
                                String _name = RuntimeException.class.getName();
                                _builder_1.append(_name, "\t");
                                _builder_1.append("(");
                                String _name_1 = String.class.getName();
                                _builder_1.append(_name_1, "\t");
                                _builder_1.append(".format(\"Cannot start edge %s at node %s\", ");
                                CharSequence _fqBeanName_3 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_1.append((Object)_fqBeanName_3, "\t");
                                _builder_1.append(".class, this.getClass()));");
                                _builder_1.newLineIfNotEmpty();
                                _builder_1.append("else if (!target.canEnd(");
                                CharSequence _fqBeanName_4 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_1.append((Object)_fqBeanName_4);
                                _builder_1.append(".class))");
                                _builder_1.newLineIfNotEmpty();
                                _builder_1.append("\t");
                                _builder_1.append("throw new ");
                                String _name_2 = RuntimeException.class.getName();
                                _builder_1.append(_name_2, "\t");
                                _builder_1.append("(");
                                String _name_3 = String.class.getName();
                                _builder_1.append(_name_3, "\t");
                                _builder_1.append(".format(\"Cannot end edge %s at node %s\", ");
                                CharSequence _fqBeanName_5 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_1.append((Object)_fqBeanName_5, "\t");
                                _builder_1.append(".class, target.getClass()));");
                                _builder_1.newLineIfNotEmpty();
                                _builder_1.append("else {");
                                _builder_1.newLine();
                                _builder_1.append("\t");
                                CharSequence _fqBeanName_6 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_1.append((Object)_fqBeanName_6, "\t");
                                _builder_1.append(" edge = ");
                                CharSequence _fqFactoryName = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqFactoryName((ModelElement)outgoingConnectingEdge);
                                _builder_1.append((Object)_fqFactoryName, "\t");
                                _builder_1.append(".eINSTANCE.create");
                                String _fuName = ((this).this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)outgoingConnectingEdge);
                                _builder_1.append(_fuName, "\t");
                                _builder_1.append("((");
                                String _name_4 = InternalNode.class.getName();
                                _builder_1.append(_name_4, "\t");
                                _builder_1.append(") this.getInternalElement_(), (");
                                String _name_5 = InternalNode.class.getName();
                                _builder_1.append(_name_5, "\t");
                                _builder_1.append(") target.getInternalElement_());");
                                _builder_1.newLineIfNotEmpty();
                                _builder_1.append("\t");
                                _builder_1.append("edge.setSourceElement(this);");
                                _builder_1.newLine();
                                _builder_1.append("\t");
                                _builder_1.append("edge.setTargetElement(target);");
                                _builder_1.newLine();
                                _builder_1.append("\t");
                                _builder_1.append("target.getRootElement().getModelElements().add(edge);");
                                _builder_1.newLine();
                                _builder_1.append("\t");
                                _builder_1.append("return edge;");
                                _builder_1.newLine();
                                _builder_1.append("}");
                                _builder_1.newLine();
                                EcoreExtensions.createEOperation(_mainEClass_2, newMethodName, (EClassifier)outgoingConnectingEdgeEClass, 0, 1, (CharSequence)_builder_1, EcoreExtensions.createEParameter(targetEClass, "target", 1, 1));
                                EClass _mainEClass_3 = it.getMainEClass();
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append("if (!this.canStart(");
                                CharSequence _fqBeanName_7 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_2.append((Object)_fqBeanName_7);
                                _builder_2.append(".class))");
                                _builder_2.newLineIfNotEmpty();
                                _builder_2.append("\t");
                                _builder_2.append("throw new ");
                                String _name_6 = RuntimeException.class.getName();
                                _builder_2.append(_name_6, "\t");
                                _builder_2.append("(");
                                String _name_7 = String.class.getName();
                                _builder_2.append(_name_7, "\t");
                                _builder_2.append(".format(\"Cannot start edge %s at node %s\", ");
                                String _fuName_1 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)outgoingConnectingEdge);
                                _builder_2.append(_fuName_1, "\t");
                                _builder_2.append(".class, this.getClass()));");
                                _builder_2.newLineIfNotEmpty();
                                _builder_2.append("else if (!target.canEnd(");
                                CharSequence _fqBeanName_8 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_2.append((Object)_fqBeanName_8);
                                _builder_2.append(".class))");
                                _builder_2.newLineIfNotEmpty();
                                _builder_2.append("\t");
                                _builder_2.append("throw new ");
                                String _name_8 = RuntimeException.class.getName();
                                _builder_2.append(_name_8, "\t");
                                _builder_2.append("(");
                                String _name_9 = String.class.getName();
                                _builder_2.append(_name_9, "\t");
                                _builder_2.append(".format(\"Cannot end edge %s at node %s\", ");
                                String _fuName_2 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)outgoingConnectingEdge);
                                _builder_2.append(_fuName_2, "\t");
                                _builder_2.append(".class, target.getClass()));");
                                _builder_2.newLineIfNotEmpty();
                                _builder_2.append("else {");
                                _builder_2.newLine();
                                _builder_2.append("\t");
                                CharSequence _fqBeanName_9 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)outgoingConnectingEdge);
                                _builder_2.append((Object)_fqBeanName_9, "\t");
                                _builder_2.append(" edge = ");
                                CharSequence _fqFactoryName_1 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fqFactoryName((ModelElement)outgoingConnectingEdge);
                                _builder_2.append((Object)_fqFactoryName_1, "\t");
                                _builder_2.append(".eINSTANCE.create");
                                String _fuName_3 = ((this).this).MGLEcoreGenerator.this._generatorUtils.fuName((ModelElement)outgoingConnectingEdge);
                                _builder_2.append(_fuName_3, "\t");
                                _builder_2.append("(id, (");
                                String _name_10 = InternalNode.class.getName();
                                _builder_2.append(_name_10, "\t");
                                _builder_2.append(") this.getInternalElement_(), (");
                                String _name_11 = InternalNode.class.getName();
                                _builder_2.append(_name_11, "\t");
                                _builder_2.append(") target.getInternalElement_());");
                                _builder_2.newLineIfNotEmpty();
                                _builder_2.append("\t");
                                _builder_2.append("edge.setSourceElement(this);");
                                _builder_2.newLine();
                                _builder_2.append("\t");
                                _builder_2.append("edge.setTargetElement(target);");
                                _builder_2.newLine();
                                _builder_2.append("\t");
                                _builder_2.append("return edge;");
                                _builder_2.newLine();
                                _builder_2.append("}");
                                _builder_2.newLine();
                                EcoreExtensions.createEOperation(_mainEClass_3, newMethodName, (EClassifier)outgoingConnectingEdgeEClass, 0, 1, (CharSequence)_builder_2, EcoreExtensions.createEParameter(targetEClass, "target", 1, 1), EcoreExtensions.createEStringParameter("id", 1, 1));
                            }
                        };
                        MGLUtil.getAllPossibleTargets((Edge)outgoingConnectingEdge).forEach(_function_1);
                    }
                };
                outgoingConnectingEdges.forEach(_function_12);
                Consumer<ContainingElement> _function_13 = new Consumer<ContainingElement>(){

                    @Override
                    public void accept(final ContainingElement possibleContainer) {
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ModelElement)possibleContainer));
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass = null;
                        if (_findFirst != null) {
                            _mainEClass = _findFirst.getMainEClass();
                        }
                        EClass possibleContainerEClass = _mainEClass;
                        EClass _mainEClass_1 = it.getMainEClass();
                        EDataType _eBoolean = EcorePackage.eINSTANCE.getEBoolean();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("return target.canContain(");
                        CharSequence _fqBeanName = (this).MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)it.getModelElement());
                        _builder.append((Object)_fqBeanName);
                        _builder.append(".class);");
                        Functions.Function1<ElementEClasses, Boolean> _function_1 = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ModelElement)possibleContainer));
                            }
                        };
                        ElementEClasses _findFirst_1 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_1);
                        EClass _mainEClass_2 = null;
                        if (_findFirst_1 != null) {
                            _mainEClass_2 = _findFirst_1.getMainEClass();
                        }
                        EcoreExtensions.createEOperation(_mainEClass_1, "canMoveTo", (EClassifier)_eBoolean, 1, 1, (CharSequence)_builder, EcoreExtensions.createEParameter(_mainEClass_2, "target", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                        EClass _mainEClass_3 = it.getMainEClass();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("transact(\"Move to\", () -> {");
                        _builder_1.newLine();
                        _builder_1.append("\t");
                        String _name = ModelElementContainer.class.getName();
                        _builder_1.append(_name, "\t");
                        _builder_1.append(" sourceContainer = this.getContainer();");
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("\t");
                        String _name_1 = InternalNode.class.getName();
                        _builder_1.append(_name_1, "\t");
                        _builder_1.append(" ime = (");
                        String _name_2 = InternalNode.class.getName();
                        _builder_1.append(_name_2, "\t");
                        _builder_1.append(") this.getInternalElement_();");
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("\t");
                        _builder_1.append("int deltaX = x - ime.getX();");
                        _builder_1.newLine();
                        _builder_1.append("\t");
                        _builder_1.append("int deltaY = y - ime.getY();");
                        _builder_1.newLine();
                        boolean _booleanWriteMethodCallPreMove = (this).MGLEcoreGenerator.this._generatorUtils.booleanWriteMethodCallPreMove(it.getModelElement());
                        if (_booleanWriteMethodCallPreMove) {
                            _builder_1.append("\t");
                            _builder_1.append("preMove(target, x, y);");
                            _builder_1.newLine();
                        }
                        _builder_1.append("\t");
                        _builder_1.append("s_moveTo(target, x, y);");
                        _builder_1.newLine();
                        _builder_1.append("\t");
                        _builder_1.append("target.getInternalContainerElement().getModelElements().add(ime);");
                        _builder_1.newLine();
                        _builder_1.append("\t");
                        _builder_1.append("ime.setX(x);");
                        _builder_1.newLine();
                        _builder_1.append("\t");
                        _builder_1.append("ime.setY(y);");
                        _builder_1.newLine();
                        boolean _booleanWriteMethodCallPostMove = (this).MGLEcoreGenerator.this._generatorUtils.booleanWriteMethodCallPostMove(it.getModelElement());
                        if (_booleanWriteMethodCallPostMove) {
                            _builder_1.append("\t");
                            _builder_1.append("postMove(sourceContainer, target, x, y, deltaX, deltaY);");
                            _builder_1.newLine();
                        }
                        _builder_1.append("});");
                        _builder_1.newLine();
                        EcoreExtensions.createEOperation(_mainEClass_3, "moveTo", null, 1, 1, (CharSequence)_builder_1, EcoreExtensions.createEParameter(possibleContainerEClass, "target", 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                        EcoreExtensions.createEOperation(it.getMainEClass(), "s_moveTo", null, 1, 1, "", EcoreExtensions.createEParameter(possibleContainerEClass, StringExtensions.toFirstLower((String)(this).MGLEcoreGenerator.this._generatorUtils.getName(possibleContainer)), 1, 1), EcoreExtensions.createEIntParameter("x", 1, 1), EcoreExtensions.createEIntParameter("y", 1, 1));
                    }
                };
                possibleContainers.forEach(_function_13);
                if (!IterableExtensions.isNullOrEmpty(allContainingElements) && IterableExtensions.size((Iterable)Iterables.filter(allContainingElements, GraphModel.class)) == 0) {
                    final Node lowestMutualSuperNode = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperNode(Iterables.filter(allContainingElements, Node.class));
                    if (lowestMutualSuperNode != null) {
                        EClass _mainEClass_8 = it.getMainEClass();
                        Functions.Function1<ElementEClasses, Boolean> _function_14 = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)lowestMutualSuperNode);
                            }
                        };
                        ElementEClasses _findFirst_4 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_14);
                        EClass _mainEClass_9 = null;
                        if (_findFirst_4 != null) {
                            _mainEClass_9 = _findFirst_4.getMainEClass();
                        }
                        StringConcatenation _builder_6 = new StringConcatenation();
                        _builder_6.append("return (");
                        CharSequence _fqBeanName_4 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)lowestMutualSuperNode);
                        _builder_6.append((Object)_fqBeanName_4);
                        _builder_6.append(")getInternalElement_().getContainer().getContainerElement();");
                        _builder_6.newLineIfNotEmpty();
                        EcoreExtensions.createEOperation(_mainEClass_8, "getContainer", (EClassifier)_mainEClass_9, 0, 1, (CharSequence)_builder_6, new EParameter[0]);
                    }
                } else {
                    Functions.Function1<ContainingElement, Boolean> _function_15;
                    boolean _forall;
                    boolean _greaterEqualsThan;
                    int _size_2 = IterableExtensions.size(allContainingElements);
                    boolean bl5 = _greaterEqualsThan = _size_2 >= 1;
                    if (_greaterEqualsThan && (_forall = IterableExtensions.forall(allContainingElements, (Functions.Function1)(_function_15 = new Functions.Function1<ContainingElement, Boolean>(){

                        public Boolean apply(ContainingElement c) {
                            return c instanceof GraphModel;
                        }
                    })))) {
                        final GraphModel lowestMutualSuperGraphModel = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperGraphModel(Iterables.filter(allContainingElements, GraphModel.class));
                        EClass _mainEClass_10 = it.getMainEClass();
                        EClass _elvis_8 = null;
                        Functions.Function1<ElementEClasses, Boolean> _function_16 = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)lowestMutualSuperGraphModel);
                            }
                        };
                        ElementEClasses _findFirst_5 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_16);
                        EClass _mainEClass_11 = null;
                        if (_findFirst_5 != null) {
                            _mainEClass_11 = _findFirst_5.getMainEClass();
                        }
                        if (_mainEClass_11 != null) {
                            _elvis_8 = _mainEClass_11;
                        } else {
                            EClassifier _eClassifier_6 = GraphmodelPackage.eINSTANCE.getEClassifier("GraphModel");
                            _elvis_8 = _eClassifier_6;
                        }
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append("return (");
                        if (lowestMutualSuperGraphModel != null) {
                            CharSequence _fqBeanName_5 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)lowestMutualSuperGraphModel);
                            _builder_7.append((Object)_fqBeanName_5);
                        } else {
                            _builder_7.append("GraphModel");
                        }
                        _builder_7.append(")getInternalElement_().getContainer().getContainerElement();");
                        _builder_7.newLineIfNotEmpty();
                        EcoreExtensions.createEOperation(_mainEClass_10, "getContainer", (EClassifier)_elvis_8, 0, 1, (CharSequence)_builder_7, new EParameter[0]);
                    }
                }
                if (_isPrime = MGLEcoreGenerator.this._generatorUtils.isPrime((Node)(_modelElement_19 = it.getModelElement()), false)) {
                    boolean _not_2;
                    EClass _switchResult = null;
                    ModelElement _modelElement_20 = it.getModelElement();
                    ReferencedType _retrievePrimeReference = MGLEcoreGenerator.this._generatorUtils.retrievePrimeReference((Node)_modelElement_20);
                    boolean _matched = false;
                    if (_retrievePrimeReference instanceof ReferencedEClass) {
                        _matched = true;
                        _switchResult = EcorePackage.eINSTANCE.getEObject();
                    }
                    if (!_matched && _retrievePrimeReference instanceof ReferencedModelElement) {
                        _matched = true;
                        EClass _elvis_9 = null;
                        Functions.Function1<ElementEClasses, Boolean> _function_17 = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses elementEClass) {
                                ModelElement _modelElement = it.getModelElement();
                                ReferencedType _retrievePrimeReference = (this).MGLEcoreGenerator.this._generatorUtils.retrievePrimeReference((Node)_modelElement);
                                return MGLUtil.equalModelElement((Type)elementEClass.getModelElement(), (Type)((ReferencedModelElement)_retrievePrimeReference).getType());
                            }
                        };
                        ElementEClasses _findFirst_6 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_17);
                        EClass _mainEClass_12 = null;
                        if (_findFirst_6 != null) {
                            _mainEClass_12 = _findFirst_6.getMainEClass();
                        }
                        if (_mainEClass_12 != null) {
                            _elvis_9 = _mainEClass_12;
                        } else {
                            EClassifier _eClassifier_7 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                            _elvis_9 = _eClassifier_7;
                        }
                        _switchResult = _elvis_9;
                    }
                    EClass primeEClass = _switchResult;
                    EClass _mainEClass_12 = it.getMainEClass();
                    StringConcatenation _builder_8 = new StringConcatenation();
                    _builder_8.append("get");
                    ModelElement _modelElement_21 = it.getModelElement();
                    String _firstUpper = StringExtensions.toFirstUpper((String)MGLEcoreGenerator.this._generatorUtils.primeName((Node)_modelElement_21));
                    _builder_8.append(_firstUpper);
                    StringConcatenation _builder_9 = new StringConcatenation();
                    _builder_9.append("String uid = ((");
                    ModelElement _modelElement_22 = it.getModelElement();
                    CharSequence _fqInternalBeanName = MGLEcoreGenerator.this._generatorUtils.fqInternalBeanName((Type)((Node)_modelElement_22));
                    _builder_9.append((Object)_fqInternalBeanName);
                    _builder_9.append(")getInternalElement_()).getLibraryComponentUID();");
                    _builder_9.newLineIfNotEmpty();
                    _builder_9.append("return ");
                    ModelElement _modelElement_23 = it.getModelElement();
                    ReferencedType _retrievePrimeReference_1 = MGLEcoreGenerator.this._generatorUtils.retrievePrimeReference((Node)_modelElement_23);
                    if (_retrievePrimeReference_1 instanceof ReferencedModelElement) {
                        _builder_9.append("(");
                        ModelElement _modelElement_24 = it.getModelElement();
                        CharSequence _primeFqTypeName = MGLEcoreGenerator.this._generatorUtils.primeFqTypeName((Node)_modelElement_24);
                        _builder_9.append((Object)_primeFqTypeName);
                        _builder_9.append(")");
                    }
                    _builder_9.append(" ");
                    String _name = ReferenceRegistry.class.getName();
                    _builder_9.append(_name);
                    _builder_9.append(".getInstance().getEObject(uid);");
                    _builder_9.newLineIfNotEmpty();
                    EcoreExtensions.createEOperation(_mainEClass_12, _builder_8.toString(), (EClassifier)primeEClass, 0, 1, (CharSequence)_builder_9, new EParameter[0]);
                    EClass _internalEClass_2 = it.getInternalEClass();
                    StringConcatenation _builder_10 = new StringConcatenation();
                    _builder_10.append("get");
                    ModelElement _modelElement_25 = it.getModelElement();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)MGLEcoreGenerator.this._generatorUtils.primeName((Node)_modelElement_25));
                    _builder_10.append(_firstUpper_1);
                    StringConcatenation _builder_11 = new StringConcatenation();
                    _builder_11.append("String uid = getLibraryComponentUID();");
                    _builder_11.newLine();
                    _builder_11.append("return ");
                    ModelElement _modelElement_26 = it.getModelElement();
                    ReferencedType _retrievePrimeReference_2 = MGLEcoreGenerator.this._generatorUtils.retrievePrimeReference((Node)_modelElement_26);
                    if (_retrievePrimeReference_2 instanceof ReferencedModelElement) {
                        _builder_11.append("(");
                        ModelElement _modelElement_27 = it.getModelElement();
                        CharSequence _primeFqTypeName_1 = MGLEcoreGenerator.this._generatorUtils.primeFqTypeName((Node)_modelElement_27);
                        _builder_11.append((Object)_primeFqTypeName_1);
                        _builder_11.append(")");
                    }
                    _builder_11.append(" ");
                    String _name_1 = ReferenceRegistry.class.getName();
                    _builder_11.append(_name_1);
                    _builder_11.append(".getInstance().getEObject(uid);");
                    _builder_11.newLineIfNotEmpty();
                    EcoreExtensions.createEOperation(_internalEClass_2, _builder_10.toString(), (EClassifier)primeEClass, 0, 1, (CharSequence)_builder_11, new EParameter[0]);
                    ModelElement _modelElement_28 = it.getModelElement();
                    Functions.Function1<ModelElement, Boolean> _function_17 = new Functions.Function1<ModelElement, Boolean>(){

                        public Boolean apply(ModelElement it) {
                            return it instanceof Node && (this).MGLEcoreGenerator.this._generatorUtils.isPrime((Node)it);
                        }
                    };
                    boolean _exists = IterableExtensions.exists((Iterable)MGLUtil.allSuperTypes((ModelElement)((Node)_modelElement_28)), (Functions.Function1)_function_17);
                    boolean bl6 = _not_2 = !_exists;
                    if (_not_2) {
                        EcoreExtensions.createEAttribute(it.getInternalEClass(), "libraryComponentUID", (EClassifier)EcorePackage.eINSTANCE.getEString(), 0, 1);
                        EClass _mainEClass_13 = it.getMainEClass();
                        EDataType _eString = EcorePackage.eINSTANCE.getEString();
                        StringConcatenation _builder_12 = new StringConcatenation();
                        _builder_12.append("return ((");
                        ModelElement _modelElement_29 = it.getModelElement();
                        CharSequence _fqInternalBeanName_1 = MGLEcoreGenerator.this._generatorUtils.fqInternalBeanName((Type)((Node)_modelElement_29));
                        _builder_12.append((Object)_fqInternalBeanName_1);
                        _builder_12.append(") this.getInternalElement_()).getLibraryComponentUID();");
                        EcoreExtensions.createEOperation(_mainEClass_13, "getLibraryComponentUID", (EClassifier)_eString, 1, 1, (CharSequence)_builder_12, new EParameter[0]);
                        EClass _mainEClass_14 = it.getMainEClass();
                        StringConcatenation _builder_13 = new StringConcatenation();
                        _builder_13.append("((");
                        ModelElement _modelElement_30 = it.getModelElement();
                        CharSequence _fqInternalBeanName_2 = MGLEcoreGenerator.this._generatorUtils.fqInternalBeanName((Type)((Node)_modelElement_30));
                        _builder_13.append((Object)_fqInternalBeanName_2);
                        _builder_13.append(") this.getInternalElement_()).setLibraryComponentUID(id);");
                        EcoreExtensions.createEOperation(_mainEClass_14, "setLibraryComponentUID", null, 1, 1, (CharSequence)_builder_13, EcoreExtensions.createEStringParameter("id", 1, 1));
                    }
                }
            }
        };
        IterableExtensions.filter(elementEClasses, (Functions.Function1)_function).forEach(_function_1);
    }

    private void populateEdgeEClasses(final Set<ElementEClasses> elementEClasses) {
        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

            public Boolean apply(ElementEClasses it) {
                ModelElement _modelElement = it.getModelElement();
                return _modelElement instanceof Edge;
            }
        };
        Consumer<ElementEClasses> _function_1 = new Consumer<ElementEClasses>(){

            @Override
            public void accept(final ElementEClasses it) {
                ModelElement _modelElement = it.getModelElement();
                Functions.Function1<ModelElement, Edge> _function = new Functions.Function1<ModelElement, Edge>(){

                    public Edge apply(ModelElement it) {
                        return (Edge)it;
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)MGLUtil.subTypes((ModelElement)((Edge)_modelElement)), (Functions.Function1)_function);
                ModelElement _modelElement_1 = it.getModelElement();
                Iterable _iterable = MGLEcoreGenerator.this._generatorUtils.iterable((Object)((Edge)_modelElement_1));
                Functions.Function1<Edge, Set<Node>> _function_1 = new Functions.Function1<Edge, Set<Node>>(){

                    public Set<Node> apply(Edge it) {
                        return MGLUtil.getAllPossibleSources((Edge)it);
                    }
                };
                final Node lowestMutualSourceNode = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperNode(MGLEcoreGenerator.this.cleanupConnectingNodes(IterableExtensions.map((Iterable)Iterables.concat((Iterable)_map, (Iterable)_iterable), (Functions.Function1)_function_1)));
                ModelElement _modelElement_2 = it.getModelElement();
                Functions.Function1<ModelElement, Edge> _function_2 = new Functions.Function1<ModelElement, Edge>(){

                    public Edge apply(ModelElement it) {
                        return (Edge)it;
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)MGLUtil.subTypes((ModelElement)((Edge)_modelElement_2)), (Functions.Function1)_function_2);
                ModelElement _modelElement_3 = it.getModelElement();
                Iterable _iterable_1 = MGLEcoreGenerator.this._generatorUtils.iterable((Object)((Edge)_modelElement_3));
                Functions.Function1<Edge, Set<Node>> _function_3 = new Functions.Function1<Edge, Set<Node>>(){

                    public Set<Node> apply(Edge it) {
                        return MGLUtil.getAllPossibleTargets((Edge)it);
                    }
                };
                final Node lowestMutualTargetNode = MGLEcoreGenerator.this._generatorUtils.getLowestMutualSuperNode(MGLEcoreGenerator.this.cleanupConnectingNodes(IterableExtensions.map((Iterable)Iterables.concat((Iterable)_map_1, (Iterable)_iterable_1), (Functions.Function1)_function_3)));
                EClass _elvis = null;
                Functions.Function1<ElementEClasses, Boolean> _function_4 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)lowestMutualSourceNode);
                    }
                };
                ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_4);
                EClass _mainEClass = null;
                if (_findFirst != null) {
                    _mainEClass = _findFirst.getMainEClass();
                }
                if (_mainEClass != null) {
                    _elvis = _mainEClass;
                } else {
                    EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                    _elvis = _eClassifier;
                }
                EClass lowestMutualSourceNodeEClass = _elvis;
                EClass _elvis_1 = null;
                Functions.Function1<ElementEClasses, Boolean> _function_5 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)lowestMutualTargetNode);
                    }
                };
                ElementEClasses _findFirst_1 = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function_5);
                EClass _mainEClass_1 = null;
                if (_findFirst_1 != null) {
                    _mainEClass_1 = _findFirst_1.getMainEClass();
                }
                if (_mainEClass_1 != null) {
                    _elvis_1 = _mainEClass_1;
                } else {
                    EClassifier _eClassifier_1 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                    _elvis_1 = _eClassifier_1;
                }
                EClass lowestMutualTargetNodeEClass = _elvis_1;
                ModelElement _modelElement_4 = it.getModelElement();
                Set possibleSources = MGLUtil.getPossibleSources((Edge)((Edge)_modelElement_4));
                ModelElement _modelElement_5 = it.getModelElement();
                Set possibleTargets = MGLUtil.getPossibleTargets((Edge)((Edge)_modelElement_5));
                EClass _mainEClass_2 = it.getMainEClass();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return(");
                if (lowestMutualSourceNode != null) {
                    CharSequence _fqBeanName = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)lowestMutualSourceNode);
                    _builder.append((Object)_fqBeanName);
                } else {
                    _builder.append("graphmodel.Node");
                }
                _builder.append(")super.getSourceElement();");
                EcoreExtensions.createEOperation(_mainEClass_2, "getSourceElement", (EClassifier)lowestMutualSourceNodeEClass, 0, 1, (CharSequence)_builder, new EParameter[0]);
                EClass _mainEClass_3 = it.getMainEClass();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("return(");
                if (lowestMutualTargetNode != null) {
                    CharSequence _fqBeanName_1 = MGLEcoreGenerator.this._generatorUtils.fqBeanName((EObject)lowestMutualTargetNode);
                    _builder_1.append((Object)_fqBeanName_1);
                } else {
                    _builder_1.append("graphmodel.Node");
                }
                _builder_1.append(")super.getTargetElement();");
                EcoreExtensions.createEOperation(_mainEClass_3, "getTargetElement", (EClassifier)lowestMutualTargetNodeEClass, 0, 1, (CharSequence)_builder_1, new EParameter[0]);
                Consumer<Node> _function_6 = new Consumer<Node>(){

                    @Override
                    public void accept(final Node possibleSource) {
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)possibleSource);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass = null;
                        if (_findFirst != null) {
                            _mainEClass = _findFirst.getMainEClass();
                        }
                        EClass sourceEClass = _mainEClass;
                        EClass _mainEClass_1 = it.getMainEClass();
                        EDataType _eBoolean = EcorePackage.eINSTANCE.getEBoolean();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("return source.canStart(this.getClass());");
                        EcoreExtensions.createEOperation(_mainEClass_1, "canReconnectSource", (EClassifier)_eBoolean, 1, 1, (CharSequence)_builder, EcoreExtensions.createEParameter(sourceEClass, "source", 1, 1));
                        EClass _mainEClass_2 = it.getMainEClass();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("this.setSourceElement(source);");
                        EcoreExtensions.createEOperation(_mainEClass_2, "reconnectSource", null, 1, 1, (CharSequence)_builder_1, EcoreExtensions.createEParameter(sourceEClass, "source", 1, 1));
                    }
                };
                possibleSources.forEach(_function_6);
                Consumer<Node> _function_7 = new Consumer<Node>(){

                    @Override
                    public void accept(final Node possibleTarget) {
                        Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                            public Boolean apply(ElementEClasses it) {
                                return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)possibleTarget);
                            }
                        };
                        ElementEClasses _findFirst = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                        EClass _mainEClass = null;
                        if (_findFirst != null) {
                            _mainEClass = _findFirst.getMainEClass();
                        }
                        EClass targetEClass = _mainEClass;
                        EClass _mainEClass_1 = it.getMainEClass();
                        EDataType _eBoolean = EcorePackage.eINSTANCE.getEBoolean();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("return target.canEnd(this.getClass());");
                        EcoreExtensions.createEOperation(_mainEClass_1, "canReconnectTarget", (EClassifier)_eBoolean, 1, 1, (CharSequence)_builder, EcoreExtensions.createEParameter(targetEClass, "target", 1, 1));
                        EClass _mainEClass_2 = it.getMainEClass();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("this.setTargetElement(target);");
                        EcoreExtensions.createEOperation(_mainEClass_2, "reconnectTarget", null, 1, 1, (CharSequence)_builder_1, EcoreExtensions.createEParameter(targetEClass, "target", 1, 1));
                    }
                };
                possibleTargets.forEach(_function_7);
            }
        };
        IterableExtensions.filter(elementEClasses, (Functions.Function1)_function).forEach(_function_1);
    }

    public Iterable<Node> cleanupConnectingNodes(Iterable<Set<Node>> sets) {
        Functions.Function1<Iterable<? extends Node>, Boolean> _function = new Functions.Function1<Iterable<? extends Node>, Boolean>(){

            public Boolean apply(Iterable<? extends Node> d) {
                return IterableExtensions.isNullOrEmpty(d);
            }
        };
        return this._collectionExtension.flattenUnless(sets, (Functions.Function1)_function);
    }

    private void setSuperTypes(final Set<ElementEClasses> elementEClasses) {
        Consumer<ElementEClasses> _function = new Consumer<ElementEClasses>(){

            @Override
            public void accept(ElementEClasses it) {
                ModelElement _modelElement_3;
                ModelElement _modelElement_2;
                ModelElement _modelElement_1;
                ModelElement parentModelElement = null;
                boolean _matched = false;
                ModelElement _modelElement = it.getModelElement();
                if (_modelElement instanceof UserDefinedType) {
                    _matched = true;
                    parentModelElement = MGLUtil.extend((ModelElement)it.getModelElement());
                }
                if (!_matched && (_modelElement_1 = it.getModelElement()) instanceof Node) {
                    _matched = true;
                    parentModelElement = MGLUtil.extend((ModelElement)it.getModelElement());
                }
                if (!_matched && (_modelElement_2 = it.getModelElement()) instanceof Edge) {
                    _matched = true;
                    parentModelElement = MGLUtil.extend((ModelElement)it.getModelElement());
                }
                if (!_matched && (_modelElement_3 = it.getModelElement()) instanceof GraphModel) {
                    _matched = true;
                    parentModelElement = MGLUtil.extend((ModelElement)it.getModelElement());
                }
                if (parentModelElement != null) {
                    final ModelElement finalParentModelElement = parentModelElement;
                    Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                        public Boolean apply(ElementEClasses it) {
                            return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)finalParentModelElement);
                        }
                    };
                    ElementEClasses parentElementEClass = (ElementEClasses)IterableExtensions.findFirst((Iterable)elementEClasses, (Functions.Function1)_function);
                    EList _eSuperTypes = it.getMainEClass().getESuperTypes();
                    EClass _mainEClass = parentElementEClass.getMainEClass();
                    _eSuperTypes.add((Object)_mainEClass);
                    EList _eSuperTypes_1 = it.getInternalEClass().getESuperTypes();
                    EClass _internalEClass = parentElementEClass.getInternalEClass();
                    _eSuperTypes_1.add((Object)_internalEClass);
                    EList _eSuperTypes_2 = it.getMainView().getESuperTypes();
                    EClass _mainView = parentElementEClass.getMainView();
                    _eSuperTypes_2.add((Object)_mainView);
                    if (it.getModelElement() instanceof ContainingElement && !(MGLUtil.extend((ModelElement)it.getModelElement()) instanceof ContainingElement)) {
                        EList _eSuperTypes_3 = it.getMainEClass().getESuperTypes();
                        EClassifier _eClassifier = GraphmodelPackage.eINSTANCE.getEClassifier("Container");
                        _eSuperTypes_3.add((Object)((EClass)_eClassifier));
                        EList _eSuperTypes_4 = it.getInternalEClass().getESuperTypes();
                        EClassifier _eClassifier_1 = InternalPackage.eINSTANCE.getEClassifier("InternalContainer");
                        _eSuperTypes_4.add((Object)((EClass)_eClassifier_1));
                    }
                } else {
                    ModelElement _modelElement_8;
                    ModelElement _modelElement_7;
                    ModelElement _modelElement_5;
                    boolean _matched_1 = false;
                    ModelElement _modelElement_4 = it.getModelElement();
                    if (_modelElement_4 instanceof GraphModel) {
                        _matched_1 = true;
                        EList _eSuperTypes_5 = it.getMainEClass().getESuperTypes();
                        EClassifier _eClassifier_2 = GraphmodelPackage.eINSTANCE.getEClassifier("GraphModel");
                        _eSuperTypes_5.add((Object)((EClass)_eClassifier_2));
                        EList _eSuperTypes_6 = it.getInternalEClass().getESuperTypes();
                        EClassifier _eClassifier_3 = InternalPackage.eINSTANCE.getEClassifier("InternalGraphModel");
                        _eSuperTypes_6.add((Object)((EClass)_eClassifier_3));
                    }
                    if (!_matched_1 && (_modelElement_5 = it.getModelElement()) instanceof Node) {
                        _matched_1 = true;
                        ModelElement _modelElement_6 = it.getModelElement();
                        if (_modelElement_6 instanceof ContainingElement) {
                            EList _eSuperTypes_7 = it.getMainEClass().getESuperTypes();
                            EClassifier _eClassifier_4 = GraphmodelPackage.eINSTANCE.getEClassifier("Container");
                            _eSuperTypes_7.add((Object)((EClass)_eClassifier_4));
                            EList _eSuperTypes_8 = it.getInternalEClass().getESuperTypes();
                            EClassifier _eClassifier_5 = InternalPackage.eINSTANCE.getEClassifier("InternalContainer");
                            _eSuperTypes_8.add((Object)((EClass)_eClassifier_5));
                        } else {
                            EList _eSuperTypes_9 = it.getMainEClass().getESuperTypes();
                            EClassifier _eClassifier_6 = GraphmodelPackage.eINSTANCE.getEClassifier("Node");
                            _eSuperTypes_9.add((Object)((EClass)_eClassifier_6));
                            EList _eSuperTypes_10 = it.getInternalEClass().getESuperTypes();
                            EClassifier _eClassifier_7 = InternalPackage.eINSTANCE.getEClassifier("InternalNode");
                            _eSuperTypes_10.add((Object)((EClass)_eClassifier_7));
                        }
                    }
                    if (!_matched_1 && (_modelElement_7 = it.getModelElement()) instanceof Edge) {
                        _matched_1 = true;
                        EList _eSuperTypes_11 = it.getMainEClass().getESuperTypes();
                        EClassifier _eClassifier_8 = GraphmodelPackage.eINSTANCE.getEClassifier("Edge");
                        _eSuperTypes_11.add((Object)((EClass)_eClassifier_8));
                        EList _eSuperTypes_12 = it.getInternalEClass().getESuperTypes();
                        EClassifier _eClassifier_9 = InternalPackage.eINSTANCE.getEClassifier("InternalEdge");
                        _eSuperTypes_12.add((Object)((EClass)_eClassifier_9));
                    }
                    if (!_matched_1 && (_modelElement_8 = it.getModelElement()) instanceof UserDefinedType) {
                        _matched_1 = true;
                        EList _eSuperTypes_13 = it.getMainEClass().getESuperTypes();
                        EClass _type = GraphmodelPackage.eINSTANCE.getType();
                        _eSuperTypes_13.add((Object)_type);
                        EList _eSuperTypes_14 = it.getInternalEClass().getESuperTypes();
                        EClass _internalType = InternalPackage.eINSTANCE.getInternalType();
                        _eSuperTypes_14.add((Object)_internalType);
                    }
                }
            }
        };
        elementEClasses.forEach(_function);
    }

    private void referenceAndPopulateMainView(Set<ElementEClasses> elementEClasses) {
        Consumer<ElementEClasses> _function = new Consumer<ElementEClasses>(){

            @Override
            public void accept(final ElementEClasses it) {
                boolean _not;
                boolean _isAbstract = it.getMainView().isAbstract();
                boolean bl = _not = !_isAbstract;
                if (_not) {
                    EClass _mainEClass = it.getMainEClass();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("get");
                    String _name = it.getModelElement().getName();
                    _builder.append(_name);
                    _builder.append("View");
                    EClass _mainView = it.getMainView();
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = it.getMainView().getName();
                    _builder_1.append(_name_1);
                    _builder_1.append(" ");
                    String _firstLower = StringExtensions.toFirstLower((String)it.getMainView().getName());
                    _builder_1.append(_firstLower);
                    _builder_1.append(" = ");
                    EObject _eContainer = it.getModelElement().eContainer();
                    String _package = ((MGLModel)_eContainer).getPackage();
                    _builder_1.append(_package);
                    _builder_1.append(".");
                    EObject _eContainer_1 = it.getModelElement().eContainer();
                    String _ePackageName = MGLUtil.ePackageName((MGLModel)((MGLModel)_eContainer_1));
                    _builder_1.append(_ePackageName);
                    _builder_1.append(".views.ViewsFactory.eINSTANCE.create");
                    String _name_2 = it.getMainView().getName();
                    _builder_1.append(_name_2);
                    _builder_1.append("();");
                    _builder_1.newLineIfNotEmpty();
                    String _firstLower_1 = StringExtensions.toFirstLower((String)it.getMainView().getName());
                    _builder_1.append(_firstLower_1);
                    _builder_1.append(".setInternal");
                    String _name_3 = it.getMainEClass().getName();
                    _builder_1.append(_name_3);
                    _builder_1.append("((");
                    EObject _eContainer_2 = it.getModelElement().eContainer();
                    String _package_1 = ((MGLModel)_eContainer_2).getPackage();
                    _builder_1.append(_package_1);
                    _builder_1.append(".");
                    EObject _eContainer_3 = it.getModelElement().eContainer();
                    String _ePackageName_1 = MGLUtil.ePackageName((MGLModel)((MGLModel)_eContainer_3));
                    _builder_1.append(_ePackageName_1);
                    _builder_1.append(".internal.Internal");
                    String _name_4 = it.getMainEClass().getName();
                    _builder_1.append(_name_4);
                    _builder_1.append(")getInternalElement_());");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("return ");
                    String _firstLower_2 = StringExtensions.toFirstLower((String)it.getMainView().getName());
                    _builder_1.append(_firstLower_2);
                    _builder_1.append(";");
                    _builder_1.newLineIfNotEmpty();
                    EcoreExtensions.createEOperation(_mainEClass, _builder.toString(), (EClassifier)_mainView, 0, 1, (CharSequence)_builder_1, new EParameter[0]);
                }
                EcoreExtensions.createReference(it.getMainView(), StringExtensions.toFirstLower((String)it.getInternalEClass().getName()), it.getInternalEClass(), 0, 1, false, null);
                Consumer<Attribute> _function = new Consumer<Attribute>(){

                    @Override
                    public void accept(final Attribute attribute) {
                        boolean _not;
                        boolean bl = _not = !(attribute instanceof ComplexAttribute) || !((ComplexAttribute)attribute).isOverride();
                        if (_not) {
                            Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                                public Boolean apply(EStructuralFeature it) {
                                    String _name = it.getName();
                                    String _name_1 = attribute.getName();
                                    return Objects.equal((Object)_name, (Object)_name_1);
                                }
                            };
                            EStructuralFeature feature = (EStructuralFeature)IterableExtensions.findFirst((Iterable)it.getInternalEClass().getEStructuralFeatures(), (Functions.Function1)_function);
                            if (feature != null) {
                                boolean _notEquals;
                                MGLEcoreGenerator.this.createGetter(it.getMainView(), it, attribute);
                                MGLEcoreGenerator.this.createSetter(it.getMainView(), it, attribute);
                                Integer _upperBound = attribute.getUpperBound();
                                boolean bl2 = _notEquals = _upperBound != 1;
                                if (_notEquals) {
                                    MGLEcoreGenerator.this.createAdder(it.getMainView(), it, attribute);
                                    MGLEcoreGenerator.this.createRemove(it.getMainView(), it, attribute);
                                }
                            }
                        }
                    }
                };
                MGLUtil.allAttributes((ModelElement)it.getModelElement()).forEach(_function);
            }
        };
        elementEClasses.forEach(_function);
    }

    private EOperation createGetter(EClass eClass, ElementEClasses elementEClasses, final Attribute attr) {
        EOperation _xblockexpression = null;
        EDataType returnType = null;
        if (attr instanceof PrimitiveAttribute) {
            returnType = this.getEDataType(((PrimitiveAttribute)attr).getType());
        } else {
            Type _type = ((ComplexAttribute)attr).getType();
            if (_type instanceof Enumeration) {
                returnType = (EClassifier)this.eEnumMap.get(((ComplexAttribute)attr).getType());
            } else {
                Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ComplexAttribute)attr).getType());
                    }
                };
                returnType = ((ElementEClasses)IterableExtensions.findFirst(this.allElementEClasses, (Functions.Function1)_function)).getMainEClass();
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        if (attr instanceof PrimitiveAttribute && Objects.equal((Object)((PrimitiveAttribute)attr).getType(), (Object)EDataTypeType.EBOOLEAN)) {
            _builder.append("is");
        } else {
            _builder.append("get");
        }
        String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
        _builder.append(_firstUpper);
        Integer _lowerBound = attr.getLowerBound();
        Integer _upperBound = attr.getUpperBound();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("return get");
        String _name = elementEClasses.getInternalEClass().getName();
        _builder_1.append(_name);
        _builder_1.append("().");
        if (attr instanceof PrimitiveAttribute && Objects.equal((Object)((PrimitiveAttribute)attr).getType(), (Object)EDataTypeType.EBOOLEAN)) {
            _builder_1.append("is");
        } else {
            _builder_1.append("get");
        }
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr.getName());
        _builder_1.append(_firstUpper_1);
        _builder_1.append("();");
        _xblockexpression = EcoreExtensions.createEOperation(eClass, _builder.toString(), (EClassifier)returnType, (int)_lowerBound, (int)_upperBound, (CharSequence)_builder_1, new EParameter[0]);
        return _xblockexpression;
    }

    private EOperation createSetter(EClass modelElementClass, ElementEClasses elementEClasses, final Attribute attr) {
        boolean _equals;
        EOperation _xblockexpression = null;
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        parameter.setName("_arg");
        parameter.setLowerBound(0);
        parameter.setUpperBound(attr.getUpperBound().intValue());
        if (attr instanceof PrimitiveAttribute) {
            parameter.setEType((EClassifier)this.getEDataType(((PrimitiveAttribute)attr).getType()));
        } else {
            Type _type = ((ComplexAttribute)attr).getType();
            if (_type instanceof Enumeration) {
                parameter.setEType((EClassifier)this.eEnumMap.get(((ComplexAttribute)attr).getType()));
            } else {
                Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ComplexAttribute)attr).getType());
                    }
                };
                parameter.setEType((EClassifier)((ElementEClasses)IterableExtensions.findFirst(this.allElementEClasses, (Functions.Function1)_function)).getMainEClass());
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("set");
        String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
        _builder.append(_firstUpper);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("get");
        String _name = elementEClasses.getInternalEClass().getName();
        _builder_1.append(_name);
        _builder_1.append("().getElement().transact(\"Set ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr.getName());
        _builder_1.append(_firstUpper_1);
        _builder_1.append("\", () -> {");
        _builder_1.newLineIfNotEmpty();
        Integer _upperBound = attr.getUpperBound();
        boolean bl = _equals = _upperBound == 1;
        if (_equals) {
            _builder_1.append("\t");
            _builder_1.append("get");
            String _name_1 = elementEClasses.getInternalEClass().getName();
            _builder_1.append(_name_1, "\t");
            _builder_1.append("().set");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)attr.getName());
            _builder_1.append(_firstUpper_2, "\t");
            _builder_1.append("(_arg);");
            _builder_1.newLineIfNotEmpty();
        } else {
            _builder_1.append("\t");
            _builder_1.append("get");
            String _name_2 = elementEClasses.getInternalEClass().getName();
            _builder_1.append(_name_2, "\t");
            _builder_1.append("().get");
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)attr.getName());
            _builder_1.append(_firstUpper_3, "\t");
            _builder_1.append("().clear();");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("get");
            String _name_3 = elementEClasses.getInternalEClass().getName();
            _builder_1.append(_name_3, "\t");
            _builder_1.append("().get");
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)attr.getName());
            _builder_1.append(_firstUpper_4, "\t");
            _builder_1.append("().addAll(_arg);");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("});");
        _builder_1.newLine();
        _xblockexpression = EcoreExtensions.createEOperation(modelElementClass, _builder.toString(), null, 0, 1, (CharSequence)_builder_1, parameter);
        return _xblockexpression;
    }

    private EOperation createAdder(EClass modelElementClass, ElementEClasses elementEClasses, final Attribute attr) {
        EOperation _xblockexpression = null;
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        parameter.setName("_arg");
        parameter.setLowerBound(0);
        parameter.setUpperBound(1);
        if (attr instanceof PrimitiveAttribute) {
            parameter.setEType((EClassifier)this.getEDataType(((PrimitiveAttribute)attr).getType()));
        } else {
            Type _type = ((ComplexAttribute)attr).getType();
            if (_type instanceof Enumeration) {
                parameter.setEType((EClassifier)this.eEnumMap.get(((ComplexAttribute)attr).getType()));
            } else {
                Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ComplexAttribute)attr).getType());
                    }
                };
                parameter.setEType((EClassifier)((ElementEClasses)IterableExtensions.findFirst(this.allElementEClasses, (Functions.Function1)_function)).getMainEClass());
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("add");
        String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
        _builder.append(_firstUpper);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("get");
        String _name = elementEClasses.getInternalEClass().getName();
        _builder_1.append(_name);
        _builder_1.append("().getElement().transact(\"Set ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr.getName());
        _builder_1.append(_firstUpper_1);
        _builder_1.append("\", () -> {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("get");
        String _name_1 = elementEClasses.getInternalEClass().getName();
        _builder_1.append(_name_1, "\t");
        _builder_1.append("().get");
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)attr.getName());
        _builder_1.append(_firstUpper_2, "\t");
        _builder_1.append("().add(_arg);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("});");
        _builder_1.newLine();
        _xblockexpression = EcoreExtensions.createEOperation(modelElementClass, _builder.toString(), null, 0, 1, (CharSequence)_builder_1, parameter);
        return _xblockexpression;
    }

    private EOperation createRemove(EClass modelElementClass, ElementEClasses elementEClasses, final Attribute attr) {
        EOperation _xblockexpression = null;
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        parameter.setName(StringExtensions.toFirstLower((String)attr.getName()));
        parameter.setUpperBound(1);
        parameter.setLowerBound(0);
        if (attr instanceof PrimitiveAttribute) {
            parameter.setEType((EClassifier)this.getEDataType(((PrimitiveAttribute)attr).getType()));
        } else {
            Type _type = ((ComplexAttribute)attr).getType();
            if (_type instanceof Enumeration) {
                parameter.setEType((EClassifier)this.eEnumMap.get(((ComplexAttribute)attr).getType()));
            } else {
                Functions.Function1<ElementEClasses, Boolean> _function = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses it) {
                        return MGLUtil.equalModelElement((Type)it.getModelElement(), (Type)((ComplexAttribute)attr).getType());
                    }
                };
                parameter.setEType((EClassifier)((ElementEClasses)IterableExtensions.findFirst(this.allElementEClasses, (Functions.Function1)_function)).getMainEClass());
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("remove");
        String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
        _builder.append(_firstUpper);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("get");
        String _name = elementEClasses.getInternalEClass().getName();
        _builder_1.append(_name);
        _builder_1.append("().getElement().transact(\"Set ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr.getName());
        _builder_1.append(_firstUpper_1);
        _builder_1.append("\", () -> {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("get");
        String _name_1 = elementEClasses.getInternalEClass().getName();
        _builder_1.append(_name_1, "\t");
        _builder_1.append("().get");
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)attr.getName());
        _builder_1.append(_firstUpper_2, "\t");
        _builder_1.append("().remove(");
        String _name_2 = attr.getName();
        _builder_1.append(_name_2, "\t");
        _builder_1.append(");");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("});");
        _builder_1.newLine();
        _xblockexpression = EcoreExtensions.createEOperation(modelElementClass, _builder.toString(), null, 0, 1, (CharSequence)_builder_1, parameter);
        return _xblockexpression;
    }

    private EDataType getEDataType(EDataTypeType type) {
        EClassifier _eClassifier = EcorePackage.eINSTANCE.getEClassifier(type.getLiteral());
        return (EDataType)_eClassifier;
    }

    private Iterable<ContainingElement> allContainingElements(final GraphicalModelElement element) {
        List<ContainingElement> _xifexpression = null;
        if (element != null) {
            HashSet<ContainingElement> containingElements = new HashSet<ContainingElement>();
            Functions.Function1<MGLModel, EList<GraphModel>> _function = new Functions.Function1<MGLModel, EList<GraphModel>>(){

                public EList<GraphModel> apply(MGLModel it) {
                    return it.getGraphModels();
                }
            };
            Iterable graphModels = IterableExtensions.flatMap((Iterable)this._generatorUtils.allMGLs, (Functions.Function1)_function);
            for (GraphModel gm : graphModels) {
                Iterable<GraphicalElementContainment> containable = this._nodeMethodsGeneratorExtensions.getAllContainmentConstraints((ContainingElement)gm);
                if (!IterableExtensions.exists(containable, (Functions.Function1)new Functions.Function1<GraphicalElementContainment, Boolean>(){

                    public Boolean apply(GraphicalElementContainment it) {
                        return (IterableExtensions.exists((Iterable)it.getTypes(), (Functions.Function1)new Functions.Function1<GraphicalModelElement, Boolean>(){

                            public Boolean apply(GraphicalModelElement it) {
                                return MGLUtil.equalModelElement((Type)it, (Type)element);
                            }
                        }) || it.getTypes().isEmpty()) && it.getUpperBound() != 0;
                    }
                }) && !gm.getContainableElements().isEmpty()) continue;
                containingElements.add((ContainingElement)gm);
            }
            Iterable<ContainingElement> _containingElements = this.containingElements(element);
            Iterables.addAll(containingElements, _containingElements);
            Functions.Function1<ModelElement, Iterable<ContainingElement>> _function_1 = new Functions.Function1<ModelElement, Iterable<ContainingElement>>(){

                public Iterable<ContainingElement> apply(ModelElement it) {
                    return MGLEcoreGenerator.this.containingElements((GraphicalModelElement)it);
                }
            };
            Iterable _flatMap = IterableExtensions.flatMap((Iterable)MGLUtil.allSuperTypes((ModelElement)element), (Functions.Function1)_function_1);
            Iterables.addAll(containingElements, (Iterable)_flatMap);
            Functions.Function1<ModelElement, Iterable<ContainingElement>> _function_2 = new Functions.Function1<ModelElement, Iterable<ContainingElement>>(){

                public Iterable<ContainingElement> apply(ModelElement it) {
                    return MGLEcoreGenerator.this.containingElements((GraphicalModelElement)it);
                }
            };
            Iterable _flatMap_1 = IterableExtensions.flatMap((Iterable)MGLUtil.allSubTypes((ModelElement)element), (Functions.Function1)_function_2);
            Iterables.addAll(containingElements, (Iterable)_flatMap_1);
            return containingElements;
        }
        _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        return _xifexpression;
    }

    private Iterable<ContainingElement> containingElements(final GraphicalModelElement element) {
        Functions.Function1<MGLModel, EList<GraphModel>> _function = new Functions.Function1<MGLModel, EList<GraphModel>>(){

            public EList<GraphModel> apply(MGLModel it) {
                return it.getGraphModels();
            }
        };
        Functions.Function1<GraphModel, Iterable<ContainingElement>> _function_1 = new Functions.Function1<GraphModel, Iterable<ContainingElement>>(){

            public Iterable<ContainingElement> apply(GraphModel it) {
                Functions.Function1<ContainingElement, Boolean> _function = new Functions.Function1<ContainingElement, Boolean>(){

                    public Boolean apply(ContainingElement it) {
                        Functions.Function1<GraphicalElementContainment, Boolean> _function = new Functions.Function1<GraphicalElementContainment, Boolean>(){

                            public Boolean apply(GraphicalElementContainment it) {
                                return IterableExtensions.exists((Iterable)it.getTypes(), (Functions.Function1)new Functions.Function1<GraphicalModelElement, Boolean>(){

                                    public Boolean apply(GraphicalModelElement it) {
                                        return MGLUtil.equalModelElement((Type)it, (Type)element);
                                    }
                                }) && it.getUpperBound() != 0;
                            }
                        };
                        return IterableExtensions.exists((this).MGLEcoreGenerator.this._nodeMethodsGeneratorExtensions.getAllContainmentConstraints(it), (Functions.Function1)_function);
                    }
                };
                return IterableExtensions.filter((Iterable)MGLUtil.getContainingElements((GraphModel)it), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)this._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1);
    }
}

