/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.generator;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.mgl.generator.extensions.AdapterGeneratorExtension;
import de.jabc.cinco.meta.core.utils.projects.ContentWriter;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import mgl.GraphModel;
import mgl.GraphicalModelElement;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.UserDefinedType;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MGLAdaptersGenerator {
    @Extension
    private AdapterGeneratorExtension _adapterGeneratorExtension = new AdapterGeneratorExtension();

    public void generateAdapters(MGLModel model) {
        IProject project = ProjectCreator.getProject((Resource)model.eResource());
        String _package = model.getPackage();
        String packageName = String.valueOf(_package) + ".adapter";
        ProjectCreator.exportPackage((IProject)project, (String)packageName);
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)model.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel n : _filter) {
            CharSequence adapterContent = this._adapterGeneratorExtension.generateAdapter((ModelElement)n);
            String _name = n.getName();
            String fileName = String.valueOf(_name) + "EContentAdapter.xtend";
            ContentWriter.writeFile((IProject)project, (String)"src-gen", (CharSequence)packageName, (String)fileName, (CharSequence)adapterContent.toString());
        }
        EList _nodes = model.getNodes();
        EList _edges = model.getEdges();
        Iterable _plus = Iterables.concat((Iterable)_nodes, (Iterable)_edges);
        for (GraphicalModelElement n_1 : _plus) {
            String _name = n_1.getName();
            String fileName = String.valueOf(_name) + "EContentAdapter.xtend";
            CharSequence adapterContent = this._adapterGeneratorExtension.generateAdapter((ModelElement)n_1);
            ContentWriter.writeFile((IProject)project, (String)"src-gen", (CharSequence)packageName, (String)fileName, (CharSequence)adapterContent.toString());
        }
        Iterable _filter_1 = Iterables.filter((Iterable)model.getTypes(), UserDefinedType.class);
        for (UserDefinedType t : _filter_1) {
            String _name = t.getName();
            String fileName = String.valueOf(_name) + "EContentAdapter.xtend";
            CharSequence adapterContent = this._adapterGeneratorExtension.generateAdapter(t);
            ContentWriter.writeFile((IProject)project, (String)"src-gen", (CharSequence)packageName, (String)fileName, (CharSequence)adapterContent.toString());
        }
    }
}

