/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.dsl;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.plugin.dsl.FolderDescription;
import de.jabc.cinco.meta.plugin.dsl.ProjectDescription;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class ProjectType {
    @Accessors
    private final Set<String> natures = CollectionLiterals.newLinkedHashSet();
    @Accessors
    private final Set<IClasspathEntry> classpath = CollectionLiterals.newLinkedHashSet();
    @Accessors
    private boolean manifestRequired = false;
    @Accessors
    private boolean buildPropertiesRequired = false;
    public static final ProjectType JAVA = (ProjectType)ObjectExtensions.operator_doubleArrow((Object)new ProjectType(), (Procedures.Procedure1)new Procedures.Procedure1<ProjectType>(){

        public void apply(ProjectType it) {
            Iterables.addAll(it.natures, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.core.javanature"})));
            Functions.Function1<String, IClasspathEntry> _function = new Functions.Function1<String, IClasspathEntry>(){

                public IClasspathEntry apply(String it) {
                    Path _path = new Path(it);
                    return JavaCore.newContainerEntry((IPath)_path);
                }
            };
            List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-11"})), (Functions.Function1)_function);
            Iterables.addAll(it.classpath, (Iterable)_map);
        }
    });
    public static final ProjectType PLUGIN = (ProjectType)ObjectExtensions.operator_doubleArrow((Object)new ProjectType(), (Procedures.Procedure1)new Procedures.Procedure1<ProjectType>(){

        public void apply(ProjectType it) {
            Iterables.addAll(it.natures, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"})));
            Functions.Function1<String, IClasspathEntry> _function = new Functions.Function1<String, IClasspathEntry>(){

                public IClasspathEntry apply(String it) {
                    Path _path = new Path(it);
                    return JavaCore.newContainerEntry((IPath)_path);
                }
            };
            List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-11", "org.eclipse.pde.core.requiredPlugins"})), (Functions.Function1)_function);
            Iterables.addAll(it.classpath, (Iterable)_map);
            it.manifestRequired = true;
            it.buildPropertiesRequired = true;
        }
    });
    public static final ProjectType FEATURE = (ProjectType)ObjectExtensions.operator_doubleArrow((Object)new ProjectType(), (Procedures.Procedure1)new Procedures.Procedure1<ProjectType>(){

        public void apply(ProjectType it) {
            Iterables.addAll(it.natures, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"})));
            Functions.Function1<String, IClasspathEntry> _function = new Functions.Function1<String, IClasspathEntry>(){

                public IClasspathEntry apply(String it) {
                    Path _path = new Path(it);
                    return JavaCore.newContainerEntry((IPath)_path);
                }
            };
            List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-11", "org.eclipse.pde.core.requiredPlugins"})), (Functions.Function1)_function);
            Iterables.addAll(it.classpath, (Iterable)_map);
            it.manifestRequired = true;
            it.buildPropertiesRequired = true;
        }
    });

    public IJavaProject initProject(final ProjectDescription project) {
        try {
            boolean _not;
            IJavaProject _xblockexpression = null;
            IProject iProject = (IProject)project.getIResource();
            iProject.setDescription(this.getIProjectDescription(project), (IProgressMonitor)project.getMonitor());
            IJavaProject _xifexpression = null;
            boolean _isEmpty = this.classpath.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                IJavaProject _create = JavaCore.create((IProject)iProject);
                Procedures.Procedure1<IJavaProject> _function = new Procedures.Procedure1<IJavaProject>(){

                    public void apply(IJavaProject it) {
                        try {
                            Functions.Function1<IProject, IClasspathEntry> _function = new Functions.Function1<IProject, IClasspathEntry>(){

                                public IClasspathEntry apply(IProject it) {
                                    return JavaCore.newProjectEntry((IPath)it.getFullPath());
                                }
                            };
                            List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)ProjectType.this.getIProjectDescription(project).getReferencedProjects())), (Functions.Function1)_function);
                            Iterable _plus = Iterables.concat(ProjectType.this.classpath, (Iterable)_map);
                            Functions.Function1<FolderDescription, IFolder> _function_1 = new Functions.Function1<FolderDescription, IFolder>(){

                                public IFolder apply(FolderDescription it) {
                                    return ProjectType.this.toProjectFolder(project, it.getName());
                                }
                            };
                            Functions.Function1<IFolder, IClasspathEntry> _function_2 = new Functions.Function1<IFolder, IClasspathEntry>(){

                                public IClasspathEntry apply(IFolder it) {
                                    return JavaCore.newSourceEntry((IPath)it.getFullPath());
                                }
                            };
                            Iterable _map_1 = IterableExtensions.map((Iterable)IterableExtensions.map(project.getSourceFolders(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                            Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_map_1);
                            it.setRawClasspath((IClasspathEntry[])Conversions.unwrapArray((Object)_plus_1, IClasspathEntry.class), (IProgressMonitor)project.getMonitor());
                            String _name = project.getName();
                            String _plus_2 = "/" + _name;
                            String _plus_3 = String.valueOf(_plus_2) + "/bin";
                            Path _path = new Path(_plus_3);
                            it.setOutputLocation((IPath)_path, (IProgressMonitor)project.getMonitor());
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                _xifexpression = (IJavaProject)ObjectExtensions.operator_doubleArrow((Object)_create, (Procedures.Procedure1)_function);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected IProjectDescription getIProjectDescription(final ProjectDescription project) {
        IProjectDescription _xblockexpression = null;
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription _newProjectDescription = workspace.newProjectDescription(project.getName());
        Procedures.Procedure1<IProjectDescription> _function = new Procedures.Procedure1<IProjectDescription>(){

            public void apply(IProjectDescription it) {
                ICommand _newCommand = it.newCommand();
                Procedures.Procedure1<ICommand> _function = new Procedures.Procedure1<ICommand>(){

                    public void apply(ICommand it) {
                        it.setBuilderName("org.eclipse.jdt.core.javabuilder");
                    }
                };
                ICommand _doubleArrow = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand, (Procedures.Procedure1)_function);
                ICommand _newCommand_1 = it.newCommand();
                Procedures.Procedure1<ICommand> _function_1 = new Procedures.Procedure1<ICommand>(){

                    public void apply(ICommand it) {
                        it.setBuilderName("org.eclipse.pde.ManifestBuilder");
                    }
                };
                ICommand _doubleArrow_1 = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand_1, (Procedures.Procedure1)_function_1);
                ICommand _newCommand_2 = it.newCommand();
                Procedures.Procedure1<ICommand> _function_2 = new Procedures.Procedure1<ICommand>(){

                    public void apply(ICommand it) {
                        it.setBuilderName("org.eclipse.pde.SchemaBuilder");
                    }
                };
                ICommand _doubleArrow_2 = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand_2, (Procedures.Procedure1)_function_2);
                it.setBuildSpec(new ICommand[]{_doubleArrow, _doubleArrow_1, _doubleArrow_2});
                List _reverse = ListExtensions.reverse((List)IterableExtensions.toList(project.getNatures()));
                Iterable _plus = Iterables.concat(ProjectType.this.natures, (Iterable)_reverse);
                it.setNatureIds((String[])Conversions.unwrapArray((Object)_plus, String.class));
                Functions.Function1<String, IProject> _function_3 = new Functions.Function1<String, IProject>(){

                    public IProject apply(String it) {
                        return workspace.getRoot().getProject(project.getName());
                    }
                };
                it.setReferencedProjects((IProject[])Conversions.unwrapArray((Object)IterableExtensions.map(project.getReferencedProjects(), (Functions.Function1)_function_3), IProject.class));
            }
        };
        _xblockexpression = (IProjectDescription)ObjectExtensions.operator_doubleArrow((Object)_newProjectDescription, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected IFolder toProjectFolder(final ProjectDescription project, String name) {
        IFolder _folder = ((IProject)project.getIResource()).getFolder(name);
        Procedures.Procedure1<IFolder> _function = new Procedures.Procedure1<IFolder>(){

            public void apply(IFolder it) {
                try {
                    boolean _not;
                    boolean _exists = it.exists();
                    boolean bl = _not = !_exists;
                    if (_not) {
                        it.create(false, true, (IProgressMonitor)project.getMonitor());
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (IFolder)ObjectExtensions.operator_doubleArrow((Object)_folder, (Procedures.Procedure1)_function);
    }

    @Pure
    public Set<String> getNatures() {
        return this.natures;
    }

    @Pure
    public Set<IClasspathEntry> getClasspath() {
        return this.classpath;
    }

    @Pure
    public boolean isManifestRequired() {
        return this.manifestRequired;
    }

    public void setManifestRequired(boolean manifestRequired) {
        this.manifestRequired = manifestRequired;
    }

    @Pure
    public boolean isBuildPropertiesRequired() {
        return this.buildPropertiesRequired;
    }

    public void setBuildPropertiesRequired(boolean buildPropertiesRequired) {
        this.buildPropertiesRequired = buildPropertiesRequired;
    }
}

