/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.dsl;

import de.jabc.cinco.meta.plugin.CincoMetaContext;
import de.jabc.cinco.meta.plugin.dsl.FileContainerDescription;
import de.jabc.cinco.meta.plugin.dsl.ProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class ProjectResourceDescription<T extends IResource>
extends CincoMetaContext {
    @Accessors
    private String name;
    @Accessors
    private String symbolicName;
    @Accessors
    private ProjectDescription project;
    @Accessors
    private FileContainerDescription<?> parent;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private T iResource;

    public ProjectResourceDescription(String name) {
        this.setName(name);
    }

    protected abstract T create();

    public T create(FileContainerDescription<?> parent) {
        return this.withParent(parent).create();
    }

    public void setName(String name) {
        this.name = name;
        if (name != null) {
            boolean _startsWith;
            String it = name.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
            boolean _endsWith = it.endsWith(".");
            if (_endsWith) {
                String _plus;
                String _substring = it.substring(0, it.lastIndexOf("."));
                it = _plus = String.valueOf(_substring) + "_";
            }
            if (_startsWith = it.startsWith(".")) {
                String _plus_1;
                String _substring_1 = it.substring(1);
                it = _plus_1 = "_" + _substring_1;
            }
            this.symbolicName = it;
        }
    }

    public ProjectResourceDescription<T> withParent(FileContainerDescription<?> parent) {
        CincoMetaContext.withContext(this, parent);
        this.setParent(parent);
        if (parent instanceof ProjectDescription) {
            this.setProject((ProjectDescription)parent);
        } else {
            this.setProject(parent.getProject());
        }
        return this;
    }

    protected NullProgressMonitor getMonitor() {
        return new NullProgressMonitor();
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    @Pure
    public ProjectDescription getProject() {
        return this.project;
    }

    public void setProject(ProjectDescription project) {
        this.project = project;
    }

    @Pure
    public FileContainerDescription<?> getParent() {
        return this.parent;
    }

    public void setParent(FileContainerDescription<?> parent) {
        this.parent = parent;
    }

    @Pure
    public T getIResource() {
        return this.iResource;
    }

    protected void setIResource(T iResource) {
        this.iResource = iResource;
    }
}

