/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.dsl;

import de.jabc.cinco.meta.plugin.dsl.BuildPropertiesDescription;
import de.jabc.cinco.meta.plugin.dsl.FileContainerDescription;
import de.jabc.cinco.meta.plugin.dsl.FileDescription;
import de.jabc.cinco.meta.plugin.dsl.FolderDescription;
import de.jabc.cinco.meta.plugin.dsl.ManifestDescription;
import de.jabc.cinco.meta.plugin.dsl.ProjectType;
import de.jabc.cinco.meta.plugin.template.ProjectTemplate;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class ProjectDescription
extends FileContainerDescription<IProject> {
    private ProjectTemplate template;
    private ProjectType type = ProjectType.PLUGIN;
    private BuildPropertiesDescription buildProperties = new BuildPropertiesDescription();
    private ManifestDescription manifest = new ManifestDescription();
    private final Set<String> natures = CollectionLiterals.newLinkedHashSet();
    private final Set<String> referencedProjects = CollectionLiterals.newHashSet();

    public ProjectDescription(String name) {
        super(name);
        this.setDeleteIfExistent(true);
    }

    public ProjectDescription(ProjectTemplate template, String name) {
        this(name);
        this.template = template;
    }

    public ProjectDescription(ProjectTemplate template) {
        this(template, template.getProjectName());
    }

    public Iterable<FolderDescription> getSourceFolders() {
        Functions.Function1<FolderDescription, Boolean> _function = new Functions.Function1<FolderDescription, Boolean>(){

            public Boolean apply(FolderDescription it) {
                return it.isSourceFolder();
            }
        };
        return IterableExtensions.filter(this.getFolders(), (Functions.Function1)_function);
    }

    public ProjectDescription setNatures(final String[] names) {
        Procedures.Procedure1<ProjectDescription> _function = new Procedures.Procedure1<ProjectDescription>(){

            public void apply(ProjectDescription it) {
                Procedures.Procedure1<Set<String>> _function = new Procedures.Procedure1<Set<String>>(){

                    public void apply(Set<String> it) {
                        it.clear();
                        CollectionExtensions.addAll(it, (Object[])names);
                    }
                };
                ObjectExtensions.operator_doubleArrow(it.natures, (Procedures.Procedure1)_function);
            }
        };
        return (ProjectDescription)ObjectExtensions.operator_doubleArrow((Object)this, (Procedures.Procedure1)_function);
    }

    public ProjectDescription setReferencedProjects(final String[] names) {
        Procedures.Procedure1<ProjectDescription> _function = new Procedures.Procedure1<ProjectDescription>(){

            public void apply(ProjectDescription it) {
                Procedures.Procedure1<Set<String>> _function = new Procedures.Procedure1<Set<String>>(){

                    public void apply(Set<String> it) {
                        it.clear();
                        CollectionExtensions.addAll(it, (Object[])names);
                    }
                };
                ObjectExtensions.operator_doubleArrow(it.referencedProjects, (Procedures.Procedure1)_function);
            }
        };
        return (ProjectDescription)ObjectExtensions.operator_doubleArrow((Object)this, (Procedures.Procedure1)_function);
    }

    @Override
    public IProject create() {
        this.init();
        this.createFiles();
        this.createFolders();
        return (IProject)this.getIResource();
    }

    protected void init() {
        try {
            boolean _not_1;
            boolean _not;
            IProject project = this._workspaceExtension.getWorkspace().getRoot().getProject(this.getName());
            this.setIResource(project);
            boolean initialize = true;
            boolean _exists = project.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                project.create(null, (IProgressMonitor)this.getMonitor());
            } else {
                boolean _isDeleteIfExistent = this.isDeleteIfExistent();
                if (_isDeleteIfExistent) {
                    Procedures.Procedure1<IProject> _function = new Procedures.Procedure1<IProject>(){

                        public void apply(IProject it) {
                            try {
                                it.delete(true, true, (IProgressMonitor)ProjectDescription.this.getMonitor());
                                it.create(null, (IProgressMonitor)ProjectDescription.this.getMonitor());
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)project, (Procedures.Procedure1)_function);
                } else {
                    initialize = false;
                }
            }
            boolean _isOpen = project.isOpen();
            boolean bl2 = _not_1 = !_isOpen;
            if (_not_1) {
                project.open((IProgressMonitor)this.getMonitor());
            }
            if (initialize) {
                this.type.initProject(this);
            }
            Functions.Function1<FolderDescription, Boolean> _function_1 = new Functions.Function1<FolderDescription, Boolean>(){

                public Boolean apply(FolderDescription it) {
                    return it.isDeleteIfExistent();
                }
            };
            Consumer<FolderDescription> _function_2 = new Consumer<FolderDescription>(){

                @Override
                public void accept(FolderDescription foldDesc) {
                    IFolder _folder = ((IProject)ProjectDescription.this.getIResource()).getFolder(foldDesc.getName());
                    Procedures.Procedure1<IFolder> _function = new Procedures.Procedure1<IFolder>(){

                        public void apply(IFolder folder) {
                            try {
                                boolean _exists = folder.exists();
                                if (_exists) {
                                    folder.delete(true, (IProgressMonitor)ProjectDescription.this.getMonitor());
                                }
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_folder, (Procedures.Procedure1)_function);
                }
            };
            IterableExtensions.filter(this.getFolders(), (Functions.Function1)_function_1).forEach(_function_2);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void createFiles() {
        boolean _isBuildPropertiesRequired;
        super.createFiles();
        boolean _isManifestRequired = this.type.isManifestRequired();
        if (_isManifestRequired) {
            this.manifest.create(this);
        }
        if (_isBuildPropertiesRequired = this.type.isBuildPropertiesRequired()) {
            this.buildProperties.create(this);
        }
    }

    @Override
    public void add(FileDescription file) {
        super.add(file);
        file.setProject(this);
    }

    @Override
    public void add(FolderDescription folder) {
        super.add(folder);
        folder.setProject(this);
    }

    @Pure
    public ProjectTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ProjectTemplate template) {
        this.template = template;
    }

    @Pure
    public ProjectType getType() {
        return this.type;
    }

    public void setType(ProjectType type) {
        this.type = type;
    }

    @Pure
    public BuildPropertiesDescription getBuildProperties() {
        return this.buildProperties;
    }

    public void setBuildProperties(BuildPropertiesDescription buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Pure
    public ManifestDescription getManifest() {
        return this.manifest;
    }

    public void setManifest(ManifestDescription manifest) {
        this.manifest = manifest;
    }

    @Pure
    public Set<String> getNatures() {
        return this.natures;
    }

    @Pure
    public Set<String> getReferencedProjects() {
        return this.referencedProjects;
    }
}

