/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.dsl;

import de.jabc.cinco.meta.plugin.dsl.ProjectResourceDescription;
import de.jabc.cinco.meta.plugin.template.FileTemplate;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class FileDescription
extends ProjectResourceDescription<IFile> {
    @Accessors
    private CharSequence content;
    @Accessors
    private Class<? extends FileTemplate> templateClass;
    @Accessors
    private Consumer<IFile> postProcessing;
    @Accessors
    private FileTemplate template;
    @Accessors
    private boolean overwrite = true;

    public FileDescription(String name) {
        super(name);
    }

    public FileDescription(Class<? extends FileTemplate> templateClass) {
        this(templateClass.getSimpleName(), templateClass);
    }

    public FileDescription(FileTemplate template) {
        this(template.getClass());
        this.template = template;
    }

    public FileDescription(String name, Class<? extends FileTemplate> templateClass) {
        super(name);
        this.templateClass = templateClass;
    }

    public FileDescription(String name, FileTemplate template) {
        this(name, template.getClass());
        this.template = template;
    }

    public FileDescription(String name, CharSequence content) {
        super(name);
        this.content = content;
    }

    @Override
    public IFile create() {
        IFile _iResource;
        boolean _tripleEquals;
        CharSequence content = this.getContent();
        if (content != null) {
            return this.createFile(this.getName(), content);
        }
        FileTemplate template = this.getTemplate();
        if (template == null) {
            template = this.template = this.createNewInstance(this.templateClass, new Object[0]);
        }
        if (template != null) {
            Procedures.Procedure1<FileTemplate> _function = new Procedures.Procedure1<FileTemplate>(){

                public void apply(FileTemplate it) {
                    it.setCpd(FileDescription.this.getCpd());
                    it.setModel(FileDescription.this.getModel());
                    it.setGraphModel(FileDescription.this.getGraphModel());
                    it.setParent(FileDescription.this.getParent());
                    it.setProject(FileDescription.this.getProject());
                    FileDescription.this.createFile(it.getTargetFileName(), it.getContent());
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)template, (Procedures.Procedure1)_function);
        }
        boolean bl = _tripleEquals = (_iResource = (IFile)this.getIResource()) == null;
        if (_tripleEquals) {
            this._codingExtension.warn((Object)this, (CharSequence)"Nothing to create: content is null and no template provided");
        }
        return (IFile)this.getIResource();
    }

    protected IFile createFile(String fileName, CharSequence content) {
        Path _path = new Path(fileName);
        IFile targetFile = ((IContainer)this.getParent().getIResource()).getFile((IPath)_path);
        if (this.overwrite || targetFile == null || !targetFile.exists()) {
            IFile file = this._workspaceExtension.createFile((IContainer)this.getParent().getIResource(), fileName, content);
            this.setIResource(file);
            if (this.postProcessing != null) {
                this.postProcessing.accept(file);
            }
        }
        return (IFile)this.getIResource();
    }

    private <T> T createNewInstance(Class<T> clazz, final Object ... parameters) {
        try {
            Constructor<?>[] _constructors = null;
            if (clazz != null) {
                _constructors = clazz.getConstructors();
            }
            Constructor _findFirst = null;
            if ((Iterable)Conversions.doWrapArray(_constructors) != null) {
                Functions.Function1 _function = new Functions.Function1<Constructor<?>, Boolean>(){

                    public Boolean apply(Constructor<?> constructor) {
                        int _size;
                        int _parameterCount = constructor.getParameterCount();
                        return _parameterCount == (_size = ((List)Conversions.doWrapArray((Object)parameters)).size());
                    }
                };
                _findFirst = (Constructor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray(_constructors)), (Functions.Function1)_function);
            }
            T _newInstance = null;
            if (_findFirst != null) {
                _newInstance = _findFirst.newInstance(parameters);
            }
            return _newInstance;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Pure
    public CharSequence getContent() {
        return this.content;
    }

    public void setContent(CharSequence content) {
        this.content = content;
    }

    @Pure
    public Class<? extends FileTemplate> getTemplateClass() {
        return this.templateClass;
    }

    public void setTemplateClass(Class<? extends FileTemplate> templateClass) {
        this.templateClass = templateClass;
    }

    @Pure
    public Consumer<IFile> getPostProcessing() {
        return this.postProcessing;
    }

    public void setPostProcessing(Consumer<IFile> postProcessing) {
        this.postProcessing = postProcessing;
    }

    @Pure
    public FileTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(FileTemplate template) {
        this.template = template;
    }

    @Pure
    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

