/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.dsl;

import de.jabc.cinco.meta.plugin.dsl.BasePath;
import de.jabc.cinco.meta.plugin.dsl.FileDescription;
import java.io.FileNotFoundException;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class FileCopyDescription
extends FileDescription {
    private String targetFileName;
    private String sourcePath;
    private BasePath relativeToBasePath;

    public FileCopyDescription(String name) {
        super(name);
    }

    public FileCopyDescription(String targetFileName, String sourcePath, BasePath relativeToBasePath) {
        super(targetFileName);
        this.targetFileName = targetFileName;
        this.sourcePath = sourcePath;
        this.relativeToBasePath = relativeToBasePath;
    }

    @Override
    public IFile create() {
        try {
            IWorkspaceRoot sourceBasePath;
            IFile sourceFile;
            IWorkspaceRoot _switchResult = null;
            BasePath relativeToBasePath = this.relativeToBasePath;
            if (relativeToBasePath != null) {
                switch (relativeToBasePath) {
                    case WORKSPACE_ROOT: {
                        _switchResult = this._workspaceExtension.getWorkspaceRoot();
                        break;
                    }
                    case PROJECT: {
                        _switchResult = ((IContainer)this.getParent().getIResource()).getProject();
                        break;
                    }
                    case FOLDER: {
                        _switchResult = (IContainer)this.getParent().getIResource();
                        break;
                    }
                }
            }
            if ((sourceFile = (sourceBasePath = _switchResult).getFile((IPath)this._workspaceExtension.toPath(this.sourcePath))) == null || !sourceFile.exists()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("File \"");
                IPath _append = sourceBasePath.getFullPath().append(this.sourcePath);
                _builder.append((Object)_append);
                _builder.append("\" does not exist");
                throw new FileNotFoundException(_builder.toString());
            }
            IFile targetFile = ((IContainer)this.getParent().getIResource()).getFile((IPath)this._workspaceExtension.toPath(this.getName()));
            if (this.isOverwrite() || targetFile == null || !targetFile.exists()) {
                this.setIResource(this._workspaceExtension.createFile((IContainer)this.getParent().getIResource(), this.getName(), sourceFile.getContents()));
                Consumer<IFile> _postProcessing = this.getPostProcessing();
                if (_postProcessing != null) {
                    _postProcessing.accept((IFile)this.getIResource());
                }
            }
            return (IFile)this.getIResource();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Pure
    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    @Pure
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Pure
    public BasePath getRelativeToBasePath() {
        return this.relativeToBasePath;
    }

    public void setRelativeToBasePath(BasePath relativeToBasePath) {
        this.relativeToBasePath = relativeToBasePath;
    }
}

