/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.dsl;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.plugin.dsl.FileDescription;
import de.jabc.cinco.meta.plugin.dsl.FolderDescription;
import de.jabc.cinco.meta.plugin.dsl.ProjectResourceDescription;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.osgi.framework.Bundle;

public abstract class FileContainerDescription<T extends IContainer>
extends ProjectResourceDescription<T> {
    @Accessors
    private boolean deleteIfExistent = false;
    @Accessors
    private Set<FileDescription> files = CollectionLiterals.newHashSet();
    @Accessors
    private Set<Pair<String, String>> filesFromBundles = CollectionLiterals.newHashSet();
    @Accessors
    private Set<Pair<String, String>> filesFromProjects = CollectionLiterals.newHashSet();
    @Accessors
    private Set<FolderDescription> folders = CollectionLiterals.newLinkedHashSet();

    public FileContainerDescription(String name) {
        super(name);
    }

    public void createFiles() {
        Functions.Function1<Pair<String, String>, Enumeration<URL>> _function = new Functions.Function1<Pair<String, String>, Enumeration<URL>>(){

            public Enumeration<URL> apply(Pair<String, String> it) {
                Bundle _bundle = Platform.getBundle((String)((String)it.getKey()));
                Enumeration _findEntries = null;
                if (_bundle != null) {
                    _findEntries = _bundle.findEntries((String)it.getValue(), "*", true);
                }
                return _findEntries;
            }
        };
        Functions.Function1<Enumeration<URL>, List<URL>> _function_1 = new Functions.Function1<Enumeration<URL>, List<URL>>(){

            public List<URL> apply(Enumeration<URL> it) {
                return FileContainerDescription.this._collectionExtension.toList(it);
            }
        };
        Consumer<URL> _function_2 = new Consumer<URL>(){

            @Override
            public void accept(URL it) {
                try {
                    String _file = it.getFile();
                    int _lastIndexOf = it.getFile().lastIndexOf("/");
                    int _plus = _lastIndexOf + 1;
                    FileContainerDescription.this._workspaceExtension.createFile((IContainer)FileContainerDescription.this.getIResource(), _file.substring(_plus), it.openStream());
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map(this.filesFromBundles, (Functions.Function1)_function), (Functions.Function1)_function_1)).forEach(_function_2);
        Functions.Function1<Pair<String, String>, List<IFile>> _function_3 = new Functions.Function1<Pair<String, String>, List<IFile>>(){

            public List<IFile> apply(Pair<String, String> it) {
                IWorkspaceRoot _workspaceRoot = FileContainerDescription.this._workspaceExtension.getWorkspaceRoot();
                IProject _project = null;
                if (_workspaceRoot != null) {
                    _project = _workspaceRoot.getProject((String)it.getKey());
                }
                IFolder _folder = null;
                if (_project != null) {
                    _folder = _project.getFolder((String)it.getValue());
                }
                return FileContainerDescription.this._workspaceExtension.getFiles(_folder);
            }
        };
        Consumer<IFile> _function_4 = new Consumer<IFile>(){

            @Override
            public void accept(IFile it) {
                try {
                    it.copy(((IContainer)FileContainerDescription.this.getIResource()).getFullPath().append(it.getName()), true, null);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterables.concat((Iterable)IterableExtensions.map(this.filesFromProjects, (Functions.Function1)_function_3)).forEach(_function_4);
        Consumer<FileDescription> _function_5 = new Consumer<FileDescription>(){

            @Override
            public void accept(FileDescription it) {
                it.create(FileContainerDescription.this);
            }
        };
        this.files.forEach(_function_5);
    }

    public void createFolders() {
        Consumer<FolderDescription> _function = new Consumer<FolderDescription>(){

            @Override
            public void accept(FolderDescription foldDesc) {
                boolean _isDeleteIfExistent = foldDesc.isDeleteIfExistent();
                if (_isDeleteIfExistent) {
                    String _name = foldDesc.getName();
                    Path _path = new Path(_name);
                    IFolder _folder = ((IContainer)FileContainerDescription.this.getIResource()).getFolder((IPath)_path);
                    Procedures.Procedure1<IFolder> _function = new Procedures.Procedure1<IFolder>(){

                        public void apply(IFolder folder) {
                            try {
                                boolean _exists = false;
                                if (folder != null) {
                                    _exists = folder.exists();
                                }
                                if (_exists) {
                                    folder.delete(true, (IProgressMonitor)FileContainerDescription.this.getMonitor());
                                }
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_folder, (Procedures.Procedure1)_function);
                }
                foldDesc.create(FileContainerDescription.this);
            }
        };
        this.folders.forEach(_function);
    }

    public Iterable<FileContainerDescription<?>> getHierarchy() {
        Iterable<FileContainerDescription<Object>> _elvis = null;
        FileContainerDescription<?> _parent = this.getParent();
        Iterable<FileContainerDescription<?>> _hierarchy = null;
        if (_parent != null) {
            _hierarchy = _parent.getHierarchy();
        }
        _elvis = _hierarchy != null ? _hierarchy : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new FileContainerDescription[]{this})), _elvis);
    }

    public void add(FileDescription file) {
        this.files.add(file);
        file.setParent(this);
    }

    public void add(FolderDescription folder) {
        this.folders.add(folder);
        folder.setParent(this);
    }

    @Pure
    public boolean isDeleteIfExistent() {
        return this.deleteIfExistent;
    }

    public void setDeleteIfExistent(boolean deleteIfExistent) {
        this.deleteIfExistent = deleteIfExistent;
    }

    @Pure
    public Set<FileDescription> getFiles() {
        return this.files;
    }

    public void setFiles(Set<FileDescription> files) {
        this.files = files;
    }

    @Pure
    public Set<Pair<String, String>> getFilesFromBundles() {
        return this.filesFromBundles;
    }

    public void setFilesFromBundles(Set<Pair<String, String>> filesFromBundles) {
        this.filesFromBundles = filesFromBundles;
    }

    @Pure
    public Set<Pair<String, String>> getFilesFromProjects() {
        return this.filesFromProjects;
    }

    public void setFilesFromProjects(Set<Pair<String, String>> filesFromProjects) {
        this.filesFromProjects = filesFromProjects;
    }

    @Pure
    public Set<FolderDescription> getFolders() {
        return this.folders;
    }

    public void setFolders(Set<FolderDescription> folders) {
        this.folders = folders;
    }
}

