/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.headless;

import info.scce.dime.headless.generator.HeadlessGenerator;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class DIMEHeadlessGenerator
implements IApplication {
    private String graphPath;
    private String importPath = null;
    private final String USAGE = "Usage: dime -data <workspacePath> -application info.scce.dime.headless [--importProject <importPath>] --model <modelPath>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext context) throws Exception {
        System.out.println("Reading Parameters");
        Object[] params = this.getArgs(context);
        if (params[0] != null && params[1] != null) {
            this.importPath = params[0];
            this.graphPath = params[1];
        } else if (params[0] != null) {
            this.graphPath = params[0];
        } else {
            System.err.println("Usage: dime -data <workspacePath> -application info.scce.dime.headless [--importProject <importPath>] --model <modelPath>");
            throw new RuntimeException(String.format("Can not read parameters: %s", Arrays.toString(params)));
        }
        System.out.println("Project Root: " + this.importPath);
        System.out.println("DAD File: " + this.graphPath);
        Job job = new HeadlessGenerator().createGenerationJob(this.importPath, this.graphPath);
        System.out.println("Scheduling generation job...");
        job.schedule();
        Job job2 = job;
        synchronized (job2) {
            job.join();
        }
        IStatus result = job.getResult();
        if (Status.OK_STATUS.equals(result)) {
            System.out.println("Generation job result: " + result);
            System.out.println("Success.");
            return IApplication.EXIT_OK;
        }
        Throwable e = result.getException();
        if (e != null) {
            e.printStackTrace();
        }
        System.out.println("Generation job result: " + result);
        System.out.println("Error.");
        return 1;
    }

    public String[] getArgs(IApplicationContext context) {
        Map args = context.getArguments();
        Object[] appArgs = (String[])args.get("application.args");
        String[] parameters = new String[2];
        if (appArgs.length >= 4) {
            int j = 0;
            int i = 0;
            while (i < appArgs.length - 1) {
                if (((String)appArgs[i]).equals("--importProject")) {
                    parameters[j] = appArgs[i + 1];
                    ++j;
                }
                if (((String)appArgs[i]).equals("--model")) {
                    parameters[j] = appArgs[i + 1];
                    break;
                }
                ++i;
            }
        } else {
            System.err.println(Arrays.toString(appArgs));
            System.err.println("Usage: dime -data <workspacePath> -application info.scce.dime.headless [--importProject <importPath>] --model <modelPath>");
        }
        return parameters;
    }

    public void stop() {
    }
}

