/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.primeviewer.validation;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.pluginregistry.validation.IMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.ValidationResult;
import de.jabc.cinco.meta.core.utils.xapi.GraphModelExtension;
import java.util.List;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.Node;
import mgl.ReferencedEClass;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PrimeViewerValidator
implements IMetaPluginValidator {
    @Extension
    private GraphModelExtension _graphModelExtension = new GraphModelExtension();

    public ValidationResult<String, EStructuralFeature> checkOnEdit(EObject obj) {
        ValidationResult<String, EStructuralFeature> _xifexpression = null;
        if (obj instanceof Annotation) {
            ValidationResult<String, EStructuralFeature> _switchResult = null;
            String _name = ((Annotation)obj).getName();
            boolean _matched = false;
            if (Objects.equal((Object)_name, (Object)"primeviewer")) {
                _matched = true;
                _switchResult = this.checkPrimeviewer((Annotation)obj);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"pvLabel")) {
                _matched = true;
                _switchResult = this.checkPvLabel((Annotation)obj);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"pvFileExtension")) {
                _matched = true;
                _switchResult = this.checkPvFileExtension((Annotation)obj);
            }
            _xifexpression = _switchResult;
        }
        return _xifexpression;
    }

    public ValidationResult<String, EStructuralFeature> checkPrimeviewer(Annotation annotation) {
        boolean _not;
        if (annotation.getValue() != null && annotation.getValue().size() != 0) {
            return ValidationResult.newError((Object)"The @primeviewer annotation does not expect any parameters.", (Object)annotation.eClass().getEStructuralFeature("value"));
        }
        boolean _pvFileExtensionAnnotationExists = this.pvFileExtensionAnnotationExists(annotation);
        boolean bl = _not = !_pvFileExtensionAnnotationExists;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("This MGL does not contain any @pvFileExtension(...) annotations.");
            _builder.newLine();
            _builder.append("The Prime Viewer meta plugin will have no effect.");
            _builder.newLine();
            _builder.append("Add @pvFileExtension(...) to a prime reference to display it in the Prime Viewer.");
            _builder.newLine();
            return ValidationResult.newWarning((Object)_builder.toString().trim(), (Object)annotation.eClass().getEStructuralFeature("value"));
        }
        return null;
    }

    public ValidationResult<String, EStructuralFeature> checkPvLabel(Annotation annotation) {
        boolean _not_1;
        boolean _primeviewerAnnotationExists;
        boolean _not;
        if (annotation.getValue() == null || annotation.getValue().size() != 1) {
            return ValidationResult.newError((Object)"Provide exactly one valid attribute as label, e.g. @pvLabel(name)", (Object)annotation.eClass().getEStructuralFeature("name"));
        }
        Annotatable _parent = annotation.getParent();
        if (_parent instanceof ReferencedType) {
            boolean valid;
            final String attrName = (String)IterableExtensions.head((Iterable)annotation.getValue());
            Annotatable _parent_1 = annotation.getParent();
            ReferencedType refType = (ReferencedType)_parent_1;
            boolean _switchResult = false;
            ReferencedType it = refType;
            boolean _matched = false;
            if (it instanceof ReferencedEClass) {
                _matched = true;
                EStructuralFeature _eStructuralFeature = ((ReferencedEClass)it).getType().getEStructuralFeature(attrName);
                boolean bl = _switchResult = _eStructuralFeature != null;
            }
            if (!_matched && it instanceof ReferencedModelElement) {
                _matched = true;
                Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

                    public String apply(Attribute it) {
                        return it.getName();
                    }
                };
                Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String it) {
                        return Objects.equal((Object)it, (Object)attrName);
                    }
                };
                _switchResult = IterableExtensions.exists((Iterable)IterableExtensions.map((Iterable)this._graphModelExtension.getAllAttributes(((ReferencedModelElement)it).getType()), (Functions.Function1)_function), (Functions.Function1)_function_1);
            }
            if (!(valid = _switchResult)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(attrName);
                _builder.append(" is not a valid attribute of the referenced type ");
                String _name = refType.getName();
                _builder.append(_name);
                return ValidationResult.newError((Object)_builder.toString(), (Object)annotation.eClass().getEStructuralFeature("value"));
            }
        }
        boolean bl = _not = !(_primeviewerAnnotationExists = this.primeviewerAnnotationExists(annotation));
        if (_not) {
            return ValidationResult.newWarning((Object)"Missing @primeviewer annotation. To activate the Prime Viewer meta plugin, add @primeviewer to the graph model.", (Object)annotation.eClass().getEStructuralFeature("name"));
        }
        boolean _hasAnnotation = this._graphModelExtension.hasAnnotation(annotation.getParent(), "pvFileExtension");
        boolean bl2 = _not_1 = !_hasAnnotation;
        if (_not_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The prime reference \"");
            Annotatable _parent_2 = annotation.getParent();
            String _name_1 = ((ReferencedType)_parent_2).getName();
            _builder_1.append(_name_1);
            _builder_1.append("\" has no @pvFileExtension(...) annotation.");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("To display it in the Prime Viewer, you must add @pvFileExtension(...) to the prime reference.");
            _builder_1.newLine();
            return ValidationResult.newWarning((Object)_builder_1.toString().trim(), (Object)annotation.eClass().getEStructuralFeature("name"));
        }
        return null;
    }

    public ValidationResult<String, EStructuralFeature> checkPvFileExtension(Annotation annotation) {
        boolean _not;
        if (annotation.getValue() == null || annotation.getValue().size() != 1) {
            return ValidationResult.newError((Object)"Provide exactly one file extension, e.g. @pvFileExtension(\"value\")", (Object)annotation.eClass().getEStructuralFeature("name"));
        }
        boolean _primeviewerAnnotationExists = this.primeviewerAnnotationExists(annotation);
        boolean bl = _not = !_primeviewerAnnotationExists;
        if (_not) {
            return ValidationResult.newWarning((Object)"Missing @primeviewer annotation. To activate the Prime Viewer meta plugin, add @primeviewer to the graph model.", (Object)annotation.eClass().getEStructuralFeature("name"));
        }
        return null;
    }

    private MGLModel getMglModel(Annotation annotation) {
        Annotatable parent = annotation.getParent();
        while (parent != null && !(parent instanceof MGLModel)) {
            parent = parent.eContainer();
        }
        return (MGLModel)parent;
    }

    private boolean pvFileExtensionAnnotationExists(Annotation annotation) {
        Functions.Function1<Node, ReferencedType> _function = new Functions.Function1<Node, ReferencedType>(){

            public ReferencedType apply(Node it) {
                return it.getPrimeReference();
            }
        };
        Functions.Function1<ReferencedType, Boolean> _function_1 = new Functions.Function1<ReferencedType, Boolean>(){

            public Boolean apply(ReferencedType it) {
                return PrimeViewerValidator.this._graphModelExtension.hasAnnotation((Annotatable)it, "pvFileExtension");
            }
        };
        return IterableExtensions.exists((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)this.getMglModel(annotation).getNodes(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
    }

    private boolean primeviewerAnnotationExists(Annotation annotation) {
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                return PrimeViewerValidator.this._graphModelExtension.hasAnnotation((Annotatable)it, "primeviewer");
            }
        };
        return IterableExtensions.exists((Iterable)this.getMglModel(annotation).getGraphModels(), (Functions.Function1)_function);
    }
}

