/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.headless.generator;

import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import graphmodel.GraphModel;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.generator.dad.Generator;
import info.scce.dime.headless.generator.ProjectImport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;

public class HeadlessGenerator {
    public String TARGET_FOLDER = "target";
    private IWorkspaceRoot workspaceRoot;
    private IWorkspace workspace;
    private IProgressMonitor monitor = new NullProgressMonitor();
    private WorkspaceExtension workEx = new WorkspaceExtension();
    private String graphPath;
    private IPath outlet;
    private DAD graph;
    private String importPath;

    public Job createGenerationJob(String importPath, String modelPath) {
        this.graphPath = modelPath;
        this.importPath = importPath;
        try {
            this.setUpWorkspace();
            this.loadDADModel();
            CompoundJob job = JobFactory.job((String)"DIME Headless Generator", (boolean)false);
            job.consume(100, "Starting Code Generation");
            this.collectCodeGenerationTasks(job);
            job.onFinished(this::finish);
            return job;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Headless generation failed...", e);
        }
    }

    private void collectCodeGenerationTasks(CompoundJob job) throws HeadlessGeneratorException {
        if (this.graph == null) {
            throw new HeadlessGeneratorException(String.format("Could not load model: %s", this.graphPath));
        }
        Generator dimeGraphGen = new Generator();
        dimeGraphGen.setHeadless(true);
        dimeGraphGen.collectTasks((GraphModel)this.graph, this.outlet, job);
    }

    private void finish() {
        System.out.println("Code Generation Finished");
        try {
            System.out.print("Refreshing workspace... ");
            this.workspaceRoot.refreshLocal(2, this.monitor);
            System.out.println("done.");
            System.out.print("Saving workspace... ");
            this.workspace.save(true, this.monitor);
            System.out.println("done.");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadDADModel() throws HeadlessGeneratorException {
        System.out.print("Loading DAD Model... ");
        URI uri = URI.createURI((String)("platform:/resource/" + this.graphPath));
        System.out.println("URI to be loaded: " + uri.toString());
        IFile modelFile = this.workEx.getFile(uri);
        try {
            this.graph = (DAD)this.workEx.getGraphModel(modelFile, DAD.class);
            System.out.println("done.");
        }
        catch (NullPointerException e) {
            throw new HeadlessGeneratorException("NullPointerExcpetion caught. Check if the app's source folder matches the app name in the .project file! Compare https://gitlab.com/scce/dime/-/issues/823", e);
        }
    }

    private void setUpWorkspace() throws HeadlessGeneratorException {
        System.out.println("Setting up workspace...");
        this.workspace = this.workEx.getWorkspace();
        this.workspaceRoot = this.workspace.getRoot();
        this.importProjects();
        this.openProjects();
        this.initOutlet();
        this.refreshWorkspace();
        System.out.println("done.");
    }

    private void refreshWorkspace() throws HeadlessGeneratorException {
        System.out.print("  Refreshing workspace... ");
        try {
            this.workspaceRoot.refreshLocal(2, this.monitor);
        }
        catch (CoreException e) {
            throw new HeadlessGeneratorException("Failed to refresh workspace", e);
        }
        System.out.println("done.");
    }

    private void openProjects() throws HeadlessGeneratorException {
        System.out.println("  Opening projects in workspace...");
        IProject[] iProjectArray = this.workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            System.out.println("    Opening project " + project.getName());
            try {
                project.open(this.monitor);
            }
            catch (CoreException e) {
                throw new HeadlessGeneratorException("Failed to open pojects in workspace", e);
            }
            ++n2;
        }
        System.out.println("  done.");
    }

    private void initOutlet() {
        System.out.println("  Initializing outlet...");
        IFile modelFile = this.workspaceRoot.getFile(Path.fromOSString((String)this.graphPath));
        IProject project = modelFile.getProject();
        this.outlet = project.getFolder(this.TARGET_FOLDER).getLocation();
        System.out.println("    Resolved outlet folder: " + this.outlet + " (exists: " + this.outlet.toFile().exists() + ")");
        if (!this.outlet.toFile().exists()) {
            System.out.println("    Creating outlet folder...");
            this.outlet.toFile().mkdirs();
            System.out.println("    done. (exists: " + this.outlet.toFile().exists() + ")");
        } else if (!this.outlet.toFile().isDirectory()) {
            throw new RuntimeException("Outlet exists, but is no directory: " + this.outlet);
        }
        System.out.println("  done.");
    }

    private void importProjects() throws HeadlessGeneratorException {
        if (this.importPath != null) {
            System.out.print("  Importing projects into workspace... ");
            try {
                ProjectImport.importProjectFromString(this.importPath);
            }
            catch (CoreException e) {
                throw new HeadlessGeneratorException("Failed to imports pojects in workspace", e);
            }
            System.out.println("done.");
        }
    }

    class HeadlessGeneratorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HeadlessGeneratorException(String message, Throwable cause) {
            super(message, cause);
        }

        public HeadlessGeneratorException(String message) {
            super(message);
        }
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

