/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.productdefinition.validation;

import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.core.utils.projects.ContentWriter;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.productdefinition.validation.AbstractCPDValidator;
import de.jabc.cinco.meta.util.xapi.FileExtension;
import java.io.File;
import java.util.Collections;
import java.util.List;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import productDefinition.About;
import productDefinition.CincoProduct;
import productDefinition.Color;
import productDefinition.MGLDescriptor;
import productDefinition.ProductDefinitionPackage;
import productDefinition.SplashScreen;

public class CPDValidator
extends AbstractCPDValidator {
    @Extension
    private FileExtension _fileExtension = new FileExtension();

    @Check
    public void checkColor(Color it) {
        if (it.getR() < 0 || it.getR() > 255) {
            this.error("Value for red must be in the range from 0 to 255.", (EStructuralFeature)ProductDefinitionPackage.Literals.COLOR__R);
        }
        if (it.getG() < 0 || it.getG() > 255) {
            this.error("Value for green must be in the range from 0 to 255.", (EStructuralFeature)ProductDefinitionPackage.Literals.COLOR__G);
        }
        if (it.getB() < 0 || it.getB() > 255) {
            this.error("Value for blue must be in the range from 0 to 255.", (EStructuralFeature)ProductDefinitionPackage.Literals.COLOR__B);
        }
    }

    @Check
    public void checkMGLs(MGLDescriptor mglDesc) {
        this.checkIfPathExists(mglDesc.getMglPath(), (EObject)mglDesc, (EStructuralFeature)ProductDefinitionPackage.Literals.MGL_DESCRIPTOR__MGL_PATH, "an MGL file");
        this.checkFileExtension(mglDesc.getMglPath(), (EObject)mglDesc, (EStructuralFeature)ProductDefinitionPackage.Literals.MGL_DESCRIPTOR__MGL_PATH, "mgl");
    }

    @Check
    public void checkWindowImages(CincoProduct cpd) {
        this.checkIfPathExists(cpd.getImage16(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__IMAGE16, "the 16x16 icon");
        this.checkIfPathExists(cpd.getImage32(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__IMAGE32, "the 32x32 icon");
        this.checkIfPathExists(cpd.getImage48(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__IMAGE48, "the 48x48 icon");
        this.checkIfPathExists(cpd.getImage64(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__IMAGE64, "the 64x64 icon");
        this.checkIfPathExists(cpd.getImage128(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__IMAGE128, "the 128x128 icon");
        this.checkIfPathExists(cpd.getImage256(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__IMAGE256, "the 256x256 icon");
    }

    @Check
    public void checkAboutImage(About about) {
        this.checkIfPathExists(about.getImagePath(), (EObject)about, (EStructuralFeature)ProductDefinitionPackage.Literals.ABOUT__IMAGE_PATH, "the about screen image");
    }

    @Check
    public void checkSplashImage(SplashScreen splashScreen) {
        this.checkIfPathExists(splashScreen.getPath(), (EObject)splashScreen, (EStructuralFeature)ProductDefinitionPackage.Literals.SPLASH_SCREEN__PATH, "the splash screen image");
        this.checkFileExtension(splashScreen.getPath(), (EObject)splashScreen, (EStructuralFeature)ProductDefinitionPackage.Literals.SPLASH_SCREEN__PATH, "bmp");
    }

    @Check
    public void checkLinuxIcon(CincoProduct cpd) {
        this.checkIfPathExists(cpd.getLinuxIcon(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__LINUX_ICON, "the Linux icon");
        this.checkFileExtension(cpd.getLinuxIcon(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__LINUX_ICON, "xpm");
    }

    @Check
    public void checkMacOSIcon(CincoProduct cpd) {
        this.checkIfPathExists(cpd.getMacOSIcon(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__MAC_OS_ICON, "the macOS icon");
        this.checkFileExtension(cpd.getMacOSIcon(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__MAC_OS_ICON, "icns");
    }

    @Check
    public void checkWindowsIcon(CincoProduct cpd) {
        this.checkIfPathExists(cpd.getWindowsIcon(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__WINDOWS_ICON, "the Windows icon");
        this.checkFileExtension(cpd.getWindowsIcon(), (EObject)cpd, (EStructuralFeature)ProductDefinitionPackage.Literals.CINCO_PRODUCT__WINDOWS_ICON, "ico");
    }

    @Check
    public void checkMGLUniquenesses(CincoProduct cpd) {
        final IProject cpdProject = ProjectCreator.getProject((Resource)cpd.eResource());
        Functions.Function1<MGLDescriptor, MGLPair> _function = new Functions.Function1<MGLDescriptor, MGLPair>(){

            public MGLPair apply(MGLDescriptor mglDesc) {
                String path = PathValidator.getRelativePath((String)mglDesc.getMglPath(), (IProject)cpdProject);
                IFile file = cpdProject.getFile(path);
                MGLModel _content = (MGLModel)CPDValidator.this._fileExtension.getContent(file, MGLModel.class);
                return new MGLPair(mglDesc, _content);
            }
        };
        List mgls = ListExtensions.map((List)cpd.getMgls(), (Functions.Function1)_function);
        Functions.Function1<MGLPair, String> _function_1 = new Functions.Function1<MGLPair, String>(){

            public String apply(MGLPair it) {
                return it.model.getPackage();
            }
        };
        List mglIDs = ListExtensions.map((List)mgls, (Functions.Function1)_function_1);
        for (MGLPair mgl : mgls) {
            boolean _greaterThan;
            int _frequency = Collections.frequency(mglIDs, mgl.model.getPackage());
            boolean bl = _greaterThan = _frequency > 1;
            if (!_greaterThan) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("MGL ID \"");
            String _package = mgl.model.getPackage();
            _builder.append(_package);
            _builder.append("\" is not unique.");
            this.error(_builder.toString(), (EObject)mgl.desc, (EStructuralFeature)ProductDefinitionPackage.Literals.MGL_DESCRIPTOR__MGL_PATH);
        }
        Functions.Function1<MGLPair, EList<GraphModel>> _function_2 = new Functions.Function1<MGLPair, EList<GraphModel>>(){

            public EList<GraphModel> apply(MGLPair mgl) {
                return mgl.model.getGraphModels();
            }
        };
        List allGraphModels = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)mgls, (Functions.Function1)_function_2));
        Functions.Function1<GraphModel, String> _function_3 = new Functions.Function1<GraphModel, String>(){

            public String apply(GraphModel it) {
                return it.getName();
            }
        };
        List allGraphModelNames = ListExtensions.map((List)allGraphModels, (Functions.Function1)_function_3);
        Functions.Function1<GraphModel, String> _function_4 = new Functions.Function1<GraphModel, String>(){

            public String apply(GraphModel it) {
                return it.getFileExtension();
            }
        };
        List allGraphModelFileExtensions = ListExtensions.map((List)allGraphModels, (Functions.Function1)_function_4);
        for (MGLPair mgl_1 : mgls) {
            EList _graphModels = mgl_1.model.getGraphModels();
            for (GraphModel gm : _graphModels) {
                int _frequency_2;
                boolean _greaterThan_2;
                boolean _greaterThan_1;
                int _frequency_1 = Collections.frequency(allGraphModelNames, gm.getName());
                boolean bl = _greaterThan_1 = _frequency_1 > 1;
                if (_greaterThan_1) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Graph model name \"");
                    String _name = gm.getName();
                    _builder_1.append(_name);
                    _builder_1.append("\" is not unique.");
                    this.error(_builder_1.toString(), (EObject)mgl_1.desc, (EStructuralFeature)ProductDefinitionPackage.Literals.MGL_DESCRIPTOR__MGL_PATH);
                }
                boolean bl2 = _greaterThan_2 = (_frequency_2 = Collections.frequency(allGraphModelFileExtensions, gm.getFileExtension())) > 1;
                if (!_greaterThan_2) continue;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("File extension \"");
                String _fileExtension = gm.getFileExtension();
                _builder_2.append(_fileExtension);
                _builder_2.append("\" for graph model \"");
                String _name_1 = gm.getName();
                _builder_2.append(_name_1);
                _builder_2.append("\" is not unique.");
                this.error(_builder_2.toString(), (EObject)mgl_1.desc, (EStructuralFeature)ProductDefinitionPackage.Literals.MGL_DESCRIPTOR__MGL_PATH);
            }
        }
    }

    private void checkIfPathExists(String path, EObject eObj, EStructuralFeature eStructuralFeature, String fileDescription) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)path);
        if (_isNullOrEmpty) {
            return;
        }
        String strippedPath = ContentWriter.stripOffQuotes((String)path);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)strippedPath);
        if (_isNullOrEmpty_1) {
            String _xifexpression = null;
            boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)fileDescription);
            _xifexpression = _isNullOrEmpty_2 ? "the file" : StringExtensions.toFirstLower((String)fileDescription);
            String fileDesc = _xifexpression;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Please enter the path to ");
            _builder.append(fileDesc);
            _builder.append(".");
            this.error(_builder.toString(), eObj, eStructuralFeature);
        } else {
            IProject project = ProjectCreator.getProject((Resource)eObj.eResource());
            if (!project.getFile(strippedPath).exists() && !new File(strippedPath).exists()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("The file \"");
                _builder_1.append(strippedPath);
                _builder_1.append("\" does not exist.");
                this.error(_builder_1.toString(), eObj, eStructuralFeature);
            }
        }
    }

    private void checkFileExtension(String path, EObject eObj, EStructuralFeature eStructuralFeature, String fileExtension) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)path);
        if (_isNullOrEmpty) {
            return;
        }
        String _lowerCase = path.toLowerCase();
        String _stripOffQuotes = null;
        if (_lowerCase != null) {
            _stripOffQuotes = ContentWriter.stripOffQuotes((String)_lowerCase);
        }
        String strippedPath = _stripOffQuotes;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _lowerCase_1 = fileExtension.toLowerCase();
        _builder.append(_lowerCase_1);
        String suffix = _builder.toString();
        if (StringExtensions.isNullOrEmpty((String)strippedPath) || !strippedPath.endsWith(suffix)) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The file must be a ");
            String _upperCase = fileExtension.toUpperCase();
            _builder_1.append(_upperCase);
            _builder_1.append(" file.");
            this.error(_builder_1.toString(), eObj, eStructuralFeature);
        }
    }

    @Data
    private static class MGLPair {
        private final MGLDescriptor desc;
        private final MGLModel model;

        public MGLPair(MGLDescriptor desc, MGLModel model) {
            this.desc = desc;
            this.model = model;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            return 31 * result + (this.model == null ? 0 : this.model.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MGLPair other = (MGLPair)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.model == null ? other.model != null : !this.model.equals(other.model));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("desc", (Object)this.desc);
            b.add("model", (Object)this.model);
            return b.toString();
        }

        @Pure
        public MGLDescriptor getDesc() {
            return this.desc;
        }

        @Pure
        public MGLModel getModel() {
            return this.model;
        }
    }
}

