/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.productdefinition.generator;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ui.templates.DefaultPerspectiveContent;
import de.jabc.cinco.meta.core.utils.BuildProperties;
import de.jabc.cinco.meta.core.utils.BundleRegistry;
import de.jabc.cinco.meta.core.utils.projects.ContentWriter;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.productdefinition.configuration.CincoPluginConfiguration;
import de.jabc.cinco.meta.productdefinition.generator.PluginCustomization;
import de.jabc.cinco.meta.productdefinition.templates.ExtensionTemplate;
import de.jabc.cinco.meta.productdefinition.templates.ParentPOMTemplate;
import de.jabc.cinco.meta.productdefinition.templates.ProductProjectPOMTemplate;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.product.AboutInfo;
import org.eclipse.pde.internal.core.product.ArgumentsInfo;
import org.eclipse.pde.internal.core.product.LauncherInfo;
import org.eclipse.pde.internal.core.product.ProductFeature;
import org.eclipse.pde.internal.core.product.SplashInfo;
import org.eclipse.pde.internal.core.product.WindowImages;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import productDefinition.About;
import productDefinition.CincoProduct;
import productDefinition.Color;
import productDefinition.SplashScreen;

public class CPDGenerator
implements IGenerator {
    @Extension
    private WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    private CincoProduct cpd;
    private IProgressMonitor monitor;
    private IProject mglProject;
    private String id;
    private IProject productProject;
    private IProduct product;
    private BuildProperties bp;
    private Set<String> binIncludes;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        this.cpd = (CincoProduct)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), CincoProduct.class));
        if (this.cpd == null) {
            return;
        }
        NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
        this.monitor = _nullProgressMonitor;
        this.mglProject = ProjectCreator.getProject((Resource)resource);
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getId());
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = this.mglProject.getName();
            _builder.append(_name);
            _builder.append(".product");
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = this.cpd.getId();
        }
        this.id = _xifexpression;
        this.generateProductProject();
        this.generateProductFile();
        this.generateBuildProperties();
        this.setWindowImages();
        this.setLinuxIcon();
        this.setMacOSIcon();
        this.setWindowsIcon();
        this.generateSplashScreen();
        this.generateAbout();
        this.setLauncherArguments();
        this.setBinIncludes();
        this.save(this.product);
        this.generatePluginXML();
        this.generateDefaultPerspective();
        this.mavenizeProduct();
        this.refreshProjects();
    }

    private void generateProductProject() {
        try {
            ArrayList _arrayList = new ArrayList();
            ArrayList _arrayList_1 = new ArrayList();
            HashSet _hashSet = new HashSet();
            ArrayList _arrayList_2 = new ArrayList();
            ArrayList _arrayList_3 = new ArrayList(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.pde.PluginNature"})));
            this.productProject = ProjectCreator.createProject((String)this.id, _arrayList, _arrayList_1, _hashSet, _arrayList_2, _arrayList_3, (IProgressMonitor)this.monitor, (boolean)false);
            this.productProject.open(this.monitor);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void generateProductFile() {
        try {
            StringConcatenation _builder = new StringConcatenation();
            String _name = this.cpd.getName();
            _builder.append(_name);
            _builder.append(".product");
            IFile productFile = ProjectCreator.createFile((String)_builder.toString(), (IContainer)this.productProject, (String)"", (IProgressMonitor)this.monitor);
            WorkspaceProductModel productModel = new WorkspaceProductModel(productFile, true);
            productModel.load();
            this.product = productModel.getProduct();
            this.product.setName(this.cpd.getName());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(this.id);
            _builder_1.append(".id");
            this.product.setId(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(this.id);
            _builder_2.append(".product");
            this.product.setProductId(_builder_2.toString());
            this.product.setApplication("org.eclipse.ui.ide.workbench");
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getVersion());
            _xifexpression = _isNullOrEmpty ? "1.0.0.qualifier" : this.cpd.getVersion();
            this.product.setVersion(_xifexpression);
            LauncherInfo _launcherInfo = new LauncherInfo((IProductModel)productModel);
            this.product.setLauncherInfo((ILauncherInfo)_launcherInfo);
            ILauncherInfo _launcherInfo_1 = this.product.getLauncherInfo();
            _launcherInfo_1.setLauncherName(this.cpd.getName().toLowerCase());
            ArrayList<ProductFeature> features = new ArrayList<ProductFeature>();
            ProductFeature feature = new ProductFeature((IProductModel)productModel);
            StringConcatenation _builder_3 = new StringConcatenation();
            String _projectSymbolicName = ProjectCreator.getProjectSymbolicName((IProject)this.mglProject);
            _builder_3.append(_projectSymbolicName);
            _builder_3.append(".feature");
            feature.setId(_builder_3.toString());
            features.add(feature);
            BundleRegistry.INSTANCE.addBundle(this.id, false, true);
            List<String> _usedFeatures = this.getUsedFeatures();
            for (String featureId : _usedFeatures) {
                ProductFeature _productFeature;
                feature = _productFeature = new ProductFeature((IProductModel)productModel);
                feature.setId(featureId);
                features.add(feature);
            }
            this.product.addFeatures((IProductFeature[])Conversions.unwrapArray(features, IProductFeature.class));
            this.product.setUseFeatures(true);
            CincoPluginConfiguration _newPluginConfiguration = this.newPluginConfiguration("org.apache.felix.scr", 2);
            CincoPluginConfiguration _newPluginConfiguration_1 = this.newPluginConfiguration("org.eclipse.core.runtime", 0);
            CincoPluginConfiguration _newPluginConfiguration_2 = this.newPluginConfiguration("org.eclipse.equinox.common", 2);
            CincoPluginConfiguration _newPluginConfiguration_3 = this.newPluginConfiguration("org.eclipse.equinox.event", 2);
            CincoPluginConfiguration _newPluginConfiguration_4 = this.newPluginConfiguration("org.eclipse.equinox.simpleconfigurator", 1);
            List customPluginConfigurations = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new CincoPluginConfiguration[]{_newPluginConfiguration, _newPluginConfiguration_1, _newPluginConfiguration_2, _newPluginConfiguration_3, _newPluginConfiguration_4}));
            IPluginConfiguration[] _pluginConfigurations = this.product.getPluginConfigurations();
            Iterable _plus = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)_pluginConfigurations)), customPluginConfigurations);
            this.product.addPluginConfigurations((IPluginConfiguration[])Conversions.unwrapArray((Object)_plus, IPluginConfiguration.class));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void generateBuildProperties() {
        try {
            IFile bpFile = this.mglProject.getFile("build.properties");
            this.bp = BuildProperties.loadBuildProperties((IFile)bpFile);
            IFolder srcFolder = this.mglProject.getFolder("src");
            if (srcFolder != null && srcFolder.exists()) {
                this.bp.appendSource("src/");
            }
            this.save(this.bp);
            this.binIncludes = CollectionLiterals.newHashSet();
            IFile productBPFile = this.productProject.getFile("build.properties");
            BuildProperties productBP = BuildProperties.loadBuildProperties((IFile)productBPFile);
            productBP.appendBinIncludes("plugin.xml");
            productBP.deleteEntry("source..");
            String iniFileName = "plugin_customization.ini";
            String iniFileContent = PluginCustomization.customizeProject("org.eclipse.ui.resourcePerspective");
            ProjectCreator.createFile((String)"plugin_customization.ini", (IContainer)this.productProject, (String)iniFileContent, (IProgressMonitor)this.monitor);
            productBP.appendBinIncludes("plugin_customization.ini");
            this.save(productBP);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void generateDefaultPerspective() {
        IFile cpdFile = this._workspaceExtension.getFile((EObject)this.cpd);
        CharSequence perspectiveContent = DefaultPerspectiveContent.generateDefaultPerspective((CincoProduct)this.cpd, (IFile)cpdFile);
        StringConcatenation _builder = new StringConcatenation();
        String _name = cpdFile.getProject().getName();
        _builder.append(_name);
        _builder.append(".perspective");
        String packageName = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_1 = this.cpd.getName();
        _builder_1.append(_name_1);
        _builder_1.append("Perspective.java");
        String fileName = _builder_1.toString();
        ContentWriter.writeJavaFileInSrcGen((IProject)this._workspaceExtension.getProject((EObject)this.cpd), (String)packageName, (String)fileName, (CharSequence)perspectiveContent);
        ProjectCreator.exportPackage((IProject)this._workspaceExtension.getProject((EObject)this.cpd), (String)packageName);
    }

    private void setWindowImages() {
        this.setWindowImage(0, 16, this.cpd.getImage16());
        this.setWindowImage(1, 32, this.cpd.getImage32());
        this.setWindowImage(2, 48, this.cpd.getImage48());
        this.setWindowImage(3, 64, this.cpd.getImage64());
        this.setWindowImage(4, 128, this.cpd.getImage128());
        this.setWindowImage(5, 256, this.cpd.getImage256());
    }

    private void setWindowImage(int index, int size, String imagePath) {
        boolean _not;
        boolean _tripleEquals;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)imagePath);
        if (_isNullOrEmpty) {
            return;
        }
        IWindowImages _windowImages = this.product.getWindowImages();
        boolean bl = _tripleEquals = _windowImages == null;
        if (_tripleEquals) {
            IProductModel _model = this.product.getModel();
            WindowImages _windowImages_1 = new WindowImages(_model);
            this.product.setWindowImages((IWindowImages)_windowImages_1);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("icon_");
        _builder.append((Object)size);
        _builder.append(".png");
        String filePath = this.addFileToMGLProject(imagePath, "icons/branding", _builder.toString(), false);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)filePath);
        boolean bl2 = _not = !_isNullOrEmpty_1;
        if (_not) {
            this.product.getWindowImages().setImagePath(filePath, index);
        }
    }

    private void setLinuxIcon() {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getLinuxIcon());
        if (_isNullOrEmpty) {
            return;
        }
        String filePath = this.addFileToMGLProject(this.cpd.getLinuxIcon(), "icons/branding", "icon_linux.xpm", false);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)filePath);
        boolean bl = _not = !_isNullOrEmpty_1;
        if (_not) {
            this.product.getLauncherInfo().setIconPath("linuxIcon", filePath);
        }
    }

    private void setMacOSIcon() {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getMacOSIcon());
        if (_isNullOrEmpty) {
            return;
        }
        String filePath = this.addFileToMGLProject(this.cpd.getMacOSIcon(), "icons/branding", "icon_macos.icns", false);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)filePath);
        boolean bl = _not = !_isNullOrEmpty_1;
        if (_not) {
            this.product.getLauncherInfo().setIconPath("macosxIcon", filePath);
        }
    }

    private void setWindowsIcon() {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getWindowsIcon());
        if (_isNullOrEmpty) {
            return;
        }
        String filePath = this.addFileToMGLProject(this.cpd.getWindowsIcon(), "icons/branding", "icon_windows.ico", false);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)filePath);
        boolean bl = _not = !_isNullOrEmpty_1;
        if (_not) {
            ILauncherInfo _launcherInfo = this.product.getLauncherInfo();
            _launcherInfo.setUseWinIcoFile(true);
            this.product.getLauncherInfo().setIconPath("icoFile", filePath);
        }
    }

    private void generateSplashScreen() {
        boolean _isAddProgressMessage;
        boolean _isNullOrEmpty;
        SplashScreen splashScreen = this.cpd.getSplashScreen();
        String _path = null;
        if (splashScreen != null) {
            _path = splashScreen.getPath();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_path)) {
            return;
        }
        String filePath = this.addFileToMGLProject(splashScreen.getPath(), null, "splash.bmp", true);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)filePath);
        if (_isNullOrEmpty_1) {
            return;
        }
        IProductModel _model = this.product.getModel();
        SplashInfo splashInfo = new SplashInfo(_model);
        this.product.setSplashInfo((ISplashInfo)splashInfo);
        splashInfo.setLocation(this.mglProject.getName(), true);
        boolean _isAddProgressBar = splashScreen.isAddProgressBar();
        if (_isAddProgressBar) {
            splashInfo.addProgressBar(true, true);
            int _pbXOffset = splashScreen.getPbXOffset();
            int _pbYOffset = splashScreen.getPbYOffset();
            int _pbWidth = splashScreen.getPbWidth();
            int _pbHeight = splashScreen.getPbHeight();
            List geo = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{_pbXOffset, _pbYOffset, _pbWidth, _pbHeight}));
            splashInfo.setProgressGeometry((int[])Conversions.unwrapArray(geo, Integer.TYPE), true);
        }
        if (_isAddProgressMessage = splashScreen.isAddProgressMessage()) {
            boolean _tripleNotEquals;
            splashInfo.addProgressMessage(true, true);
            int _pmXOffset = splashScreen.getPmXOffset();
            int _pmYOffset = splashScreen.getPmYOffset();
            int _pmWidth = splashScreen.getPmWidth();
            int _pmHeight = splashScreen.getPmHeight();
            List geo_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{_pmXOffset, _pmYOffset, _pmWidth, _pmHeight}));
            splashInfo.setMessageGeometry((int[])Conversions.unwrapArray(geo_1, Integer.TYPE), true);
            Color _textColor = splashScreen.getTextColor();
            boolean bl = _tripleNotEquals = _textColor != null;
            if (_tripleNotEquals) {
                String color = this.colorString(splashScreen.getTextColor());
                splashInfo.setForegroundColor(color, true);
            }
        }
    }

    private void generateAbout() {
        boolean _not;
        boolean _tripleEquals;
        About _about = this.cpd.getAbout();
        boolean bl = _tripleEquals = _about == null;
        if (_tripleEquals) {
            return;
        }
        IProductModel _model = this.product.getModel();
        AboutInfo aboutInfo = new AboutInfo(_model);
        this.product.setAboutInfo((IAboutInfo)aboutInfo);
        aboutInfo.setText(this.cpd.getAbout().getAboutText());
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getAbout().getImagePath());
        if (_isNullOrEmpty) {
            return;
        }
        String imagePath = this.addFileToMGLProject(this.cpd.getAbout().getImagePath(), "icons/branding", "about.png", false);
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)imagePath);
        boolean bl2 = _not = !_isNullOrEmpty_1;
        if (_not) {
            aboutInfo.setImagePath(imagePath);
        }
    }

    private void setLauncherArguments() {
        IProductModel _model = this.product.getModel();
        ArgumentsInfo arguments = new ArgumentsInfo(_model);
        this.product.setLauncherArguments((IArgumentsInfo)arguments);
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.cpd.getDefaultPerspective());
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("-perspective ");
            String _name = this.mglProject.getName();
            _builder.append(_name);
            _builder.append(".");
            String _lowerCase = this.cpd.getName().toLowerCase();
            _builder.append(_lowerCase);
            _builder.append("perspective");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("-perspective ");
            String _defaultPerspective = this.cpd.getDefaultPerspective();
            _builder_1.append(_defaultPerspective);
            _xifexpression = _builder_1.toString();
        }
        String defaultPerspective = _xifexpression;
        arguments.setProgramArguments(defaultPerspective, 0);
        String vmArguments = "-Xms40m -Xmx3072m -XX:+CMSClassUnloadingEnabled -XX:+UseConcMarkSweepGC -Dfile.encoding=UTF-8";
        String programArgumentsLinux = "--launcher.GTK_version 3";
        boolean linux = true;
        String _vMArguments = arguments.getVMArguments(0);
        String _plus = String.valueOf(_vMArguments) + "-Xms40m -Xmx3072m -XX:+CMSClassUnloadingEnabled -XX:+UseConcMarkSweepGC -Dfile.encoding=UTF-8";
        arguments.setVMArguments(_plus, 0);
        String _programArguments = arguments.getProgramArguments(1);
        String _plus_1 = String.valueOf(_programArguments) + "--launcher.GTK_version 3";
        arguments.setProgramArguments(_plus_1, 1);
    }

    private void setBinIncludes() {
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String binInclude) {
                CPDGenerator.this.bp.appendBinIncludes(binInclude);
            }
        };
        this.binIncludes.forEach(_function);
        this.save(this.bp);
    }

    private void generatePluginXML() {
        boolean _isNullOrEmpty_5;
        boolean _not_5;
        boolean _isNullOrEmpty_4;
        boolean _not_4;
        boolean _isNullOrEmpty_3;
        boolean _not_3;
        boolean _isNullOrEmpty_2;
        boolean _not_2;
        boolean _isNullOrEmpty_1;
        boolean _not_1;
        boolean _not;
        Functions.Function1<Integer, String> _function = new Functions.Function1<Integer, String>(){

            public String apply(Integer i) {
                IWindowImages _windowImages = CPDGenerator.this.product.getWindowImages();
                String _imagePath = null;
                if (_windowImages != null) {
                    _imagePath = _windowImages.getImagePath(i.intValue());
                }
                return _imagePath;
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return StringExtensions.isNullOrEmpty((String)it);
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String wi) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("platform:/plugin");
                _builder.append(wi);
                return _builder.toString();
            }
        };
        String windowImages = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.reject((Iterable)IterableExtensions.map((Iterable)new IntegerRange(0, 5), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (CharSequence)",");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<?eclipse version=\"3.4\"?>");
        _builder.newLine();
        _builder.append("<plugin>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"product\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"org.eclipse.core.runtime.products\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<product");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("application=\"org.eclipse.ui.ide.workbench\"");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("name=\"");
        String _name = this.cpd.getName();
        _builder.append(_name, "\t\t\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("<property");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("name=\"appName\"");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("value=\"");
        String _name_1 = this.cpd.getName();
        _builder.append(_name_1, "\t\t\t\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("</property>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<property");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("name=\"preferenceCustomization\"");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("value=\"plugin_customization.ini\">");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("</property>");
        _builder.newLine();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)windowImages);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t\t\t");
            _builder.append("<property");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("name=\"windowImages\"");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("value=\"");
            _builder.append(windowImages, "\t\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</property>");
            _builder.newLine();
        }
        IAboutInfo _aboutInfo = this.product.getAboutInfo();
        String _imagePath = null;
        if (_aboutInfo != null) {
            _imagePath = _aboutInfo.getImagePath();
        }
        boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(_imagePath));
        if (_not_1) {
            _builder.append("\t\t\t");
            _builder.append("<property");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("name=\"aboutImage\"");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("value=\"platform:/plugin");
            String _imagePath_1 = this.product.getAboutInfo().getImagePath();
            _builder.append(_imagePath_1, "\t\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</property>");
            _builder.newLine();
        }
        IAboutInfo _aboutInfo_1 = this.product.getAboutInfo();
        String _text = null;
        if (_aboutInfo_1 != null) {
            _text = _aboutInfo_1.getText();
        }
        boolean bl3 = _not_2 = !(_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(_text));
        if (_not_2) {
            _builder.append("\t\t\t");
            _builder.append("<property");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("name=\"aboutText\"");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("value=\"");
            String _text_1 = this.product.getAboutInfo().getText();
            _builder.append(_text_1, "\t\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</property>");
            _builder.newLine();
        }
        ISplashInfo _splashInfo = this.product.getSplashInfo();
        String _foregroundColor = null;
        if (_splashInfo != null) {
            _foregroundColor = _splashInfo.getForegroundColor();
        }
        boolean bl4 = _not_3 = !(_isNullOrEmpty_3 = StringExtensions.isNullOrEmpty(_foregroundColor));
        if (_not_3) {
            _builder.append("\t\t\t");
            _builder.append("<property");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("name=\"startupForegroundColor\"");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("value=\"");
            String _foregroundColor_1 = this.product.getSplashInfo().getForegroundColor();
            _builder.append(_foregroundColor_1, "\t\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</property>");
            _builder.newLine();
        }
        ISplashInfo _splashInfo_1 = this.product.getSplashInfo();
        int[] _messageGeometry = null;
        if (_splashInfo_1 != null) {
            _messageGeometry = _splashInfo_1.getMessageGeometry();
        }
        boolean bl5 = _not_4 = !(_isNullOrEmpty_4 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray(_messageGeometry))));
        if (_not_4) {
            _builder.append("\t\t\t");
            _builder.append("<property");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("name=\"startupMessageRect\"");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("value=\"");
            String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)this.product.getSplashInfo().getMessageGeometry())), (CharSequence)",");
            _builder.append(_join, "\t\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</property>");
            _builder.newLine();
        }
        ISplashInfo _splashInfo_2 = this.product.getSplashInfo();
        int[] _progressGeometry = null;
        if (_splashInfo_2 != null) {
            _progressGeometry = _splashInfo_2.getProgressGeometry();
        }
        boolean bl6 = _not_5 = !(_isNullOrEmpty_5 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray(_progressGeometry))));
        if (_not_5) {
            _builder.append("\t\t\t");
            _builder.append("<property");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("name=\"startupProgressRect\"");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("value=\"");
            String _join_1 = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)this.product.getSplashInfo().getProgressGeometry())), (CharSequence)",");
            _builder.append(_join_1, "\t\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</property>");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("</product>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</extension>");
        _builder.newLine();
        _builder.append("</plugin>");
        _builder.newLine();
        String content = _builder.toString();
        ProjectCreator.createFile((String)"plugin.xml", (IContainer)this.productProject, (String)content.toString(), (IProgressMonitor)this.monitor);
    }

    private void mavenizeProduct() {
        try {
            String mvnPath;
            String pathSeparator;
            File workspaceDirectory;
            block7: {
                String productPOMContent = ProductProjectPOMTemplate.content(this.cpd, this.mglProject.getName()).toString();
                StringInputStream productPOMContentStream = new StringInputStream(productPOMContent);
                IFile productPOMFile = this.productProject.getFile("pom.xml");
                boolean _exists = productPOMFile.exists();
                if (_exists) {
                    productPOMFile.setContents((InputStream)productPOMContentStream, false, false, this.monitor);
                } else {
                    productPOMFile.create((InputStream)productPOMContentStream, false, this.monitor);
                }
                workspaceDirectory = this.productProject.getWorkspace().getRoot().getLocation().toFile();
                pathSeparator = System.getProperty("file.separator");
                StringConcatenation _builder = new StringConcatenation();
                String _absolutePath = workspaceDirectory.getAbsolutePath();
                _builder.append(_absolutePath);
                _builder.append(pathSeparator);
                _builder.append(".mvn");
                _builder.append(pathSeparator);
                mvnPath = _builder.toString();
                try {
                    new File(mvnPath).mkdirs();
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) break block7;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(mvnPath);
            _builder_1.append("extensions.xml");
            String extensionsPath = _builder_1.toString();
            File extensionsFile = new File(extensionsPath);
            boolean _createNewFile = extensionsFile.createNewFile();
            if (_createNewFile) {
                CharSequence extensionsContent = ExtensionTemplate.content();
                FileUtils.write((File)extensionsFile, (CharSequence)extensionsContent, (Charset)StandardCharsets.UTF_8);
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            String _absolutePath_1 = workspaceDirectory.getAbsolutePath();
            _builder_2.append(_absolutePath_1);
            _builder_2.append(pathSeparator);
            _builder_2.append("pom.xml");
            String parentPOMPath = _builder_2.toString();
            File parentPOMFile = new File(parentPOMPath);
            parentPOMFile.createNewFile();
            CharSequence parentPOMContent = ParentPOMTemplate.content(this.cpd, this.mglProject.getName());
            FileUtils.write((File)parentPOMFile, (CharSequence)parentPOMContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void refreshProjects() {
        try {
            this.mglProject.refreshLocal(2, this.monitor);
            this.productProject.refreshLocal(2, this.monitor);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void save(IProduct iProduct) {
        IProductModel _model = iProduct.getModel();
        ((WorkspaceProductModel)_model).save();
    }

    private void save(BuildProperties buildProperties) {
        try {
            buildProperties.store(buildProperties.getFile(), this.monitor);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String colorString(Color color) {
        return String.format("%02X%02X%02X", color.getR(), color.getG(), color.getB()).toUpperCase();
    }

    private String addFileToMGLProject(String sourceFilePath_, String targetFolderPath_, String targetFileName_, boolean forceCopy) {
        String sourceFilePathString = ContentWriter.stripOffQuotes((String)sourceFilePath_);
        String _elvis = null;
        String _stripOffQuotes = ContentWriter.stripOffQuotes((String)targetFolderPath_);
        _elvis = _stripOffQuotes != null ? _stripOffQuotes : "";
        String targetFolderPathString = _elvis;
        String targetFileName = ContentWriter.stripOffQuotes((String)targetFileName_);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)sourceFilePathString);
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            String _simpleName = this.getClass().getSimpleName();
            _builder.append(_simpleName);
            _builder.append(".addFileToMGLProject(...): sourceFilePathString is null or empty");
            System.err.println(_builder);
            return null;
        }
        File externalSourceFile = new File(sourceFilePathString);
        IFile _xtrycatchfinallyexpression = null;
        try {
            IFile _file;
            _xtrycatchfinallyexpression = _file = this.mglProject.getFile(sourceFilePathString);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e = (IllegalArgumentException)_t;
                StringConcatenation _builder_1 = new StringConcatenation();
                String _simpleName_1 = this.getClass().getSimpleName();
                _builder_1.append(_simpleName_1);
                _builder_1.append(".addFileToMGLProject(...): Cannot check file ");
                _builder_1.append(sourceFilePathString);
                System.err.println(_builder_1);
                e.printStackTrace();
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        IFile internalSourceFile = _xtrycatchfinallyexpression;
        File sourceFile = null;
        boolean copy = false;
        boolean _exists = internalSourceFile.exists();
        if (_exists) {
            sourceFile = internalSourceFile.getLocation().toFile();
            copy = forceCopy;
        } else {
            boolean _exists_1 = externalSourceFile.exists();
            if (_exists_1) {
                sourceFile = externalSourceFile;
                copy = true;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _simpleName_1 = this.getClass().getSimpleName();
                _builder_1.append(_simpleName_1);
                _builder_1.append(".addFileToMGLProject(...): Cannot find file ");
                _builder_1.append(sourceFilePathString);
                System.err.println(_builder_1);
                return null;
            }
        }
        IPath targetFilePath = null;
        if (copy) {
            IPath targetFolderPath = this.mglProject.getLocation().append(targetFolderPathString);
            File targetFolder = targetFolderPath.toFile();
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                StringConcatenation _builder_2 = new StringConcatenation();
                String _simpleName_2 = this.getClass().getSimpleName();
                _builder_2.append(_simpleName_2);
                _builder_2.append(".copyFile(...): Cannot create target folder ");
                _builder_2.append(targetFolderPathString);
                System.err.println(_builder_2);
                return null;
            }
            String _xifexpression = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)targetFileName);
            _xifexpression = _isNullOrEmpty_1 ? sourceFile.getName() : targetFileName;
            targetFileName = _xifexpression;
            targetFilePath = targetFolderPath.append(targetFileName);
            File targetFile = targetFilePath.toFile();
            try {
                FileChannel sourceChannel = new FileInputStream(sourceFile).getChannel();
                FileChannel targetChannel = new FileOutputStream(targetFile).getChannel();
                targetChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    StringConcatenation _builder_3 = new StringConcatenation();
                    String _simpleName_3 = this.getClass().getSimpleName();
                    _builder_3.append(_simpleName_3);
                    _builder_3.append(".copyFile(...): Cannot copy file ");
                    _builder_3.append(sourceFilePathString);
                    _builder_3.append(" to ");
                    _builder_3.append(targetFolderPathString);
                    System.err.println(_builder_3);
                    e.printStackTrace();
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            targetFilePath = targetFilePath.makeRelativeTo(this.mglProject.getWorkspace().getRoot().getLocation()).makeAbsolute();
        } else {
            targetFilePath = internalSourceFile.getFullPath();
        }
        String targetFilePathString = null;
        boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)targetFolderPathString);
        targetFilePathString = _isNullOrEmpty_2 ? targetFileName : targetFilePath.removeFirstSegments(1).removeLastSegments(1).addTrailingSeparator().toPortableString();
        this.binIncludes.add(targetFilePathString);
        return targetFilePath.toPortableString();
    }

    private CincoPluginConfiguration newPluginConfiguration(String id, int startLevel) {
        IProductModel _model = this.product.getModel();
        CincoPluginConfiguration config = new CincoPluginConfiguration(_model);
        config.setId(id);
        config.setAutoStart(true);
        config.setStartLevel(startLevel);
        return config;
    }

    private List<String> getUsedFeatures() {
        List defaultFeatures = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.e4.rcp", "org.eclipse.e4.rcp.source", "org.eclipse.ecf.core.feature", "org.eclipse.ecf.core.feature.source", "org.eclipse.ecf.core.ssl.feature", "org.eclipse.ecf.core.ssl.feature.source", "org.eclipse.ecf.filetransfer.feature", "org.eclipse.ecf.filetransfer.feature.source", "org.eclipse.ecf.filetransfer.httpclient45.feature", "org.eclipse.ecf.filetransfer.httpclient45.feature.source", "org.eclipse.ecf.filetransfer.ssl.feature", "org.eclipse.ecf.filetransfer.ssl.feature.source", "org.eclipse.egit", "org.eclipse.emf", "org.eclipse.emf.codegen", "org.eclipse.emf.codegen.ecore", "org.eclipse.emf.codegen.ecore.source", "org.eclipse.emf.codegen.ecore.ui", "org.eclipse.emf.codegen.ecore.ui.source", "org.eclipse.emf.codegen.source", "org.eclipse.emf.codegen.ui", "org.eclipse.emf.codegen.ui.source", "org.eclipse.emf.common", "org.eclipse.emf.common.source", "org.eclipse.emf.common.ui", "org.eclipse.emf.common.ui.source", "org.eclipse.emf.converter", "org.eclipse.emf.converter.source", "org.eclipse.emf.databinding", "org.eclipse.emf.databinding.edit", "org.eclipse.emf.databinding.edit.source", "org.eclipse.emf.databinding.source", "org.eclipse.emf.doc", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.edit", "org.eclipse.emf.ecore.edit.source", "org.eclipse.emf.ecore.editor", "org.eclipse.emf.ecore.editor.source", "org.eclipse.emf.ecore.source", "org.eclipse.emf.edit", "org.eclipse.emf.edit.source", "org.eclipse.emf.edit.ui", "org.eclipse.emf.edit.ui.source", "org.eclipse.emf.mapping", "org.eclipse.emf.mapping.ecore", "org.eclipse.emf.mapping.ecore.editor", "org.eclipse.emf.mapping.ecore.editor.source", "org.eclipse.emf.mapping.ecore.source", "org.eclipse.emf.mapping.source", "org.eclipse.emf.mapping.ui", "org.eclipse.emf.mapping.ui.source", "org.eclipse.emf.mwe2.language.sdk", "org.eclipse.emf.mwe2.launcher", "org.eclipse.emf.mwe2.launcher.source", "org.eclipse.emf.mwe2.runtime.sdk", "org.eclipse.emf.sdk", "org.eclipse.emf.source", "org.eclipse.equinox.p2.core.feature", "org.eclipse.equinox.p2.core.feature.source", "org.eclipse.equinox.p2.extras.feature", "org.eclipse.equinox.p2.extras.feature.source", "org.eclipse.equinox.p2.rcp.feature", "org.eclipse.equinox.p2.rcp.feature.source", "org.eclipse.equinox.p2.user.ui", "org.eclipse.equinox.p2.user.ui.source", "org.eclipse.graphiti.feature", "org.eclipse.graphiti.feature.examples", "org.eclipse.graphiti.feature.examples.source", "org.eclipse.graphiti.feature.tools", "org.eclipse.graphiti.feature.tools.source", "org.eclipse.graphiti.sdk.feature", "org.eclipse.help", "org.eclipse.help.source", "org.eclipse.jdt", "org.eclipse.jdt.source", "org.eclipse.jgit", "org.eclipse.jgit.gpg.bc", "org.eclipse.jgit.http.apache", "org.eclipse.jgit.ssh.apache", "org.eclipse.jgit.ssh.jsch", "org.eclipse.pde", "org.eclipse.pde.source", "org.eclipse.platform", "org.eclipse.platform.source", "org.eclipse.rcp", "org.eclipse.rcp.source", "org.eclipse.sdk", "org.eclipse.xtend.sdk", "org.eclipse.xtext.docs", "org.eclipse.xtext.examples", "org.eclipse.xtext.redist", "org.eclipse.xtext.runtime", "org.eclipse.xtext.sdk", "org.eclipse.xtext.ui", "org.eclipse.xtext.xbase", "org.eclipse.xtext.xbase.lib", "org.eclipse.xtext.xtext.ui", "org.eclipse.xtext.xtext.ui.graph"}));
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return ContentWriter.stripOffQuotes((String)it);
            }
        };
        List productFeatures = ListExtensions.map((List)this.cpd.getFeatures(), (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)Iterables.concat(defaultFeatures, (Iterable)productFeatures));
    }
}

