/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.runtime.xapi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.xapi.FileExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class WorkbenchExtension
extends de.jabc.cinco.meta.util.xapi.WorkbenchExtension {
    public Diagram getActiveDiagram() {
        DiagramEditor _activeDiagramEditor = this.getActiveDiagramEditor();
        Diagram _diagram = null;
        if (_activeDiagramEditor != null) {
            _diagram = this.getDiagram(_activeDiagramEditor);
        }
        return _diagram;
    }

    public GraphModel getActiveGraphModel() {
        IEditorPart _activeEditor = this.getActiveEditor();
        GraphModel _graphModel = null;
        if (_activeEditor != null) {
            _graphModel = this.getGraphModel(_activeEditor);
        }
        return _graphModel;
    }

    public DiagramEditor getActiveDiagramEditor() {
        IEditorPart _activeEditor = this.getActiveEditor();
        DiagramEditor _diagramEditor = null;
        if (_activeEditor != null) {
            _diagramEditor = this.getDiagramEditor(_activeEditor);
        }
        return _diagramEditor;
    }

    public DiagramEditor getDiagramEditor(final Predicate<DiagramEditor> predicate) {
        IWorkbenchPage _activePage = this.getActivePage();
        IEditorReference[] _editorReferences = null;
        if (_activePage != null) {
            _editorReferences = _activePage.getEditorReferences();
        }
        List _map = null;
        if ((List)Conversions.doWrapArray((Object)_editorReferences) != null) {
            Functions.Function1<IEditorReference, DiagramEditor> _function = new Functions.Function1<IEditorReference, DiagramEditor>(){

                public DiagramEditor apply(IEditorReference it) {
                    IEditorPart _editor = it.getEditor(true);
                    DiagramEditor _diagramEditor = null;
                    if (_editor != null) {
                        _diagramEditor = WorkbenchExtension.this.getDiagramEditor(_editor);
                    }
                    return _diagramEditor;
                }
            };
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_editorReferences)), (Functions.Function1)_function);
        }
        Iterable _filterNull = null;
        if (_map != null) {
            _filterNull = IterableExtensions.filterNull(_map);
        }
        DiagramEditor _findFirst = null;
        if (_filterNull != null) {
            Functions.Function1<DiagramEditor, Boolean> _function_1 = new Functions.Function1<DiagramEditor, Boolean>(){

                public Boolean apply(DiagramEditor it) {
                    return predicate.test(it);
                }
            };
            _findFirst = (DiagramEditor)IterableExtensions.findFirst((Iterable)_filterNull, (Functions.Function1)_function_1);
        }
        return _findFirst;
    }

    public DiagramEditor getDiagramEditor(IEditorPart editor) {
        DiagramEditor _switchResult = null;
        boolean _matched = false;
        if (editor instanceof MultiPageEditorPart) {
            Object _selectedPage;
            _matched = true;
            DiagramEditor _switchResult_1 = null;
            Object it = _selectedPage = ((MultiPageEditorPart)editor).getSelectedPage();
            boolean _matched_1 = false;
            if (it instanceof DiagramEditor) {
                _matched_1 = true;
                _switchResult_1 = (DiagramEditor)it;
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && editor instanceof DiagramEditor) {
            _matched = true;
            _switchResult = (DiagramEditor)editor;
        }
        return _switchResult;
    }

    public DiagramEditor getEditor(final Diagram diagram) {
        Predicate<DiagramEditor> _function = new Predicate<DiagramEditor>(){

            @Override
            public boolean test(DiagramEditor editor) {
                Diagram _diagram = WorkbenchExtension.this.getDiagram(editor);
                return Objects.equal((Object)_diagram, (Object)diagram);
            }
        };
        return this.getDiagramEditor(_function);
    }

    public DiagramEditor getEditor(final PictogramElement pictogramElement) {
        Predicate<DiagramEditor> _function = new Predicate<DiagramEditor>(){

            @Override
            public boolean test(DiagramEditor it) {
                Resource _resource = WorkbenchExtension.this.getResource((IEditorPart)it);
                Resource _eResource = pictogramElement.eResource();
                return Objects.equal((Object)_resource, (Object)_eResource);
            }
        };
        return this.getDiagramEditor(_function);
    }

    public DiagramEditor getEditor(final IdentifiableElement modelElement) {
        Predicate<DiagramEditor> _function = new Predicate<DiagramEditor>(){

            @Override
            public boolean test(DiagramEditor it) {
                Resource _resource = WorkbenchExtension.this.getResource((IEditorPart)it);
                Resource _eResource = modelElement.eResource();
                return Objects.equal((Object)_resource, (Object)_eResource);
            }
        };
        return this.getDiagramEditor(_function);
    }

    public Diagram getDiagram(PictogramElement pictogramElement) {
        Diagram _xtrycatchfinallyexpression = null;
        try {
            EObject _rootContainer = EcoreUtil.getRootContainer((EObject)pictogramElement);
            _xtrycatchfinallyexpression = (Diagram)_rootContainer;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public Diagram getDiagram(IdentifiableElement modelElement) {
        Diagram _xblockexpression = null;
        ResourceExtension ext = new ResourceExtension();
        Resource _eResource = modelElement.eResource();
        Diagram _diagram = null;
        if (_eResource != null) {
            _diagram = ext.getDiagram(_eResource);
        }
        _xblockexpression = _diagram;
        return _xblockexpression;
    }

    public DiagramBehavior getDiagramBehavior(Diagram diagram) {
        DiagramEditor _editor = this.getEditor(diagram);
        DiagramBehavior _diagramBehavior = null;
        if (_editor != null) {
            _diagramBehavior = _editor.getDiagramBehavior();
        }
        return _diagramBehavior;
    }

    public DiagramBehavior getDiagramBehavior(PictogramElement pictogramElement) {
        DiagramEditor _editor = this.getEditor(pictogramElement);
        DiagramBehavior _diagramBehavior = null;
        if (_editor != null) {
            _diagramBehavior = _editor.getDiagramBehavior();
        }
        return _diagramBehavior;
    }

    public IDiagramTypeProvider getDiagramTypeProvider(DiagramEditor editor) {
        IDiagramTypeProvider _diagramTypeProvider = null;
        if (editor != null) {
            _diagramTypeProvider = editor.getDiagramTypeProvider();
        }
        return _diagramTypeProvider;
    }

    public IDiagramTypeProvider getDiagramTypeProvider(Diagram diagram) {
        DiagramEditor _editor = this.getEditor(diagram);
        IDiagramTypeProvider _diagramTypeProvider = null;
        if (_editor != null) {
            _diagramTypeProvider = _editor.getDiagramTypeProvider();
        }
        return _diagramTypeProvider;
    }

    public IDiagramTypeProvider getDiagramTypeProvider(PictogramElement pictogramElement) {
        Diagram _diagram = this.getDiagram(pictogramElement);
        IDiagramTypeProvider _diagramTypeProvider = null;
        if (_diagram != null) {
            _diagramTypeProvider = this.getDiagramTypeProvider(_diagram);
        }
        return _diagramTypeProvider;
    }

    public IFeatureProvider getFeatureProvider(DiagramEditor editor) {
        IDiagramTypeProvider _diagramTypeProvider = editor.getDiagramTypeProvider();
        IFeatureProvider _featureProvider = null;
        if (_diagramTypeProvider != null) {
            _featureProvider = _diagramTypeProvider.getFeatureProvider();
        }
        return _featureProvider;
    }

    public IFeatureProvider getFeatureProvider(Diagram diagram) {
        IDiagramTypeProvider _diagramTypeProvider = this.getDiagramTypeProvider(diagram);
        IFeatureProvider _featureProvider = null;
        if (_diagramTypeProvider != null) {
            _featureProvider = _diagramTypeProvider.getFeatureProvider();
        }
        return _featureProvider;
    }

    public IFeatureProvider getFeatureProvider(PictogramElement pictogramElement) {
        IDiagramTypeProvider _diagramTypeProvider = this.getDiagramTypeProvider(pictogramElement);
        IFeatureProvider _featureProvider = null;
        if (_diagramTypeProvider != null) {
            _featureProvider = _diagramTypeProvider.getFeatureProvider();
        }
        return _featureProvider;
    }

    public Object getBusinessObject(PictogramElement pictogramElement) {
        Object _elvis = null;
        IFeatureProvider _featureProvider = this.getFeatureProvider(pictogramElement);
        Object _businessObjectForPictogramElement = null;
        if (_featureProvider != null) {
            _businessObjectForPictogramElement = _featureProvider.getBusinessObjectForPictogramElement(pictogramElement);
        }
        if (_businessObjectForPictogramElement != null) {
            _elvis = _businessObjectForPictogramElement;
        } else {
            EObject _businessObjectForLinkedPictogramElement = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pictogramElement);
            _elvis = _businessObjectForLinkedPictogramElement;
        }
        return _elvis;
    }

    public PictogramElement getPictogramElement(final IdentifiableElement element) {
        PictogramElement _xblockexpression = null;
        ResourceExtension ResourceExtension2 = new ResourceExtension();
        Resource _eResource = element.getInternalElement_().eResource();
        Diagram _diagram = null;
        if (_eResource != null) {
            _diagram = ResourceExtension2.getDiagram(_eResource);
        }
        EList _pictogramLinks = null;
        if (_diagram != null) {
            _pictogramLinks = _diagram.getPictogramLinks();
        }
        Iterable _filter = null;
        if (_pictogramLinks != null) {
            Functions.Function1<PictogramLink, Boolean> _function = new Functions.Function1<PictogramLink, Boolean>(){

                public Boolean apply(PictogramLink it) {
                    Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                        public Boolean apply(EObject it) {
                            return EcoreUtil.equals((EObject)it, (EObject)element);
                        }
                    };
                    return IterableExtensions.exists((Iterable)it.getBusinessObjects(), (Functions.Function1)_function);
                }
            };
            _filter = IterableExtensions.filter((Iterable)_pictogramLinks, (Functions.Function1)_function);
        }
        Iterable _map = null;
        if (_filter != null) {
            Functions.Function1<PictogramLink, PictogramElement> _function_1 = new Functions.Function1<PictogramLink, PictogramElement>(){

                public PictogramElement apply(PictogramLink it) {
                    return it.getPictogramElement();
                }
            };
            _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        }
        PictogramElement _findFirst = null;
        if (_map != null) {
            Functions.Function1<PictogramElement, Boolean> _function_2 = new Functions.Function1<PictogramElement, Boolean>(){

                public Boolean apply(PictogramElement it) {
                    return it != null;
                }
            };
            _findFirst = (PictogramElement)IterableExtensions.findFirst((Iterable)_map, (Functions.Function1)_function_2);
        }
        _xblockexpression = _findFirst;
        return _xblockexpression;
    }

    public boolean testBusinessObjectType(PictogramElement pe, Class<?> cls) {
        Object bo = this.getBusinessObject(pe);
        if (bo == null) {
            return false;
        }
        boolean test = cls.isAssignableFrom(bo.getClass());
        if (!test && bo instanceof InternalIdentifiableElement) {
            test = cls.isAssignableFrom(((InternalIdentifiableElement)bo).getElement().getClass());
        }
        return test;
    }

    public Diagram getDiagram(DiagramEditor editor) {
        IDiagramTypeProvider _diagramTypeProvider = editor.getDiagramTypeProvider();
        Diagram _diagram = null;
        if (_diagramTypeProvider != null) {
            _diagram = _diagramTypeProvider.getDiagram();
        }
        return _diagram;
    }

    public Diagram getDiagram(IEditorPart editor) {
        Diagram _xblockexpression = null;
        ResourceExtension ext = new ResourceExtension();
        Resource _resource = null;
        if (editor != null) {
            _resource = this.getResource(editor);
        }
        Diagram _diagram = null;
        if (_resource != null) {
            _diagram = ext.getDiagram(_resource);
        }
        _xblockexpression = _diagram;
        return _xblockexpression;
    }

    public Iterable<ModelElement> getSelectedModelElements(GraphModel model) {
        Iterable<Object> _elvis = null;
        Diagram _diagram = null;
        if (model != null) {
            _diagram = this.getDiagram((IdentifiableElement)model);
        }
        List<PictogramElement> _selectedPictogramElements = null;
        if (_diagram != null) {
            _selectedPictogramElements = this.getSelectedPictogramElements(_diagram);
        }
        List _map = null;
        if (_selectedPictogramElements != null) {
            Functions.Function1<PictogramElement, Object> _function = new Functions.Function1<PictogramElement, Object>(){

                public Object apply(PictogramElement it) {
                    return WorkbenchExtension.this.getBusinessObject(it);
                }
            };
            _map = ListExtensions.map(_selectedPictogramElements, (Functions.Function1)_function);
        }
        Iterable _filter = null;
        if (_map != null) {
            _filter = Iterables.filter(_map, InternalModelElement.class);
        }
        Iterable<Object> _map_1 = null;
        if (_filter != null) {
            Functions.Function1<InternalModelElement, ModelElement> _function_1 = new Functions.Function1<InternalModelElement, ModelElement>(){

                public ModelElement apply(InternalModelElement it) {
                    return it.getElement();
                }
            };
            _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        }
        _elvis = _map_1 != null ? _map_1 : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        return _elvis;
    }

    public List<PictogramElement> getSelectedPictogramElements(Diagram diagram) {
        List<PictogramElement> _elvis = null;
        DiagramBehavior _diagramBehavior = null;
        if (diagram != null) {
            _diagramBehavior = this.getDiagramBehavior(diagram);
        }
        PictogramElement[] _selectedPictogramElements = null;
        if (_diagramBehavior != null) {
            _selectedPictogramElements = _diagramBehavior.getSelectedPictogramElements();
        }
        List<PictogramElement> _list = null;
        if ((Iterable)Conversions.doWrapArray((Object)_selectedPictogramElements) != null) {
            _list = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)_selectedPictogramElements)));
        }
        _elvis = _list != null ? _list : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        return _elvis;
    }

    public boolean isSelected(final ModelElement element) {
        GraphModel _rootElement = null;
        if (element != null) {
            _rootElement = element.getRootElement();
        }
        Iterable<ModelElement> _selectedModelElements = null;
        if (_rootElement != null) {
            _selectedModelElements = this.getSelectedModelElements(_rootElement);
        }
        boolean _exists = false;
        if (_selectedModelElements != null) {
            Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                public Boolean apply(ModelElement it) {
                    return Objects.equal((Object)it, (Object)element);
                }
            };
            _exists = IterableExtensions.exists(_selectedModelElements, (Functions.Function1)_function);
        }
        return _exists;
    }

    public boolean isSelected(PictogramElement element) {
        Diagram _diagram = null;
        if (element != null) {
            _diagram = this.getDiagram(element);
        }
        List<PictogramElement> _selectedPictogramElements = null;
        if (_diagram != null) {
            _selectedPictogramElements = this.getSelectedPictogramElements(_diagram);
        }
        boolean _contains = false;
        if (_selectedPictogramElements != null) {
            _contains = _selectedPictogramElements.contains(element);
        }
        return _contains;
    }

    public void select(ModelElement element) {
        Diagram _diagram = this.getDiagram((IdentifiableElement)element);
        if (_diagram != null) {
            PictogramElement _pictogramElement = this.getPictogramElement((IdentifiableElement)element);
            this.select(_diagram, new PictogramElement[]{_pictogramElement});
        }
    }

    public void select(PictogramElement pe) {
        Diagram _diagram = this.getDiagram(pe);
        if (_diagram != null) {
            this.select(_diagram, new PictogramElement[]{pe});
        }
    }

    public void select(GraphModel model, ModelElement[] elements) {
        Diagram _diagram = this.getDiagram((IdentifiableElement)model);
        if (_diagram != null) {
            List _map = null;
            if ((List)Conversions.doWrapArray((Object)elements) != null) {
                Functions.Function1<ModelElement, PictogramElement> _function = new Functions.Function1<ModelElement, PictogramElement>(){

                    public PictogramElement apply(ModelElement it) {
                        return WorkbenchExtension.this.getPictogramElement((IdentifiableElement)it);
                    }
                };
                _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)elements)), (Functions.Function1)_function);
            }
            this.select(_diagram, (PictogramElement[])Conversions.unwrapArray(_map, PictogramElement.class));
        }
    }

    public void select(Diagram diagram, PictogramElement[] pes) {
        DiagramBehavior _diagramBehavior = this.getDiagramBehavior(diagram);
        IDiagramContainerUI _diagramContainer = null;
        if (_diagramBehavior != null) {
            _diagramContainer = _diagramBehavior.getDiagramContainer();
        }
        if (_diagramContainer != null) {
            _diagramContainer.selectPictogramElements(pes);
        }
    }

    public void unselect(ModelElement element) {
        PictogramElement _pictogramElement = this.getPictogramElement((IdentifiableElement)element);
        if (_pictogramElement != null) {
            this.unselect(_pictogramElement);
        }
    }

    public void unselect(PictogramElement pe) {
        Diagram _diagram = this.getDiagram(pe);
        if (_diagram != null) {
            this.unselect(_diagram, new PictogramElement[]{pe});
        }
    }

    public void unselect(GraphModel model, ModelElement[] elements) {
        Diagram _diagram = this.getDiagram((IdentifiableElement)model);
        if (_diagram != null) {
            List _map = null;
            if ((List)Conversions.doWrapArray((Object)elements) != null) {
                Functions.Function1<ModelElement, PictogramElement> _function = new Functions.Function1<ModelElement, PictogramElement>(){

                    public PictogramElement apply(ModelElement it) {
                        return WorkbenchExtension.this.getPictogramElement((IdentifiableElement)it);
                    }
                };
                _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)elements)), (Functions.Function1)_function);
            }
            this.unselect(_diagram, (PictogramElement[])Conversions.unwrapArray(_map, PictogramElement.class));
        }
    }

    public void unselect(Diagram it, final PictogramElement[] pes) {
        Functions.Function1<PictogramElement, Boolean> _function = new Functions.Function1<PictogramElement, Boolean>(){

            public Boolean apply(PictogramElement it) {
                boolean _contains = ArrayExtensions.contains((Object[])pes, (Object)it);
                return !_contains;
            }
        };
        this.select(it, (PictogramElement[])Conversions.unwrapArray((Object)IterableExtensions.filter(this.getSelectedPictogramElements(it), (Functions.Function1)_function), PictogramElement.class));
    }

    public void clearSelection(GraphModel model) {
        Diagram _diagram = this.getDiagram((IdentifiableElement)model);
        if (_diagram != null) {
            this.clearSelection(_diagram);
        }
    }

    public void clearSelection(Diagram diagram) {
        this.select(diagram, new PictogramElement[0]);
    }

    public GraphModel getGraphModel(IEditorPart editor) {
        GraphModel _xblockexpression = null;
        ResourceExtension ext = new ResourceExtension();
        Resource _resource = this.getResource(editor);
        GraphModel _graphModel = null;
        if (_resource != null) {
            _graphModel = ext.getGraphModel(_resource);
        }
        _xblockexpression = _graphModel;
        return _xblockexpression;
    }

    public <T extends GraphModel> T getGraphModel(IEditorPart editor, Class<T> modelClass) {
        GraphModel _xblockexpression = null;
        ResourceExtension ext = new ResourceExtension();
        Resource _resource = null;
        if (editor != null) {
            _resource = this.getResource(editor);
        }
        GraphModel _content = null;
        if (_resource != null) {
            _content = (GraphModel)ext.getContent(_resource, modelClass, 1);
        }
        _xblockexpression = _content;
        return (T)_xblockexpression;
    }

    public Object getLinkedGraphModel(Diagram diagram) {
        return this.getBusinessObject((PictogramElement)diagram);
    }

    public void refresh(final Diagram diagram) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                DiagramBehavior _diagramBehavior = WorkbenchExtension.this.getDiagramBehavior(diagram);
                if (_diagramBehavior != null) {
                    _diagramBehavior.refreshContent();
                }
            }
        };
        this.async(_function);
    }

    public void refreshDiagramEditor() {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                DiagramEditor _activeDiagramEditor = WorkbenchExtension.this.getActiveDiagramEditor();
                DiagramBehavior _diagramBehavior = null;
                if (_activeDiagramEditor != null) {
                    _diagramBehavior = _activeDiagramEditor.getDiagramBehavior();
                }
                if (_diagramBehavior != null) {
                    _diagramBehavior.refresh();
                }
            }
        };
        this.async(_function);
    }

    public void refreshDecorators(final PictogramElement pe) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                DiagramEditor _editor = WorkbenchExtension.this.getEditor(pe);
                DiagramBehavior _diagramBehavior = null;
                if (_editor != null) {
                    _diagramBehavior = _editor.getDiagramBehavior();
                }
                if (_diagramBehavior != null) {
                    _diagramBehavior.refreshRenderingDecorators(pe);
                }
            }
        };
        this.async(_function);
    }

    public void refreshDecorators(final Iterable<PictogramElement> pes) {
        DiagramBehavior db;
        Iterable _map = null;
        if (pes != null) {
            Functions.Function1<PictogramElement, DiagramBehavior> _function = new Functions.Function1<PictogramElement, DiagramBehavior>(){

                public DiagramBehavior apply(PictogramElement it) {
                    DiagramEditor _editor = WorkbenchExtension.this.getEditor(it);
                    DiagramBehavior _diagramBehavior = null;
                    if (_editor != null) {
                        _diagramBehavior = _editor.getDiagramBehavior();
                    }
                    return _diagramBehavior;
                }
            };
            _map = IterableExtensions.map(pes, (Functions.Function1)_function);
        }
        Iterable _filterNull = null;
        if (_map != null) {
            _filterNull = IterableExtensions.filterNull(_map);
        }
        DiagramBehavior _head = null;
        if (_filterNull != null) {
            _head = (DiagramBehavior)IterableExtensions.head((Iterable)_filterNull);
        }
        if ((db = _head) != null) {
            Runnable _function_1 = new Runnable(){

                @Override
                public void run() {
                    for (PictogramElement pe : pes) {
                        db.refreshRenderingDecorators(pe);
                    }
                }
            };
            this.async(_function_1);
        } else {
            System.err.println("No DiagramBehavior found for any pictogram");
        }
    }

    public int showCustomQuestionDialog(String title, String message, String[] buttonLabels) {
        Shell _activeShell = this.getDisplay().getActiveShell();
        return new MessageDialog(_activeShell, title, null, message, 3, buttonLabels, 0).open();
    }

    public boolean showConfirmDialog(String title, String message) {
        return MessageDialog.openConfirm((Shell)this.getDisplay().getActiveShell(), (String)title, (String)message);
    }

    public void showErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)title, (String)message);
    }

    public void showInfoDialog(String title, String message) {
        MessageDialog.openInformation((Shell)this.getDisplay().getActiveShell(), (String)title, (String)message);
    }

    public boolean showQuestionDialog(String title, String message) {
        return MessageDialog.openQuestion((Shell)this.getDisplay().getActiveShell(), (String)title, (String)message);
    }

    public void showWarningDialog(String title, String message) {
        MessageDialog.openWarning((Shell)this.getDisplay().getActiveShell(), (String)title, (String)message);
    }

    public IEditorPart openEditor(EObject obj) {
        IEditorPart _xblockexpression = null;
        WorkspaceExtension we = new WorkspaceExtension();
        FileExtension fe = new FileExtension();
        IFile _file = we.getFile(obj);
        IEditorPart _openInEditor = null;
        if (_file != null) {
            _openInEditor = fe.openInEditor(_file);
        }
        _xblockexpression = _openInEditor;
        return _xblockexpression;
    }

    public void transact(EObject object, Runnable runnable) {
        this.transact(object, null, runnable);
    }

    public void transact(EObject object, String label, Runnable runnable) {
        ResourceExtension ResourceExtension2 = new ResourceExtension();
        ResourceExtension2.transact(object.eResource(), label, runnable);
    }
}

