/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.runtime.xapi;

import com.google.common.collect.Iterables;
import graphmodel.GraphModel;
import graphmodel.internal.InternalGraphModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class NIOExtension {
    public final StandardCopyOption REPLACE_EXISTING = StandardCopyOption.REPLACE_EXISTING;
    public final StandardCopyOption COPY_ATTRIBUTES = StandardCopyOption.COPY_ATTRIBUTES;
    public final StandardCopyOption ATOMIC_MOVE = StandardCopyOption.ATOMIC_MOVE;
    public final NIOExtensionCopyOption REPLACE_DIRECTORIES = NIOExtensionCopyOption.REPLACE_DIRECTORIES;
    public final NIOExtensionCopyOption MERGE_DIRECTORIES = NIOExtensionCopyOption.MERGE_DIRECTORIES;
    public final StandardOpenOption READ = StandardOpenOption.READ;
    public final StandardOpenOption WRITE = StandardOpenOption.WRITE;
    public final StandardOpenOption APPEND = StandardOpenOption.APPEND;
    public final StandardOpenOption TRUNCATE_EXISTING = StandardOpenOption.TRUNCATE_EXISTING;
    public final StandardOpenOption CREATE = StandardOpenOption.CREATE;
    public final StandardOpenOption CREATE_NEW = StandardOpenOption.CREATE_NEW;
    public final StandardOpenOption DELETE_ON_CLOSE = StandardOpenOption.DELETE_ON_CLOSE;
    public final StandardOpenOption SPARSE = StandardOpenOption.SPARSE;
    public final StandardOpenOption SYNC = StandardOpenOption.SYNC;
    public final StandardOpenOption DSYNC = StandardOpenOption.DSYNC;
    public final LinkOption NOFOLLOW_LINKS = LinkOption.NOFOLLOW_LINKS;
    public final FileVisitOption FOLLOW_LINKS = FileVisitOption.FOLLOW_LINKS;
    public final PosixFilePermission OWNER_READ = PosixFilePermission.OWNER_READ;
    public final PosixFilePermission OWNER_WRITE = PosixFilePermission.OWNER_WRITE;
    public final PosixFilePermission OWNER_EXECUTE = PosixFilePermission.OWNER_EXECUTE;
    public final PosixFilePermission GROUP_READ = PosixFilePermission.GROUP_READ;
    public final PosixFilePermission GROUP_WRITE = PosixFilePermission.GROUP_WRITE;
    public final PosixFilePermission GROUP_EXECUTE = PosixFilePermission.GROUP_EXECUTE;
    public final PosixFilePermission OTHERS_READ = PosixFilePermission.OTHERS_READ;
    public final PosixFilePermission OTHERS_WRITE = PosixFilePermission.OTHERS_WRITE;
    public final PosixFilePermission OTHERS_EXECUTE = PosixFilePermission.OTHERS_EXECUTE;
    public final Charset US_ASCII = StandardCharsets.US_ASCII;
    public final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public final Charset UTF_8 = StandardCharsets.UTF_8;
    public final Charset UTF_16BE = StandardCharsets.UTF_16BE;
    public final Charset UTF_16LE = StandardCharsets.UTF_16LE;
    public final Charset UTF_16 = StandardCharsets.UTF_16;

    public java.nio.file.Path newPath(CharSequence ... segments) {
        if (segments == null || ArrayExtensions.contains((Object[])segments, null)) {
            throw new NullPointerException();
        }
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)segments)).isEmpty();
        if (_isEmpty) {
            return Paths.get("", new String[0]);
        }
        Functions.Function1<CharSequence, String> _function = new Functions.Function1<CharSequence, String>(){

            public String apply(CharSequence it) {
                return it.toString();
            }
        };
        return Paths.get(((CharSequence)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)segments)))).toString(), (String[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.tail((Iterable)((Iterable)Conversions.doWrapArray((Object)segments))), (Functions.Function1)_function), String.class));
    }

    public java.nio.file.Path resolve(java.nio.file.Path path, java.nio.file.Path ... segments) {
        Functions.Function1<java.nio.file.Path, Boolean> _function = new Functions.Function1<java.nio.file.Path, Boolean>(){

            public Boolean apply(java.nio.file.Path it) {
                return it.isAbsolute();
            }
        };
        boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)segments)), (Functions.Function1)_function);
        if (_exists) {
            throw new IllegalArgumentException("At least one path segment is absolute.");
        }
        java.nio.file.Path result = path;
        java.nio.file.Path[] pathArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            java.nio.file.Path segment = pathArray[n2];
            result = result.resolve(segment);
            ++n2;
        }
        return result;
    }

    public java.nio.file.Path resolve(java.nio.file.Path path, CharSequence ... segments) {
        java.nio.file.Path result = path;
        CharSequence[] charSequenceArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence segment = charSequenceArray[n2];
            result = result.resolve(segment.toString());
            ++n2;
        }
        return result;
    }

    public InputStream newInputStream(java.nio.file.Path path, OpenOption ... options) throws IOException {
        return Files.newInputStream(path, options);
    }

    public OutputStream newOutputStream(java.nio.file.Path path, OpenOption ... options) throws IOException {
        return Files.newOutputStream(path, options);
    }

    public SeekableByteChannel newByteChannel(java.nio.file.Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return Files.newByteChannel(path, options, attrs);
    }

    public SeekableByteChannel newByteChannel(java.nio.file.Path path, OpenOption ... options) throws IOException {
        return Files.newByteChannel(path, options);
    }

    public DirectoryStream<java.nio.file.Path> newDirectoryStream(java.nio.file.Path dir) throws IOException {
        return Files.newDirectoryStream(dir);
    }

    public DirectoryStream<java.nio.file.Path> newDirectoryStream(java.nio.file.Path dir, String glob) throws IOException {
        return Files.newDirectoryStream(dir, glob);
    }

    public DirectoryStream<java.nio.file.Path> newDirectoryStream(java.nio.file.Path dir, final Functions.Function1<? super java.nio.file.Path, ? extends Boolean> filter) throws IOException {
        return Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super java.nio.file.Path>)new DirectoryStream.Filter<java.nio.file.Path>(){

            @Override
            public boolean accept(java.nio.file.Path arg0) {
                return (Boolean)filter.apply((Object)arg0);
            }
        });
    }

    public java.nio.file.Path createFile(java.nio.file.Path path, FileAttribute<?> ... attrs) throws IOException {
        return Files.createFile(path, attrs);
    }

    public java.nio.file.Path createDirectory(java.nio.file.Path dir, FileAttribute<?> ... attrs) throws IOException {
        return Files.createDirectory(dir, attrs);
    }

    public java.nio.file.Path createDirectories(java.nio.file.Path dir, FileAttribute<?> ... attrs) throws IOException {
        return Files.createDirectories(dir, attrs);
    }

    public java.nio.file.Path createTempFile(java.nio.file.Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempFile(dir, prefix, suffix, attrs);
    }

    public java.nio.file.Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempFile(prefix, suffix, attrs);
    }

    public java.nio.file.Path createTempDirectory(java.nio.file.Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory(dir, prefix, attrs);
    }

    public java.nio.file.Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory(prefix, attrs);
    }

    public java.nio.file.Path createSymbolicLink(java.nio.file.Path link, java.nio.file.Path target, FileAttribute<?> ... attrs) throws IOException {
        return Files.createSymbolicLink(link, target, attrs);
    }

    public java.nio.file.Path createLink(java.nio.file.Path link, java.nio.file.Path existing) throws IOException {
        return Files.createLink(link, existing);
    }

    public void delete(java.nio.file.Path path) throws IOException {
        Files.delete(path);
    }

    public boolean deleteIfExists(java.nio.file.Path path) throws IOException {
        return Files.deleteIfExists(path);
    }

    public java.nio.file.Path copy(java.nio.file.Path source, java.nio.file.Path target, CopyOption ... options) throws IOException {
        return Files.copy(source, target, options);
    }

    public java.nio.file.Path move(java.nio.file.Path source, java.nio.file.Path target, CopyOption ... options) throws IOException {
        return Files.move(source, target, options);
    }

    public java.nio.file.Path readSymbolicLink(java.nio.file.Path link) throws IOException {
        return Files.readSymbolicLink(link);
    }

    public FileStore getFileStore(java.nio.file.Path path) throws IOException {
        return Files.getFileStore(path);
    }

    public boolean isSameFile(java.nio.file.Path path, java.nio.file.Path path2) throws IOException {
        return Files.isSameFile(path, path2);
    }

    public boolean isHidden(java.nio.file.Path path) throws IOException {
        return Files.isHidden(path);
    }

    public String probeContentType(java.nio.file.Path path) throws IOException {
        return Files.probeContentType(path);
    }

    public <V extends FileAttributeView> V getFileAttributeView(java.nio.file.Path path, Class<V> type, LinkOption ... options) {
        return Files.getFileAttributeView(path, type, options);
    }

    public <A extends BasicFileAttributes> A readAttributes(java.nio.file.Path path, Class<A> type, LinkOption ... options) throws IOException {
        return Files.readAttributes(path, type, options);
    }

    public java.nio.file.Path setAttribute(java.nio.file.Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        return Files.setAttribute(path, attribute, value, options);
    }

    public Object getAttribute(java.nio.file.Path path, String attribute, LinkOption ... options) throws IOException {
        return Files.getAttribute(path, attribute, options);
    }

    public Map<String, Object> readAttributes(java.nio.file.Path path, String attributes, LinkOption ... options) throws IOException {
        return Files.readAttributes(path, attributes, options);
    }

    public Set<PosixFilePermission> getPosixFilePermissions(java.nio.file.Path path, LinkOption ... options) throws IOException {
        return Files.getPosixFilePermissions(path, options);
    }

    public java.nio.file.Path setPosixFilePermissions(java.nio.file.Path path, Set<PosixFilePermission> perms) throws IOException {
        return Files.setPosixFilePermissions(path, perms);
    }

    public UserPrincipal getOwner(java.nio.file.Path path, LinkOption ... options) throws IOException {
        return Files.getOwner(path, options);
    }

    public java.nio.file.Path setOwner(java.nio.file.Path path, UserPrincipal owner) throws IOException {
        return Files.setOwner(path, owner);
    }

    public boolean isSymbolicLink(java.nio.file.Path path) {
        return Files.isSymbolicLink(path);
    }

    public boolean isDirectory(java.nio.file.Path path, LinkOption ... options) {
        return Files.isDirectory(path, options);
    }

    public boolean isRegularFile(java.nio.file.Path path, LinkOption ... options) {
        return Files.isRegularFile(path, options);
    }

    public FileTime getLastModifiedTime(java.nio.file.Path path, LinkOption ... options) throws IOException {
        return Files.getLastModifiedTime(path, options);
    }

    public java.nio.file.Path setLastModifiedTime(java.nio.file.Path path, FileTime time) throws IOException {
        return Files.setLastModifiedTime(path, time);
    }

    public long size(java.nio.file.Path path) throws IOException {
        return Files.size(path);
    }

    public boolean exists(java.nio.file.Path path, LinkOption ... options) {
        return Files.exists(path, options);
    }

    public boolean notExists(java.nio.file.Path path, LinkOption ... options) {
        return Files.notExists(path, options);
    }

    public boolean isReadable(java.nio.file.Path path) {
        return Files.isReadable(path);
    }

    public boolean isWritable(java.nio.file.Path path) {
        return Files.isWritable(path);
    }

    public boolean isExecutable(java.nio.file.Path path) {
        return Files.isExecutable(path);
    }

    public java.nio.file.Path walkFileTree(java.nio.file.Path start, Set<FileVisitOption> options, int maxDepth, FileVisitor<? super java.nio.file.Path> visitor) throws IOException {
        return Files.walkFileTree(start, options, maxDepth, visitor);
    }

    public java.nio.file.Path walkFileTree(java.nio.file.Path start, FileVisitor<? super java.nio.file.Path> visitor) throws IOException {
        return Files.walkFileTree(start, visitor);
    }

    public BufferedReader newBufferedReader(java.nio.file.Path path, Charset cs) throws IOException {
        return Files.newBufferedReader(path, cs);
    }

    public BufferedReader newBufferedReader(java.nio.file.Path path) throws IOException {
        return Files.newBufferedReader(path);
    }

    public BufferedWriter newBufferedWriter(java.nio.file.Path path, Charset cs, OpenOption ... options) throws IOException {
        return Files.newBufferedWriter(path, cs, options);
    }

    public BufferedWriter newBufferedWriter(java.nio.file.Path path, OpenOption ... options) throws IOException {
        return Files.newBufferedWriter(path, options);
    }

    public long copy(InputStream in, java.nio.file.Path target, CopyOption ... options) throws IOException {
        return Files.copy(in, target, options);
    }

    public long copy(java.nio.file.Path source, OutputStream out) throws IOException {
        return Files.copy(source, out);
    }

    public byte[] readAllBytes(java.nio.file.Path path) throws IOException {
        return Files.readAllBytes(path);
    }

    public String readString(java.nio.file.Path path) throws IOException {
        return Files.readString(path);
    }

    public String readString(java.nio.file.Path path, Charset cs) throws IOException {
        return Files.readString(path, cs);
    }

    public List<String> readAllLines(java.nio.file.Path path, Charset cs) throws IOException {
        return Files.readAllLines(path, cs);
    }

    public List<String> readAllLines(java.nio.file.Path path) throws IOException {
        return Files.readAllLines(path);
    }

    public java.nio.file.Path write(java.nio.file.Path path, byte[] bytes, OpenOption ... options) throws IOException {
        return Files.write(path, bytes, options);
    }

    public java.nio.file.Path write(java.nio.file.Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) throws IOException {
        return Files.write(path, lines, cs, options);
    }

    public java.nio.file.Path write(java.nio.file.Path path, Iterable<? extends CharSequence> lines, OpenOption ... options) throws IOException {
        return Files.write(path, lines, options);
    }

    public java.nio.file.Path writeString(java.nio.file.Path path, CharSequence csq, OpenOption ... options) throws IOException {
        return Files.writeString(path, csq, options);
    }

    public java.nio.file.Path writeString(java.nio.file.Path path, CharSequence csq, Charset cs, OpenOption ... options) throws IOException {
        return Files.writeString(path, csq, cs, options);
    }

    public Stream<java.nio.file.Path> list(java.nio.file.Path dir) throws IOException {
        return Files.list(dir);
    }

    public Stream<java.nio.file.Path> walk(java.nio.file.Path start, int maxDepth, FileVisitOption ... options) throws IOException {
        return Files.walk(start, maxDepth, options);
    }

    public Stream<java.nio.file.Path> walk(java.nio.file.Path start, FileVisitOption ... options) throws IOException {
        return Files.walk(start, options);
    }

    public Stream<java.nio.file.Path> find(java.nio.file.Path start, int maxDepth, final Functions.Function2<? super java.nio.file.Path, ? super BasicFileAttributes, ? extends Boolean> matcher, FileVisitOption ... options) throws IOException {
        return Files.find(start, maxDepth, new BiPredicate<java.nio.file.Path, BasicFileAttributes>(){

            @Override
            public boolean test(java.nio.file.Path arg0, BasicFileAttributes arg1) {
                return (Boolean)matcher.apply((Object)arg0, (Object)arg1);
            }
        }, options);
    }

    public Stream<String> lines(java.nio.file.Path path, Charset cs) throws IOException {
        return Files.lines(path, cs);
    }

    public Stream<String> lines(java.nio.file.Path path) throws IOException {
        return Files.lines(path);
    }

    public String getFileExtension(java.nio.file.Path path) {
        String fileName;
        boolean _isNullOrEmpty;
        java.nio.file.Path _fileName = path.getFileName();
        String _string = null;
        if (_fileName != null) {
            _string = _fileName.toString();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)(fileName = _string))) {
            return null;
        }
        int i = fileName.lastIndexOf(".");
        if (i < 1 || i == fileName.length() - 1) {
            return null;
        }
        return fileName.substring(i + 1);
    }

    public String getFileNameWithoutExtension(java.nio.file.Path path) {
        String fileName;
        boolean _isNullOrEmpty;
        java.nio.file.Path _fileName = path.getFileName();
        String _string = null;
        if (_fileName != null) {
            _string = _fileName.toString();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)(fileName = _string))) {
            return null;
        }
        int i = fileName.lastIndexOf(".");
        if (i < 1 || i == fileName.length() - 1) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    public String getFileNameWithExtension(java.nio.file.Path path) {
        java.nio.file.Path _fileName = path.getFileName();
        String _string = null;
        if (_fileName != null) {
            _string = _fileName.toString();
        }
        return _string;
    }

    public boolean isEmptyDirectory(java.nio.file.Path dir) throws IOException {
        return this.list(dir).findAny().isPresent();
    }

    public void deleteRecursively(java.nio.file.Path path) throws IOException {
        List _reverse = ListExtensions.reverse(this.toList(this.walk(path, new FileVisitOption[0])));
        for (java.nio.file.Path currentPath : _reverse) {
            this.delete(currentPath);
        }
    }

    public boolean deleteRecursivelyIfExists(java.nio.file.Path path) throws IOException {
        boolean _exists = this.exists(path, new LinkOption[0]);
        if (_exists) {
            this.deleteRecursively(path);
            return true;
        }
        return false;
    }

    public java.nio.file.Path copyRecursively(java.nio.file.Path source, java.nio.file.Path target, CopyOption ... options) throws IOException {
        boolean replaceExisting = ArrayExtensions.contains((Object[])options, (Object)this.REPLACE_EXISTING);
        boolean replaceDirectories = ArrayExtensions.contains((Object[])options, (Object)this.REPLACE_DIRECTORIES);
        boolean mergeDirectories = ArrayExtensions.contains((Object[])options, (Object)this.MERGE_DIRECTORIES);
        if (replaceDirectories && !replaceExisting) {
            throw new IllegalArgumentException("Copy option 'REPLACE_DIRECTORIES' must be combined with 'REPLACE_EXISTING'.");
        }
        if (mergeDirectories && !replaceExisting) {
            throw new IllegalArgumentException("Copy option 'MERGE_DIRECTORIES' must be combined with 'REPLACE_EXISTING'.");
        }
        if (replaceDirectories && mergeDirectories) {
            throw new IllegalArgumentException("Copy options 'REPLACE_DIRECTORIES' and 'MERGE_DIRECTORIES' are not compatible.");
        }
        CopyOption[] standardCopyOptions = (StandardCopyOption[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)options)), StandardCopyOption.class), StandardCopyOption.class);
        List<java.nio.file.Path> _list = this.toList(this.walk(source, new FileVisitOption[0]));
        for (java.nio.file.Path sourcePath : _list) {
            java.nio.file.Path relativeSourcePath = source.relativize(sourcePath);
            java.nio.file.Path targetPath = target.resolve(relativeSourcePath);
            boolean isDirectory = this.isDirectory(targetPath, new LinkOption[0]);
            if (isDirectory && replaceExisting && replaceDirectories) {
                this.deleteRecursively(targetPath);
                this.copy(sourcePath, targetPath, standardCopyOptions);
                continue;
            }
            if (isDirectory && replaceExisting && mergeDirectories) continue;
            this.copy(sourcePath, targetPath, standardCopyOptions);
        }
        return target;
    }

    public java.nio.file.Path toPath(CharSequence segments) {
        return this.newPath(segments);
    }

    public java.nio.file.Path toPath(Iterable<? extends CharSequence> segments) {
        return this.newPath((CharSequence[])Conversions.unwrapArray(segments, CharSequence.class));
    }

    public java.nio.file.Path toNIOPath(CharSequence segments) {
        return this.newPath(segments);
    }

    public java.nio.file.Path toNIOPath(Iterable<? extends CharSequence> segments) {
        return this.newPath((CharSequence[])Conversions.unwrapArray(segments, CharSequence.class));
    }

    public java.nio.file.Path toNIOPath(File file) {
        return file.toPath();
    }

    public File toIOFile(java.nio.file.Path path) {
        return path.toFile();
    }

    public java.nio.file.Path toNIOPath(java.net.URI uri) {
        return Paths.get(uri);
    }

    public java.net.URI toNetURI(java.nio.file.Path path) {
        return path.toUri();
    }

    public java.nio.file.Path toNIOPath(IPath path) {
        return this.toPath(path.toOSString());
    }

    public IPath toIPath(java.nio.file.Path path) {
        String _string = path.toString();
        return new Path(_string);
    }

    public java.nio.file.Path toNIOPath(IResource resource) {
        return this.toNIOPath(resource.getLocation());
    }

    public IResource toIResource(java.nio.file.Path path) {
        boolean _tripleEquals;
        java.nio.file.Path _xifexpression = null;
        java.nio.file.Path _root = path.getRoot();
        boolean bl = _tripleEquals = _root == null;
        if (_tripleEquals) {
            _xifexpression = path;
        } else {
            java.nio.file.Path _workspaceRootPath = this.getWorkspaceRootPath();
            java.nio.file.Path _relativize = null;
            if (_workspaceRootPath != null) {
                _relativize = _workspaceRootPath.relativize(path);
            }
            _xifexpression = _relativize;
        }
        java.nio.file.Path workspaceRelativePath = _xifexpression;
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        IResource _findMember = null;
        if (_workspaceRoot != null) {
            _findMember = _workspaceRoot.findMember(workspaceRelativePath.toString());
        }
        return _findMember;
    }

    public IFile toIFile(java.nio.file.Path path) {
        IResource _iResource = this.toIResource(path);
        return (IFile)_iResource;
    }

    public IFolder toIFolder(java.nio.file.Path path) {
        IResource _iResource = this.toIResource(path);
        return (IFolder)_iResource;
    }

    public IProject toIProject(java.nio.file.Path path) {
        IResource _iResource = this.toIResource(path);
        return (IProject)_iResource;
    }

    public IWorkspaceRoot toIWorkspaceRoot(java.nio.file.Path path) {
        IResource _iResource = this.toIResource(path);
        return (IWorkspaceRoot)_iResource;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = null;
        if (_workspace != null) {
            _root = _workspace.getRoot();
        }
        return _root;
    }

    public java.nio.file.Path getWorkspaceRootPath() {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        java.nio.file.Path _nIOPath = null;
        if (_workspaceRoot != null) {
            _nIOPath = this.toNIOPath((IResource)_workspaceRoot);
        }
        return _nIOPath;
    }

    public java.nio.file.Path getProjectPath(java.nio.file.Path path) {
        IResource _iResource = this.toIResource(path);
        IProject _project = null;
        if (_iResource != null) {
            _project = _iResource.getProject();
        }
        java.nio.file.Path _nIOPath = null;
        if (_project != null) {
            _nIOPath = this.toNIOPath((IResource)_project);
        }
        return _nIOPath;
    }

    public java.nio.file.Path toNIOPath(URI uri) {
        return this.toPath(CommonPlugin.resolve((URI)uri).toFileString());
    }

    public java.nio.file.Path toNIOPath2(URI uri) {
        String platformString = uri.toPlatformString(true);
        return this.toNIOPath(this.getWorkspaceRoot().findMember(platformString));
    }

    public URI toEURI(java.nio.file.Path path) {
        java.nio.file.Path workspaceRelativePath = this.getWorkspaceRootPath().relativize(path);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("platform:/resource/");
        _builder.append((Object)workspaceRelativePath);
        String platformString = _builder.toString();
        return URI.createURI((String)platformString);
    }

    public java.nio.file.Path getProjectPath(URI uri) {
        String platformString = uri.toPlatformString(true);
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        IResource _findMember = null;
        if (_workspaceRoot != null) {
            _findMember = _workspaceRoot.findMember(platformString);
        }
        IProject _project = null;
        if (_findMember != null) {
            _project = _findMember.getProject();
        }
        java.nio.file.Path _nIOPath = null;
        if (_project != null) {
            _nIOPath = this.toNIOPath((IResource)_project);
        }
        return _nIOPath;
    }

    public java.nio.file.Path toNIOPath(Resource resource) {
        return this.toNIOPath(resource.getURI());
    }

    public Resource toEResource(java.nio.file.Path path) {
        URI uri = this.toEURI(path);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet.getResource(uri, true);
    }

    public java.nio.file.Path getProjectPath(Resource resource) {
        return this.getProjectPath(resource.getURI());
    }

    public java.nio.file.Path toNIOPath(EObject object) {
        return this.toNIOPath(object.eResource());
    }

    public GraphModel toGraphModel(java.nio.file.Path path) {
        return ((InternalGraphModel)IterableExtensions.head((Iterable)Iterables.filter((Iterable)this.toEResource(path).getContents(), InternalGraphModel.class))).getElement();
    }

    public <GM extends GraphModel> GM toGraphModel(java.nio.file.Path path, Class<GM> graphModelClass) {
        GraphModel _graphModel = this.toGraphModel(path);
        return (GM)_graphModel;
    }

    public java.nio.file.Path getProjectPath(EObject object) {
        return this.getProjectPath(object.eResource());
    }

    public <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static class NIOExtensionCopyOption
    implements CopyOption {
        public static final NIOExtensionCopyOption REPLACE_DIRECTORIES = new NIOExtensionCopyOption();
        public static final NIOExtensionCopyOption MERGE_DIRECTORIES = new NIOExtensionCopyOption();

        private NIOExtensionCopyOption() {
        }
    }
}

