/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.runtime.xapi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.xapi.CodingExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import graphmodel.Direction;
import graphmodel.Edge;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import graphmodel.Type;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GraphModelExtension {
    @Extension
    protected CodingExtension _codingExtension = new CodingExtension();

    public boolean operator_equals(IdentifiableElement it, IdentifiableElement that) {
        boolean _or = false;
        if (it == that) {
            _or = true;
        } else {
            boolean _equals;
            String _id = null;
            if (it != null) {
                _id = it.getId();
            }
            String _id_1 = null;
            if (that != null) {
                _id_1 = that.getId();
            }
            _or = _equals = Objects.equal((Object)_id, (Object)_id_1);
        }
        return _or;
    }

    public boolean operator_notEquals(IdentifiableElement it, IdentifiableElement that) {
        boolean _equals = this.operator_equals(it, that);
        return !_equals;
    }

    public Iterable<ModelElement> getPathToRoot(ModelElement el) {
        Iterable<Object> _xifexpression = null;
        ModelElementContainer _container = el.getContainer();
        if (_container instanceof ModelElement) {
            ModelElementContainer _container_1 = el.getContainer();
            Iterable<ModelElement> _pathToRoot = this.getPathToRoot((ModelElement)_container_1);
            _xifexpression = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{el})), _pathToRoot);
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{el}));
        }
        return _xifexpression;
    }

    public <C extends IdentifiableElement> Iterable<C> find(ModelElementContainer container, final Class<C> clazz) {
        Iterable _xblockexpression = null;
        EList children = container.getModelElements();
        Iterable _filter = Iterables.filter((Iterable)children, clazz);
        Functions.Function1 _function = new Functions.Function1<ModelElementContainer, Iterable<C>>(){

            public Iterable<C> apply(ModelElementContainer it) {
                return GraphModelExtension.this.find(it, clazz);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)children, ModelElementContainer.class), (Functions.Function1)_function));
        _xblockexpression = Iterables.concat((Iterable)_filter, (Iterable)_flatten);
        return _xblockexpression;
    }

    public Iterable<? extends ModelElement> find(ModelElementContainer container, final Class<? extends ModelElement> ... classes) {
        Iterable _xblockexpression = null;
        EList children = container.getModelElements();
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(final ModelElement child) {
                Functions.Function1<Class<? extends ModelElement>, Boolean> _function = new Functions.Function1<Class<? extends ModelElement>, Boolean>(){

                    public Boolean apply(Class<? extends ModelElement> it) {
                        return it.isInstance(child);
                    }
                };
                return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)classes)), (Functions.Function1)_function);
            }
        };
        Iterable filtered = IterableExtensions.filter((Iterable)children, (Functions.Function1)_function);
        Functions.Function1<ModelElementContainer, Iterable<? extends ModelElement>> _function_1 = new Functions.Function1<ModelElementContainer, Iterable<? extends ModelElement>>(){

            public Iterable<? extends ModelElement> apply(ModelElementContainer it) {
                return GraphModelExtension.this.find(it, classes);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)children, ModelElementContainer.class), (Functions.Function1)_function_1));
        _xblockexpression = Iterables.concat((Iterable)filtered, (Iterable)_flatten);
        return _xblockexpression;
    }

    public <C extends ModelElement> C findThe(ModelElementContainer container, Class<C> cls) {
        boolean _greaterThan;
        Iterable<C> result = this.find(container, cls);
        int _size = IterableExtensions.size(result);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            int _size_1 = IterableExtensions.size(result);
            _builder.append((Object)_size_1);
            _builder.append(" elements of type '");
            _builder.append(cls);
            _builder.append("' found.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("Exactly one was expected when calling method 'findThe' on container ");
            _builder.append((Object)container, "  ");
            _builder.append("..");
            _builder.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder);
        }
        return (C)((ModelElement)IterableExtensions.head(result));
    }

    public <C extends ModelElement> C findThe(ModelElementContainer container, Class<C> cls, Functions.Function1<? super C, ? extends Boolean> predicate) {
        boolean _greaterThan;
        Iterable result = IterableExtensions.filter(this.find(container, cls), predicate);
        int _size = IterableExtensions.size((Iterable)result);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            int _size_1 = IterableExtensions.size((Iterable)result);
            _builder.append((Object)_size_1);
            _builder.append(" elements of type '");
            _builder.append(cls);
            _builder.append("' found that fulfill the specified predicate.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("Exactly one was expected when calling method 'findThe' on container ");
            _builder.append((Object)container, "  ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder);
        }
        return (C)((ModelElement)IterableExtensions.head((Iterable)result));
    }

    public <C extends IdentifiableElement> Iterable<C> findDeeply(ModelElementContainer container, Class<C> clazz, Functions.Function1<? super IdentifiableElement, ? extends ModelElementContainer> progression) {
        return this.findDeeply_recurse(container, (Class[])Conversions.unwrapArray(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Class[]{clazz})), Class.class), progression, CollectionLiterals.newHashSet());
    }

    public <C extends IdentifiableElement> Iterable<C> findDeeply(ModelElementContainer container, Class<C>[] classes, Functions.Function1<? super IdentifiableElement, ? extends ModelElementContainer> progression) {
        return this.findDeeply_recurse(container, classes, progression, CollectionLiterals.newHashSet());
    }

    private <C extends IdentifiableElement> Iterable<C> findDeeply_recurse(ModelElementContainer container, final Class<C>[] classes, final Functions.Function1<? super IdentifiableElement, ? extends ModelElementContainer> progression, final Set<ModelElementContainer> visited) {
        boolean _not;
        Iterable _xblockexpression = null;
        boolean _add = visited.add(container);
        boolean bl = _not = !_add;
        if (_not) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Iterable candidates = this._codingExtension.plus(container, this.find(container, (Class<C>)IdentifiableElement.class));
        Functions.Function1<IdentifiableElement, Boolean> _function = new Functions.Function1<IdentifiableElement, Boolean>(){

            public Boolean apply(final IdentifiableElement o) {
                Functions.Function1 _function = new Functions.Function1<Class<C>, Boolean>(){

                    public Boolean apply(Class<C> it) {
                        return it.isInstance(o);
                    }
                };
                return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)classes)), (Functions.Function1)_function);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)candidates, (Functions.Function1)_function);
        Functions.Function1 _function_1 = new Functions.Function1<ModelElementContainer, Iterable<C>>(){

            public Iterable<C> apply(ModelElementContainer it) {
                return GraphModelExtension.this.findDeeply_recurse(it, classes, (Functions.Function1<? super IdentifiableElement, ? extends ModelElementContainer>)progression, visited);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)candidates, progression)), (Functions.Function1)_function_1));
        _xblockexpression = Iterables.concat((Iterable)_filter, (Iterable)_flatten);
        return _xblockexpression;
    }

    public <C extends ModelElement> Iterable<C> findParents(ModelElement it, Class<C> cls) {
        Iterable<Object> _xifexpression = null;
        boolean _isInstance = cls.isInstance(it.getContainer());
        if (_isInstance) {
            ModelElementContainer _container = it.getContainer();
            ModelElementContainer _container_1 = it.getContainer();
            Iterable<C> _findParents = this.findParents((ModelElement)_container_1, cls);
            _xifexpression = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{(ModelElement)_container})), _findParents);
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _xifexpression;
    }

    public <C extends ModelElement> C findFirstParent(ModelElement it, Class<C> cls) {
        Functions.Function1 _function = new Functions.Function1<C, Boolean>(){

            public Boolean apply(C it) {
                return true;
            }
        };
        return this.findFirstParent(it, cls, _function);
    }

    public <C extends ModelElement> C findFirstParent(ModelElement it, Class<C> cls, Functions.Function1<? super C, ? extends Boolean> predicate) {
        Object _switchResult = null;
        ModelElementContainer _container = it.getContainer();
        boolean _matched = false;
        boolean _and = false;
        boolean _isInstance = cls.isInstance(it.getContainer());
        if (!_isInstance) {
            _and = false;
        } else {
            Boolean _apply = null;
            if (predicate != null) {
                ModelElementContainer _container_1 = it.getContainer();
                _apply = (Boolean)predicate.apply((Object)((ModelElement)_container_1));
            }
            _and = _apply;
        }
        if (_and) {
            _matched = true;
            ModelElementContainer _container_2 = it.getContainer();
            _switchResult = (ModelElement)_container_2;
        }
        if (!_matched && _container instanceof ModelElement) {
            _matched = true;
            ModelElementContainer _container_3 = it.getContainer();
            _switchResult = this.findFirstParent((ModelElement)_container_3, cls, predicate);
        }
        return (C)_switchResult;
    }

    public <C extends ModelElement> C findLastParent(ModelElement it, Class<C> cls) {
        Functions.Function1 _function = new Functions.Function1<C, Boolean>(){

            public Boolean apply(C it) {
                return true;
            }
        };
        return this.findLastParent(it, cls, _function);
    }

    public <C extends ModelElement> C findLastParent(ModelElement it, Class<C> cls, Functions.Function1<? super C, ? extends Boolean> predicate) {
        return (C)((ModelElement)IterableExtensions.last((Iterable)IterableExtensions.filter(this.findParents(it, cls), predicate)));
    }

    public <C extends ModelElement> boolean hasParent(ModelElement it, Class<C> cls) {
        C _findFirstParent = this.findFirstParent(it, cls);
        return this.operator_notEquals((IdentifiableElement)_findFirstParent, null);
    }

    public <C extends Edge> Iterable<Node> findSourcesOf(Node node, Class<C> cls) {
        Functions.Function1 _function = new Functions.Function1<C, Node>(){

            public Node apply(C it) {
                return it.getSourceElement();
            }
        };
        return IterableExtensions.filterNull((Iterable)ListExtensions.map((List)node.getIncoming(cls), (Functions.Function1)_function));
    }

    public <C extends Edge> Node findSourceOf(Node node, Class<C> cls) {
        Edge edge;
        boolean _greaterThan;
        EList result = node.getIncoming(cls);
        int _size = result.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            int _size_1 = result.size();
            _builder.append((Object)_size_1);
            _builder.append(" incoming edges of type '");
            _builder.append(cls);
            _builder.append("' found.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("Exactly one was expected when calling method 'findSourceOf' on node ");
            _builder.append((Object)node, "  ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder);
        }
        if (this.operator_notEquals((IdentifiableElement)(edge = (Edge)IterableExtensions.head((Iterable)result)), null) && this.operator_equals((IdentifiableElement)edge.getSourceElement(), null)) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Source element of edge ");
            _builder_1.append((Object)edge);
            _builder_1.append(" is null.");
            _builder_1.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder_1);
        }
        Node _sourceElement = null;
        if (edge != null) {
            _sourceElement = edge.getSourceElement();
        }
        return _sourceElement;
    }

    public <C extends Edge> Node findSourceOf(Node node, Class<C> cls, Functions.Function1<? super C, ? extends Boolean> predicate) {
        Edge edge;
        boolean _greaterThan;
        Iterable result = IterableExtensions.filter((Iterable)node.getIncoming(cls), predicate);
        int _size = IterableExtensions.size((Iterable)result);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            int _size_1 = IterableExtensions.size((Iterable)result);
            _builder.append((Object)_size_1);
            _builder.append(" incoming edges of type '");
            _builder.append(cls);
            _builder.append("' found that fulfill the specified predicate.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("Exactly one was expected when calling method 'findSourceOf' on node ");
            _builder.append((Object)node, "  ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder);
        }
        if (this.operator_notEquals((IdentifiableElement)(edge = (Edge)IterableExtensions.head((Iterable)result)), null) && this.operator_equals((IdentifiableElement)edge.getSourceElement(), null)) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Source element of edge ");
            _builder_1.append((Object)edge);
            _builder_1.append(" is null.");
            _builder_1.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder_1);
        }
        Node _sourceElement = null;
        if (edge != null) {
            _sourceElement = edge.getSourceElement();
        }
        return _sourceElement;
    }

    public <C extends Edge> Iterable<Node> findTargetsOf(Node node, Class<C> cls) {
        Functions.Function1 _function = new Functions.Function1<C, Node>(){

            public Node apply(C it) {
                return it.getTargetElement();
            }
        };
        return IterableExtensions.filterNull((Iterable)ListExtensions.map((List)node.getOutgoing(cls), (Functions.Function1)_function));
    }

    public <C extends Edge> Node findTargetOf(Node node, Class<C> cls) {
        Edge edge;
        boolean _greaterThan;
        EList result = node.getOutgoing(cls);
        int _size = result.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            int _size_1 = result.size();
            _builder.append((Object)_size_1);
            _builder.append(" outgoing edges of type '");
            _builder.append(cls);
            _builder.append("' found.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("Exactly one was expected when calling method 'findTargetOf' on node ");
            _builder.append((Object)node, "  ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder);
        }
        if (this.operator_notEquals((IdentifiableElement)(edge = (Edge)IterableExtensions.head((Iterable)result)), null) && this.operator_equals((IdentifiableElement)edge.getTargetElement(), null)) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Target element of edge ");
            _builder_1.append((Object)edge);
            _builder_1.append(" is null.");
            _builder_1.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder_1);
        }
        Node _targetElement = null;
        if (edge != null) {
            _targetElement = edge.getTargetElement();
        }
        return _targetElement;
    }

    public <C extends Edge> Node findTargetOf(Node node, Class<C> cls, Functions.Function1<? super C, ? extends Boolean> predicate) {
        Edge edge;
        boolean _greaterThan;
        Iterable result = IterableExtensions.filter((Iterable)node.getOutgoing(cls), predicate);
        int _size = IterableExtensions.size((Iterable)result);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            int _size_1 = IterableExtensions.size((Iterable)result);
            _builder.append((Object)_size_1);
            _builder.append(" outgoing edges of type '");
            _builder.append(cls);
            _builder.append("' found that fulfill the specified predicate.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("Exactly one was expected when calling method 'findTargetOf' on node ");
            _builder.append((Object)node, "  ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder);
        }
        if (this.operator_notEquals((IdentifiableElement)(edge = (Edge)IterableExtensions.head((Iterable)result)), null) && this.operator_equals((IdentifiableElement)edge.getTargetElement(), null)) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Target element of edge ");
            _builder_1.append((Object)edge);
            _builder_1.append(" is null.");
            _builder_1.newLineIfNotEmpty();
            this._codingExtension.warn(this, (CharSequence)_builder_1);
        }
        Node _targetElement = null;
        if (edge != null) {
            _targetElement = edge.getTargetElement();
        }
        return _targetElement;
    }

    public Set<Node> findSuccessors(Node node) {
        return this.findSuccessorsVia(node, Edge.class);
    }

    public Set<Node> findSuccessorsVia(Node node, Class<? extends Edge> ... classes) {
        return IterableExtensions.toSet(this.findSuccessorsVia_recurse(node, (Iterable)Conversions.doWrapArray(classes), CollectionLiterals.newHashSet()));
    }

    private Iterable<Node> findSuccessorsVia_recurse(Node node, final Iterable<Class<? extends Edge>> classes, final Set<Node> visited) {
        Functions.Function1<Edge, Boolean> _function;
        boolean _not;
        Iterable _xblockexpression = null;
        boolean _add = visited.add(node);
        boolean bl = _not = !_add;
        if (_not) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1<Edge, Boolean> typecheck = _function = new Functions.Function1<Edge, Boolean>(){

            public Boolean apply(final Edge edge) {
                Functions.Function1<Class<? extends Edge>, Boolean> _function = new Functions.Function1<Class<? extends Edge>, Boolean>(){

                    public Boolean apply(Class<? extends Edge> cls) {
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{edge})), cls));
                        return !_isEmpty;
                    }
                };
                return IterableExtensions.exists((Iterable)classes, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Edge, Node> _function_1 = new Functions.Function1<Edge, Node>(){

            public Node apply(Edge it) {
                return it.getTargetElement();
            }
        };
        Iterable successors = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)node.getOutgoing(), (Functions.Function1)typecheck), (Functions.Function1)_function_1);
        Functions.Function1<Node, Iterable<Node>> _function_2 = new Functions.Function1<Node, Iterable<Node>>(){

            public Iterable<Node> apply(Node it) {
                return GraphModelExtension.this.findSuccessorsVia_recurse(it, classes, visited);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)successors, (Functions.Function1)_function_2));
        _xblockexpression = Iterables.concat((Iterable)successors, (Iterable)_flatten);
        return _xblockexpression;
    }

    public Set<Node> findPredecessors(Node node) {
        return this.findPredecessorsVia(node, Edge.class);
    }

    public Set<Node> findPredecessorsVia(Node node, Class<? extends Edge> ... classes) {
        return IterableExtensions.toSet(this.findPredecessorsVia_recurse(node, (Iterable)Conversions.doWrapArray(classes), CollectionLiterals.newHashSet()));
    }

    private Iterable<Node> findPredecessorsVia_recurse(Node node, final Iterable<Class<? extends Edge>> classes, final Set<Node> visited) {
        Functions.Function1<Edge, Boolean> _function;
        boolean _not;
        Iterable _xblockexpression = null;
        boolean _add = visited.add(node);
        boolean bl = _not = !_add;
        if (_not) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1<Edge, Boolean> typecheck = _function = new Functions.Function1<Edge, Boolean>(){

            public Boolean apply(final Edge edge) {
                Functions.Function1<Class<? extends Edge>, Boolean> _function = new Functions.Function1<Class<? extends Edge>, Boolean>(){

                    public Boolean apply(Class<? extends Edge> cls) {
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{edge})), cls));
                        return !_isEmpty;
                    }
                };
                return IterableExtensions.exists((Iterable)classes, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Edge, Node> _function_1 = new Functions.Function1<Edge, Node>(){

            public Node apply(Edge it) {
                return it.getSourceElement();
            }
        };
        Iterable predecessors = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)node.getIncoming(), (Functions.Function1)typecheck), (Functions.Function1)_function_1);
        Functions.Function1<Node, Iterable<Node>> _function_2 = new Functions.Function1<Node, Iterable<Node>>(){

            public Iterable<Node> apply(Node it) {
                return GraphModelExtension.this.findPredecessorsVia_recurse(it, classes, visited);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)predecessors, (Functions.Function1)_function_2));
        _xblockexpression = Iterables.concat((Iterable)predecessors, (Iterable)_flatten);
        return _xblockexpression;
    }

    public <T extends Node> ArrayList<List<Node>> findPathsTo(Node node, final Class<T> clazz) {
        final ArrayList paths = CollectionLiterals.newArrayList();
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node succ) {
                Functions.Function1 _function = new Functions.Function1<T, Boolean>(){

                    public Boolean apply(T it) {
                        return true;
                    }
                };
                GraphModelExtension.this.collectPathsTo_recurse(succ, clazz, _function, CollectionLiterals.newArrayList(), paths, false);
            }
        };
        node.getSuccessors().forEach((Consumer)_function);
        return paths;
    }

    public <T extends Node> ArrayList<List<Node>> findPathsTo(Node node, final Class<T> clazz, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        final ArrayList paths = CollectionLiterals.newArrayList();
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node succ) {
                GraphModelExtension.this.collectPathsTo_recurse(succ, clazz, predicate, CollectionLiterals.newArrayList(), paths, false);
            }
        };
        node.getSuccessors().forEach((Consumer)_function);
        return paths;
    }

    public ArrayList<List<Node>> findPathsTo(Node startNode, final Node targetNode) {
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return GraphModelExtension.this.operator_equals((IdentifiableElement)it, (IdentifiableElement)targetNode);
            }
        };
        return this.findPathsToFirst(startNode, targetNode.getClass(), _function);
    }

    public <T extends Node> ArrayList<List<Node>> findPathsToFirst(Node node, final Class<T> clazz) {
        final ArrayList paths = CollectionLiterals.newArrayList();
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node succ) {
                Functions.Function1 _function = new Functions.Function1<T, Boolean>(){

                    public Boolean apply(T it) {
                        return true;
                    }
                };
                GraphModelExtension.this.collectPathsTo_recurse(succ, clazz, _function, CollectionLiterals.newArrayList(), paths, true);
            }
        };
        node.getSuccessors().forEach((Consumer)_function);
        return paths;
    }

    public <T extends Node> ArrayList<List<Node>> findPathsToFirst(Node node, final Class<T> clazz, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        final ArrayList paths = CollectionLiterals.newArrayList();
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node succ) {
                GraphModelExtension.this.collectPathsTo_recurse(succ, clazz, predicate, CollectionLiterals.newArrayList(), paths, true);
            }
        };
        node.getSuccessors().forEach((Consumer)_function);
        return paths;
    }

    private <T extends Node> void collectPathsTo_recurse(Node node, final Class<T> clazz, final Functions.Function1<? super T, ? extends Boolean> predicate, final List<Node> path, final Collection<List<Node>> paths, final boolean stopAtFirst) {
        path.add(node);
        if (clazz.isAssignableFrom(node.getClass()) && ((Boolean)predicate.apply((Object)node)).booleanValue()) {
            paths.add(path);
            if (stopAtFirst) {
                return;
            }
        }
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                boolean _contains = path.contains(it);
                return !_contains;
            }
        };
        Consumer<Node> _function_1 = new Consumer<Node>(){

            @Override
            public void accept(Node succ) {
                GraphModelExtension.this.collectPathsTo_recurse(succ, clazz, predicate, CollectionLiterals.newArrayList((Object[])((Node[])Conversions.unwrapArray((Object)path, Node.class))), paths, stopAtFirst);
            }
        };
        IterableExtensions.filter((Iterable)node.getSuccessors(), (Functions.Function1)_function).forEach(_function_1);
    }

    public boolean isInstanceOf(EObject obj, final Class<? extends EObject> cls) {
        return obj != null && (Objects.equal((Object)obj.eClass().getName(), (Object)cls.getSimpleName()) || IterableExtensions.exists((Iterable)obj.eClass().getEAllSuperTypes(), (Functions.Function1)new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                String _simpleName = cls.getSimpleName();
                return Objects.equal((Object)_name, (Object)_simpleName);
            }
        }));
    }

    public Iterable<IdentifiableElement> withChildren(ModelElementContainer container) {
        EList _modelElements = container.getModelElements();
        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElementContainer[]{container})), (Iterable)_modelElements);
    }

    public <C extends Collection<T>, T> C withAll(C collection, final Iterable<T> toBeIncluded) {
        Procedures.Procedure1 _function = new Procedures.Procedure1<C>(){

            public void apply(C it) {
                Iterables.addAll(it, (Iterable)toBeIncluded);
            }
        };
        return (C)((Collection)ObjectExtensions.operator_doubleArrow(collection, (Procedures.Procedure1)_function));
    }

    public GraphModel getRootElement(Type type) {
        GraphModel _xblockexpression = null;
        EObject container = type.eContainer();
        while (!(container instanceof InternalGraphModel) && container != null) {
            container = container.eContainer();
        }
        GraphModel _xifexpression = null;
        _xifexpression = container == null ? null : ((InternalGraphModel)container).getElement();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Iterable<InternalModelElement> getModelElement(final Type t) {
        boolean _tripleEquals;
        Iterable _xblockexpression = null;
        Resource _eResource = t.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            return null;
        }
        GraphModel gm = new ResourceExtension().getGraphModel(t.eResource());
        Functions.Function1<ModelElement, InternalModelElement> _function = new Functions.Function1<ModelElement, InternalModelElement>(){

            public InternalModelElement apply(ModelElement it) {
                return it.getInternalElement_();
            }
        };
        Functions.Function1<InternalModelElement, Boolean> _function_1 = new Functions.Function1<InternalModelElement, Boolean>(){

            public Boolean apply(InternalModelElement it) {
                return GraphModelExtension.this.containsType((EObject)it, t);
            }
        };
        _xblockexpression = IterableExtensions.filter((Iterable)ListExtensions.map((List)gm.getModelElements(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    private boolean containsType(EObject me, final Type t) {
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                boolean _or = false;
                boolean _equals = Objects.equal((Object)it, (Object)t);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _xifexpression = false;
                    _xifexpression = it instanceof Type ? GraphModelExtension.this.containsType((EObject)((Type)it).getInternalElement_(), t) : false;
                    _or = _xifexpression;
                }
                return _or;
            }
        };
        return IteratorExtensions.exists((Iterator)me.eAllContents(), (Functions.Function1)_function);
    }

    public Direction getResizeDirection(int oldWidth, int oldHeight, int oldX, int oldY, int newWidth, int newHeight, int newX, int newY) {
        boolean north = oldY - newY == 0;
        boolean west = oldX - newX == 0;
        boolean south = newHeight - oldHeight - (oldY - newY) == 0;
        boolean east = newWidth - oldWidth - (oldX - newX) == 0;
        Direction _xifexpression = null;
        if (!north && east && south && west) {
            _xifexpression = Direction.NORTH;
        } else {
            Direction _xifexpression_1 = null;
            if (!north && !east && south && west) {
                _xifexpression_1 = Direction.NORTH_EAST;
            } else {
                Direction _xifexpression_2 = null;
                if (north && !east && south && west) {
                    _xifexpression_2 = Direction.EAST;
                } else {
                    Direction _xifexpression_3 = null;
                    if (north && !east && !south && west) {
                        _xifexpression_3 = Direction.SOUTH_EAST;
                    } else {
                        Direction _xifexpression_4 = null;
                        if (north && east && !south && west) {
                            _xifexpression_4 = Direction.SOUTH;
                        } else {
                            Direction _xifexpression_5 = null;
                            if (north && east && !south && !west) {
                                _xifexpression_5 = Direction.SOUTH_WEST;
                            } else {
                                Direction _xifexpression_6 = null;
                                if (north && east && south && !west) {
                                    _xifexpression_6 = Direction.WEST;
                                } else {
                                    Direction _xifexpression_7 = null;
                                    _xifexpression_7 = !north && east && south && !west ? Direction.NORTH_WEST : Direction.UNSPECIFIED;
                                    _xifexpression_6 = _xifexpression_7;
                                }
                                _xifexpression_5 = _xifexpression_6;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String getArrow(Direction direction) {
        String _switchResult = null;
        if (direction != null) {
            switch (direction) {
                case NORTH: {
                    _switchResult = "\u2191";
                    break;
                }
                case NORTH_EAST: {
                    _switchResult = "\u2197\ufe0e";
                    break;
                }
                case EAST: {
                    _switchResult = "\u2192";
                    break;
                }
                case SOUTH_EAST: {
                    _switchResult = "\u2198\ufe0e";
                    break;
                }
                case SOUTH: {
                    _switchResult = "\u2193";
                    break;
                }
                case SOUTH_WEST: {
                    _switchResult = "\u2199\ufe0e";
                    break;
                }
                case WEST: {
                    _switchResult = "\u2190";
                    break;
                }
                case NORTH_WEST: {
                    _switchResult = "\u2196\ufe0e";
                    break;
                }
                default: {
                    _switchResult = "?";
                    break;
                }
            }
        } else {
            _switchResult = "?";
        }
        return _switchResult;
    }
}

