/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.runtime.xapi;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DiagramExtension {
    public IDiagramTypeProvider getDiagramTypeProvider(Diagram diagram) {
        IDiagramTypeProvider _xblockexpression = null;
        WorkbenchExtension ext = new WorkbenchExtension();
        DiagramEditor _editor = ext.getEditor(diagram);
        IDiagramTypeProvider _diagramTypeProvider = null;
        if (_editor != null) {
            _diagramTypeProvider = _editor.getDiagramTypeProvider();
        }
        _xblockexpression = _diagramTypeProvider;
        return _xblockexpression;
    }

    public IFeatureProvider getFeatureProvider(Diagram diagram) {
        IDiagramTypeProvider _diagramTypeProvider = this.getDiagramTypeProvider(diagram);
        IFeatureProvider _featureProvider = null;
        if (_diagramTypeProvider != null) {
            _featureProvider = _diagramTypeProvider.getFeatureProvider();
        }
        return _featureProvider;
    }

    public ArrayList<ContainerShape> getContainerShapes(ContainerShape parent) {
        return this.getContainerShapes(parent, false);
    }

    public ArrayList<ContainerShape> getContainerShapes(ContainerShape parent, boolean includeParent) {
        ArrayList shapes = CollectionLiterals.newArrayList();
        if (includeParent) {
            shapes.add(parent);
        }
        this.collectChildShapes(parent, shapes, ContainerShape.class);
        return shapes;
    }

    public PictogramElement getPictogramElement(Diagram diagram, final EObject businessObject) {
        Functions.Function1<PictogramLink, Boolean> _function = new Functions.Function1<PictogramLink, Boolean>(){

            public Boolean apply(PictogramLink it) {
                Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                    public Boolean apply(EObject it) {
                        return EcoreUtil.equals((EObject)it, (EObject)businessObject);
                    }
                };
                return IterableExtensions.exists((Iterable)it.getBusinessObjects(), (Functions.Function1)_function);
            }
        };
        Functions.Function1<PictogramLink, PictogramElement> _function_1 = new Functions.Function1<PictogramLink, PictogramElement>(){

            public PictogramElement apply(PictogramLink it) {
                return it.getPictogramElement();
            }
        };
        Functions.Function1<PictogramElement, Boolean> _function_2 = new Functions.Function1<PictogramElement, Boolean>(){

            public Boolean apply(PictogramElement it) {
                return it != null;
            }
        };
        return (PictogramElement)IterableExtensions.findFirst((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)diagram.getPictogramLinks(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    public List<Shape> getShapes(ContainerShape parent) {
        return this.getShapes(parent, false);
    }

    public List<Shape> getShapes(ContainerShape parent, boolean includeParent) {
        List<Shape> _xblockexpression = null;
        ArrayList shapes = CollectionLiterals.newArrayList();
        if (includeParent) {
            shapes.add(parent);
        }
        _xblockexpression = this.collectChildShapes(parent, shapes);
        return _xblockexpression;
    }

    public <T extends Shape> List<T> getShapes(ContainerShape parent, Class<T> clazz) {
        return this.getShapes(parent, clazz, false);
    }

    public <T extends Shape> List<T> getShapes(ContainerShape parent, Class<T> clazz, boolean includeParent) {
        List<T> _xblockexpression = null;
        ArrayList shapes = CollectionLiterals.newArrayList();
        if (includeParent && clazz.isInstance(parent)) {
            shapes.add((Shape)clazz.cast(parent));
        }
        _xblockexpression = this.collectChildShapes(parent, shapes, clazz);
        return _xblockexpression;
    }

    private <T extends Shape> List<T> collectChildShapes(ContainerShape container, List<T> shapes) {
        return this.collectChildShapes(container, shapes, null);
    }

    private <T extends Shape> List<T> collectChildShapes(ContainerShape container, final List<T> shapes, final Class<T> cls) {
        EList _children = null;
        if (container != null) {
            _children = container.getChildren();
        }
        Iterable _filter = null;
        if (_children != null) {
            Functions.Function1<Shape, Boolean> _function = new Functions.Function1<Shape, Boolean>(){

                public Boolean apply(Shape child) {
                    return cls == null || cls.isInstance(child);
                }
            };
            _filter = IterableExtensions.filter((Iterable)_children, (Functions.Function1)_function);
        }
        Consumer<Shape> _function_1 = new Consumer<Shape>(){

            @Override
            public void accept(Shape child) {
                shapes.add(child);
                if (child instanceof ContainerShape) {
                    DiagramExtension.this.collectChildShapes((ContainerShape)child, shapes, cls);
                }
            }
        };
        _filter.forEach(_function_1);
        return shapes;
    }

    public void refresh(final Diagram diagram) {
        final WorkbenchExtension ext = new WorkbenchExtension();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                DiagramBehavior _diagramBehavior = ext.getDiagramBehavior(diagram);
                if (_diagramBehavior != null) {
                    _diagramBehavior.refreshContent();
                }
            }
        };
        ext.async(_function);
    }

    public void refreshDiagramEditor(final Diagram diagram) {
        final WorkbenchExtension ext = new WorkbenchExtension();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                DiagramBehavior _diagramBehavior = ext.getDiagramBehavior(diagram);
                if (_diagramBehavior != null) {
                    _diagramBehavior.refresh();
                }
            }
        };
        ext.async(_function);
    }
}

