/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.runtime.layout;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.layout.NodeCannotBeMovedToContainerException;
import graphmodel.Container;
import graphmodel.GraphModel;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class NodeExtensions {
    public Iterable<Node> collectAllNodesInModel(GraphModel model) {
        final LinkedList<Node> result = new LinkedList<Node>();
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node n) {
                NodeExtensions.this.collectAllNodesInModel(n, result);
            }
        };
        model.getAllNodes().forEach((Consumer)_function);
        return result;
    }

    private void collectAllNodesInModel(Node node, final LinkedList<Node> result) {
        result.add(node);
        if (node instanceof Container) {
            Consumer<Node> _function = new Consumer<Node>(){

                @Override
                public void accept(Node n) {
                    NodeExtensions.this.collectAllNodesInModel(n, result);
                }
            };
            ((Container)node).getAllNodes().forEach((Consumer)_function);
        }
    }

    public Iterable<Node> collectAllNodesInModel(Node node) {
        return this.collectAllNodesInModel(node.getRootElement());
    }

    public void autoResize(Container container, int padding) {
        int minimalY;
        this.moveAllContainedNodesToNonNegativeKoordiantes(container);
        EList innerNodes = container.getAllNodes();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)innerNodes);
        if (_isEmpty) {
            container.resize(2 * padding, 2 * padding);
            return;
        }
        int minimalX = this.minimalX((Iterable<Node>)innerNodes);
        if (minimalX != padding) {
            for (Node node : innerNodes) {
                int _x = node.getX();
                int _plus = _x + padding;
                int _minus = _plus - minimalX;
                node.move(_minus, node.getY());
            }
        }
        if ((minimalY = this.minimalY((Iterable<Node>)innerNodes)) != padding) {
            for (Node node_1 : innerNodes) {
                int _x_1 = node_1.getX();
                int _y = node_1.getY();
                int _plus_1 = _y + padding;
                int _minus_1 = _plus_1 - minimalY;
                node_1.move(_x_1, _minus_1);
            }
        }
        int _maximalBottomX = this.maximalBottomX((Iterable<Node>)innerNodes);
        int _plus_2 = padding + _maximalBottomX;
        int _maximalRightY = this.maximalRightY((Iterable<Node>)innerNodes);
        int _plus_3 = padding + _maximalRightY;
        container.resize(_plus_2, _plus_3);
    }

    public void autoResize(Container container) {
        this.autoResize(container, 30);
    }

    private void moveAllContainedNodesToNonNegativeKoordiantes(Container container) {
        EList innerNodes = container.getAllNodes();
        final int minimalX = this.minimalX((Iterable<Node>)innerNodes);
        final int minimalY = this.minimalY((Iterable<Node>)innerNodes);
        if (minimalX < 0) {
            Consumer<Node> _function = new Consumer<Node>(){

                @Override
                public void accept(Node n) {
                    int _x = n.getX();
                    int _minus = _x - minimalX;
                    n.move(_minus, n.getY());
                }
            };
            innerNodes.forEach(_function);
        }
        if (minimalY < 0) {
            Consumer<Node> _function_1 = new Consumer<Node>(){

                @Override
                public void accept(Node n) {
                    int _x = n.getX();
                    int _y = n.getY();
                    int _minus = _y - minimalY;
                    n.move(_x, _minus);
                }
            };
            innerNodes.forEach(_function_1);
        }
    }

    public void moveNodeToContainer(Node movedNode, ModelElementContainer container, int xPos, int yPos) throws NodeCannotBeMovedToContainerException {
        boolean _canMoveTo = movedNode.canMoveTo(container);
        if (!_canMoveTo) {
            throw new NodeCannotBeMovedToContainerException("Child cannot be moved To Parent", movedNode, container);
        }
        movedNode.moveTo(container, xPos, yPos);
    }

    public void alignNodeOverlapping(Node movedNode, Node anchor, int distanceX, int distanceY) throws NodeCannotBeMovedToContainerException {
        int _x = anchor.getX();
        int xPos = _x + distanceX;
        int _y = anchor.getY();
        int yPos = _y + distanceY;
        ModelElementContainer newParent = anchor.getContainer();
        this.moveNodeToContainer(movedNode, newParent, xPos, yPos);
    }

    public void alignNode(Node movedNode, Node anchor, int distanceX, int distanceY) throws NodeCannotBeMovedToContainerException {
        int _width = movedNode.getWidth();
        int _plus = distanceX + _width;
        int _height = movedNode.getHeight();
        int _plus_1 = distanceY + _height;
        this.alignNodeOverlapping(movedNode, anchor, _plus, _plus_1);
    }

    public void alignNodesAsCircle(Iterable<Node> nodes, ModelElementContainer cont, int centerX, int centerY, int radius) throws NodeCannotBeMovedToContainerException {
        int N = ((Object[])Conversions.unwrapArray(nodes, Object.class)).length;
        int n = 0;
        while (n < N) {
            Node node = ((Node[])Conversions.unwrapArray(nodes, Node.class))[n];
            double _cos = Math.cos(1.0 * (double)n / (double)N * 2.0 * Math.PI);
            double _multiply = (double)radius * _cos;
            double _plus = _multiply + (double)centerX;
            int _width = node.getWidth();
            int _divide = _width / 2;
            double x = _plus - (double)_divide;
            double _sin = Math.sin(1.0 * (double)n / (double)N * 2.0 * Math.PI);
            double _multiply_1 = (double)radius * _sin;
            double _plus_1 = _multiply_1 + (double)centerY;
            int _height = node.getHeight();
            int _divide_1 = _height / 2;
            double y = _plus_1 - (double)_divide_1;
            this.moveNodeToContainer(node, cont, Double.valueOf(x).intValue(), Double.valueOf(y).intValue());
            ++n;
        }
    }

    public void alignNodesAsOverlappingRow(Node anchor, Iterable<Node> nodes, int[] distances, int degree) throws NodeCannotBeMovedToContainerException {
        boolean _lessEqualsThan;
        int _size = IterableExtensions.size(nodes);
        boolean bl = _lessEqualsThan = _size <= 0;
        if (_lessEqualsThan) {
            return;
        }
        Node anch = anchor;
        int deg = degree % 360;
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < IterableExtensions.size(nodes)) {
            double _cos = Math.cos(Math.toRadians(deg));
            int _get = distances[i];
            double _multiply = _cos * (double)_get;
            x = (int)_multiply;
            double _sin = Math.sin(Math.toRadians(deg));
            int _get_1 = distances[i];
            double _multiply_1 = _sin * (double)_get_1;
            y = (int)_multiply_1;
            this.alignNodeOverlapping(((Node[])Conversions.unwrapArray(nodes, Node.class))[i], anch, x, y);
            anch = ((Node[])Conversions.unwrapArray(nodes, Node.class))[i];
            ++i;
        }
    }

    public void alignNodesAsOverlappingRow(Node anchor, Iterable<Node> nodes, int distance, int degree) throws NodeCannotBeMovedToContainerException {
        int[] distances = new int[IterableExtensions.size(nodes)];
        int i = 0;
        while (i < ((List)Conversions.doWrapArray((Object)distances)).size()) {
            distances[i] = distance;
            ++i;
        }
        this.alignNodesAsOverlappingRow(anchor, nodes, distances, degree);
    }

    public void alignNodesAsOverlappingRow(Iterable<Node> nodes, int distance, LineOfAlignment align) throws NodeCannotBeMovedToContainerException {
        Node anchor = (Node)IterableExtensions.head(nodes);
        if (align != null) {
            switch (align) {
                case Horizontal: {
                    this.alignNodesAsOverlappingRow(anchor, nodes, distance, 0);
                    break;
                }
                case MainDiagonal: {
                    this.alignNodesAsOverlappingRow(anchor, nodes, distance, 45);
                    break;
                }
                case Vertical: {
                    this.alignNodesAsOverlappingRow(anchor, nodes, distance, 90);
                    break;
                }
                case SecondaryDiagonal: {
                    this.alignNodesAsOverlappingRow(anchor, nodes, distance, 135);
                    break;
                }
            }
        }
    }

    public void alignNodesAsRow(Node anchor, Iterable<Node> nodes, int[] distances, int degree) throws NodeCannotBeMovedToContainerException {
        int _plus_1;
        int _size = IterableExtensions.size(nodes);
        int _plus = _size + 1;
        int[] dist = new int[_plus];
        int z = 0;
        z = this.calculateDiameterforAlignNodesAsRow(anchor, degree);
        int _get = distances[0];
        dist[0] = _plus_1 = z + _get;
        int i = 0;
        while (i < IterableExtensions.size(nodes)) {
            int _plus_2;
            z = this.calculateDiameterforAlignNodesAsRow(((Node[])Conversions.unwrapArray(nodes, Node.class))[i], degree);
            int _get_1 = distances[i + 1];
            dist[i + 1] = _plus_2 = z + _get_1;
            ++i;
        }
        this.alignNodesAsOverlappingRow(anchor, nodes, dist, degree);
    }

    public void alignNodesAsRow(Node anchor, Iterable<Node> nodes, int distance, int degree) throws NodeCannotBeMovedToContainerException {
        int _size = IterableExtensions.size(nodes);
        int _plus = _size + 1;
        int[] distances = new int[_plus];
        int i = 0;
        while (i < ((List)Conversions.doWrapArray((Object)distances)).size()) {
            distances[i] = distance;
            ++i;
        }
        this.alignNodesAsRow(anchor, nodes, distances, degree);
    }

    public void alignNodesAsRow(Iterable<Node> nodes, int distance, LineOfAlignment align) throws NodeCannotBeMovedToContainerException {
        Node anchor = (Node)IterableExtensions.head(nodes);
        if (align != null) {
            switch (align) {
                case Horizontal: {
                    this.alignNodesAsRow(anchor, nodes, distance, 0);
                    break;
                }
                case MainDiagonal: {
                    this.alignNodesAsRow(anchor, nodes, distance, 45);
                    break;
                }
                case Vertical: {
                    this.alignNodesAsRow(anchor, nodes, distance, 90);
                    break;
                }
                case SecondaryDiagonal: {
                    this.alignNodesAsRow(anchor, nodes, distance, 135);
                    break;
                }
            }
        }
    }

    public void alignNodesAsOverlappingGrid(Node anch, Iterable<Node> nodes, int distanceX, int degreeX, int breakNumber, int distanceY, int degreeY, NodeResizing rez) throws NodeCannotBeMovedToContainerException {
        int _size_2;
        int _i;
        boolean _lessThan_2;
        boolean _lessThan_1;
        int _size;
        boolean _lessThan;
        int break_ = breakNumber;
        Node anchor = anch;
        if (rez != null) {
            switch (rez) {
                case WidenNodesToGreatestNodeSize: {
                    this.WidenNodesToGreatestNodeSize(Iterables.concat(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Node[]{anchor})), nodes));
                    break;
                }
                case ShrinkNodesToSmallestNodeSize: {
                    this.ShrinkNodesToSmallestNodeSize(Iterables.concat(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Node[]{anchor})), nodes));
                    break;
                }
            }
        }
        boolean bl = _lessThan = (_size = IterableExtensions.size(nodes)) < 1;
        if (_lessThan) {
            return;
        }
        if (breakNumber <= 0) {
            break_ = Integer.MAX_VALUE;
        }
        LinkedList<Node> firstColumn = new LinkedList<Node>();
        int i = -1;
        int _size_1 = IterableExtensions.size(nodes);
        boolean _while = _lessThan_1 = i < _size_1;
        while (_while) {
            if (i > -1) {
                firstColumn.add((Node)IterableExtensions.toList(nodes).get(i));
            }
            _while = _lessThan_2 = (i = (_i = i) + breakNumber) < (_size_2 = IterableExtensions.size(nodes));
        }
        this.alignNodesAsOverlappingRow(anch, firstColumn, distanceY, degreeY);
        i = -1;
        _size_1 = IterableExtensions.size(nodes);
        _while = _lessThan_1 = i < _size_1;
        while (_while) {
            if (i > -1) {
                anchor = (Node)IterableExtensions.toList(nodes).get(i);
            }
            this.alignNodesAsOverlappingRow(anchor, IterableExtensions.toList(nodes).subList(i + 1, Math.min(i + breakNumber, IterableExtensions.size(nodes))), distanceX, degreeX);
            _i = i;
            i = _i + break_;
            _size_2 = IterableExtensions.size(nodes);
            _while = _lessThan_2 = i < _size_2;
        }
    }

    public void alignNodesAsOverlappingGrid(Iterable<Node> nodes, int distance, LineOfAlignment align) throws NodeCannotBeMovedToContainerException {
        int _size;
        boolean _notEquals;
        int degreeX = 0;
        int degreeY = 0;
        double _sqrt = Math.sqrt(IterableExtensions.size(nodes));
        int breakNumber = (int)_sqrt;
        boolean bl = _notEquals = breakNumber * breakNumber != (_size = IterableExtensions.size(nodes));
        if (_notEquals) {
            ++breakNumber;
        }
        if (align != null) {
            switch (align) {
                case Horizontal: {
                    degreeX = 0;
                    degreeY = 90;
                    break;
                }
                case MainDiagonal: {
                    degreeX = 45;
                    degreeY = 135;
                    break;
                }
                case Vertical: {
                    degreeX = 90;
                    degreeY = 0;
                    break;
                }
                case SecondaryDiagonal: {
                    degreeX = 135;
                    degreeY = 45;
                    break;
                }
            }
        }
        this.alignNodesAsOverlappingGrid((Node)IterableExtensions.head(nodes), IterableExtensions.tail(nodes), distance, degreeX, breakNumber, distance, degreeY, NodeResizing.NoResizing);
    }

    public void alignNodesAsGrid(Node anch, Iterable<Node> nodes, int distanceX, int degreeX, int breakNumber, int distanceY, int degreeY, NodeResizing rez) throws NodeCannotBeMovedToContainerException {
        int _size_3;
        int _i;
        boolean _lessThan_2;
        boolean _lessThan_1;
        int _size;
        boolean _lessThan;
        int break_ = breakNumber;
        Node anchor = anch;
        if (rez != null) {
            switch (rez) {
                case WidenNodesToGreatestNodeSize: {
                    this.WidenNodesToGreatestNodeSize(Iterables.concat(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Node[]{anchor})), nodes));
                    break;
                }
                case ShrinkNodesToSmallestNodeSize: {
                    this.ShrinkNodesToSmallestNodeSize(Iterables.concat(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Node[]{anchor})), nodes));
                    break;
                }
            }
        }
        boolean bl = _lessThan = (_size = IterableExtensions.size(nodes)) < 1;
        if (_lessThan) {
            return;
        }
        if (break_ <= 0) {
            int _plus;
            int _size_1 = IterableExtensions.size(nodes);
            break_ = _plus = _size_1 + 1;
        }
        LinkedList<Node> firstColumn = new LinkedList<Node>();
        int i = -1;
        int _size_2 = IterableExtensions.size(nodes);
        boolean _while = _lessThan_1 = i < _size_2;
        while (_while) {
            if (i > -1) {
                firstColumn.add((Node)IterableExtensions.toList(nodes).get(i));
            }
            _while = _lessThan_2 = (i = (_i = i) + breakNumber) < (_size_3 = IterableExtensions.size(nodes));
        }
        this.alignNodesAsRow(anch, firstColumn, distanceY, degreeY);
        i = -1;
        _size_2 = IterableExtensions.size(nodes);
        _while = _lessThan_1 = i < _size_2;
        while (_while) {
            if (i > -1) {
                anchor = (Node)IterableExtensions.toList(nodes).get(i);
            }
            this.alignNodesAsRow(anchor, IterableExtensions.toList(nodes).subList(i + 1, Math.min(i + breakNumber, IterableExtensions.size(nodes))), distanceX, degreeX);
            _i = i;
            i = _i + breakNumber;
            _size_3 = IterableExtensions.size(nodes);
            _while = _lessThan_2 = i < _size_3;
        }
    }

    public void alignNodesAsGrid(Iterable<Node> nodes, int distance, LineOfAlignment align) throws NodeCannotBeMovedToContainerException {
        int _size;
        boolean _notEquals;
        int degreeX = 0;
        int degreeY = 0;
        double _sqrt = Math.sqrt(IterableExtensions.size(nodes));
        int breakNumber = (int)_sqrt;
        boolean bl = _notEquals = breakNumber * breakNumber != (_size = IterableExtensions.size(nodes));
        if (_notEquals) {
            ++breakNumber;
        }
        if (align != null) {
            switch (align) {
                case Horizontal: {
                    degreeX = 0;
                    degreeY = 90;
                    break;
                }
                case MainDiagonal: {
                    degreeX = 45;
                    degreeY = 135;
                    break;
                }
                case Vertical: {
                    degreeX = 90;
                    degreeY = 0;
                    break;
                }
                case SecondaryDiagonal: {
                    degreeX = 135;
                    degreeY = 45;
                    break;
                }
            }
        }
        this.alignNodesAsGrid((Node)IterableExtensions.head(nodes), IterableExtensions.tail(nodes), distance, degreeX, breakNumber, distance, degreeY, NodeResizing.NoResizing);
    }

    private int minimalX(Iterable<Node> nodes) {
        int x = Integer.MAX_VALUE;
        for (Node node : nodes) {
            boolean _lessThan;
            int _x = node.getX();
            boolean bl = _lessThan = _x < x;
            if (!_lessThan) continue;
            x = node.getX();
        }
        return x;
    }

    private int minimalY(Iterable<Node> nodes) {
        int y = Integer.MAX_VALUE;
        for (Node node : nodes) {
            boolean _lessThan;
            int _y = node.getY();
            boolean bl = _lessThan = _y < y;
            if (!_lessThan) continue;
            y = node.getY();
        }
        return y;
    }

    private int maximalBottomX(Iterable<Node> nodes) {
        int x = 0;
        for (Node node : nodes) {
            int _plus_1;
            boolean _greaterThan;
            int _x;
            int _width = node.getWidth();
            int _plus = _width + (_x = node.getX());
            boolean bl = _greaterThan = _plus > x;
            if (!_greaterThan) continue;
            int _width_1 = node.getWidth();
            int _x_1 = node.getX();
            x = _plus_1 = _width_1 + _x_1;
        }
        return x;
    }

    private int maximalRightY(Iterable<Node> nodes) {
        int y = 0;
        for (Node node : nodes) {
            int _plus_1;
            boolean _greaterThan;
            int _y;
            int _height = node.getHeight();
            int _plus = _height + (_y = node.getY());
            boolean bl = _greaterThan = _plus > y;
            if (!_greaterThan) continue;
            int _height_1 = node.getHeight();
            int _y_1 = node.getY();
            y = _plus_1 = _height_1 + _y_1;
        }
        return y;
    }

    private int maximalNodeSizeHorizontal(Iterable<Node> nodes) {
        int x = 0;
        for (Node node : nodes) {
            boolean _greaterThan;
            int _width = node.getWidth();
            boolean bl = _greaterThan = _width > x;
            if (!_greaterThan) continue;
            x = node.getWidth();
        }
        return x;
    }

    private int maximalNodeSizeVertical(Iterable<Node> nodes) {
        int y = 0;
        for (Node node : nodes) {
            boolean _greaterThan;
            int _height = node.getHeight();
            boolean bl = _greaterThan = _height > y;
            if (!_greaterThan) continue;
            y = node.getHeight();
        }
        return y;
    }

    private int minimalNodeSizeHorizontal(Iterable<Node> nodes) {
        int x = Integer.MAX_VALUE;
        for (Node node : nodes) {
            boolean _lessThan;
            int _width = node.getWidth();
            boolean bl = _lessThan = _width < x;
            if (!_lessThan) continue;
            x = node.getWidth();
        }
        return x;
    }

    private int minimalNodeSizeVertical(Iterable<Node> nodes) {
        int y = Integer.MAX_VALUE;
        for (Node node : nodes) {
            boolean _lessThan;
            int _height = node.getHeight();
            boolean bl = _lessThan = _height < y;
            if (!_lessThan) continue;
            y = node.getHeight();
        }
        return y;
    }

    private void WidenNodesToGreatestNodeSize(Iterable<Node> nodes) {
        final int newX = this.maximalNodeSizeHorizontal(nodes);
        final int newY = this.maximalNodeSizeVertical(nodes);
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node node) {
                node.resize(newX, newY);
            }
        };
        nodes.forEach(_function);
    }

    private void ShrinkNodesToSmallestNodeSize(Iterable<Node> nodes) {
        final int newX = this.minimalNodeSizeHorizontal(nodes);
        final int newY = this.minimalNodeSizeVertical(nodes);
        Consumer<Node> _function = new Consumer<Node>(){

            @Override
            public void accept(Node node) {
                node.resize(newX, newY);
            }
        };
        nodes.forEach(_function);
    }

    private int calculateDiameterforAlignNodesAsRow(Node node, int degree) {
        int _x = node.getX();
        int _width = node.getWidth();
        double _multiply = 0.5 * (double)_width;
        double MX = (double)_x + _multiply;
        int _y = node.getY();
        int _height = node.getHeight();
        double _multiply_1 = 0.5 * (double)_height;
        double MY = (double)_y + _multiply_1;
        double M = Math.tan(Math.toRadians(degree));
        double B = MY - MX * M;
        boolean first = true;
        double X1 = 0.0;
        double X2 = 0.0;
        double Y1 = 0.0;
        double Y2 = 0.0;
        if ((double)node.getX() <= ((double)node.getY() - B) / M && ((double)node.getY() - B) / M < (double)(node.getX() + node.getWidth())) {
            if (first) {
                double _divide;
                int _y_1 = node.getY();
                double _minus = (double)_y_1 - B;
                X1 = _divide = _minus / M;
                Y1 = node.getY();
                first = false;
            } else {
                double _divide_1;
                int _y_2 = node.getY();
                double _minus_1 = (double)_y_2 - B;
                X2 = _divide_1 = _minus_1 / M;
                Y2 = node.getY();
            }
        }
        if ((double)node.getY() <= M * (double)(node.getX() + node.getWidth()) + B && M * (double)(node.getX() + node.getWidth()) + B < (double)(node.getY() + node.getHeight())) {
            if (first) {
                double _plus_2;
                int _x_1 = node.getX();
                int _width_1 = node.getWidth();
                int _plus = _x_1 + _width_1;
                X1 = _plus;
                int _x_2 = node.getX();
                int _width_2 = node.getWidth();
                int _plus_1 = _x_2 + _width_2;
                double _multiply_2 = M * (double)_plus_1;
                Y1 = _plus_2 = _multiply_2 + B;
                first = false;
            } else {
                double _plus_5;
                int _x_3 = node.getX();
                int _width_3 = node.getWidth();
                int _plus_3 = _x_3 + _width_3;
                X2 = _plus_3;
                int _x_4 = node.getX();
                int _width_4 = node.getWidth();
                int _plus_4 = _x_4 + _width_4;
                double _multiply_3 = M * (double)_plus_4;
                Y2 = _plus_5 = _multiply_3 + B;
            }
        }
        if ((double)node.getX() < ((double)(node.getY() + node.getHeight()) - B) / M && ((double)(node.getY() + node.getHeight()) - B) / M <= (double)(node.getX() + node.getWidth())) {
            if (first) {
                double _divide_2;
                int _y_3 = node.getY();
                int _height_1 = node.getHeight();
                int _plus_6 = _y_3 + _height_1;
                double _minus_2 = (double)_plus_6 - B;
                X1 = _divide_2 = _minus_2 / M;
                int _y_4 = node.getY();
                int _height_2 = node.getHeight();
                int _plus_7 = _y_4 + _height_2;
                Y1 = _plus_7;
                first = false;
            } else {
                double _divide_3;
                int _y_5 = node.getY();
                int _height_3 = node.getHeight();
                int _plus_8 = _y_5 + _height_3;
                double _minus_3 = (double)_plus_8 - B;
                X2 = _divide_3 = _minus_3 / M;
                int _y_6 = node.getY();
                int _height_4 = node.getHeight();
                int _plus_9 = _y_6 + _height_4;
                Y2 = _plus_9;
            }
        }
        if ((double)node.getY() < M * (double)node.getX() + B && M * (double)node.getX() + B <= (double)(node.getY() + node.getHeight())) {
            if (first) {
                double _plus_10;
                X1 = node.getX();
                int _x_5 = node.getX();
                double _multiply_4 = M * (double)_x_5;
                Y1 = _plus_10 = _multiply_4 + B;
                first = false;
            } else {
                double _plus_11;
                X2 = node.getX();
                int _x_6 = node.getX();
                double _multiply_5 = M * (double)_x_6;
                Y2 = _plus_11 = _multiply_5 + B;
            }
        }
        double _pow = Math.pow(Y2 - Y1, 2.0);
        double _pow_1 = Math.pow(X2 - X1, 2.0);
        double _plus_12 = _pow + _pow_1;
        double _sqrt = Math.sqrt(_plus_12);
        return (int)_sqrt;
    }

    public static enum LineOfAlignment {
        Horizontal,
        MainDiagonal,
        Vertical,
        SecondaryDiagonal;

    }

    public static enum NodeResizing {
        NoResizing,
        WidenNodesToGreatestNodeSize,
        ShrinkNodesToSmallestNodeSize;

    }
}

