/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.build;

import com.google.inject.Injector;
import de.jabc.cinco.meta.core.utils.CincoProperties;
import de.jabc.cinco.meta.plugin.gratext.build.GratextMwe2Job;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe2.language.Mwe2StandaloneSetup;
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Launcher;
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Runner;

public class HeadlessGratextMwe2Job
extends GratextMwe2Job {
    boolean success;
    private Object jobStatus;

    public HeadlessGratextMwe2Job(IProject project, IFile mwe2File) {
        super(project, mwe2File);
    }

    @Override
    public void onTerminated(IProcess process) {
        try {
            this.success = process.getExitValue() == 0;
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onQuit() {
        this.jobStatus = this.success ? Status.OK_STATUS : new Status(4, this.getName(), "Mwe2 workflow failed.");
    }

    @Override
    protected void afterwork() {
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void prepare() {
        if (this.mwe2File == null) {
            try {
                this.mwe2File = (IFile)this.getProjectFiles(this.project, "mwe2").stream().filter(file -> file.getName().endsWith("Gratext.mwe2")).collect(Collectors.toList()).get(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.quit();
                return;
            }
        }
        this.launches = new ArrayList();
        this.unseen = new ArrayList();
        this.processes = new ArrayList();
        this.registerLaunchListener();
        this.launch(this.project, this.mwe2File);
    }

    @Override
    protected void launch(ILaunchConfigurationType type, IProject project, IFile file) throws CoreException {
        this.buildMWE2(file, project);
    }

    protected void launch(IProject project, IFile file) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.emf.mwe2.launch.Mwe2LaunchConfigurationType");
        try {
            Arrays.stream(manager.getLaunchConfigurations(type)).filter(cfg -> cfg.getName().equals(file.getName())).forEach(cfg -> {
                try {
                    cfg.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            });
            this.launch(type, project, file);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void buildMWE2(IFile mwe, IProject project) {
        try {
            IPath workspacePath = project.getWorkspace().getRoot().getRawLocation();
            Injector i = new Mwe2StandaloneSetup().createInjectorAndDoEMFRegistration();
            Mwe2Runner runner = (Mwe2Runner)i.getInstance(Mwe2Runner.class);
            System.out.println(CincoProperties.getVmArgs());
            System.out.println(project.getRawLocation());
            System.out.println(project.getLocation());
            IPath projectPath = project.getLocation().makeAbsolute();
            System.out.println(projectPath.makeAbsolute());
            Mwe2Launcher launcher = (Mwe2Launcher)i.getInstance(Mwe2Launcher.class);
            URL url = ((Object)((Object)this)).getClass().getResource(workspacePath.append(mwe.getFullPath().makeAbsolute()).toOSString());
            String str = workspacePath.append(mwe.getFullPath().makeAbsolute()).toOSString();
            URI uri = URI.createFileURI((String)str);
            System.out.println(url);
            System.out.println("URI: " + uri);
            String[] args = new String[]{"-p", String.format("runtimeProject=%s", projectPath.makeAbsolute().toOSString())};
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("runtimeProject", projectPath.makeAbsolute().toOSString());
            runner.run(uri, params);
            System.out.println("NOTHING HERE");
        }
        catch (Exception e) {
            e.printStackTrace();
            CincoProperties.shutdown((boolean)true);
        }
    }
}

