/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.build;

import com.google.common.collect.Lists;
import de.jabc.cinco.meta.core.utils.CincoProperties;
import de.jabc.cinco.meta.core.utils.job.ReiteratingThread;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;

public abstract class GratextMwe2Job
extends ReiteratingThread {
    protected static final int INTERVAL = 1000;
    protected IProject project;
    protected IFile mwe2File;
    protected List<IProcess> processes;
    protected List<ILaunchConfiguration> launches;
    protected List<ILaunchConfiguration> unseen;
    private ILaunchListener launchListener;

    public GratextMwe2Job(IProject project) {
        super(1000, 100);
        this.project = project;
    }

    public GratextMwe2Job(IProject project, IFile mwe2File) {
        super(1000, 100);
        this.project = project;
        this.mwe2File = mwe2File;
    }

    public abstract void onTerminated(IProcess var1);

    public abstract void onQuit();

    protected void prepare() {
        if (this.mwe2File == null) {
            try {
                this.mwe2File = (IFile)this.getProjectFiles(this.project, "mwe2").stream().filter(file -> file.getName().endsWith("Gratext.mwe2")).collect(Collectors.toList()).get(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.quit();
                return;
            }
        }
        this.launches = new ArrayList<ILaunchConfiguration>();
        this.unseen = new ArrayList<ILaunchConfiguration>();
        this.processes = new ArrayList<IProcess>();
        this.registerLaunchListener();
        this.launch(this.project, this.mwe2File);
    }

    protected void work() {
        for (IProcess process : new ArrayList<IProcess>(this.processes)) {
            if (!process.isTerminated()) continue;
            this.terminate(process);
        }
    }

    protected void afterwork() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.emf.mwe2.launch.Mwe2LaunchConfigurationType");
        try {
            Arrays.stream(manager.getLaunchConfigurations(type)).filter(cfg -> cfg.getName().equals(this.mwe2File.getName())).forEach(cfg -> {
                try {
                    cfg.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void cleanup() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.removeLaunchListener(this.launchListener);
    }

    private void launch(IProject project, IFile file) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.emf.mwe2.launch.Mwe2LaunchConfigurationType");
        try {
            Arrays.stream(manager.getLaunchConfigurations(type)).filter(cfg -> cfg.getName().equals(file.getName())).forEach(cfg -> {
                try {
                    cfg.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            });
            this.launch(type, project, file);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void launch(ILaunchConfigurationType type, IProject project, IFile file) throws CoreException {
        ILaunchConfigurationWorkingCopy cfg = type.newInstance(null, project.getName());
        cfg.setAttribute("org.eclipse.debug.core.ATTR_REFRESH_SCOPE", "${project}");
        cfg.setAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS", (List)Lists.newArrayList((Object[])new String[]{"/" + project.getName()}));
        cfg.setAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_TYPES", (List)Lists.newArrayList((Object[])new String[]{"4"}));
        cfg.setAttribute("org.eclipse.jdt.launching.ATTR_USE_START_ON_FIRST_THREAD", true);
        cfg.setAttribute("org.eclipse.jdt.launching.MAIN_TYPE", "org.eclipse.emf.mwe2.launch.runtime.Mwe2Launcher");
        cfg.setAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", file.getProjectRelativePath().toPortableString());
        cfg.setAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", CincoProperties.getVmArgs());
        cfg.setAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", project.getName());
        cfg.setAttribute("org.eclipse.ptp.launch.ATTR_AUTO_RUN_COMMAND", true);
        ILaunchConfiguration launchCfg = cfg.doSave();
        this.register(launchCfg);
        IJobManager manager = Job.getJobManager();
        Job[] build = manager.find(ResourcesPlugin.FAMILY_AUTO_BUILD);
        if (build.length == 1) {
            try {
                build[0].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            launchCfg.launch("run", null);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    protected void registerLaunchListener() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        this.launchListener = new ILaunchListener(){

            public void launchChanged(ILaunch launch) {
                if (GratextMwe2Job.this.launches.contains(launch.getLaunchConfiguration())) {
                    IProcess[] iProcessArray = launch.getProcesses();
                    int n = iProcessArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess process = iProcessArray[n2];
                        if (process != null && !GratextMwe2Job.this.processes.contains(process)) {
                            GratextMwe2Job.this.register(process, launch.getLaunchConfiguration());
                        }
                        ++n2;
                    }
                }
            }

            public void launchRemoved(ILaunch launch) {
            }

            public void launchAdded(ILaunch launch) {
            }
        };
        manager.addLaunchListener(this.launchListener);
    }

    private void register(ILaunchConfiguration cfg) {
        this.launches.add(cfg);
        this.unseen.add(cfg);
    }

    private void register(IProcess process, ILaunchConfiguration cfg) {
        this.processes.add(process);
        this.unseen.remove(cfg);
    }

    private void terminate(IProcess process) {
        this.onTerminated(process);
        this.processes.remove(process);
        if (this.processes.isEmpty() && this.unseen.isEmpty()) {
            this.quit();
        }
    }

    protected List<IFile> getProjectFiles(IProject project, String fileExtension) {
        return this.getFiles((IContainer)project, fileExtension, true);
    }

    protected List<IFile> getFiles(IContainer container, String fileExtension, boolean recurse) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (members != null) {
            Arrays.stream(members).forEach(mbr -> {
                if (recurse && mbr instanceof IContainer) {
                    files.addAll(this.getFiles((IContainer)mbr, fileExtension, recurse));
                } else if (mbr instanceof IFile && !mbr.isDerived()) {
                    IFile file = (IFile)mbr;
                    if (fileExtension == null || fileExtension.equals(file.getFileExtension())) {
                        files.add(file);
                    }
                }
            });
        }
        return files;
    }

    public static IFile createFile(IProject project, String name, InputStream content) {
        IFile file;
        block12: {
            file = project.getFile((IPath)new Path(name));
            try {
                try {
                    if (file.exists()) {
                        file.setContents(content, true, true, null);
                        break block12;
                    }
                    file.create(content, true, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        content.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    content.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public void quit() {
        super.quit();
        this.onQuit();
    }
}

