/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.build;

import de.jabc.cinco.meta.core.utils.CincoProperties;
import de.jabc.cinco.meta.core.utils.job.ReiteratingJob;
import de.jabc.cinco.meta.plugin.gratext.build.GratextMwe2Job;
import de.jabc.cinco.meta.plugin.gratext.build.HeadlessGratextMwe2Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;

public class GratextLanguageBuild
extends ReiteratingJob {
    protected IProject project;
    private IFolder modelFolder;
    protected IFile mwe2;
    private IFile xtext;
    protected IProgressMonitor monitor;
    private IStatus jobStatus;
    protected boolean failed;
    private boolean buildGratext;

    public GratextLanguageBuild(IProject project) {
        this(project, true);
    }

    public GratextLanguageBuild(IProject project, boolean buildGratext) {
        super("Building Gratext: " + project.getName());
        this.project = project;
        this.buildGratext = buildGratext;
    }

    protected void prepare() {
        this.monitor = this.getMonitor();
        this.findModelFolder();
        this.refreshProjects();
        this.findMwe2();
        if (!CincoProperties.isHeadless()) {
            this.runMwe2();
        } else {
            this.runMwe2();
        }
    }

    protected void repeat() {
        if (this.jobStatus != null) {
            this.quit(this.jobStatus);
        }
    }

    protected void afterwork() {
        if (this.jobStatus.isOK()) {
            if (this.buildGratext) {
                this.deleteSources();
            }
            this.buildProjects();
        } else {
            this.refreshProjects();
        }
    }

    protected void findModelFolder() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Retrieve .genmodel: " + this.project.getName());
                this.modelFolder = this.project.getFolder("model");
            }
            catch (Exception e) {
                this.fail("Failed to retrieve .genmodel file.", e);
                return;
            }
        }
    }

    protected void findMwe2() {
        if (!this.failed) {
            try {
                this.xtext = (IFile)this.getProjectFiles("xtext").stream().filter(file -> file.getName().endsWith(".xtext")).collect(Collectors.toList()).get(0);
                this.mwe2 = (IFile)this.getProjectFiles("mwe2").stream().filter(file -> file.getName().endsWith(".mwe2")).collect(Collectors.toList()).get(0);
            }
            catch (Exception e) {
                this.fail("Genmodel job fine, but failed to retrieve .mwe2 file.", e);
                return;
            }
        }
    }

    private void runMwe2() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Mwe2 job: " + this.mwe2.getName() + " - " + this.project.getName());
                GratextMwe2Job job = new GratextMwe2Job(this.project, this.mwe2){
                    boolean success;

                    @Override
                    public void onTerminated(IProcess process) {
                        try {
                            this.success = process.getExitValue() == 0;
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onQuit() {
                        GratextLanguageBuild.this.jobStatus = this.success ? Status.OK_STATUS : new Status(4, this.getName(), "Mwe2 workflow failed.");
                    }
                };
                job.start();
            }
            catch (Exception e) {
                this.fail("Mwe2 workflow failed.", e);
                return;
            }
        }
    }

    private void deleteSources() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Cleaning up " + this.mwe2.getName() + " - " + this.project.getName());
                this.xtext.delete(true, null);
                this.mwe2.delete(true, null);
                this.modelFolder.delete(true, null);
            }
            catch (Exception e) {
                this.fail("Failed to delete model sources (mwe2, xtext, model folder)", e);
                return;
            }
        }
    }

    protected void refreshProjects() {
        this.refreshProject("");
        this.refreshProject(".ui");
    }

    private void refreshProject(String suffix) {
        if (!this.failed) {
            try {
                String projectName = String.valueOf(this.project.getName()) + suffix;
                IProject project = this.getProject(projectName);
                if (project != null) {
                    this.monitor.setTaskName("Refreshing " + projectName);
                    project.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void buildProjects() {
        this.buildProject("");
        this.buildProject(".ui");
    }

    public void buildProject(String suffix) {
        if (!this.failed) {
            try {
                String projectName = String.valueOf(this.project.getName()) + suffix;
                IProject project = this.getProject(projectName);
                if (project != null) {
                    this.monitor.setTaskName("Refreshing " + projectName);
                    project.refreshLocal(2, null);
                    this.monitor.setTaskName("Building " + projectName);
                    project.build(10, null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private List<IFile> getProjectFiles(String fileExtension) {
        return this.getFiles((IContainer)this.project, fileExtension, true);
    }

    private List<IFile> getFiles(IContainer container, String fileExtension, boolean recurse) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (members != null) {
            Arrays.stream(members).forEach(mbr -> {
                if (recurse && mbr instanceof IContainer) {
                    files.addAll(this.getFiles((IContainer)mbr, fileExtension, recurse));
                } else if (mbr instanceof IFile && !mbr.isDerived()) {
                    IFile file = (IFile)mbr;
                    if (fileExtension == null || fileExtension.equals(file.getFileExtension())) {
                        files.add(file);
                    }
                }
            });
        }
        return files;
    }

    protected void fail(String msg, Exception e) {
        this.failed = true;
        super.fail(msg, e);
    }

    private void runHeadlessMwe2() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Mwe2 job: " + this.mwe2.getName() + " - " + this.project.getName());
                HeadlessGratextMwe2Job job = new HeadlessGratextMwe2Job(this.project, this.mwe2);
                job.start();
            }
            catch (Exception e) {
                this.fail("Mwe2 workflow failed.", e);
                return;
            }
        }
    }
}

