/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.build;

import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.plugin.gratext.build.GratextBuild;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;

public class GratextBuildAction
implements IActionDelegate {
    private Display display;
    private List<IProject> projects;
    private boolean autoBuild;

    public void run(IAction action) {
        JobFactory.job((String)"Gratext Builder").cancelOnFail(false).consume(5, "Initializing...").task(this::init).cancelIf(() -> this.projects.isEmpty(), "No Gratext model files found.\nGratext build finished (in a fairly trivial way).").task(this::disableAutoBuild).consumeConcurrent(100, "Running Gratext builds...").taskForEach(() -> this.projects.stream(), this::spawnJob, IResource::getName).onFinished(() -> this.showMessage("Gratext build finished.")).onDone(this::resetAutoBuild).schedule();
    }

    private void init() {
        this.projects = Arrays.stream(this.getProjects()).filter(project -> project.getName().endsWith("gratext")).filter(project -> this.containsGratextMWE((IProject)project)).collect(Collectors.toList());
    }

    private void spawnJob(IProject project) {
        GratextBuild job = new GratextBuild(project);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private IProject[] getProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private boolean containsGratextMWE(IProject project) {
        return !this.getProjectFiles(project, "mwe2").stream().filter(file -> file.getName().endsWith("Gratext.mwe2")).collect(Collectors.toList()).isEmpty();
    }

    protected List<IFile> getProjectFiles(IProject project, String fileExtension) {
        return this.getFiles((IContainer)project, fileExtension, true);
    }

    protected List<IFile> getFiles(IContainer container, String fileExtension, boolean recurse) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (members != null) {
            Arrays.stream(members).forEach(mbr -> {
                if (recurse && mbr instanceof IContainer) {
                    files.addAll(this.getFiles((IContainer)mbr, fileExtension, recurse));
                } else if (mbr instanceof IFile && !mbr.isDerived()) {
                    IFile file = (IFile)mbr;
                    if (fileExtension == null || fileExtension.equals(file.getFileExtension())) {
                        files.add(file);
                    }
                }
            });
        }
        return files;
    }

    private void showMessage(String msg) {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        this.display.asyncExec(() -> {
            int n = new MessageDialog(this.display.getActiveShell(), "Gratext Builder", this.display.getSystemImage(2), msg, 2, new String[]{"OK"}, 0).open();
        });
    }

    private void setAutoBuild(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        this.autoBuild = desc.isAutoBuilding();
        if (this.autoBuild != enable) {
            desc.setAutoBuilding(enable);
            workspace.setDescription(desc);
        }
    }

    private boolean isAutoBuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        return desc.isAutoBuilding();
    }

    private void disableAutoBuild() {
        block2: {
            try {
                this.setAutoBuild(false);
            }
            catch (Exception e) {
                if (!this.isAutoBuild()) break block2;
                System.out.println("[Gratext] WARN: Failed to deactivate \"Build Automatically\".");
                e.printStackTrace();
            }
        }
    }

    private void resetAutoBuild() {
        block2: {
            try {
                this.setAutoBuild(this.autoBuild);
            }
            catch (Exception e) {
                if (!this.autoBuild == this.isAutoBuild()) break block2;
                System.out.println("[Gratext] WARN: Failed to reset state for \"Build Automatically\". Should be " + this.autoBuild);
                e.printStackTrace();
            }
        }
    }

    public void build(IProject project) {
        try {
            project.build(10, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

