/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.build;

import de.jabc.cinco.meta.core.utils.job.ReiteratingJob;
import de.jabc.cinco.meta.plugin.gratext.build.GratextMwe2Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class GratextBuild
extends ReiteratingJob {
    private IProject project;
    private IFolder modelFolder;
    private IFile genmodel;
    private IFile mwe2;
    private IFile xtext;
    private IProgressMonitor monitor;
    private IStatus jobStatus;
    private boolean failed;

    public GratextBuild(IProject project) {
        super("Building Gratext: " + project.getName());
        this.project = project;
    }

    protected void prepare() {
        this.monitor = this.getMonitor();
        this.findGenmodel();
        this.runGenmodel();
        this.buildProject();
        this.findMwe2();
        this.runMwe2();
    }

    protected void repeat() {
        if (this.jobStatus != null) {
            this.quit(this.jobStatus);
        }
    }

    protected void afterwork() {
        if (this.jobStatus.isOK()) {
            this.deleteSources();
            this.triggerRefresh();
            this.buildProject();
            this.buildUIProject();
        } else {
            this.triggerRefresh();
        }
    }

    private void findGenmodel() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Retrieve .genmodel: " + this.project.getName());
                this.genmodel = (IFile)this.getProjectFiles("genmodel").stream().filter(file -> file.getName().endsWith("Gratext.genmodel")).collect(Collectors.toList()).get(0);
                this.modelFolder = this.project.getFolder("model");
            }
            catch (Exception e) {
                this.fail("Failed to retrieve .genmodel file.", e);
                return;
            }
        }
    }

    private void findMwe2() {
        if (!this.failed) {
            try {
                this.xtext = (IFile)this.getProjectFiles("xtext").stream().filter(file -> file.getName().endsWith("Gratext.xtext")).collect(Collectors.toList()).get(0);
                this.mwe2 = (IFile)this.getProjectFiles("mwe2").stream().filter(file -> file.getName().endsWith("Gratext.mwe2")).collect(Collectors.toList()).get(0);
            }
            catch (Exception e) {
                this.fail("Genmodel job fine, but failed to retrieve .mwe2 file.", e);
                return;
            }
        }
    }

    private void runGenmodel() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Genmodel job: " + this.project.getName());
                Resource res = new ResourceSetImpl().getResource(URI.createPlatformResourceURI((String)this.genmodel.getFullPath().toString(), (boolean)true), true);
                res.load(null);
                res.getContents().stream().filter(GenModel.class::isInstance).map(GenModel.class::cast).forEach(genModel -> {
                    genModel.reconcile();
                    genModel.getUsedGenPackages().stream().filter(pkg -> !pkg.getGenModel().equals(genModel)).forEach(arg_0 -> genModel.getUsedGenPackages().add(arg_0));
                    genModel.setCanGenerate(true);
                    GenModelUtil.createGenerator((GenModel)genModel).generate(genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)new NullProgressMonitor(), (int)100));
                });
            }
            catch (Exception e) {
                this.fail("Model code generation failed.", e);
                return;
            }
        }
    }

    private void runMwe2() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Mwe2 job: " + this.mwe2.getName());
                GratextMwe2Job job = new GratextMwe2Job(this.project, this.mwe2){
                    boolean success;

                    @Override
                    public void onTerminated(IProcess process) {
                        try {
                            this.success = process.getExitValue() == 0;
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onQuit() {
                        GratextBuild.this.jobStatus = this.success ? Status.OK_STATUS : new Status(4, this.getName(), "Mwe2 workflow failed.");
                    }
                };
                job.start();
            }
            catch (Exception e) {
                this.fail("Genmodel job fine, but Mwe2 workflow failed.", e);
                return;
            }
        }
    }

    private void deleteSources() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Cleaning up " + this.mwe2.getName());
                this.xtext.delete(true, null);
                this.mwe2.delete(true, null);
                this.modelFolder.delete(true, null);
            }
            catch (Exception e) {
                this.fail("Build process fine, but failed to delete .genmodel and/or .xtext file.", e);
                return;
            }
        }
    }

    private void triggerRefresh() {
        if (!this.failed) {
            try {
                this.project.refreshLocal(2, null);
                this.getProject(String.valueOf(this.project.getName()) + ".ui").refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void buildProject() {
        if (!this.failed) {
            try {
                this.monitor.setTaskName("Building " + this.project.getName());
                this.project.build(10, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void buildUIProject() {
        if (!this.failed) {
            try {
                String projectName = String.valueOf(this.project.getName()) + ".ui";
                IProject project = this.getProject(projectName);
                if (project != null) {
                    this.monitor.setTaskName("Building " + projectName);
                    project.build(10, null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private List<IFile> getProjectFiles(String fileExtension) {
        return this.getFiles((IContainer)this.project, fileExtension, true);
    }

    private List<IFile> getFiles(IContainer container, String fileExtension, boolean recurse) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (members != null) {
            Arrays.stream(members).forEach(mbr -> {
                if (recurse && mbr instanceof IContainer) {
                    files.addAll(this.getFiles((IContainer)mbr, fileExtension, recurse));
                } else if (mbr instanceof IFile && !mbr.isDerived()) {
                    IFile file = (IFile)mbr;
                    if (fileExtension == null || fileExtension.equals(file.getFileExtension())) {
                        files.add(file);
                    }
                }
            });
        }
        return files;
    }

    protected void fail(String msg, Exception e) {
        this.failed = true;
        super.fail(msg, e);
    }
}

