/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.objectlang.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.objectlang.ObjectLangExtension;
import info.scce.dime.objectlang.objectLang.AttributeDef;
import info.scce.dime.objectlang.objectLang.AttributeValueDef;
import info.scce.dime.objectlang.objectLang.AttributeValueReferenceDef;
import info.scce.dime.objectlang.objectLang.BooleanAttributeValueDef;
import info.scce.dime.objectlang.objectLang.BooleanListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.ComplexInputDef;
import info.scce.dime.objectlang.objectLang.ComplexListAttributeValuesDef;
import info.scce.dime.objectlang.objectLang.EmptyList;
import info.scce.dime.objectlang.objectLang.GenerateDef;
import info.scce.dime.objectlang.objectLang.Import;
import info.scce.dime.objectlang.objectLang.InputDef;
import info.scce.dime.objectlang.objectLang.IntegerAttributeValueDef;
import info.scce.dime.objectlang.objectLang.IntegerListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.NamedObject;
import info.scce.dime.objectlang.objectLang.ObjectCreation;
import info.scce.dime.objectlang.objectLang.ObjectDef;
import info.scce.dime.objectlang.objectLang.ObjectExtend;
import info.scce.dime.objectlang.objectLang.ObjectLangPackage;
import info.scce.dime.objectlang.objectLang.ObjectsModel;
import info.scce.dime.objectlang.objectLang.PrimitiveListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.ProcessArgumentDef;
import info.scce.dime.objectlang.objectLang.ProcessOutput;
import info.scce.dime.objectlang.objectLang.RealAttributeValueDef;
import info.scce.dime.objectlang.objectLang.RealListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.TextAttributeValueDef;
import info.scce.dime.objectlang.objectLang.TextListAttributeValueDef;
import info.scce.dime.objectlang.validation.AbstractObjectLangValidator;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.Process;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ObjectLangValidator
extends AbstractObjectLangValidator {
    @Extension
    private DataExtension _dataExtension = DataExtension.getInstance();
    @Extension
    private ResourceExtension _resourceExtension = new ResourceExtension();
    @Extension
    private ObjectLangExtension _objectLangExtension = new ObjectLangExtension();

    @Check
    public void checkImport(Import it) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getPath());
        if (_isNullOrEmpty) {
            this.error(it, "Specify an ID or a project relative file path");
            return;
        }
        List acceptedClasses = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{ObjectsModel.class, Data.class, Process.class}));
        final String id = it.getPath();
        Functions.Function1<GenerateDef, Boolean> _function = new Functions.Function1<GenerateDef, Boolean>(){

            public Boolean apply(GenerateDef it) {
                String _modelId = it.getModelId();
                return Objects.equal((Object)_modelId, (Object)id);
            }
        };
        boolean _exists = IterableExtensions.exists(this._objectLangExtension.getObjectsModel(it).getGenerations(), (Functions.Function1)_function);
        if (_exists) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Cyclic reference");
            this.error(it, _builder.toString());
            return;
        }
        final EObject obj = ReferenceRegistry.getInstance().getEObject(id);
        if (obj != null && !IterableExtensions.exists(acceptedClasses, (Functions.Function1)new Functions.Function1<Class<? extends EObject>, Boolean>(){

            public Boolean apply(Class<? extends EObject> it) {
                return it.isInstance(obj);
            }
        })) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Supported types of imported objects: ");
            Functions.Function1<Class<? extends EObject>, String> _function_1 = new Functions.Function1<Class<? extends EObject>, String>(){

                public String apply(Class<? extends EObject> it) {
                    return it.getSimpleName();
                }
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(acceptedClasses, (Functions.Function1)_function_1), (CharSequence)", ");
            _builder_1.append(_join);
            this.error(it, _builder_1.toString());
            return;
        }
        boolean _and = false;
        Functions.Function1<ObjectsModel, Boolean> _function_2 = new Functions.Function1<ObjectsModel, Boolean>(){

            public Boolean apply(ObjectsModel it) {
                Functions.Function1<GenerateDef, Boolean> _function = new Functions.Function1<GenerateDef, Boolean>(){

                    public Boolean apply(GenerateDef it) {
                        String _modelId = it.getModelId();
                        return Objects.equal((Object)_modelId, (Object)id);
                    }
                };
                return IterableExtensions.exists(it.getGenerations(), (Functions.Function1)_function);
            }
        };
        boolean _exists_1 = IterableExtensions.exists(this._objectLangExtension.getOtherObjectsModels(this._objectLangExtension.getObjectsModel(it)), (Functions.Function1)_function_2);
        boolean bl = _not = !_exists_1;
        if (!_not) {
            _and = false;
        } else {
            boolean _not_1;
            IFile _file = this._resourceExtension.getProject(it.eResource()).getFile(it.getPath());
            boolean _exists_2 = false;
            if (_file != null) {
                _exists_2 = _file.exists();
            }
            _and = _not_1 = !_exists_2;
        }
        if (_and) {
            StringConcatenation _builder_2 = new StringConcatenation();
            String _path = it.getPath();
            _builder_2.append(_path);
            _builder_2.append(" not found");
            this.error(it, _builder_2.toString());
        }
    }

    public void error(Import imp, String msg) {
        this.error(msg, (EStructuralFeature)ObjectLangPackage.Literals.IMPORT__PATH, "Failed to load resource", new String[0]);
    }

    @Check
    public void checkObjectSrc(NamedObject objSrc) {
        boolean _isDuplicateObjectName = this.isDuplicateObjectName(this._objectLangExtension.getObjectsModel(objSrc), objSrc.getName());
        if (_isDuplicateObjectName) {
            this.error("Duplicate name", (EStructuralFeature)ObjectLangPackage.Literals.NAMED_OBJECT__NAME);
        }
    }

    public boolean isDuplicateObjectName(ObjectsModel model, String name) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            EList<ObjectDef> _objects = model.getObjects();
            EList<InputDef> _inputs = model.getInputs();
            Functions.Function1<NamedObject, String> _function = new Functions.Function1<NamedObject, String>(){

                public String apply(NamedObject it) {
                    return it.getName();
                }
            };
            List names = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.concat(_objects, _inputs), (Functions.Function1)_function));
            int frequency = Collections.frequency(names, name);
            return frequency > 1;
        }
        return false;
    }

    @Check
    public void checkObjectExtend(ObjectExtend objExt) {
        ObjectDef _objSrc;
        ObjectDef objDef = this._objectLangExtension.findFirstParent((EObject)objExt, ObjectDef.class);
        boolean _equals = Objects.equal((Object)objDef, (Object)(_objSrc = objExt.getObjSrc()));
        if (_equals) {
            this.error("You really seek to provoke a stack overflow, huh? An object cannot extend itself!", (EStructuralFeature)ObjectLangPackage.Literals.OBJECT_EXTEND__OBJ_SRC);
        }
    }

    @Check
    public void checkBooleanAttributeValueDef(BooleanAttributeValueDef valueDef) {
        this.assertValueType(valueDef, valueDef.eContainer(), new PrimitiveType[]{PrimitiveType.BOOLEAN});
    }

    @Check
    public void checkBooleanListAttributeValueDef(BooleanListAttributeValueDef valueDef) {
        this.assertValueListType(valueDef, PrimitiveType.BOOLEAN);
    }

    @Check
    public void checkIntegerAttributeValueDef(IntegerAttributeValueDef valueDef) {
        this.assertValueType(valueDef, valueDef.eContainer(), new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.TIMESTAMP});
    }

    @Check
    public void checkIntegerListAttributeValueDef(IntegerListAttributeValueDef valueDef) {
        this.assertValueListType(valueDef, PrimitiveType.INTEGER, PrimitiveType.TIMESTAMP);
    }

    @Check
    public void checkRealAttributeValueDef(RealAttributeValueDef valueDef) {
        this.assertValueType(valueDef, valueDef.eContainer(), new PrimitiveType[]{PrimitiveType.REAL});
    }

    @Check
    public void checkRealListAttributeValueDef(RealListAttributeValueDef valueDef) {
        this.assertValueListType(valueDef, PrimitiveType.REAL);
    }

    @Check
    public void checkTextAttributeValueDef(final TextAttributeValueDef valueDef) {
        EObject parent = this._objectLangExtension.findFirstParent((EObject)valueDef, AttributeDef.class, ProcessArgumentDef.class);
        boolean _matched = false;
        if (parent instanceof ProcessArgumentDef) {
            _matched = true;
        }
        if (!_matched && parent instanceof AttributeDef) {
            _matched = true;
            EObject attribute = ((AttributeDef)parent).getKey();
            if (attribute instanceof Attribute) {
                boolean _isEnumAttribute = this._objectLangExtension.isEnumAttribute((Attribute)attribute);
                if (_isEnumAttribute) {
                    Functions.Function1<EnumLiteral, Boolean> _function;
                    EList literals;
                    boolean _exists;
                    boolean _not;
                    Type _enumType = this._objectLangExtension.getEnumType((Attribute)attribute);
                    EList _enumLiterals = null;
                    if (_enumType != null) {
                        _enumLiterals = _enumType.getEnumLiterals();
                    }
                    boolean bl = _not = !(_exists = IterableExtensions.exists((Iterable)(literals = _enumLiterals), (Functions.Function1)(_function = new Functions.Function1<EnumLiteral, Boolean>(){

                        public Boolean apply(EnumLiteral it) {
                            String _name = it.getName();
                            String _value = valueDef.getValue();
                            return Objects.equal((Object)_name, (Object)_value);
                        }
                    })));
                    if (_not) {
                        this.error("Enum literal does not exist", (EStructuralFeature)ObjectLangPackage.Literals.TEXT_ATTRIBUTE_VALUE_DEF__VALUE);
                        return;
                    }
                } else {
                    this.assertValueType(valueDef, parent, new PrimitiveType[]{PrimitiveType.TEXT, PrimitiveType.FILE});
                }
                PrimitiveType primitiveType = null;
                if (attribute instanceof PrimitiveAttribute) {
                    PrimitiveType _primitiveType = null;
                    if ((Attribute)attribute != null) {
                        _primitiveType = this.getPrimitiveType((Attribute)attribute);
                    }
                    primitiveType = _primitiveType;
                } else {
                    EObject output;
                    ProcessArgumentDef _findFirstParent = this._objectLangExtension.findFirstParent((EObject)valueDef, ProcessArgumentDef.class);
                    EObject _key = null;
                    if (_findFirstParent != null) {
                        _key = _findFirstParent.getKey();
                    }
                    if ((output = _key) instanceof PrimitiveOutputPort) {
                        primitiveType = this._objectLangExtension.mapOnDataType(((PrimitiveOutputPort)output).getDataType());
                    }
                }
                if (primitiveType != null) {
                    switch (primitiveType) {
                        case FILE: {
                            boolean _not_1;
                            String fileName = valueDef.getValue();
                            IFile file = this._resourceExtension.getProject(valueDef.eResource()).getFolder("initFiles").getFile(fileName);
                            boolean _exists_1 = file.exists();
                            boolean bl = _not_1 = !_exists_1;
                            if (!_not_1) break;
                            this.error("File does not exist", (EStructuralFeature)ObjectLangPackage.Literals.TEXT_ATTRIBUTE_VALUE_DEF__VALUE);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Check
    public void checkTextListAttributeValueDef(TextListAttributeValueDef valueDef) {
        this.assertValueListType(valueDef, PrimitiveType.TEXT, PrimitiveType.FILE);
    }

    @Check
    public void checkComplexAttributeValueDef(ObjectCreation valueDef) {
        EObject attribute;
        AttributeDef _findFirstParent = this._objectLangExtension.findFirstParent((EObject)valueDef, AttributeDef.class);
        EObject _key = null;
        if (_findFirstParent != null) {
            _key = _findFirstParent.getKey();
        }
        if ((attribute = _key) instanceof ComplexAttribute) {
            this.checkAttributeValueType(valueDef, ((ComplexAttribute)attribute).getDataType());
        } else {
            EObject output;
            ProcessArgumentDef _findFirstParent_1 = this._objectLangExtension.findFirstParent((EObject)valueDef, ProcessArgumentDef.class);
            EObject _key_1 = null;
            if (_findFirstParent_1 != null) {
                _key_1 = _findFirstParent_1.getKey();
            }
            if ((output = _key_1) instanceof ComplexOutputPort) {
                this.checkAttributeValueType(valueDef, ((ComplexOutputPort)output).getDataType());
            }
        }
    }

    @Check
    public void checkAttributeValueReferenceDef(AttributeValueReferenceDef valueDef) {
        EObject parent = this._objectLangExtension.findFirstParent((EObject)valueDef, AttributeDef.class, ProcessArgumentDef.class);
        boolean _matched = false;
        if (parent instanceof ProcessArgumentDef) {
            EObject _key;
            _matched = true;
            EObject param = _key = ((ProcessArgumentDef)parent).getKey();
            boolean _matched_1 = false;
            if (param instanceof ComplexOutputPort) {
                _matched_1 = true;
                this.checkAttributeValueType(valueDef, ((ComplexOutputPort)param).getDataType());
            }
            if (!_matched_1 && param instanceof ComplexInputDef) {
                _matched_1 = true;
                this.checkAttributeValueType(valueDef, this._objectLangExtension.getType((NamedObject)param));
            }
        }
        if (!_matched && parent instanceof AttributeDef) {
            _matched = true;
            EObject attribute = ((AttributeDef)parent).getKey();
            if (attribute instanceof ComplexAttribute) {
                this.checkAttributeValueType(valueDef, ((ComplexAttribute)attribute).getDataType());
            }
        }
    }

    public void checkAttributeValueType(AttributeValueDef valueDef, Type type) {
        boolean _not;
        boolean isAbstract;
        EReference _switchResult = null;
        boolean _matched = false;
        if (valueDef instanceof ProcessOutput) {
            _matched = true;
            _switchResult = ObjectLangPackage.Literals.PROCESS_OUTPUT__PROCESS_DEF;
        }
        if (!_matched && valueDef instanceof ObjectCreation) {
            _matched = true;
            _switchResult = ObjectLangPackage.Literals.OBJECT_DEF__CREATION;
        }
        if (!_matched && valueDef instanceof AttributeValueReferenceDef) {
            _matched = true;
            _switchResult = ObjectLangPackage.Literals.ATTRIBUTE_VALUE_REFERENCE_DEF__VALUE;
        }
        EReference feature = _switchResult;
        boolean _switchResult_1 = false;
        boolean _matched_1 = false;
        if (valueDef instanceof ObjectCreation) {
            _matched_1 = true;
            _switchResult_1 = this._objectLangExtension.isAbstract((ObjectCreation)valueDef);
        }
        if (!_matched_1 && valueDef instanceof AttributeValueReferenceDef) {
            _matched_1 = true;
            _switchResult_1 = this._objectLangExtension.isAbstract(((AttributeValueReferenceDef)valueDef).getValue());
        }
        if (isAbstract = _switchResult_1) {
            this.error("Attribute value cannot be abstract", (EStructuralFeature)feature);
            return;
        }
        Type _switchResult_2 = null;
        boolean _matched_2 = false;
        if (valueDef instanceof ObjectCreation) {
            _matched_2 = true;
            _switchResult_2 = this._objectLangExtension.getType((ObjectCreation)valueDef);
        }
        if (!_matched_2 && valueDef instanceof AttributeValueReferenceDef) {
            _matched_2 = true;
            _switchResult_2 = this._objectLangExtension.getType(((AttributeValueReferenceDef)valueDef).getValue());
        }
        Type valueType = _switchResult_2;
        boolean _isTypeOf = false;
        if (valueType != null) {
            _isTypeOf = this._dataExtension.isTypeOf(valueType, type);
        }
        boolean bl = _not = !_isTypeOf;
        if (_not) {
            String _name = null;
            if (valueType != null) {
                _name = valueType.getName();
            }
            String _plus = "Attribute value is " + _name;
            String _plus_1 = String.valueOf(_plus) + " but should be ";
            String _name_1 = type.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            this.error(_plus_2, (EStructuralFeature)feature);
            return;
        }
    }

    @Check
    public AttributeValueDef checkComplexListAttributeValuesDef(ComplexListAttributeValuesDef valueDef) {
        AttributeValueDef _xblockexpression = null;
        AttributeDef attrDef = this._objectLangExtension.findFirstParent((EObject)valueDef, AttributeDef.class);
        if (attrDef instanceof AttributeDef && attrDef.getKey() instanceof ComplexAttribute && ((ComplexAttribute)attrDef.getKey()).isIsList()) {
            EObject _key = attrDef.getKey();
            final ComplexAttribute attribute = (ComplexAttribute)_key;
            Functions.Function1<AttributeValueDef, Boolean> _function = new Functions.Function1<AttributeValueDef, Boolean>(){

                public Boolean apply(AttributeValueDef it) {
                    boolean _checkTypeMatches = ObjectLangValidator.this.checkTypeMatches(it, attribute.getDataType());
                    return !_checkTypeMatches;
                }
            };
            IterableExtensions.findFirst(valueDef.getValuesDef(), (Functions.Function1)_function);
        }
        ProcessArgumentDef argDef = this._objectLangExtension.findFirstParent((EObject)valueDef, ProcessArgumentDef.class);
        AttributeValueDef _xifexpression = null;
        if (argDef instanceof ProcessArgumentDef) {
            AttributeValueDef _xifexpression_1 = null;
            if (argDef.getKey() instanceof ComplexOutputPort && ((ComplexOutputPort)argDef.getKey()).isIsList()) {
                AttributeValueDef _xblockexpression_1 = null;
                EObject _key_1 = argDef.getKey();
                final ComplexOutputPort outputPort = (ComplexOutputPort)_key_1;
                Functions.Function1<AttributeValueDef, Boolean> _function_1 = new Functions.Function1<AttributeValueDef, Boolean>(){

                    public Boolean apply(AttributeValueDef it) {
                        boolean _checkTypeMatches = ObjectLangValidator.this.checkTypeMatches(it, outputPort.getDataType());
                        return !_checkTypeMatches;
                    }
                };
                _xifexpression_1 = _xblockexpression_1 = (AttributeValueDef)IterableExtensions.findFirst(valueDef.getValuesDef(), (Functions.Function1)_function_1);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected boolean _checkTypeMatches(ObjectCreation valueDef, Type dataType) {
        boolean _not;
        Type type = this._objectLangExtension.getType(valueDef);
        boolean _isTypeOf = false;
        if (type != null) {
            _isTypeOf = this._dataExtension.isTypeOf(type, dataType);
        }
        boolean bl = _not = !_isTypeOf;
        if (_not) {
            String _name = null;
            if (type != null) {
                _name = type.getName();
            }
            String _plus = "Value is " + _name;
            String _plus_1 = String.valueOf(_plus) + " but should be ";
            String _name_1 = null;
            if (dataType != null) {
                _name_1 = dataType.getName();
            }
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            this.error(_plus_2, valueDef, (EStructuralFeature)ObjectLangPackage.Literals.OBJECT_DEF__CREATION);
            return false;
        }
        return true;
    }

    protected boolean _checkTypeMatches(AttributeValueReferenceDef valueDef, Type dataType) {
        boolean _not;
        NamedObject _value = valueDef.getValue();
        Type _type = null;
        if (_value != null) {
            _type = this._objectLangExtension.getType(_value);
        }
        Type type = _type;
        boolean _isTypeOf = false;
        if (type != null) {
            _isTypeOf = this._dataExtension.isTypeOf(type, dataType);
        }
        boolean bl = _not = !_isTypeOf;
        if (_not) {
            String _name = null;
            if (type != null) {
                _name = type.getName();
            }
            String _plus = "Value is " + _name;
            String _plus_1 = String.valueOf(_plus) + " but should be ";
            String _name_1 = null;
            if (dataType != null) {
                _name_1 = dataType.getName();
            }
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            this.error(_plus_2, valueDef, (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_VALUE_REFERENCE_DEF__VALUE);
            return false;
        }
        return true;
    }

    protected boolean _checkTypeMatches(ProcessOutput processOutput, Type dataType) {
        boolean _not;
        Type _type = null;
        if (processOutput != null) {
            _type = this._objectLangExtension.getType(processOutput);
        }
        Type type = _type;
        boolean _isTypeOf = false;
        if (type != null) {
            _isTypeOf = this._dataExtension.isTypeOf(type, dataType);
        }
        boolean bl = _not = !_isTypeOf;
        if (_not) {
            String _name = null;
            if (type != null) {
                _name = type.getName();
            }
            String _plus = "Value is " + _name;
            String _plus_1 = String.valueOf(_plus) + " but should be ";
            String _name_1 = null;
            if (dataType != null) {
                _name_1 = dataType.getName();
            }
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            this.error(_plus_2, processOutput, (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_OUTPUT__PROCESS_DEF);
            return false;
        }
        return true;
    }

    @Check
    public void checkAttributeDef(AttributeDef attrdef) {
        AttributeValueDef valueDef;
        EObject _key = attrdef.getKey();
        Attribute attribute = (Attribute)_key;
        if (attribute == null) {
            this.error("Attribute not found", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
            return;
        }
        EObject objDef = attrdef.eContainer();
        if (objDef instanceof ObjectDef) {
            Functions.Function1<AttributeDef, EObject> _function = new Functions.Function1<AttributeDef, EObject>(){

                public EObject apply(AttributeDef it) {
                    return it.getKey();
                }
            };
            Functions.Function1<Attribute, String> _function_1 = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    return it.getName();
                }
            };
            List names = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)ListExtensions.map(this._objectLangExtension.getAttributes((ObjectDef)objDef), (Functions.Function1)_function), Attribute.class), (Functions.Function1)_function_1));
            int frequency = Collections.frequency(names, attribute.getName());
            if (frequency > 1) {
                this.error("Duplicate attribute", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
            }
        }
        if ((valueDef = attrdef.getValueDef()) == null) {
            return;
        }
        if (attribute instanceof ComplexAttribute) {
            boolean _isEnumAttribute = this._objectLangExtension.isEnumAttribute(attribute);
            if (_isEnumAttribute) {
                Functions.Function1<Class<? extends AttributeValueDef>, Boolean> _function_2 = new Functions.Function1<Class<? extends AttributeValueDef>, Boolean>(){

                    public Boolean apply(Class<? extends AttributeValueDef> it) {
                        return it.isInstance(valueDef);
                    }
                };
                boolean match = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{TextAttributeValueDef.class, TextListAttributeValueDef.class, EmptyList.class})), (Functions.Function1)_function_2);
                if (!match) {
                    this.error("  Attribute has EnumType", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
                    return;
                }
            } else {
                Functions.Function1<Class<? extends AttributeValueDef>, Boolean> _function_3 = new Functions.Function1<Class<? extends AttributeValueDef>, Boolean>(){

                    public Boolean apply(Class<? extends AttributeValueDef> it) {
                        return it.isInstance(valueDef);
                    }
                };
                boolean match_1 = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{ObjectCreation.class, AttributeValueReferenceDef.class, ComplexListAttributeValuesDef.class, EmptyList.class})), (Functions.Function1)_function_3);
                if (!match_1) {
                    this.error("  Attribute is complex", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
                    return;
                }
            }
            if (!(!((ComplexAttribute)attribute).isIsList() || valueDef instanceof ComplexListAttributeValuesDef || valueDef instanceof TextListAttributeValueDef && this._objectLangExtension.isEnumAttribute(attribute) || valueDef instanceof EmptyList)) {
                return;
            }
            if (!((ComplexAttribute)attribute).isIsList() && (valueDef instanceof ComplexListAttributeValuesDef || valueDef instanceof EmptyList)) {
                this.error("Attribute is not list", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
                return;
            }
        }
        if (attribute instanceof PrimitiveAttribute) {
            if (((PrimitiveAttribute)attribute).isIsList() && !(valueDef instanceof PrimitiveListAttributeValueDef) && !(valueDef instanceof EmptyList)) {
                this.error("Attribute is list. Define a list value [ ... ]", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
                return;
            }
            if (!((PrimitiveAttribute)attribute).isIsList() && (valueDef instanceof PrimitiveListAttributeValueDef || valueDef instanceof EmptyList)) {
                this.error("Attribute is not list", (EStructuralFeature)ObjectLangPackage.Literals.ATTRIBUTE_DEF__KEY);
                return;
            }
        }
    }

    @Check
    public void checkProcessArgumentDef(ProcessArgumentDef argDef) {
        AttributeValueDef valueDef;
        boolean _tripleEquals;
        EObject _key = argDef.getKey();
        boolean bl = _tripleEquals = _key == null;
        if (_tripleEquals) {
            this.error("Input not found", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
            return;
        }
        EObject input = argDef.getKey();
        ProcessOutput outDef = this._objectLangExtension.findFirstParent((EObject)argDef, ProcessOutput.class);
        if (outDef instanceof ProcessOutput) {
            String inputName;
            int frequency;
            Functions.Function1<ProcessArgumentDef, EObject> _function = new Functions.Function1<ProcessArgumentDef, EObject>(){

                public EObject apply(ProcessArgumentDef it) {
                    return it.getKey();
                }
            };
            Functions.Function1<Output, String> _function_1 = new Functions.Function1<Output, String>(){

                public String apply(Output it) {
                    return it.getName();
                }
            };
            List names = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)ListExtensions.map(outDef.getArguments(), (Functions.Function1)_function), Output.class), (Functions.Function1)_function_1));
            String _switchResult = null;
            EObject it = input;
            boolean _matched = false;
            if (it instanceof Output) {
                _matched = true;
                _switchResult = ((Output)it).getName();
            }
            if (!_matched && it instanceof InputDef) {
                _matched = true;
                _switchResult = ((InputDef)it).getName();
            }
            if ((frequency = Collections.frequency(names, inputName = _switchResult)) > 1) {
                this.error("Duplicate argument", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
            }
        }
        if ((valueDef = argDef.getValueDef()) == null) {
            return;
        }
        if (input instanceof ComplexOutputPort) {
            boolean _isEnumPort = this._objectLangExtension.isEnumPort((IO)input);
            if (_isEnumPort) {
                Functions.Function1<Class<? extends AttributeValueDef>, Boolean> _function_2 = new Functions.Function1<Class<? extends AttributeValueDef>, Boolean>(){

                    public Boolean apply(Class<? extends AttributeValueDef> it) {
                        return it.isInstance(valueDef);
                    }
                };
                boolean match = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{TextAttributeValueDef.class, TextListAttributeValueDef.class, EmptyList.class})), (Functions.Function1)_function_2);
                if (!match) {
                    this.error("  Input has EnumType", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
                    return;
                }
            } else {
                Functions.Function1<Class<? extends AttributeValueDef>, Boolean> _function_3 = new Functions.Function1<Class<? extends AttributeValueDef>, Boolean>(){

                    public Boolean apply(Class<? extends AttributeValueDef> it) {
                        return it.isInstance(valueDef);
                    }
                };
                boolean match_1 = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{ObjectCreation.class, AttributeValueReferenceDef.class, ComplexListAttributeValuesDef.class, EmptyList.class})), (Functions.Function1)_function_3);
                if (!match_1) {
                    this.error("Input is complex", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
                    return;
                }
            }
            if (!(!((ComplexOutputPort)input).isIsList() || valueDef instanceof ComplexListAttributeValuesDef || valueDef instanceof TextListAttributeValueDef && this._objectLangExtension.isEnumPort((IO)input) || valueDef instanceof EmptyList)) {
                this.error("Input is list. Define a list value [ ... ]", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
                return;
            }
            if (!((ComplexOutputPort)input).isIsList() && (valueDef instanceof ComplexListAttributeValuesDef || valueDef instanceof EmptyList)) {
                this.error("Input is not list", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
                return;
            }
        }
        if (input instanceof PrimitiveOutputPort) {
            if (((PrimitiveOutputPort)input).isIsList() && !(valueDef instanceof PrimitiveListAttributeValueDef) && !(valueDef instanceof EmptyList)) {
                this.error("Input is list. Define a list value [ ... ]", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
                return;
            }
            if (!((PrimitiveOutputPort)input).isIsList() && (valueDef instanceof PrimitiveListAttributeValueDef || valueDef instanceof EmptyList)) {
                this.error("Input is not list", (EStructuralFeature)ObjectLangPackage.Literals.PROCESS_ARGUMENT_DEF__KEY);
                return;
            }
        }
    }

    public PrimitiveType getPrimitiveType(Attribute attr) {
        PrimitiveType _switchResult = null;
        Attribute it = attr;
        boolean _matched = false;
        if (it instanceof PrimitiveAttribute) {
            _matched = true;
            _switchResult = ((PrimitiveAttribute)it).getDataType();
        }
        return _switchResult;
    }

    public info.scce.dime.process.process.PrimitiveType getPrimitiveType(OutputPort port) {
        info.scce.dime.process.process.PrimitiveType _switchResult = null;
        OutputPort it = port;
        boolean _matched = false;
        if (it instanceof PrimitiveOutputPort) {
            _matched = true;
            _switchResult = ((PrimitiveOutputPort)it).getDataType();
        }
        return _switchResult;
    }

    public PrimitiveType getPrimitiveType(InputDef reqDef) {
        PrimitiveType _switchResult = null;
        InputDef it = reqDef;
        boolean _matched = false;
        if (it instanceof PrimitiveAttribute) {
            _matched = true;
            _switchResult = ((PrimitiveAttribute)it).getDataType();
        }
        return _switchResult;
    }

    protected void _assertValueType(AttributeValueDef valueDef, ProcessArgumentDef argDef, PrimitiveType ... dataTypes) {
        EObject output = argDef.getKey();
        if (output instanceof PrimitiveOutputPort) {
            PrimitiveType reqType = this._objectLangExtension.mapOnDataType(((PrimitiveOutputPort)output).getDataType());
            boolean _contains = ArrayExtensions.contains((Object[])dataTypes, (Object)reqType);
            if (_contains) {
                return;
            }
            this.buildValueTypeError(valueDef, reqType);
        }
    }

    protected void _assertValueType(AttributeValueDef valueDef, AttributeDef attrDef, PrimitiveType ... dataTypes) {
        boolean _contains;
        PrimitiveType reqType;
        EObject _key = attrDef.getKey();
        Attribute attribute = (Attribute)_key;
        PrimitiveType _switchResult = null;
        Attribute it = attribute;
        boolean _matched = false;
        boolean _isEnumAttribute = this._objectLangExtension.isEnumAttribute(it);
        if (_isEnumAttribute) {
            _matched = true;
            _switchResult = PrimitiveType.TEXT;
        }
        if (!_matched) {
            _switchResult = this.getPrimitiveType(it);
        }
        if ((reqType = _switchResult) == null) {
            new RuntimeException().printStackTrace();
        }
        if (_contains = ArrayExtensions.contains((Object[])dataTypes, (Object)reqType)) {
            return;
        }
        this.buildValueTypeError(valueDef, reqType);
    }

    public void buildValueTypeError(AttributeValueDef valueDef, PrimitiveType reqType) {
        String _switchResult = null;
        if (reqType != null) {
            switch (reqType) {
                case BOOLEAN: {
                    _switchResult = "Attribute value should be Boolean (true / false)";
                    break;
                }
                case INTEGER: {
                    _switchResult = "Attribute value should be Integer";
                    break;
                }
                case REAL: {
                    _switchResult = "Attribute value should be Real (e.g. 1.0)";
                    break;
                }
                case TEXT: {
                    _switchResult = "Attribute value should be Text";
                    break;
                }
                case TIMESTAMP: {
                    _switchResult = "Attribute value should be Timestamp Integer (e.g. 123456789)";
                    break;
                }
                case FILE: {
                    _switchResult = "Attribute value should be file path relative to the initFiles";
                    break;
                }
            }
        }
        String msg = _switchResult;
        EAttribute _switchResult_1 = null;
        boolean _matched = false;
        if (valueDef instanceof BooleanAttributeValueDef) {
            _matched = true;
            _switchResult_1 = ObjectLangPackage.Literals.BOOLEAN_ATTRIBUTE_VALUE_DEF__VALUE;
        }
        if (!_matched && valueDef instanceof IntegerAttributeValueDef) {
            _matched = true;
            _switchResult_1 = ObjectLangPackage.Literals.INTEGER_ATTRIBUTE_VALUE_DEF__VALUE;
        }
        if (!_matched && valueDef instanceof RealAttributeValueDef) {
            _matched = true;
            _switchResult_1 = ObjectLangPackage.Literals.REAL_ATTRIBUTE_VALUE_DEF__VALUE;
        }
        if (!_matched && valueDef instanceof TextAttributeValueDef) {
            _matched = true;
            _switchResult_1 = ObjectLangPackage.Literals.TEXT_ATTRIBUTE_VALUE_DEF__VALUE;
        }
        EAttribute feature = _switchResult_1;
        this.error(msg, (EStructuralFeature)feature);
    }

    public void assertValueListType(AttributeValueDef valueDef, PrimitiveType ... dataTypes) {
        EObject container = valueDef.eContainer();
        if (container instanceof AttributeDef) {
            boolean _not;
            EObject _key = ((AttributeDef)container).getKey();
            Attribute attribute = (Attribute)_key;
            boolean _isIsList = attribute.isIsList();
            boolean bl = _not = !_isIsList;
            if (_not) {
                EAttribute _switchResult = null;
                boolean _matched = false;
                if (valueDef instanceof BooleanListAttributeValueDef) {
                    _matched = true;
                    _switchResult = ObjectLangPackage.Literals.BOOLEAN_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                if (!_matched && valueDef instanceof IntegerListAttributeValueDef) {
                    _matched = true;
                    _switchResult = ObjectLangPackage.Literals.INTEGER_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                if (!_matched && valueDef instanceof RealListAttributeValueDef) {
                    _matched = true;
                    _switchResult = ObjectLangPackage.Literals.REAL_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                if (!_matched && valueDef instanceof TextListAttributeValueDef) {
                    _matched = true;
                    _switchResult = ObjectLangPackage.Literals.TEXT_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                EAttribute feature = _switchResult;
                this.error("Attribute is not list", (EStructuralFeature)feature);
                return;
            }
        }
        if (container instanceof ProcessArgumentDef) {
            boolean _not_1;
            EObject _key_1 = ((ProcessArgumentDef)container).getKey();
            OutputPort outputPort = (OutputPort)_key_1;
            boolean _isIsList_1 = outputPort.isIsList();
            boolean bl = _not_1 = !_isIsList_1;
            if (_not_1) {
                EAttribute _switchResult_1 = null;
                boolean _matched_1 = false;
                if (valueDef instanceof BooleanListAttributeValueDef) {
                    _matched_1 = true;
                    _switchResult_1 = ObjectLangPackage.Literals.BOOLEAN_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                if (!_matched_1 && valueDef instanceof IntegerListAttributeValueDef) {
                    _matched_1 = true;
                    _switchResult_1 = ObjectLangPackage.Literals.INTEGER_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                if (!_matched_1 && valueDef instanceof RealListAttributeValueDef) {
                    _matched_1 = true;
                    _switchResult_1 = ObjectLangPackage.Literals.REAL_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                if (!_matched_1 && valueDef instanceof TextListAttributeValueDef) {
                    _matched_1 = true;
                    _switchResult_1 = ObjectLangPackage.Literals.TEXT_ATTRIBUTE_VALUE_DEF__VALUE;
                }
                EAttribute feature_1 = _switchResult_1;
                this.error("Argument is not list", (EStructuralFeature)feature_1);
                return;
            }
        }
        this.assertValueType(valueDef, valueDef.eContainer(), dataTypes);
    }

    public boolean checkTypeMatches(AttributeValueDef processOutput, Type dataType) {
        if (processOutput instanceof ProcessOutput) {
            return this._checkTypeMatches((ProcessOutput)processOutput, dataType);
        }
        if (processOutput instanceof AttributeValueReferenceDef) {
            return this._checkTypeMatches((AttributeValueReferenceDef)processOutput, dataType);
        }
        if (processOutput instanceof ObjectCreation) {
            return this._checkTypeMatches((ObjectCreation)processOutput, dataType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(processOutput, dataType).toString());
    }

    public void assertValueType(AttributeValueDef valueDef, EObject attrDef, PrimitiveType[] dataTypes) {
        if (attrDef instanceof AttributeDef) {
            this._assertValueType(valueDef, (AttributeDef)attrDef, dataTypes);
            return;
        }
        if (attrDef instanceof ProcessArgumentDef) {
            this._assertValueType(valueDef, (ProcessArgumentDef)attrDef, dataTypes);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(valueDef, attrDef, dataTypes).toString());
    }
}

