/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.objectlang.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayout;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.runtime.xapi.GraphModelExtension;
import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import graphmodel.internal.InternalModelElement;
import info.scce.dime.api.modelgen.ProcessModelGenerationLanguage;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.data.UserType;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.objectlang.ObjectLangExtension;
import info.scce.dime.objectlang.generator.ObjectsModelProcessSIBBuild;
import info.scce.dime.objectlang.objectLang.AttributeDef;
import info.scce.dime.objectlang.objectLang.AttributeValueDef;
import info.scce.dime.objectlang.objectLang.AttributeValueReferenceDef;
import info.scce.dime.objectlang.objectLang.BooleanAttributeValueDef;
import info.scce.dime.objectlang.objectLang.BooleanListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.ComplexListAttributeValuesDef;
import info.scce.dime.objectlang.objectLang.GenerateDef;
import info.scce.dime.objectlang.objectLang.InputDef;
import info.scce.dime.objectlang.objectLang.IntegerAttributeValueDef;
import info.scce.dime.objectlang.objectLang.IntegerListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.NamedObject;
import info.scce.dime.objectlang.objectLang.ObjectCreation;
import info.scce.dime.objectlang.objectLang.ObjectDef;
import info.scce.dime.objectlang.objectLang.ObjectInstantiation;
import info.scce.dime.objectlang.objectLang.ObjectsModel;
import info.scce.dime.objectlang.objectLang.OutputDef;
import info.scce.dime.objectlang.objectLang.PrimitiveAttributeValueDef;
import info.scce.dime.objectlang.objectLang.PrimitiveListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.ProcessArgumentDef;
import info.scce.dime.objectlang.objectLang.ProcessOutput;
import info.scce.dime.objectlang.objectLang.ProcessOutputDef;
import info.scce.dime.objectlang.objectLang.RealAttributeValueDef;
import info.scce.dime.objectlang.objectLang.RealListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.TextAttributeValueDef;
import info.scce.dime.objectlang.objectLang.TextListAttributeValueDef;
import info.scce.dime.objectlang.objectLang.TypeDef;
import info.scce.dime.process.factory.ProcessFactory;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.helper.SIBLayoutUtils;
import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.CreateUserSIB;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.DataFlowSource;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.Documentation;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveVariable;
import info.scce.dime.process.process.Process;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.PutComplexToContextSIB;
import info.scce.dime.process.process.PutToContextSIB;
import info.scce.dime.process.process.Read;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.RetrieveEnumLiteralSIB;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.SetAttributeValueSIB;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import info.scce.dime.process.process.Variable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ObjectLangProcessGenerator {
    @Extension
    private GraphModelExtension _graphModelExtension = new GraphModelExtension();
    @Extension
    private DataExtension _dataExtension = DataExtension.getInstance();
    @Extension
    private ObjectLangExtension _objectLangExtension = new ObjectLangExtension();
    @Extension
    private ProcessModelGenerationLanguage _processModelGenerationLanguage = new ProcessModelGenerationLanguage();
    private final boolean printDebug = false;
    private final ObjectsModel model;
    private Process process;
    private final ArrayList<DataFlowSource> previousBranches = CollectionLiterals.newArrayList();
    private final HashMap<ObjectCreation, DataFlowSource> lastInCol = CollectionLiterals.newHashMap();
    private final LinkedHashMap<ObjectCreation, ComplexOutputPort> objCrt_on_port = CollectionLiterals.newLinkedHashMap();
    private final LinkedHashMap<InputDef, OutputPort> inputDef_on_port = CollectionLiterals.newLinkedHashMap();

    public static void generateProcess(ObjectsModel model, Path outlet, String fileName, String modelId) {
        new ObjectLangProcessGenerator(model).generateProcess(outlet, fileName, modelId);
    }

    public ObjectLangProcessGenerator(ObjectsModel model) {
        this.model = model;
    }

    public void generateProcess(final Path outlet, final String fileName, final String modelId) {
        this.debug("Generating process");
        this.debug("  outlet: " + outlet);
        this.debug("  fileName: " + fileName);
        this.debug("  modelId: " + modelId);
        ProcessFactory orgProcessFactory = ProcessFactory.eINSTANCE;
        try {
            try {
                ProcessModelGenerationLanguage _processModelGenerationLanguage;
                ProcessFactory _processFactory;
                ProcessFactory.eINSTANCE = _processFactory = new ProcessFactory();
                this._processModelGenerationLanguage = _processModelGenerationLanguage = new ProcessModelGenerationLanguage();
                this.process = this._processModelGenerationLanguage.createBasicProcess(outlet, fileName, false, false);
                Runnable _function = new Runnable(){

                    @Override
                    public void run() {
                        boolean _not;
                        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)modelId);
                        boolean bl = _not = !_isNullOrEmpty;
                        if (_not) {
                            EcoreUtil.setID((EObject)ObjectLangProcessGenerator.this.process, (String)modelId);
                        }
                        ObjectLangProcessGenerator.this.process.setModelName(fileName);
                        ObjectLangProcessGenerator.this.generateProcessComponents();
                        ObjectLangProcessGenerator.this.process.save();
                        ObjectLangProcessGenerator.this.debug(" process saved.");
                        String _id = null;
                        if (ObjectLangProcessGenerator.this.process != null) {
                            _id = ObjectLangProcessGenerator.this.process.getId();
                        }
                        String _plus = String.valueOf(fileName) + " (" + _id;
                        String _plus_1 = String.valueOf(_plus) + ") created at path ";
                        String _plus_2 = String.valueOf(_plus_1) + outlet;
                        ObjectLangProcessGenerator.this.info(_plus_2);
                    }
                };
                this.process.transact("Generate process model " + fileName, _function);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    throw new RuntimeException(e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        finally {
            ProcessFactory.eINSTANCE = orgProcessFactory;
        }
    }

    public String generateProcessComponents() {
        String _xblockexpression = null;
        StartSIB _newStartSIB = this.process.newStartSIB(50, 50, 100, 65);
        Procedures.Procedure1<StartSIB> _function = new Procedures.Procedure1<StartSIB>(){

            public void apply(StartSIB it) {
                ObjectLangProcessGenerator.this.generateProcessInputPorts(it);
            }
        };
        StartSIB _doubleArrow = (StartSIB)ObjectExtensions.operator_doubleArrow((Object)_newStartSIB, (Procedures.Procedure1)_function);
        this.setPreviousBranch((DataFlowSource)_doubleArrow);
        Functions.Function1<ObjectDef, Boolean> _function_1 = new Functions.Function1<ObjectDef, Boolean>(){

            public Boolean apply(ObjectDef it) {
                return !ObjectLangProcessGenerator.this._objectLangExtension.isAbstract(it) && !ObjectLangProcessGenerator.this.hasBeenCreated(it);
            }
        };
        Iterable _filter = IterableExtensions.filter(this.model.getObjects(), (Functions.Function1)_function_1);
        for (ObjectDef objDef : _filter) {
            this.generateObjectCreation(objDef);
        }
        EndSIB _newEndSIB = this.process.newEndSIB(0, 0, 100, 65);
        Procedures.Procedure1<EndSIB> _function_2 = new Procedures.Procedure1<EndSIB>(){

            public void apply(EndSIB it) {
                ObjectLangProcessGenerator.this.generateProcessOutputPorts(it);
            }
        };
        EndSIB endSIB = (EndSIB)ObjectExtensions.operator_doubleArrow((Object)_newEndSIB, (Procedures.Procedure1)_function_2);
        for (DataFlowSource previousBranch : this.previousBranches) {
            this._processModelGenerationLanguage.setSuccessor(previousBranch, (DataFlowTarget)endSIB);
        }
        this.debug(" apply manhattan layout to all edges");
        Consumer<DataFlow> _function_3 = new Consumer<DataFlow>(){

            @Override
            public void accept(DataFlow it) {
                EdgeLayout.C_LEFT.apply((Edge)it);
            }
        };
        Iterables.filter((Iterable)this.process.getAllEdges(), DataFlow.class).forEach(_function_3);
        _xblockexpression = this.debug(" process components generated.");
        return _xblockexpression;
    }

    public void generateProcessInputPorts(StartSIB startSIB) {
        EList<InputDef> _inputs = this.model.getInputs();
        for (final InputDef input : _inputs) {
            String _name = null;
            if (input != null) {
                _name = input.getName();
            }
            String _plus = "  creating StartSIB port for input " + _name;
            String _plus_1 = String.valueOf(_plus) + " (";
            PrimitiveType _elvis = null;
            PrimitiveType _primitiveType = this._objectLangExtension.getPrimitiveType(input);
            if (_primitiveType != null) {
                _elvis = _primitiveType;
            } else {
                Type _complexType = this._objectLangExtension.getComplexType(input);
                _elvis = _complexType;
            }
            String _plus_2 = String.valueOf(_plus_1) + _elvis;
            String _plus_3 = String.valueOf(_plus_2) + ")";
            this.debug(_plus_3);
            boolean _hasPrimitiveType = this._objectLangExtension.hasPrimitiveType(input);
            if (_hasPrimitiveType) {
                OutputPort _addOutputPort = this._processModelGenerationLanguage.addOutputPort((DataFlowSource)startSIB, this._objectLangExtension.getPrimitiveType(input), input.getName());
                Procedures.Procedure1<OutputPort> _function = new Procedures.Procedure1<OutputPort>(){

                    public void apply(OutputPort it) {
                        ObjectLangProcessGenerator.this.inputDef_on_port.put(input, it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_addOutputPort, (Procedures.Procedure1)_function);
                continue;
            }
            boolean _hasComplexType = this._objectLangExtension.hasComplexType(input);
            if (!_hasComplexType) continue;
            OutputPort _addOutputPort_1 = this._processModelGenerationLanguage.addOutputPort((DataFlowSource)startSIB, (Node)this._objectLangExtension.getComplexType(input));
            Procedures.Procedure1<OutputPort> _function_1 = new Procedures.Procedure1<OutputPort>(){

                public void apply(OutputPort it) {
                    it.setName(input.getName());
                    ObjectLangProcessGenerator.this.inputDef_on_port.put(input, it);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_addOutputPort_1, (Procedures.Procedure1)_function_1);
        }
    }

    public void generateProcessOutputPorts(EndSIB endSIB) {
        Functions.Function1<ObjectDef, Boolean> _function = new Functions.Function1<ObjectDef, Boolean>(){

            public Boolean apply(ObjectDef it) {
                OutputDef _output = it.getOutput();
                return _output != null;
            }
        };
        Iterable outObjs = IterableExtensions.filter(this.model.getObjects(), (Functions.Function1)_function);
        for (final ObjectDef outObj : outObjs) {
            InputPort _addInputPort = this._processModelGenerationLanguage.addInputPort((Container)endSIB, (Node)this._objectLangExtension.getType(outObj));
            Procedures.Procedure1<InputPort> _function_1 = new Procedures.Procedure1<InputPort>(){

                public void apply(InputPort it) {
                    String _name;
                    String _elvis = null;
                    String _alias = outObj.getOutput().getAlias();
                    _elvis = _alias != null ? _alias : (_name = outObj.getName());
                    it.setName(_elvis);
                    ObjectLangProcessGenerator.this._processModelGenerationLanguage.dataFlowFrom((Node)it, (Node)ObjectLangProcessGenerator.this.getObjectProvidingPort(outObj));
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_addInputPort, (Procedures.Procedure1)_function_1);
        }
    }

    protected SIB _generateObjectCreation(ObjectDef objDef) {
        boolean _not;
        SIB sib = this.generateObjectCreation(objDef, objDef.getCreation());
        boolean _isReferenced = this.isReferenced(objDef);
        boolean bl = _not = !_isReferenced;
        if (_not) {
            this.lastInCol.remove(objDef);
        }
        return sib;
    }

    protected SIB _generateObjectCreation(ObjectCreation objCrt) {
        return this.generateObjectCreation(objCrt, this.getHierarchicalAttributes(objCrt));
    }

    protected SIB _generateObjectCreation(ObjectInstantiation objInst, Iterable<AttributeDef> attributeDefs) {
        SIB sib = this.generateCreateSIB(objInst);
        Branch successBranch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)sib, "success");
        Functions.Function1<ComplexOutputPort, Boolean> _function = new Functions.Function1<ComplexOutputPort, Boolean>(){

            public Boolean apply(ComplexOutputPort it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"created");
            }
        };
        ComplexOutputPort _findThe = (ComplexOutputPort)this._graphModelExtension.findThe((ModelElementContainer)successBranch, ComplexOutputPort.class, (Functions.Function1)_function);
        Procedures.Procedure1<ComplexOutputPort> _function_1 = new Procedures.Procedure1<ComplexOutputPort>(){

            public void apply(ComplexOutputPort it) {
                it.resize(90, 18);
            }
        };
        ComplexOutputPort createdPort = (ComplexOutputPort)ObjectExtensions.operator_doubleArrow((Object)_findThe, (Procedures.Procedure1)_function_1);
        this.objCrt_on_port.put(objInst, createdPort);
        this.generatePrimitiveSetters(sib, objInst, attributeDefs);
        this.generatePrimitiveListSetters(objInst, attributeDefs);
        this.generateComplexSetters(objInst, attributeDefs);
        this.generateComplexListSetters(objInst, attributeDefs);
        this._processModelGenerationLanguage.alignBeneathOf((Node)successBranch, (Node)sib);
        return sib;
    }

    protected SIB _generateObjectCreation(ProcessOutput proOut, Iterable<AttributeDef> attributeDefs) {
        ProcessSIB sib = this.generateProcessSIB(proOut);
        this.generatePrimitiveSetters(proOut, attributeDefs);
        this.generatePrimitiveListSetters(proOut, attributeDefs);
        this.generateComplexSetters(proOut, attributeDefs);
        this.generateComplexListSetters(proOut, attributeDefs);
        return sib;
    }

    protected SIB _generateObjectCreation(ObjectDef objDef, ObjectInstantiation objInst) {
        boolean _not;
        SIB sib = this.generateObjectCreation(objInst);
        TypeDef _typeDef = this._objectLangExtension.getTypeDef(objDef);
        EObject _type = null;
        if (_typeDef != null) {
            _type = _typeDef.getType();
        }
        Type type = (Type)_type;
        Functions.Function1<PrimitiveInputPort, Boolean> _function = new Functions.Function1<PrimitiveInputPort, Boolean>(){

            public Boolean apply(PrimitiveInputPort it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"internalName");
            }
        };
        PrimitiveInputPort internal = (PrimitiveInputPort)this._graphModelExtension.findThe((ModelElementContainer)sib, PrimitiveInputPort.class, (Functions.Function1)_function);
        String _name = type.getName();
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)objDef.getName());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            String _name_1 = objDef.getName();
            _builder.append(_name_1, " ");
            _xifexpression = _builder;
        } else {
            _xifexpression = "";
        }
        String _plus = String.valueOf(_name) + _xifexpression;
        this.putStaticValue((InputPort)internal, _plus);
        this.generateDocumentation(objDef, (Node)sib);
        return sib;
    }

    protected SIB _generateObjectCreation(ObjectDef objDef, ProcessOutput proOut) {
        SIB sib = this.generateObjectCreation(proOut);
        this.generateDocumentation(objDef, (Node)sib);
        return sib;
    }

    public SIB generateCreateSIB(ObjectInstantiation objInst) {
        this.debug("  create CreateSIB for objInst: " + objInst);
        TypeDef _typeDef = this._objectLangExtension.getTypeDef(objInst);
        EObject _type = null;
        if (_typeDef != null) {
            _type = _typeDef.getType();
        }
        Type type = (Type)_type;
        Object _xifexpression = null;
        _xifexpression = type instanceof UserType ? this.process.newCreateUserSIB((EObject)type, 0, 0) : this.process.newCreateSIB((EObject)type, 0, 0);
        CreateUserSIB sib = _xifexpression;
        this.debug("  => " + sib);
        this.addToControlFlow((DataFlowTarget)sib, (ObjectCreation)objInst);
        Branch successBranch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)sib, "success");
        this.addToControlFlow((DataFlowSource)successBranch, (ObjectCreation)objInst);
        return sib;
    }

    public ProcessSIB generateProcessSIB(ProcessOutput processOutput) {
        ProcessSIB _xblockexpression = null;
        Process refProcess = this._objectLangExtension.getImportedProcessModel(processOutput.getProcessDef());
        ProcessSIB _xifexpression = null;
        if (refProcess != null) {
            _xifexpression = this.generateProcessSIB(refProcess, processOutput);
        } else {
            ProcessSIB _xblockexpression_1 = null;
            ObjectsModel objectsModel = this._objectLangExtension.getImportedObjectsModel(processOutput.getProcessDef());
            _xifexpression = _xblockexpression_1 = this.generateProcessSIB(objectsModel, processOutput);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ProcessSIB generateProcessSIB(final ObjectsModel objectsModel, ProcessOutput processOutput) {
        Functions.Function1<GenerateDef, String> _function = new Functions.Function1<GenerateDef, String>(){

            public String apply(GenerateDef it) {
                return it.getModelId();
            }
        };
        final String refID = (String)IterableExtensions.head((Iterable)ListExtensions.map(objectsModel.getGenerations(), (Functions.Function1)_function));
        this.debug("  create ProcessSIB for objects model: " + objectsModel);
        ProcessSIB _createProcessSIB = ProcessFactory.eINSTANCE.createProcessSIB();
        Procedures.Procedure1<ProcessSIB> _function_1 = new Procedures.Procedure1<ProcessSIB>(){

            public void apply(ProcessSIB it) {
                it.setLibraryComponentUID(refID);
                it.setLabel(ObjectLangProcessGenerator.this._objectLangExtension.getTargetFileName(objectsModel));
                it.setWidth(120);
            }
        };
        ProcessSIB processSIB = (ProcessSIB)ObjectExtensions.operator_doubleArrow((Object)_createProcessSIB, (Procedures.Procedure1)_function_1);
        InternalModelElement _internalElement_ = processSIB.getInternalElement_();
        this.process.getInternalContainerElement().getModelElements().add((Object)_internalElement_);
        this.debug("  => " + processSIB);
        ObjectsModelProcessSIBBuild.initialize(processSIB, objectsModel);
        this.generateProcessSIBInputs(processSIB, processOutput);
        Functions.Function1<ObjectDef, Boolean> _function_2 = new Functions.Function1<ObjectDef, Boolean>(){

            public Boolean apply(ObjectDef it) {
                OutputDef _output = it.getOutput();
                return _output != null;
            }
        };
        final ObjectDef output = (ObjectDef)IterableExtensions.findFirst(objectsModel.getObjects(), (Functions.Function1)_function_2);
        if (output != null) {
            Branch outputBranch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)processSIB, "success");
            this.addToControlFlow((DataFlowSource)outputBranch, (ObjectCreation)processOutput);
            Functions.Function1<OutputPort, Boolean> _function_3 = new Functions.Function1<OutputPort, Boolean>(){

                public Boolean apply(OutputPort it) {
                    String _name = it.getName();
                    String _name_1 = output.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            OutputPort createdPort = (OutputPort)this._graphModelExtension.findThe((ModelElementContainer)outputBranch, OutputPort.class, (Functions.Function1)_function_3);
            if (createdPort instanceof ComplexOutputPort) {
                this.objCrt_on_port.put(processOutput, (ComplexOutputPort)createdPort);
            }
        }
        return processSIB;
    }

    public ProcessSIB generateProcessSIB(Process refProcess, ProcessOutput processOutput) {
        String _modelName = null;
        if (refProcess != null) {
            _modelName = refProcess.getModelName();
        }
        String _plus = "  create ProcessSIB for process: " + _modelName;
        this.debug(_plus);
        ProcessSIB processSIB = this.process.newProcessSIB((EObject)refProcess, 0, 0);
        this.debug("  => " + processSIB);
        this.generateProcessSIBInputs(processSIB, processOutput);
        EObject _elvis = null;
        ProcessOutputDef _outputDef = processOutput.getOutputDef();
        EObject _output = null;
        if (_outputDef != null) {
            _output = _outputDef.getOutput();
        }
        if (_output != null) {
            _elvis = _output;
        } else {
            Process _proMod = processSIB.getProMod();
            Iterable _find = null;
            if (_proMod != null) {
                _find = this._graphModelExtension.find((ModelElementContainer)_proMod, EndSIB.class);
            }
            Iterable _flatMap = null;
            if (_find != null) {
                Functions.Function1<EndSIB, EList<InputPort>> _function = new Functions.Function1<EndSIB, EList<InputPort>>(){

                    public EList<InputPort> apply(EndSIB it) {
                        return it.getInputPorts();
                    }
                };
                _flatMap = IterableExtensions.flatMap((Iterable)_find, (Functions.Function1)_function);
            }
            InputPort _head = null;
            if (_flatMap != null) {
                _head = (InputPort)IterableExtensions.head(_flatMap);
            }
            _elvis = _head;
        }
        final EObject output = _elvis;
        if (output instanceof InputPort) {
            ModelElementContainer _container = ((InputPort)output).getContainer();
            EndSIB endSib = (EndSIB)_container;
            final Branch outputBranch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)processSIB, endSib.getBranchName());
            this.addToControlFlow((DataFlowSource)outputBranch, (ObjectCreation)processOutput);
            Branch lastBranch = outputBranch;
            Functions.Function1<Branch, Boolean> _function_1 = new Functions.Function1<Branch, Boolean>(){

                public Boolean apply(Branch it) {
                    return ObjectLangProcessGenerator.this._graphModelExtension.operator_notEquals((IdentifiableElement)it, (IdentifiableElement)outputBranch);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)processSIB.getBranchSuccessors(), (Functions.Function1)_function_1);
            for (Branch otherBranch : _filter) {
                int _right = this._processModelGenerationLanguage.getRight((Node)lastBranch);
                int _plus_1 = _right + 10;
                int _bottom = this._processModelGenerationLanguage.getBottom((Node)lastBranch);
                int _plus_2 = _bottom + 10;
                otherBranch.move(_plus_1, _plus_2);
                this.previousBranches.add((DataFlowSource)otherBranch);
                lastBranch = otherBranch;
            }
            Functions.Function1<OutputPort, Boolean> _function_2 = new Functions.Function1<OutputPort, Boolean>(){

                public Boolean apply(OutputPort it) {
                    String _name = it.getName();
                    String _name_1 = ((InputPort)output).getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            OutputPort createdPort = (OutputPort)this._graphModelExtension.findThe((ModelElementContainer)outputBranch, OutputPort.class, (Functions.Function1)_function_2);
            if (createdPort instanceof ComplexOutputPort) {
                this.objCrt_on_port.put(processOutput, (ComplexOutputPort)createdPort);
            }
        }
        return processSIB;
    }

    public DataFlowTarget generateProcessSIBInputs(ProcessSIB processSIB, ProcessOutput processOutput) {
        DataFlowTarget _xblockexpression = null;
        EList<ProcessArgumentDef> _arguments = processOutput.getArguments();
        for (ProcessArgumentDef arg : _arguments) {
            boolean _isEnumPort;
            boolean _hasPrimitiveType;
            PrimitiveOutputPort valOutput;
            boolean _isHashed;
            AttributeValueDef _valueDef;
            EObject inputDef = arg.getKey();
            String _switchResult = null;
            boolean _matched = false;
            if (inputDef instanceof OutputPort) {
                _matched = true;
                _switchResult = ((OutputPort)inputDef).getName();
            }
            if (!_matched && inputDef instanceof InputDef) {
                _matched = true;
                _switchResult = ((InputDef)inputDef).getName();
            }
            final String inputName = _switchResult;
            boolean _switchResult_1 = false;
            boolean _matched_1 = false;
            if (inputDef instanceof OutputPort) {
                _matched_1 = true;
                _switchResult_1 = this._objectLangExtension.isEnumPort((IO)inputDef);
            }
            if (!_matched_1 && inputDef instanceof InputDef) {
                _matched_1 = true;
                _switchResult_1 = false;
            }
            boolean hasEnumType = _switchResult_1;
            boolean _switchResult_2 = false;
            boolean _matched_2 = false;
            if (inputDef instanceof OutputPort) {
                _matched_2 = true;
                _switchResult_2 = this._objectLangExtension.hasPrimitiveType((IO)inputDef, PrimitiveType.FILE);
            }
            if (!_matched_2 && inputDef instanceof InputDef) {
                _matched_2 = true;
                _switchResult_2 = this._objectLangExtension.hasPrimitiveType((InputDef)inputDef, PrimitiveType.FILE);
            }
            boolean hasFileType = _switchResult_2;
            PrimitiveType _switchResult_3 = null;
            boolean _matched_3 = false;
            if (inputDef instanceof OutputPort) {
                _matched_3 = true;
                _switchResult_3 = this._objectLangExtension.getPrimitiveType((IO)inputDef);
            }
            if (!_matched_3 && inputDef instanceof InputDef) {
                _matched_3 = true;
                _switchResult_3 = this._objectLangExtension.getPrimitiveType((InputDef)inputDef);
            }
            PrimitiveType primitiveType = _switchResult_3;
            Functions.Function1<InputPort, Boolean> _function = new Functions.Function1<InputPort, Boolean>(){

                public Boolean apply(InputPort it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)inputName);
                }
            };
            InputPort sibInputPort = (InputPort)this._graphModelExtension.findThe((ModelElementContainer)processSIB, InputPort.class, (Functions.Function1)_function);
            final AttributeValueDef valueDef = _valueDef = arg.getValueDef();
            boolean _matched_4 = false;
            if (valueDef instanceof TextAttributeValueDef && (_isHashed = ((TextAttributeValueDef)valueDef).isHashed())) {
                _matched_4 = true;
                valOutput = this.generateHashedTextProvider(processOutput, ((TextAttributeValueDef)valueDef).getValue());
                this._processModelGenerationLanguage.dataFlowTo((Node)valOutput, (Node)sibInputPort);
            }
            if (!_matched_4 && valueDef instanceof TextAttributeValueDef && (_hasPrimitiveType = this._objectLangExtension.hasPrimitiveType((IO)sibInputPort, PrimitiveType.FILE))) {
                _matched_4 = true;
                valOutput = this.generateFileProvider(processOutput, ((TextAttributeValueDef)valueDef).getValue());
                this._processModelGenerationLanguage.dataFlowTo((Node)valOutput, (Node)sibInputPort);
            }
            if (!_matched_4 && valueDef instanceof TextAttributeValueDef && (_isEnumPort = this._objectLangExtension.isEnumPort((IO)sibInputPort))) {
                _matched_4 = true;
                Type enumType = this._objectLangExtension.getComplexType(arg);
                Functions.Function1<EnumLiteral, Boolean> _function_1 = new Functions.Function1<EnumLiteral, Boolean>(){

                    public Boolean apply(EnumLiteral it) {
                        String _name = it.getName();
                        String _value = ((TextAttributeValueDef)valueDef).getValue();
                        return Objects.equal((Object)_name, (Object)_value);
                    }
                };
                EnumLiteral literal = (EnumLiteral)IterableExtensions.findFirst((Iterable)enumType.getEnumLiterals(), (Functions.Function1)_function_1);
                ComplexOutputPort valOutput2 = this.generateEnumLiteralProvider(processOutput, literal);
                this._processModelGenerationLanguage.dataFlowTo((Node)valOutput2, (Node)sibInputPort);
            }
            if (!_matched_4 && valueDef instanceof IntegerAttributeValueDef && (_hasPrimitiveType = this._objectLangExtension.hasPrimitiveType((IO)sibInputPort, PrimitiveType.TIMESTAMP))) {
                _matched_4 = true;
                this.putStaticValue(sibInputPort, (PrimitiveAttributeValueDef)valueDef);
            }
            if (!_matched_4 && valueDef instanceof PrimitiveAttributeValueDef) {
                _matched_4 = true;
                this.putStaticValue(sibInputPort, (PrimitiveAttributeValueDef)valueDef);
            }
            if (!_matched_4 && valueDef instanceof PrimitiveListAttributeValueDef) {
                boolean _not;
                _matched_4 = true;
                List<?> values = this._objectLangExtension.getValues((PrimitiveListAttributeValueDef)valueDef);
                final ArrayList valOutputs = CollectionLiterals.newArrayList();
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(values);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    PutToContextSIB _newPutToContextSIB = this.process.newPutToContextSIB(0, 0);
                    Procedures.Procedure1<PutToContextSIB> _function_1 = new Procedures.Procedure1<PutToContextSIB>(){

                        public void apply(PutToContextSIB it) {
                            it.resize(120, 65);
                        }
                    };
                    PutToContextSIB putToContextSIB = (PutToContextSIB)ObjectExtensions.operator_doubleArrow((Object)_newPutToContextSIB, (Procedures.Procedure1)_function_1);
                    Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)putToContextSIB, "success");
                    Procedures.Procedure1<Branch> _function_2 = new Procedures.Procedure1<Branch>(){

                        public void apply(Branch it) {
                            it.resize(120, 25);
                        }
                    };
                    Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_2);
                    int index = 0;
                    for (final Object value : values) {
                        int _plusPlus = index++;
                        String name = "val" + Integer.valueOf(_plusPlus);
                        this.debug("   startSIBPort: " + inputName + " isEnum: " + Boolean.valueOf(hasEnumType));
                        if (hasEnumType) {
                            this.debug(" generate enum literal setter for argDef: " + arg);
                            Type enumType = this._objectLangExtension.getComplexType((IO)((OutputPort)inputDef));
                            Functions.Function1<EnumLiteral, Boolean> _function_3 = new Functions.Function1<EnumLiteral, Boolean>(){

                                public Boolean apply(EnumLiteral it) {
                                    String _name = it.getName();
                                    String _string = null;
                                    if (value != null) {
                                        _string = value.toString();
                                    }
                                    return Objects.equal((Object)_name, _string);
                                }
                            };
                            EnumLiteral literal = (EnumLiteral)IterableExtensions.findFirst((Iterable)enumType.getEnumLiterals(), (Functions.Function1)_function_3);
                            ComplexOutputPort valOutput3 = this.generateEnumLiteralProvider(processOutput, literal);
                            valOutputs.add(valOutput3);
                            continue;
                        }
                        if (hasFileType) {
                            this.debug(" generate file setter for argDef: " + arg);
                            String _string = null;
                            if (value != null) {
                                _string = value.toString();
                            }
                            PrimitiveOutputPort valOutput_1 = this.generateFileProvider(processOutput, _string);
                            valOutputs.add(valOutput_1);
                            continue;
                        }
                        boolean _isHashed2 = this._objectLangExtension.isHashed(valueDef);
                        if (_isHashed2) {
                            this.debug(" generate hashed password setter for argDef: " + arg);
                            String _string_1 = null;
                            if (value != null) {
                                _string_1 = value.toString();
                            }
                            PrimitiveOutputPort valOutput_2 = this.generateHashedTextProvider(processOutput, _string_1);
                            valOutputs.add(valOutput_2);
                            continue;
                        }
                        InputStatic _addStaticInputPort = this._processModelGenerationLanguage.addStaticInputPort((SIB)putToContextSIB, primitiveType, name, value);
                        Procedures.Procedure1<InputStatic> _function_4 = new Procedures.Procedure1<InputStatic>(){

                            public void apply(InputStatic it) {
                                it.resize(90, 18);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_addStaticInputPort, (Procedures.Procedure1)_function_4);
                        OutputPort _addOutputPort = this._processModelGenerationLanguage.addOutputPort((DataFlowSource)successBranch, primitiveType, name);
                        Procedures.Procedure1<OutputPort> _function_5 = new Procedures.Procedure1<OutputPort>(){

                            public void apply(OutputPort it) {
                                it.resize(90, 18);
                                valOutputs.add(it);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_addOutputPort, (Procedures.Procedure1)_function_5);
                    }
                    this.addToControlFlow((DataFlowTarget)putToContextSIB, (ObjectCreation)processOutput);
                    this.addToControlFlow((DataFlowSource)successBranch, (ObjectCreation)processOutput);
                    Variable variable = this.generateInputVariable(sibInputPort);
                    for (OutputPort valOutput4 : valOutputs) {
                        DataFlow _dataFlowTo = this._processModelGenerationLanguage.dataFlowTo((Node)valOutput4, (Node)variable);
                        Procedures.Procedure1<DataFlow> _function_3 = new Procedures.Procedure1<DataFlow>(){

                            public void apply(DataFlow it) {
                                EdgeLayout.C_LEFT.apply((Edge)it);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_dataFlowTo, (Procedures.Procedure1)_function_3);
                    }
                }
            }
            if (!_matched_4) {
                if (valueDef instanceof ObjectCreation) {
                    _matched_4 = true;
                }
                if (!_matched_4 && valueDef instanceof AttributeValueReferenceDef) {
                    _matched_4 = true;
                }
                if (_matched_4) {
                    this.generateRead(sibInputPort, valueDef);
                }
            }
            if (_matched_4 || !(valueDef instanceof ComplexListAttributeValuesDef)) continue;
            _matched_4 = true;
            this.generateComplexListRead((ComplexInputPort)sibInputPort, (ComplexListAttributeValuesDef)valueDef, processOutput);
        }
        _xblockexpression = this.addToControlFlow((DataFlowTarget)processSIB, (ObjectCreation)processOutput);
        return _xblockexpression;
    }

    public Documentation generateDocumentation(ObjectDef objDef, Node node) {
        Documentation _xblockexpression = null;
        this.debug("  create Documentation for objDef: " + objDef);
        String _elvis = null;
        String _name = objDef.getName();
        _elvis = _name != null ? _name : "<unnamed>";
        final String content = _elvis;
        int _width = node.getWidth();
        int _length = content.length();
        int _multiply = _length * 5;
        int width = Math.max(_width, _multiply);
        int _x = node.getX();
        int _y = node.getY();
        int _minus = _y - 60;
        Documentation _newDocumentation = this.process.newDocumentation(_x, _minus, width, 50);
        Procedures.Procedure1<Documentation> _function = new Procedures.Procedure1<Documentation>(){

            public void apply(Documentation it) {
                it.setContent(content);
            }
        };
        _xblockexpression = (Documentation)ObjectExtensions.operator_doubleArrow((Object)_newDocumentation, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public InputStatic toStatic(PrimitiveInputPort inputPort) {
        InputStatic _xblockexpression = null;
        ModelElementContainer _container = inputPort.getContainer();
        DataFlowTarget sib = (DataFlowTarget)_container;
        String name = inputPort.getName();
        PrimitiveType type = this._objectLangExtension.mapOnDataType(inputPort.getDataType());
        inputPort.delete();
        InputStatic _switchResult = null;
        if (type != null) {
            switch (type) {
                case BOOLEAN: {
                    BooleanInputStatic _addStaticBooleanInputPort = this._processModelGenerationLanguage.addStaticBooleanInputPort(sib, name);
                    Procedures.Procedure1<BooleanInputStatic> _function = new Procedures.Procedure1<BooleanInputStatic>(){

                        public void apply(BooleanInputStatic it) {
                            it.resize(90, 18);
                        }
                    };
                    _switchResult = (InputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticBooleanInputPort, (Procedures.Procedure1)_function);
                    break;
                }
                case FILE: {
                    throw new RuntimeException("Static File input ports are not supported");
                }
                case INTEGER: {
                    IntegerInputStatic _addStaticIntegerInputPort = this._processModelGenerationLanguage.addStaticIntegerInputPort(sib, name);
                    Procedures.Procedure1<IntegerInputStatic> _function_1 = new Procedures.Procedure1<IntegerInputStatic>(){

                        public void apply(IntegerInputStatic it) {
                            it.resize(90, 18);
                        }
                    };
                    _switchResult = (InputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticIntegerInputPort, (Procedures.Procedure1)_function_1);
                    break;
                }
                case REAL: {
                    RealInputStatic _addStaticRealInputPort = this._processModelGenerationLanguage.addStaticRealInputPort(sib, name);
                    Procedures.Procedure1<RealInputStatic> _function_2 = new Procedures.Procedure1<RealInputStatic>(){

                        public void apply(RealInputStatic it) {
                            it.resize(90, 18);
                        }
                    };
                    _switchResult = (InputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticRealInputPort, (Procedures.Procedure1)_function_2);
                    break;
                }
                case TIMESTAMP: {
                    TimestampInputStatic _addStaticTimestampInputPort = this._processModelGenerationLanguage.addStaticTimestampInputPort(sib, name);
                    Procedures.Procedure1<TimestampInputStatic> _function_3 = new Procedures.Procedure1<TimestampInputStatic>(){

                        public void apply(TimestampInputStatic it) {
                            it.resize(90, 18);
                        }
                    };
                    _switchResult = (InputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticTimestampInputPort, (Procedures.Procedure1)_function_3);
                    break;
                }
                case TEXT: {
                    TextInputStatic _addStaticTextInputPort = this._processModelGenerationLanguage.addStaticTextInputPort(sib, name);
                    Procedures.Procedure1<TextInputStatic> _function_4 = new Procedures.Procedure1<TextInputStatic>(){

                        public void apply(TextInputStatic it) {
                            it.resize(90, 18);
                        }
                    };
                    _switchResult = (InputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticTextInputPort, (Procedures.Procedure1)_function_4);
                    break;
                }
            }
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public InputStatic putStaticValue(InputPort inputPort, PrimitiveAttributeValueDef valueDef) {
        BooleanInputStatic _switchResult = null;
        boolean _matched = false;
        if (valueDef instanceof BooleanAttributeValueDef) {
            _matched = true;
            _switchResult = this.putStaticValue(inputPort, ((BooleanAttributeValueDef)valueDef).isValue());
        }
        if (!_matched && valueDef instanceof RealAttributeValueDef) {
            _matched = true;
            _switchResult = this.putStaticValue(inputPort, ((RealAttributeValueDef)valueDef).getValue());
        }
        if (!_matched && valueDef instanceof IntegerAttributeValueDef) {
            _matched = true;
            _switchResult = this.putStaticValue(inputPort, ((IntegerAttributeValueDef)valueDef).getValue());
        }
        if (!_matched && valueDef instanceof TextAttributeValueDef) {
            _matched = true;
            _switchResult = this.putStaticValue(inputPort, ((TextAttributeValueDef)valueDef).getValue());
        }
        return _switchResult;
    }

    public BooleanInputStatic putStaticValue(InputPort inputPort, final Boolean value) {
        BooleanInputStatic _xblockexpression = null;
        ModelElementContainer _container = inputPort.getContainer();
        DataFlowTarget sib = (DataFlowTarget)_container;
        String name = inputPort.getName();
        inputPort.delete();
        BooleanInputStatic _addStaticBooleanInputPort = this._processModelGenerationLanguage.addStaticBooleanInputPort(sib, name);
        Procedures.Procedure1<BooleanInputStatic> _function = new Procedures.Procedure1<BooleanInputStatic>(){

            public void apply(BooleanInputStatic it) {
                it.setValue(value.booleanValue());
                it.resize(90, 18);
            }
        };
        _xblockexpression = (BooleanInputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticBooleanInputPort, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public IntegerInputStatic putStaticValue(InputPort inputPort, final Long value) {
        IntegerInputStatic _xblockexpression = null;
        ModelElementContainer _container = inputPort.getContainer();
        DataFlowTarget sib = (DataFlowTarget)_container;
        String name = inputPort.getName();
        inputPort.delete();
        IntegerInputStatic _addStaticIntegerInputPort = this._processModelGenerationLanguage.addStaticIntegerInputPort(sib, name);
        Procedures.Procedure1<IntegerInputStatic> _function = new Procedures.Procedure1<IntegerInputStatic>(){

            public void apply(IntegerInputStatic it) {
                it.setValue(value.longValue());
                it.resize(90, 18);
            }
        };
        _xblockexpression = (IntegerInputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticIntegerInputPort, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public RealInputStatic putStaticValue(InputPort inputPort, final Double value) {
        RealInputStatic _xblockexpression = null;
        ModelElementContainer _container = inputPort.getContainer();
        DataFlowTarget sib = (DataFlowTarget)_container;
        String name = inputPort.getName();
        inputPort.delete();
        RealInputStatic _addStaticRealInputPort = this._processModelGenerationLanguage.addStaticRealInputPort(sib, name);
        Procedures.Procedure1<RealInputStatic> _function = new Procedures.Procedure1<RealInputStatic>(){

            public void apply(RealInputStatic it) {
                it.setValue(value.doubleValue());
                it.resize(90, 18);
            }
        };
        _xblockexpression = (RealInputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticRealInputPort, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public TextInputStatic putStaticValue(InputPort inputPort, final String value) {
        TextInputStatic _xblockexpression = null;
        ModelElementContainer _container = inputPort.getContainer();
        DataFlowTarget sib = (DataFlowTarget)_container;
        String name = inputPort.getName();
        inputPort.delete();
        TextInputStatic _addStaticTextInputPort = this._processModelGenerationLanguage.addStaticTextInputPort(sib, name);
        Procedures.Procedure1<TextInputStatic> _function = new Procedures.Procedure1<TextInputStatic>(){

            public void apply(TextInputStatic it) {
                it.setValue(value);
                it.resize(90, 18);
            }
        };
        _xblockexpression = (TextInputStatic)ObjectExtensions.operator_doubleArrow((Object)_addStaticTextInputPort, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public void generatePrimitiveSetters(final SIB createSIB, final ObjectCreation objCrt, Iterable<AttributeDef> attributeDefs) {
        this.debug(" generate primitive setters for objCrt: " + objCrt);
        Consumer<AttributeDef> _function = new Consumer<AttributeDef>(){

            @Override
            public void accept(AttributeDef attrDef) {
                boolean _isTimestampAttribute;
                Object _function;
                boolean _isIntegerAttribute;
                Object _function2;
                boolean _isHashed;
                boolean _isEnumAttribute;
                boolean _isFileAttribute;
                AttributeValueDef _valueDef;
                EObject _key = attrDef.getKey();
                Attribute attribute = (Attribute)_key;
                final AttributeValueDef valueDef = _valueDef = attrDef.getValueDef();
                boolean _matched = false;
                if (valueDef instanceof TextAttributeValueDef && (_isFileAttribute = ObjectLangProcessGenerator.this._dataExtension.isFileAttribute(attribute))) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generateFileSetter(objCrt, attrDef, (TextAttributeValueDef)valueDef);
                }
                if (!_matched && valueDef instanceof TextAttributeValueDef && (_isEnumAttribute = ObjectLangProcessGenerator.this._objectLangExtension.isEnumAttribute(attribute))) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generateEnumLiteralSetter(objCrt, attrDef, ((TextAttributeValueDef)valueDef).getValue());
                }
                if (!_matched && valueDef instanceof TextAttributeValueDef && (_isHashed = ((TextAttributeValueDef)valueDef).isHashed())) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generateHashedTextSetter(objCrt, attrDef, ((TextAttributeValueDef)valueDef).getValue());
                }
                if (!_matched && valueDef instanceof TextAttributeValueDef && ObjectLangProcessGenerator.this._dataExtension.isTextAttribute(attribute) && !((TextAttributeValueDef)valueDef).isHashed()) {
                    _matched = true;
                    TextInputStatic _addStaticTextInputPort = ObjectLangProcessGenerator.this._processModelGenerationLanguage.addStaticTextInputPort((DataFlowTarget)createSIB, attribute.getName());
                    _function2 = new Procedures.Procedure1<TextInputStatic>(){

                        public void apply(TextInputStatic it) {
                            it.setValue(((TextAttributeValueDef)valueDef).getValue());
                            it.resize(90, 18);
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_addStaticTextInputPort, (Procedures.Procedure1)_function2);
                }
                if (!_matched && valueDef instanceof BooleanAttributeValueDef) {
                    _matched = true;
                    BooleanInputStatic _addStaticBooleanInputPort = ObjectLangProcessGenerator.this._processModelGenerationLanguage.addStaticBooleanInputPort((DataFlowTarget)createSIB, attribute.getName());
                    _function2 = new Procedures.Procedure1<BooleanInputStatic>(){

                        public void apply(BooleanInputStatic it) {
                            it.setValue(((BooleanAttributeValueDef)valueDef).isValue());
                            it.resize(90, 18);
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_addStaticBooleanInputPort, (Procedures.Procedure1)_function2);
                }
                if (!_matched && valueDef instanceof IntegerAttributeValueDef && (_isIntegerAttribute = ObjectLangProcessGenerator.this._dataExtension.isIntegerAttribute(attribute))) {
                    _matched = true;
                    IntegerInputStatic _addStaticIntegerInputPort = ObjectLangProcessGenerator.this._processModelGenerationLanguage.addStaticIntegerInputPort((DataFlowTarget)createSIB, attribute.getName());
                    _function = new Procedures.Procedure1<IntegerInputStatic>(){

                        public void apply(IntegerInputStatic it) {
                            it.setValue(((IntegerAttributeValueDef)valueDef).getValue());
                            it.resize(90, 18);
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_addStaticIntegerInputPort, (Procedures.Procedure1)_function);
                }
                if (!_matched && valueDef instanceof IntegerAttributeValueDef && (_isTimestampAttribute = ObjectLangProcessGenerator.this._dataExtension.isTimestampAttribute(attribute))) {
                    _matched = true;
                    TimestampInputStatic _addStaticTimestampInputPort = ObjectLangProcessGenerator.this._processModelGenerationLanguage.addStaticTimestampInputPort((DataFlowTarget)createSIB, attribute.getName());
                    _function = new Procedures.Procedure1<TimestampInputStatic>(){

                        public void apply(TimestampInputStatic it) {
                            it.setValue(((IntegerAttributeValueDef)valueDef).getValue());
                            it.resize(90, 18);
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_addStaticTimestampInputPort, (Procedures.Procedure1)_function);
                }
                if (!_matched && valueDef instanceof RealAttributeValueDef) {
                    _matched = true;
                    RealInputStatic _addStaticRealInputPort = ObjectLangProcessGenerator.this._processModelGenerationLanguage.addStaticRealInputPort((DataFlowTarget)createSIB, attribute.getName());
                    _function2 = new Procedures.Procedure1<RealInputStatic>(){

                        public void apply(RealInputStatic it) {
                            it.setValue(((RealAttributeValueDef)valueDef).getValue());
                            it.resize(90, 18);
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_addStaticRealInputPort, (Procedures.Procedure1)_function2);
                }
                if (!_matched && valueDef instanceof AttributeValueReferenceDef) {
                    boolean _hasPrimitiveType;
                    NamedObject _value;
                    _matched = true;
                    NamedObject it = _value = ((AttributeValueReferenceDef)valueDef).getValue();
                    boolean _matched_1 = false;
                    if (it instanceof InputDef && (_hasPrimitiveType = ObjectLangProcessGenerator.this._objectLangExtension.hasPrimitiveType((InputDef)it))) {
                        _matched_1 = true;
                        ObjectLangProcessGenerator.this.generateInputValueSetter(objCrt, attrDef, (AttributeValueReferenceDef)valueDef);
                    }
                }
                if (!_matched && valueDef instanceof ProcessOutput && !(attribute instanceof ComplexAttribute)) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generateProcessOutputSetter(objCrt, attrDef, (ProcessOutput)valueDef);
                }
            }
        };
        attributeDefs.forEach(_function);
    }

    public void generatePrimitiveSetters(final ObjectCreation objCrt, Iterable<AttributeDef> attributeDefs) {
        this.debug(" generate primitive setters for objCrt: " + objCrt);
        Consumer<AttributeDef> _function = new Consumer<AttributeDef>(){

            @Override
            public void accept(AttributeDef attrDef) {
                AttributeValueDef _valueDef;
                EObject _key = attrDef.getKey();
                Attribute attribute = (Attribute)_key;
                AttributeValueDef valueDef = _valueDef = attrDef.getValueDef();
                boolean _matched = false;
                if (valueDef instanceof PrimitiveAttributeValueDef) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generatePrimitiveSetter(objCrt, attrDef, (PrimitiveAttributeValueDef)valueDef);
                }
                if (!_matched && valueDef instanceof AttributeValueReferenceDef) {
                    boolean _hasPrimitiveType;
                    NamedObject _value;
                    _matched = true;
                    NamedObject it = _value = ((AttributeValueReferenceDef)valueDef).getValue();
                    boolean _matched_1 = false;
                    if (it instanceof InputDef && (_hasPrimitiveType = ObjectLangProcessGenerator.this._objectLangExtension.hasPrimitiveType((InputDef)it))) {
                        _matched_1 = true;
                        ObjectLangProcessGenerator.this.generateInputValueSetter(objCrt, attrDef, (AttributeValueReferenceDef)valueDef);
                    }
                }
                if (!_matched && valueDef instanceof ProcessOutput && !(attribute instanceof ComplexAttribute)) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generateProcessOutputSetter(objCrt, attrDef, (ProcessOutput)valueDef);
                }
            }
        };
        attributeDefs.forEach(_function);
    }

    protected Container _generatePrimitiveSetter(ObjectCreation objCrt, AttributeDef attrDef, final TextAttributeValueDef valueDef) {
        SetAttributeValueSIB _xblockexpression = null;
        EObject _key = attrDef.getKey();
        Attribute attribute = (Attribute)_key;
        String _name = null;
        if (attribute != null) {
            _name = attribute.getName();
        }
        String _plus = "   attribute: " + _name;
        String _plus_1 = String.valueOf(_plus) + " isEnum: ";
        boolean _isEnumAttribute = this._objectLangExtension.isEnumAttribute(attribute);
        String _plus_2 = String.valueOf(_plus_1) + Boolean.valueOf(_isEnumAttribute);
        this.debug(_plus_2);
        SetAttributeValueSIB _xifexpression = null;
        boolean _isFileAttribute = this._dataExtension.isFileAttribute(attribute);
        if (_isFileAttribute) {
            SetAttributeValueSIB _xblockexpression_1 = null;
            this.debug(" generate file setter for attrDef: " + attrDef);
            _xifexpression = _xblockexpression_1 = this.generateFileSetter(objCrt, attrDef, valueDef);
        } else {
            SetAttributeValueSIB _xifexpression_1 = null;
            boolean _isEnumAttribute_1 = this._objectLangExtension.isEnumAttribute(attribute);
            if (_isEnumAttribute_1) {
                SetAttributeValueSIB _xblockexpression_2 = null;
                this.debug(" generate enum literal setter for attrDef: " + attrDef);
                _xifexpression_1 = _xblockexpression_2 = this.generateEnumLiteralSetter(objCrt, attrDef, valueDef.getValue());
            } else {
                SetAttributeValueSIB _xifexpression_2 = null;
                boolean _isHashed = valueDef.isHashed();
                if (_isHashed) {
                    SetAttributeValueSIB _xblockexpression_3 = null;
                    this.debug(" generate hashed password setter for attrDef: " + attrDef);
                    _xifexpression_2 = _xblockexpression_3 = this.generateHashedTextSetter(objCrt, attrDef, valueDef.getValue());
                } else {
                    TextInputStatic _xblockexpression_4 = null;
                    this.debug(" generate Text setter for attrDef: " + attrDef);
                    SetAttributeValueSIB sib = this.generateStaticSetter(objCrt, attrDef);
                    TextInputStatic _findThe = (TextInputStatic)this._graphModelExtension.findThe((ModelElementContainer)sib, TextInputStatic.class);
                    Procedures.Procedure1<TextInputStatic> _function = new Procedures.Procedure1<TextInputStatic>(){

                        public void apply(TextInputStatic it) {
                            ObjectLangProcessGenerator.this.debug(" TextInputStatic: " + it);
                            String _value = valueDef.getValue();
                            String _plus = "   -> set value: " + _value;
                            ObjectLangProcessGenerator.this.debug(_plus);
                            it.setValue(valueDef.getValue());
                            it.resize(90, 18);
                        }
                    };
                    _xblockexpression_4 = (TextInputStatic)ObjectExtensions.operator_doubleArrow((Object)_findThe, (Procedures.Procedure1)_function);
                    _xifexpression_2 = _xblockexpression_4;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Container _generatePrimitiveSetter(ObjectCreation objCrt, AttributeDef attrDef, final IntegerAttributeValueDef valueDef) {
        SetAttributeValueSIB sib = this.generateStaticSetter(objCrt, attrDef);
        EObject _key = attrDef.getKey();
        Attribute attr = (Attribute)_key;
        boolean _matched = false;
        boolean _isTimestampAttribute = this._dataExtension.isTimestampAttribute(attr);
        if (_isTimestampAttribute) {
            _matched = true;
            this.debug(" generate Timestamp setter for attrdef: " + attrDef);
            TimestampInputStatic _findThe = (TimestampInputStatic)this._graphModelExtension.findThe((ModelElementContainer)sib, TimestampInputStatic.class);
            Procedures.Procedure1<TimestampInputStatic> _function = new Procedures.Procedure1<TimestampInputStatic>(){

                public void apply(TimestampInputStatic it) {
                    it.setValue(valueDef.getValue());
                    it.resize(90, 18);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_findThe, (Procedures.Procedure1)_function);
        }
        if (!_matched) {
            this.debug(" generate Integer setter for attrdef: " + attrDef);
            IntegerInputStatic _findThe_1 = (IntegerInputStatic)this._graphModelExtension.findThe((ModelElementContainer)sib, IntegerInputStatic.class);
            Procedures.Procedure1<IntegerInputStatic> _function_1 = new Procedures.Procedure1<IntegerInputStatic>(){

                public void apply(IntegerInputStatic it) {
                    it.setValue(valueDef.getValue());
                    it.resize(90, 18);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_findThe_1, (Procedures.Procedure1)_function_1);
        }
        return sib;
    }

    protected Container _generatePrimitiveSetter(ObjectCreation objCrt, AttributeDef attrDef, final RealAttributeValueDef valueDef) {
        this.debug(" generate Real setter for attrdef: " + attrDef);
        SetAttributeValueSIB sib = this.generateStaticSetter(objCrt, attrDef);
        RealInputStatic _findThe = (RealInputStatic)this._graphModelExtension.findThe((ModelElementContainer)sib, RealInputStatic.class);
        Procedures.Procedure1<RealInputStatic> _function = new Procedures.Procedure1<RealInputStatic>(){

            public void apply(RealInputStatic it) {
                it.setValue(valueDef.getValue());
                it.resize(90, 18);
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_findThe, (Procedures.Procedure1)_function);
        return sib;
    }

    protected Container _generatePrimitiveSetter(ObjectCreation objCrt, AttributeDef attrDef, final BooleanAttributeValueDef valueDef) {
        this.debug(" generate Boolean setter for attrdef: " + attrDef);
        SetAttributeValueSIB sib = this.generateStaticSetter(objCrt, attrDef);
        BooleanInputStatic _findThe = (BooleanInputStatic)this._graphModelExtension.findThe((ModelElementContainer)sib, BooleanInputStatic.class);
        Procedures.Procedure1<BooleanInputStatic> _function = new Procedures.Procedure1<BooleanInputStatic>(){

            public void apply(BooleanInputStatic it) {
                it.setValue(valueDef.isValue());
                it.resize(90, 18);
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_findThe, (Procedures.Procedure1)_function);
        return sib;
    }

    public SetAttributeValueSIB generateInputValueSetter(ObjectCreation objCrt, AttributeDef attrDef, AttributeValueReferenceDef valueDef) {
        SetAttributeValueSIB _xblockexpression = null;
        this.debug(" generate Input value setter for attrdef: " + attrDef);
        OutputPort valOutput = this.getObjectProvidingPort(valueDef.getValue());
        EObject _key = attrDef.getKey();
        _xblockexpression = this.generateSetAttributeValueSIB(objCrt, (Attribute)_key, (Output)valOutput);
        return _xblockexpression;
    }

    public PrimitiveOutputPort generateFileProvider(ObjectCreation objCrt, String filePath) {
        EObject nativeDef = ReferenceRegistry.getInstance().getEObject("common.UploadProjectResource");
        this.debug(" native 'common.UploadProjectResource' from registry: " + nativeDef);
        AtomicSIB _newAtomicSIB = this.process.newAtomicSIB(nativeDef, 0, 0);
        Procedures.Procedure1<AtomicSIB> _function = new Procedures.Procedure1<AtomicSIB>(){

            public void apply(AtomicSIB it) {
                it.resize(120, 65);
            }
        };
        AtomicSIB nativeSib = (AtomicSIB)ObjectExtensions.operator_doubleArrow((Object)_newAtomicSIB, (Procedures.Procedure1)_function);
        PrimitiveInputPort valInput = (PrimitiveInputPort)this._graphModelExtension.findThe((ModelElementContainer)nativeSib, PrimitiveInputPort.class);
        this.putStaticValue((InputPort)valInput, filePath);
        Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)nativeSib, "failure");
        if (_branch != null) {
            _branch.delete();
        }
        Branch _branch_1 = this._processModelGenerationLanguage.getBranch((DataFlowTarget)nativeSib, "success");
        Procedures.Procedure1<Branch> _function_1 = new Procedures.Procedure1<Branch>(){

            public void apply(Branch it) {
                it.resize(120, 25);
            }
        };
        Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch_1, (Procedures.Procedure1)_function_1);
        PrimitiveOutputPort valOutput = (PrimitiveOutputPort)this._graphModelExtension.findThe((ModelElementContainer)successBranch, PrimitiveOutputPort.class);
        this.addToControlFlow((DataFlowTarget)nativeSib, objCrt);
        this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        return valOutput;
    }

    public SetAttributeValueSIB generateFileSetter(ObjectCreation objCrt, AttributeDef attrDef, TextAttributeValueDef valueDef) {
        SetAttributeValueSIB _xblockexpression = null;
        PrimitiveOutputPort valOutput = this.generateFileProvider(objCrt, valueDef.getValue());
        EObject _key = attrDef.getKey();
        _xblockexpression = this.generateSetAttributeValueSIB(objCrt, (Attribute)_key, (Output)valOutput);
        return _xblockexpression;
    }

    public ComplexOutputPort generateEnumLiteralProvider(ObjectCreation objCrt, EnumLiteral literal) {
        RetrieveEnumLiteralSIB _newRetrieveEnumLiteralSIB = this.process.newRetrieveEnumLiteralSIB((EObject)literal, 0, 0);
        Procedures.Procedure1<RetrieveEnumLiteralSIB> _function = new Procedures.Procedure1<RetrieveEnumLiteralSIB>(){

            public void apply(RetrieveEnumLiteralSIB it) {
                it.resize(120, 65);
            }
        };
        RetrieveEnumLiteralSIB retrieveSib = (RetrieveEnumLiteralSIB)ObjectExtensions.operator_doubleArrow((Object)_newRetrieveEnumLiteralSIB, (Procedures.Procedure1)_function);
        Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)retrieveSib, literal.getName());
        Procedures.Procedure1<Branch> _function_1 = new Procedures.Procedure1<Branch>(){

            public void apply(Branch it) {
                it.resize(120, 25);
            }
        };
        Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_1);
        ComplexOutputPort valOutput = (ComplexOutputPort)this._graphModelExtension.findThe((ModelElementContainer)successBranch, ComplexOutputPort.class);
        this.addToControlFlow((DataFlowTarget)retrieveSib, objCrt);
        this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        return valOutput;
    }

    public SetAttributeValueSIB generateEnumLiteralSetter(ObjectCreation objCrt, AttributeDef attrDef, final String literalName) {
        SetAttributeValueSIB _xblockexpression = null;
        Functions.Function1<EnumLiteral, Boolean> _function = new Functions.Function1<EnumLiteral, Boolean>(){

            public Boolean apply(EnumLiteral it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)literalName);
            }
        };
        EnumLiteral literal = (EnumLiteral)IterableExtensions.findFirst((Iterable)this._objectLangExtension.getComplexType(attrDef).getEnumLiterals(), (Functions.Function1)_function);
        ComplexOutputPort valOutput = this.generateEnumLiteralProvider(objCrt, literal);
        EObject _key = attrDef.getKey();
        _xblockexpression = this.generateSetAttributeValueSIB(objCrt, (Attribute)_key, (Output)valOutput);
        return _xblockexpression;
    }

    public PrimitiveOutputPort generateHashedTextProvider(ObjectCreation objCrt, String value) {
        EObject nativeDef = ReferenceRegistry.getInstance().getEObject("common.HashPassword");
        this.debug(" native 'common.HashPassword' from registry: " + nativeDef);
        AtomicSIB _newAtomicSIB = this.process.newAtomicSIB(nativeDef, 0, 0);
        Procedures.Procedure1<AtomicSIB> _function = new Procedures.Procedure1<AtomicSIB>(){

            public void apply(AtomicSIB it) {
                it.resize(120, 65);
            }
        };
        AtomicSIB nativeSib = (AtomicSIB)ObjectExtensions.operator_doubleArrow((Object)_newAtomicSIB, (Procedures.Procedure1)_function);
        PrimitiveInputPort valInput = (PrimitiveInputPort)this._graphModelExtension.findThe((ModelElementContainer)nativeSib, PrimitiveInputPort.class);
        this.putStaticValue((InputPort)valInput, value);
        Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)nativeSib, "success");
        Procedures.Procedure1<Branch> _function_1 = new Procedures.Procedure1<Branch>(){

            public void apply(Branch it) {
                it.resize(120, 25);
            }
        };
        Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_1);
        PrimitiveOutputPort valOutput = (PrimitiveOutputPort)this._graphModelExtension.findThe((ModelElementContainer)successBranch, PrimitiveOutputPort.class);
        this.addToControlFlow((DataFlowTarget)nativeSib, objCrt);
        this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        return valOutput;
    }

    public SetAttributeValueSIB generateHashedTextSetter(ObjectCreation objCrt, AttributeDef attrDef, String value) {
        SetAttributeValueSIB _xblockexpression = null;
        PrimitiveOutputPort valOutput = this.generateHashedTextProvider(objCrt, value);
        EObject _key = attrDef.getKey();
        _xblockexpression = this.generateSetAttributeValueSIB(objCrt, (Attribute)_key, (Output)valOutput);
        return _xblockexpression;
    }

    public SetAttributeValueSIB generateProcessOutputSetter(ObjectCreation objCrt, AttributeDef attrDef, ProcessOutput proOut) {
        SetAttributeValueSIB _xblockexpression = null;
        ProcessSIB processSIB = this.generateProcessSIB(proOut);
        EObject _elvis = null;
        ProcessOutputDef _outputDef = proOut.getOutputDef();
        EObject _output = null;
        if (_outputDef != null) {
            _output = _outputDef.getOutput();
        }
        if (_output != null) {
            _elvis = _output;
        } else {
            Functions.Function1<EndSIB, EList<InputPort>> _function = new Functions.Function1<EndSIB, EList<InputPort>>(){

                public EList<InputPort> apply(EndSIB it) {
                    return it.getInputPorts();
                }
            };
            InputPort _head = (InputPort)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)this._graphModelExtension.find((ModelElementContainer)processSIB.getProMod(), EndSIB.class), (Functions.Function1)_function), InputPort.class));
            _elvis = _head;
        }
        final EObject output = _elvis;
        SetAttributeValueSIB _xifexpression = null;
        if (output instanceof InputPort) {
            SetAttributeValueSIB _xblockexpression_1 = null;
            ModelElementContainer _container = ((InputPort)output).getContainer();
            EndSIB endSib = (EndSIB)_container;
            final Branch outputBranch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)processSIB, endSib.getBranchName());
            this.addToControlFlow((DataFlowSource)outputBranch, (ObjectCreation)proOut);
            Branch lastBranch = outputBranch;
            Functions.Function1<Branch, Boolean> _function_1 = new Functions.Function1<Branch, Boolean>(){

                public Boolean apply(Branch it) {
                    return ObjectLangProcessGenerator.this._graphModelExtension.operator_notEquals((IdentifiableElement)it, (IdentifiableElement)outputBranch);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)processSIB.getBranchSuccessors(), (Functions.Function1)_function_1);
            for (Branch otherBranch : _filter) {
                int _right = this._processModelGenerationLanguage.getRight((Node)lastBranch);
                int _plus = _right + 10;
                int _bottom = this._processModelGenerationLanguage.getBottom((Node)lastBranch);
                int _plus_1 = _bottom + 10;
                otherBranch.move(_plus, _plus_1);
                this.previousBranches.add((DataFlowSource)otherBranch);
                lastBranch = otherBranch;
            }
            Functions.Function1<OutputPort, Boolean> _function_2 = new Functions.Function1<OutputPort, Boolean>(){

                public Boolean apply(OutputPort it) {
                    String _name = it.getName();
                    String _name_1 = ((InputPort)output).getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            OutputPort createdPort = (OutputPort)this._graphModelExtension.findThe((ModelElementContainer)outputBranch, OutputPort.class, (Functions.Function1)_function_2);
            if (createdPort instanceof ComplexOutputPort) {
                this.objCrt_on_port.put(proOut, (ComplexOutputPort)createdPort);
            }
            EObject _key = attrDef.getKey();
            _xifexpression = _xblockexpression_1 = this.generateSetAttributeValueSIB(objCrt, (Attribute)_key, (Output)createdPort);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public SetAttributeValueSIB generateStaticSetter(ObjectCreation objCrt, AttributeDef attrDef) {
        this.debug(" generate primitive static setter for attrdef: " + attrDef);
        EObject _key = attrDef.getKey();
        PrimitiveAttribute attribute = (PrimitiveAttribute)_key;
        SetAttributeValueSIB sib = this.generateSetAttributeValueSIB(objCrt, (Attribute)attribute);
        this.debug(" SetAttributeValueSIB: " + sib);
        PrimitiveInputPort _last = (PrimitiveInputPort)IterableExtensions.last((Iterable)this._graphModelExtension.find((ModelElementContainer)sib, PrimitiveInputPort.class));
        Procedures.Procedure1<PrimitiveInputPort> _function = new Procedures.Procedure1<PrimitiveInputPort>(){

            public void apply(PrimitiveInputPort it) {
                it.resize(90, 18);
            }
        };
        PrimitiveInputPort valInput = (PrimitiveInputPort)ObjectExtensions.operator_doubleArrow((Object)_last, (Procedures.Procedure1)_function);
        this.debug(" val InputPort: " + valInput);
        this.toStatic(valInput);
        return sib;
    }

    public SetAttributeValueSIB generateSetAttributeValueSIB(ObjectCreation objCrt, Attribute attr) {
        SetAttributeValueSIB sib = this.process.newSetAttributeValueSIB((EObject)attr, 0, 0);
        Iterable inputPorts = this._graphModelExtension.find((ModelElementContainer)sib, InputPort.class);
        InputPort _head = (InputPort)IterableExtensions.head((Iterable)inputPorts);
        Procedures.Procedure1<InputPort> _function = new Procedures.Procedure1<InputPort>(){

            public void apply(InputPort it) {
                it.resize(90, 18);
            }
        };
        InputPort objInput = (InputPort)ObjectExtensions.operator_doubleArrow((Object)_head, (Procedures.Procedure1)_function);
        ComplexOutputPort objCreatedPort = this.getObjectProvidingPort(objCrt);
        this._processModelGenerationLanguage.dataFlowTo((Node)objCreatedPort, (Node)objInput);
        InputPort _last = (InputPort)IterableExtensions.last((Iterable)inputPorts);
        Procedures.Procedure1<InputPort> _function_1 = new Procedures.Procedure1<InputPort>(){

            public void apply(InputPort it) {
                it.resize(90, 18);
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_last, (Procedures.Procedure1)_function_1);
        this.addToControlFlow((DataFlowTarget)sib, objCrt);
        Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)sib, "success");
        Procedures.Procedure1<Branch> _function_2 = new Procedures.Procedure1<Branch>(){

            public void apply(Branch it) {
                it.resize(120, 25);
            }
        };
        Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_2);
        this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        return sib;
    }

    public SetAttributeValueSIB generateSetAttributeValueSIB(ObjectCreation objCrt, Attribute attr, Output valOutput) {
        SetAttributeValueSIB sib = this.generateSetAttributeValueSIB(objCrt, attr);
        InputPort _last = (InputPort)IterableExtensions.last((Iterable)this._graphModelExtension.find((ModelElementContainer)sib, InputPort.class));
        Procedures.Procedure1<InputPort> _function = new Procedures.Procedure1<InputPort>(){

            public void apply(InputPort it) {
                it.resize(90, 18);
            }
        };
        InputPort valInput = (InputPort)ObjectExtensions.operator_doubleArrow((Object)_last, (Procedures.Procedure1)_function);
        this._processModelGenerationLanguage.dataFlowTo((Node)valOutput, (Node)valInput);
        return sib;
    }

    public void generatePrimitiveListSetters(final ObjectCreation objCrt, Iterable<AttributeDef> attributeDefs) {
        this.debug(" generate primitive list setters for objCrt: " + objCrt);
        Consumer<AttributeDef> _function = new Consumer<AttributeDef>(){

            @Override
            public void accept(AttributeDef attrDef) {
                AttributeValueDef _valueDef;
                AttributeValueDef valueDef = _valueDef = attrDef.getValueDef();
                boolean _matched = false;
                if (valueDef instanceof PrimitiveListAttributeValueDef) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generatePrimitiveListSetter(objCrt, attrDef, (PrimitiveListAttributeValueDef)valueDef);
                }
            }
        };
        attributeDefs.forEach(_function);
    }

    public DataFlowSource generatePrimitiveListSetter(ObjectCreation objCrt, AttributeDef attrDef, PrimitiveListAttributeValueDef valueDef) {
        boolean _not;
        DataFlowSource _xblockexpression = null;
        Object _xifexpression = null;
        EObject _key = null;
        if (attrDef != null) {
            _key = attrDef.getKey();
        }
        if (_key instanceof Attribute) {
            EObject _key_1 = attrDef.getKey();
            _xifexpression = ((Attribute)_key_1).getName();
        } else {
            _xifexpression = attrDef;
        }
        String _plus = " generate primitive list setter for attrdef: " + _xifexpression;
        this.debug(_plus);
        Object _switchResult = null;
        PrimitiveListAttributeValueDef it = valueDef;
        boolean _matched = false;
        if (it instanceof BooleanListAttributeValueDef) {
            _matched = true;
            _switchResult = ((BooleanListAttributeValueDef)it).getValues();
        }
        if (!_matched && it instanceof IntegerListAttributeValueDef) {
            _matched = true;
            _switchResult = ((IntegerListAttributeValueDef)it).getValues();
        }
        if (!_matched && it instanceof RealListAttributeValueDef) {
            _matched = true;
            _switchResult = ((RealListAttributeValueDef)it).getValues();
        }
        if (!_matched && it instanceof TextListAttributeValueDef) {
            _matched = true;
            _switchResult = ((TextListAttributeValueDef)it).getValues();
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        EList<Boolean> values = _switchResult;
        final ArrayList valOutputs = CollectionLiterals.newArrayList();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(values);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            PutToContextSIB _newPutToContextSIB = this.process.newPutToContextSIB(0, 0);
            Procedures.Procedure1<PutToContextSIB> _function = new Procedures.Procedure1<PutToContextSIB>(){

                public void apply(PutToContextSIB it) {
                    it.resize(120, 65);
                }
            };
            PutToContextSIB putToContextSIB = (PutToContextSIB)ObjectExtensions.operator_doubleArrow((Object)_newPutToContextSIB, (Procedures.Procedure1)_function);
            Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)putToContextSIB, "success");
            Procedures.Procedure1<Branch> _function_1 = new Procedures.Procedure1<Branch>(){

                public void apply(Branch it) {
                    it.resize(120, 25);
                }
            };
            Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_1);
            int index = 0;
            for (final Object value : values) {
                int _plusPlus = index++;
                String name = "val" + Integer.valueOf(_plusPlus);
                EObject _key_2 = attrDef.getKey();
                Attribute attribute = (Attribute)_key_2;
                String _name = null;
                if (attribute != null) {
                    _name = attribute.getName();
                }
                String _plus_1 = "   attribute: " + _name;
                String _plus_2 = String.valueOf(_plus_1) + " isEnum: ";
                boolean _isEnumAttribute = this._objectLangExtension.isEnumAttribute(attribute);
                String _plus_3 = String.valueOf(_plus_2) + Boolean.valueOf(_isEnumAttribute);
                this.debug(_plus_3);
                boolean _isEnumAttribute_1 = this._objectLangExtension.isEnumAttribute(attribute);
                if (_isEnumAttribute_1) {
                    this.debug(" generate enum literal setter for attrDef: " + attrDef);
                    Type enumType = this._objectLangExtension.getComplexType(attrDef);
                    Functions.Function1<EnumLiteral, Boolean> _function_2 = new Functions.Function1<EnumLiteral, Boolean>(){

                        public Boolean apply(EnumLiteral it) {
                            String _name = it.getName();
                            String _string = null;
                            if (value != null) {
                                _string = value.toString();
                            }
                            return Objects.equal((Object)_name, _string);
                        }
                    };
                    EnumLiteral literal = (EnumLiteral)IterableExtensions.findFirst((Iterable)enumType.getEnumLiterals(), (Functions.Function1)_function_2);
                    ComplexOutputPort valOutput = this.generateEnumLiteralProvider(objCrt, literal);
                    valOutputs.add(valOutput);
                    continue;
                }
                boolean _isFileAttribute = this._dataExtension.isFileAttribute(attribute);
                if (_isFileAttribute) {
                    this.debug(" generate file setter for attrDef: " + attrDef);
                    String _string = null;
                    if (value != null) {
                        _string = value.toString();
                    }
                    PrimitiveOutputPort valOutput_1 = this.generateFileProvider(objCrt, _string);
                    valOutputs.add(valOutput_1);
                    continue;
                }
                boolean _isHashed = this._objectLangExtension.isHashed(valueDef);
                if (_isHashed) {
                    this.debug(" generate hashed password setter for attrDef: " + attrDef);
                    String _string_1 = null;
                    if (value != null) {
                        _string_1 = value.toString();
                    }
                    PrimitiveOutputPort valOutput_2 = this.generateHashedTextProvider(objCrt, _string_1);
                    valOutputs.add(valOutput_2);
                    continue;
                }
                PrimitiveType dataType = this._objectLangExtension.getPrimitiveType(attribute);
                InputStatic _addStaticInputPort = this._processModelGenerationLanguage.addStaticInputPort((SIB)putToContextSIB, dataType, name, value);
                Procedures.Procedure1<InputStatic> _function_3 = new Procedures.Procedure1<InputStatic>(){

                    public void apply(InputStatic it) {
                        it.resize(90, 18);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_addStaticInputPort, (Procedures.Procedure1)_function_3);
                OutputPort _addOutputPort = this._processModelGenerationLanguage.addOutputPort((DataFlowSource)successBranch, dataType, name);
                Procedures.Procedure1<OutputPort> _function_4 = new Procedures.Procedure1<OutputPort>(){

                    public void apply(OutputPort it) {
                        it.resize(90, 18);
                        valOutputs.add(it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_addOutputPort, (Procedures.Procedure1)_function_4);
            }
            this.addToControlFlow((DataFlowTarget)putToContextSIB, objCrt);
            this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        }
        EObject _key_2 = attrDef.getKey();
        _xblockexpression = this.generateListSetter(objCrt, (Attribute)_key_2, valOutputs);
        return _xblockexpression;
    }

    public PrimitiveInputPort addFileInputPort(Container dataFlowTarget, final String name) {
        IO _addInput = PortUtils.addInput((Container)dataFlowTarget, (Object)PrimitiveType.FILE);
        Procedures.Procedure1<PrimitiveInputPort> _function = new Procedures.Procedure1<PrimitiveInputPort>(){

            public void apply(PrimitiveInputPort it) {
                it.setName(name);
            }
        };
        return (PrimitiveInputPort)ObjectExtensions.operator_doubleArrow((Object)((PrimitiveInputPort)_addInput), (Procedures.Procedure1)_function);
    }

    public void generateComplexSetters(final ObjectCreation objCrt, Iterable<AttributeDef> attributeDefs) {
        this.debug(" generate complex setters for objCrt: " + objCrt);
        Functions.Function1<AttributeDef, Boolean> _function = new Functions.Function1<AttributeDef, Boolean>(){

            public Boolean apply(AttributeDef it) {
                return ObjectLangProcessGenerator.this._objectLangExtension.hasComplexType(it.getValueDef());
            }
        };
        Consumer<AttributeDef> _function_1 = new Consumer<AttributeDef>(){

            @Override
            public void accept(AttributeDef it) {
                ObjectLangProcessGenerator.this.generateComplexSetter(it, objCrt);
            }
        };
        IterableExtensions.filter(attributeDefs, (Functions.Function1)_function).forEach(_function_1);
    }

    public DataFlow generateRead(InputPort inputPort, AttributeValueDef valueDef) {
        DataFlow _xblockexpression = null;
        String _name = null;
        if (inputPort != null) {
            _name = inputPort.getName();
        }
        String _plus = " generate primitive setter for input port: " + _name;
        this.debug(_plus);
        OutputPort valObjCreatedPort = this.getValueObjectCreatedPort(valueDef);
        _xblockexpression = this._processModelGenerationLanguage.dataFlowTo((Node)valObjCreatedPort, (Node)inputPort);
        return _xblockexpression;
    }

    public DataFlowSource generateComplexSetter(AttributeDef attrDef, ObjectCreation objCrt) {
        DataFlowSource _xblockexpression = null;
        String _displayName = null;
        if (attrDef != null) {
            _displayName = this._objectLangExtension.getDisplayName(attrDef);
        }
        String _plus = " generate complex setter for attrDef: " + _displayName;
        this.debug(_plus);
        EObject _key = attrDef.getKey();
        Attribute attr = (Attribute)_key;
        SetAttributeValueSIB sib = this.process.newSetAttributeValueSIB((EObject)attr, 0, 0);
        Iterable inputPorts = this._graphModelExtension.find((ModelElementContainer)sib, ComplexInputPort.class);
        ComplexInputPort _head = (ComplexInputPort)IterableExtensions.head((Iterable)inputPorts);
        Procedures.Procedure1<ComplexInputPort> _function = new Procedures.Procedure1<ComplexInputPort>(){

            public void apply(ComplexInputPort it) {
                it.resize(90, 18);
            }
        };
        ComplexInputPort objInput = (ComplexInputPort)ObjectExtensions.operator_doubleArrow((Object)_head, (Procedures.Procedure1)_function);
        ComplexOutputPort objCreatedPort = this.getObjectProvidingPort(objCrt);
        this._processModelGenerationLanguage.dataFlowTo((Node)objCreatedPort, (Node)objInput);
        ComplexInputPort _last = (ComplexInputPort)IterableExtensions.last((Iterable)inputPorts);
        Procedures.Procedure1<ComplexInputPort> _function_1 = new Procedures.Procedure1<ComplexInputPort>(){

            public void apply(ComplexInputPort it) {
                it.resize(90, 18);
            }
        };
        ComplexInputPort valInput = (ComplexInputPort)ObjectExtensions.operator_doubleArrow((Object)_last, (Procedures.Procedure1)_function_1);
        OutputPort valObjCreatedPort = this.getValueObjectCreatedPort(attrDef.getValueDef());
        this._processModelGenerationLanguage.dataFlowTo((Node)valObjCreatedPort, (Node)valInput);
        this.addToControlFlow((DataFlowTarget)sib, objCrt);
        Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)sib, "success");
        Procedures.Procedure1<Branch> _function_2 = new Procedures.Procedure1<Branch>(){

            public void apply(Branch it) {
                it.resize(120, 25);
            }
        };
        Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_2);
        _xblockexpression = this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        return _xblockexpression;
    }

    protected OutputPort _getValueObjectCreatedPort(ObjectCreation valueDef) {
        ComplexOutputPort _xblockexpression = null;
        Collection<AttributeDef> attributes = this.getHierarchicalAttributes(valueDef);
        this.generateObjectCreation(valueDef, attributes);
        _xblockexpression = this.getObjectProvidingPort(valueDef);
        return _xblockexpression;
    }

    protected OutputPort _getValueObjectCreatedPort(AttributeValueReferenceDef valueDef) {
        return this.getObjectProvidingPort(valueDef.getValue());
    }

    public OutputPort getObjectProvidingPort(NamedObject namedObj) {
        ComplexOutputPort _switchResult = null;
        NamedObject it = namedObj;
        boolean _matched = false;
        if (it instanceof ObjectDef) {
            _matched = true;
            _switchResult = this.getObjectProvidingPort(((ObjectDef)it).getCreation());
        }
        if (!_matched && it instanceof InputDef) {
            _matched = true;
            _switchResult = this.getObjectProvidingPort((InputDef)it);
        }
        return _switchResult;
    }

    public ComplexOutputPort getObjectProvidingPort(ObjectCreation objCrt) {
        ComplexOutputPort _elvis = null;
        ComplexOutputPort _get = this.objCrt_on_port.get(objCrt);
        if (_get != null) {
            _elvis = _get;
        } else {
            ComplexOutputPort _xblockexpression = null;
            this.generateObjectCreation(objCrt);
            _elvis = _xblockexpression = this.objCrt_on_port.get(objCrt);
        }
        ComplexOutputPort port = _elvis;
        if (port == null) {
            this.error("ERROR object providing port is null for " + objCrt);
        }
        return port;
    }

    public OutputPort getObjectProvidingPort(InputDef inputDef) {
        OutputPort port = this.inputDef_on_port.get(inputDef);
        if (port == null) {
            this.error("ERROR object providing port is null for " + inputDef);
        }
        return port;
    }

    public void generateComplexListSetters(final ObjectCreation objCrt, Iterable<AttributeDef> attributeDefs) {
        this.debug(" generate complex list setters for objCrt: " + objCrt);
        Consumer<AttributeDef> _function = new Consumer<AttributeDef>(){

            @Override
            public void accept(AttributeDef attrDef) {
                AttributeValueDef _valueDef;
                AttributeValueDef valueDef = _valueDef = attrDef.getValueDef();
                boolean _matched = false;
                if (valueDef instanceof ComplexListAttributeValuesDef) {
                    _matched = true;
                    ObjectLangProcessGenerator.this.generateComplexListSetter(objCrt, attrDef, (ComplexListAttributeValuesDef)valueDef);
                }
            }
        };
        attributeDefs.forEach(_function);
    }

    public DataFlow generateComplexListRead(ComplexInputPort inputPort, ComplexListAttributeValuesDef valueDef, ObjectCreation objCrt) {
        DataFlow _xblockexpression = null;
        String _name = null;
        if (inputPort != null) {
            _name = inputPort.getName();
        }
        String _plus = " generate complex list read for InputPort: " + _name;
        this.debug(_plus);
        List<OutputPort> valOutputs = this.generatePutComplexToContextSIB(inputPort.getDataType(), valueDef, objCrt);
        Variable variable = this.generateInputVariable((InputPort)inputPort);
        for (OutputPort valOutput : valOutputs) {
            DataFlow _dataFlowTo = this._processModelGenerationLanguage.dataFlowTo((Node)valOutput, (Node)variable);
            Procedures.Procedure1<DataFlow> _function = new Procedures.Procedure1<DataFlow>(){

                public void apply(DataFlow it) {
                    EdgeLayout.C_LEFT.apply((Edge)it);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_dataFlowTo, (Procedures.Procedure1)_function);
        }
        _xblockexpression = this._processModelGenerationLanguage.dataFlowTo((Node)variable, (Node)inputPort);
        return _xblockexpression;
    }

    public DataFlowSource generateComplexListSetter(ObjectCreation objCrt, AttributeDef attrDef, ComplexListAttributeValuesDef valueDef) {
        DataFlowSource _xblockexpression = null;
        String _displayName = null;
        if (attrDef != null) {
            _displayName = this._objectLangExtension.getDisplayName(attrDef);
        }
        String _plus = " generate complex list setter for attrDef: " + _displayName;
        this.debug(_plus);
        EObject _key = attrDef.getKey();
        ComplexAttribute attribute = (ComplexAttribute)_key;
        List<OutputPort> valOutputs = this.generatePutComplexToContextSIB(attribute.getDataType(), valueDef, objCrt);
        _xblockexpression = this.generateListSetter(objCrt, (Attribute)attribute, valOutputs);
        return _xblockexpression;
    }

    public List<OutputPort> generatePutComplexToContextSIB(Type dataType, ComplexListAttributeValuesDef valueDef, ObjectCreation objCrt) {
        boolean _not;
        final ArrayList valOutputs = CollectionLiterals.newArrayList();
        Functions.Function1<AttributeValueDef, EObject> _function = new Functions.Function1<AttributeValueDef, EObject>(){

            public EObject apply(AttributeValueDef it) {
                Object _switchResult = null;
                boolean _matched = false;
                if (it instanceof ObjectCreation) {
                    _matched = true;
                    _switchResult = it;
                }
                if (!_matched && it instanceof AttributeValueReferenceDef) {
                    _matched = true;
                    _switchResult = ((AttributeValueReferenceDef)it).getValue();
                }
                return _switchResult;
            }
        };
        List values = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(valueDef.getValuesDef(), (Functions.Function1)_function)));
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)values);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            PutComplexToContextSIB _newPutComplexToContextSIB = this.process.newPutComplexToContextSIB((EObject)dataType, 0, 0);
            Procedures.Procedure1<PutComplexToContextSIB> _function_1 = new Procedures.Procedure1<PutComplexToContextSIB>(){

                public void apply(PutComplexToContextSIB it) {
                    it.resize(120, 65);
                    Consumer<InputPort> _function = new Consumer<InputPort>(){

                        @Override
                        public void accept(InputPort it) {
                            it.delete();
                        }
                    };
                    it.getInputPorts().forEach((Consumer)_function);
                }
            };
            PutComplexToContextSIB putToContextSIB = (PutComplexToContextSIB)ObjectExtensions.operator_doubleArrow((Object)_newPutComplexToContextSIB, (Procedures.Procedure1)_function_1);
            Branch _branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)putToContextSIB, "success");
            Procedures.Procedure1<Branch> _function_2 = new Procedures.Procedure1<Branch>(){

                public void apply(Branch it) {
                    it.resize(120, 25);
                    Consumer<OutputPort> _function = new Consumer<OutputPort>(){

                        @Override
                        public void accept(OutputPort it) {
                            it.delete();
                        }
                    };
                    it.getOutputPorts().forEach((Consumer)_function);
                }
            };
            Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)_branch, (Procedures.Procedure1)_function_2);
            int index = 0;
            EList<AttributeValueDef> _valuesDef = valueDef.getValuesDef();
            for (AttributeValueDef listValDef : _valuesDef) {
                final OutputPort valObjCreatedPort = this.getValueObjectCreatedPort(listValDef);
                int _plusPlus = index++;
                final String name = "val" + Integer.valueOf(_plusPlus);
                InputPort _addInputPort = this._processModelGenerationLanguage.addInputPort((Container)putToContextSIB, (Node)dataType);
                Procedures.Procedure1<InputPort> _function_3 = new Procedures.Procedure1<InputPort>(){

                    public void apply(InputPort it) {
                        it.resize(90, 18);
                        it.setName(name);
                        ObjectLangProcessGenerator.this._processModelGenerationLanguage.dataFlowFrom((Node)it, (Node)valObjCreatedPort);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_addInputPort, (Procedures.Procedure1)_function_3);
                OutputPort _addOutputPort = this._processModelGenerationLanguage.addOutputPort((DataFlowSource)successBranch, (Node)dataType);
                Procedures.Procedure1<OutputPort> _function_4 = new Procedures.Procedure1<OutputPort>(){

                    public void apply(OutputPort it) {
                        it.resize(90, 18);
                        it.setName(name);
                        valOutputs.add(it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_addOutputPort, (Procedures.Procedure1)_function_4);
            }
            this.addToControlFlow((DataFlowTarget)putToContextSIB, objCrt);
            this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        }
        return valOutputs;
    }

    public DataFlowSource generateListSetter(ObjectCreation objCrt, Attribute attribute, Iterable<? extends Output> valOutputs) {
        DataFlowSource _xblockexpression = null;
        SetAttributeValueSIB setterSib = this.process.newSetAttributeValueSIB((EObject)attribute, 0, 0);
        Iterable inputPorts = this._graphModelExtension.find((ModelElementContainer)setterSib, InputPort.class);
        InputPort _head = (InputPort)IterableExtensions.head((Iterable)inputPorts);
        Procedures.Procedure1<InputPort> _function = new Procedures.Procedure1<InputPort>(){

            public void apply(InputPort it) {
                it.resize(90, 18);
            }
        };
        InputPort objInput = (InputPort)ObjectExtensions.operator_doubleArrow((Object)_head, (Procedures.Procedure1)_function);
        ComplexOutputPort objCreatedPort = this.getObjectProvidingPort(objCrt);
        this._processModelGenerationLanguage.dataFlowTo((Node)objCreatedPort, (Node)objInput);
        InputPort _last = (InputPort)IterableExtensions.last((Iterable)inputPorts);
        Procedures.Procedure1<InputPort> _function_1 = new Procedures.Procedure1<InputPort>(){

            public void apply(InputPort it) {
                it.resize(90, 18);
            }
        };
        InputPort valInput = (InputPort)ObjectExtensions.operator_doubleArrow((Object)_last, (Procedures.Procedure1)_function_1);
        Variable variable = this.generateInputVariable(valInput);
        for (Output output : valOutputs) {
            DataFlow _dataFlowTo = this._processModelGenerationLanguage.dataFlowTo((Node)output, (Node)variable);
            Procedures.Procedure1<DataFlow> _function_2 = new Procedures.Procedure1<DataFlow>(){

                public void apply(DataFlow it) {
                    EdgeLayout.C_LEFT.apply((Edge)it);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_dataFlowTo, (Procedures.Procedure1)_function_2);
        }
        this.addToControlFlow((DataFlowTarget)setterSib, objCrt);
        Branch branch = this._processModelGenerationLanguage.getBranch((DataFlowTarget)setterSib, "success");
        Procedures.Procedure1<Branch> _function_3 = new Procedures.Procedure1<Branch>(){

            public void apply(Branch it) {
                it.resize(120, 25);
            }
        };
        Branch successBranch = (Branch)ObjectExtensions.operator_doubleArrow((Object)branch, (Procedures.Procedure1)_function_3);
        _xblockexpression = this.addToControlFlow((DataFlowSource)successBranch, objCrt);
        return _xblockexpression;
    }

    public Variable generateInputVariable(InputPort inputPort) {
        ModelElementContainer _container = inputPort.getContainer();
        return this.generateInputVariable((SIB)_container, inputPort);
    }

    protected Variable _generateInputVariable(SIB sib, final ComplexInputPort inputPort) {
        ComplexVariable _xblockexpression = null;
        int _x = sib.getX();
        int _minus = _x - 30;
        DataContext dataContext = this.process.newDataContext(_minus, sib.getY(), 30, sib.getHeight());
        Type _dataType = inputPort.getDataType();
        int _middle = this._processModelGenerationLanguage.getMiddle((Node)inputPort);
        int _minus_1 = _middle - 5;
        ComplexVariable _newComplexVariable = dataContext.newComplexVariable((EObject)_dataType, 10, _minus_1, 10, 10);
        Procedures.Procedure1<ComplexVariable> _function = new Procedures.Procedure1<ComplexVariable>(){

            public void apply(ComplexVariable it) {
                String _name = inputPort.getName();
                String _id = inputPort.getId();
                String _plus = String.valueOf(_name) + _id;
                it.setName(_plus);
                it.setIsList(inputPort.isIsList());
                ObjectLangProcessGenerator.this._processModelGenerationLanguage.dataFlowTo((Node)it, (Node)inputPort);
            }
        };
        _xblockexpression = (ComplexVariable)ObjectExtensions.operator_doubleArrow((Object)_newComplexVariable, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected Variable _generateInputVariable(SIB sib, final PrimitiveInputPort inputPort) {
        PrimitiveVariable _xblockexpression = null;
        int _x = sib.getX();
        int _minus = _x - 30;
        DataContext dataContext = this.process.newDataContext(_minus, sib.getY(), 30, sib.getHeight());
        int _middle = this._processModelGenerationLanguage.getMiddle((Node)inputPort);
        int _minus_1 = _middle - 5;
        PrimitiveVariable _newPrimitiveVariable = dataContext.newPrimitiveVariable(10, _minus_1, 10, 10);
        Procedures.Procedure1<PrimitiveVariable> _function = new Procedures.Procedure1<PrimitiveVariable>(){

            public void apply(PrimitiveVariable it) {
                it.setDataType(inputPort.getDataType());
                String _name = inputPort.getName();
                String _id = inputPort.getId();
                String _plus = String.valueOf(_name) + _id;
                it.setName(_plus);
                it.setIsList(inputPort.isIsList());
                ObjectLangProcessGenerator.this._processModelGenerationLanguage.dataFlowTo((Node)it, (Node)inputPort);
            }
        };
        _xblockexpression = (PrimitiveVariable)ObjectExtensions.operator_doubleArrow((Object)_newPrimitiveVariable, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public boolean isReferenced(ObjectDef objDef) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)objDef.getName());
        return !_isNullOrEmpty;
    }

    public Collection<AttributeDef> getHierarchicalAttributes(ObjectCreation objCrt) {
        final HashMap map = CollectionLiterals.newHashMap();
        Consumer<ObjectCreation> _function = new Consumer<ObjectCreation>(){

            @Override
            public void accept(ObjectCreation it) {
                Consumer<AttributeDef> _function = new Consumer<AttributeDef>(){

                    @Override
                    public void accept(AttributeDef it) {
                        map.put(ObjectLangProcessGenerator.this._objectLangExtension.getName(it), it);
                    }
                };
                it.getAttributes().forEach((Consumer)_function);
            }
        };
        ListExtensions.reverse(this._objectLangExtension.getExtensionHierarchy(objCrt)).forEach(_function);
        return map.values();
    }

    public DataFlowTarget addToControlFlow(final DataFlowTarget sib, final ObjectCreation objCrt) {
        Procedures.Procedure1<DataFlowTarget> _function = new Procedures.Procedure1<DataFlowTarget>(){

            public void apply(final DataFlowTarget it) {
                SIBLayoutUtils.resizeAndLayout((ModelElementContainer)it);
                for (DataFlowSource previousBranch : ObjectLangProcessGenerator.this.previousBranches) {
                    ObjectLangProcessGenerator.this._processModelGenerationLanguage.setSuccessor(previousBranch, it);
                }
                DataFlowSource lastInCol = (DataFlowSource)ObjectLangProcessGenerator.this.lastInCol.get(objCrt);
                if (lastInCol != null) {
                    int _center = ObjectLangProcessGenerator.this._processModelGenerationLanguage.getCenter((Node)lastInCol);
                    int _width = sib.getWidth();
                    int _divide = _width / 2;
                    int x = _center - _divide;
                    Functions.Function1<DataFlowSource, Integer> _function = new Functions.Function1<DataFlowSource, Integer>(){

                        public Integer apply(DataFlowSource it) {
                            return ObjectLangProcessGenerator.this._processModelGenerationLanguage.getBottom((Node)it);
                        }
                    };
                    DataFlowSource lowestBranch = (DataFlowSource)IterableExtensions.last((Iterable)IterableExtensions.sortBy((Iterable)ObjectLangProcessGenerator.this.previousBranches, (Functions.Function1)_function));
                    int _max = Math.max(ObjectLangProcessGenerator.this._processModelGenerationLanguage.getBottom((Node)lastInCol), ObjectLangProcessGenerator.this._processModelGenerationLanguage.getBottom((Node)lowestBranch));
                    int y = _max + 30;
                    String _name = sib.eClass().getName();
                    String _plus = "  align " + _name;
                    String _plus_1 = String.valueOf(_plus) + " beneath last in col: ";
                    String _plus_2 = String.valueOf(_plus_1) + lastInCol;
                    String _plus_3 = String.valueOf(_plus_2) + " to ";
                    String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(x);
                    String _plus_5 = String.valueOf(_plus_4) + " / ";
                    String _plus_6 = String.valueOf(_plus_5) + Integer.valueOf(y);
                    String _plus_7 = String.valueOf(_plus_6) + "   lastInCol.bottom: ";
                    int _bottom = ObjectLangProcessGenerator.this._processModelGenerationLanguage.getBottom((Node)lastInCol);
                    String _plus_8 = String.valueOf(_plus_7) + Integer.valueOf(_bottom);
                    String _plus_9 = String.valueOf(_plus_8) + " previousBranch.bottom: ";
                    int _bottom_1 = ObjectLangProcessGenerator.this._processModelGenerationLanguage.getBottom((Node)lowestBranch);
                    String _plus_10 = String.valueOf(_plus_9) + Integer.valueOf(_bottom_1);
                    ObjectLangProcessGenerator.this.debug(_plus_10);
                    it.move(x, y);
                    int _x = it.getX();
                    String _plus_11 = "  moved to " + Integer.valueOf(_x);
                    String _plus_12 = String.valueOf(_plus_11) + " / ";
                    int _y = it.getY();
                    String _plus_13 = String.valueOf(_plus_12) + Integer.valueOf(_y);
                    ObjectLangProcessGenerator.this.debug(_plus_13);
                } else {
                    ObjectLangProcessGenerator.this.debug("  align right of rightmostBranch");
                    int _right = ObjectLangProcessGenerator.this._processModelGenerationLanguage.getRight((Node)ObjectLangProcessGenerator.this.getRightmostBranch());
                    int _plus_14 = _right + 30;
                    Functions.Function1<DataFlowSource, Integer> _function_1 = new Functions.Function1<DataFlowSource, Integer>(){

                        public Integer apply(DataFlowSource it) {
                            return ObjectLangProcessGenerator.this._processModelGenerationLanguage.getRight((Node)it);
                        }
                    };
                    int _middle = ObjectLangProcessGenerator.this._processModelGenerationLanguage.getMiddle((Node)IterableExtensions.last((Iterable)IterableExtensions.sortBy((Iterable)ObjectLangProcessGenerator.this.previousBranches, (Functions.Function1)_function_1)));
                    int _height = sib.getHeight();
                    int _divide_1 = _height / 2;
                    int _minus = _middle - _divide_1;
                    it.move(_plus_14, _minus);
                }
                Functions.Function1<InputPort, Boolean> _function_2 = new Functions.Function1<InputPort, Boolean>(){

                    public Boolean apply(InputPort it) {
                        boolean _isEmpty = it.getIncoming(Read.class).isEmpty();
                        return !_isEmpty;
                    }
                };
                Functions.Function1<InputPort, ModelElementContainer> _function_3 = new Functions.Function1<InputPort, ModelElementContainer>(){

                    public ModelElementContainer apply(InputPort it) {
                        return ((Read)IterableExtensions.head((Iterable)it.getIncoming(Read.class))).getSourceElement().getContainer();
                    }
                };
                Consumer<DataContext> _function_4 = new Consumer<DataContext>(){

                    @Override
                    public void accept(DataContext dataContext) {
                        int _x = it.getX();
                        int _minus = _x - 30;
                        dataContext.move(_minus, it.getY());
                        dataContext.resize(dataContext.getWidth(), it.getHeight());
                    }
                };
                Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ObjectLangProcessGenerator.this._graphModelExtension.find((ModelElementContainer)it, InputPort.class), (Functions.Function1)_function_2), (Functions.Function1)_function_3), DataContext.class).forEach(_function_4);
            }
        };
        return (DataFlowTarget)ObjectExtensions.operator_doubleArrow((Object)sib, (Procedures.Procedure1)_function);
    }

    public DataFlowSource addToControlFlow(DataFlowSource branch, final ObjectCreation objCrt) {
        Procedures.Procedure1<DataFlowSource> _function = new Procedures.Procedure1<DataFlowSource>(){

            public void apply(DataFlowSource it) {
                SIBLayoutUtils.resizeAndLayout((ModelElementContainer)it);
                ObjectLangProcessGenerator.this._processModelGenerationLanguage.alignBeneathOf((Node)it, (Node)IterableExtensions.head((Iterable)it.getSIBPredecessors()));
                ObjectLangProcessGenerator.this.setPreviousBranch(it);
                ObjectLangProcessGenerator.this.lastInCol.put(objCrt, it);
            }
        };
        return (DataFlowSource)ObjectExtensions.operator_doubleArrow((Object)branch, (Procedures.Procedure1)_function);
    }

    public ArrayList<DataFlowSource> setPreviousBranch(final DataFlowSource branch) {
        Procedures.Procedure1<ArrayList<DataFlowSource>> _function = new Procedures.Procedure1<ArrayList<DataFlowSource>>(){

            public void apply(ArrayList<DataFlowSource> it) {
                it.clear();
                it.add(branch);
            }
        };
        return (ArrayList)ObjectExtensions.operator_doubleArrow(this.previousBranches, (Procedures.Procedure1)_function);
    }

    public Iterable<ObjectDef> findObjectDefs(EObject model) {
        Iterable _filter = Iterables.filter((Iterable)model.eContents(), ObjectDef.class);
        Functions.Function1<EObject, Iterable<ObjectDef>> _function = new Functions.Function1<EObject, Iterable<ObjectDef>>(){

            public Iterable<ObjectDef> apply(EObject it) {
                return ObjectLangProcessGenerator.this.findObjectDefs(it);
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)model.eContents(), (Functions.Function1)_function);
        return Iterables.concat((Iterable)_filter, (Iterable)_flatMap);
    }

    public boolean containsAnyOf(Collection<?> c1, Collection<?> c2) {
        boolean _disjoint = Collections.disjoint(c1, c2);
        return !_disjoint;
    }

    public DataFlowSource getRightmostBranch() {
        Functions.Function1<DataFlowSource, Integer> _function = new Functions.Function1<DataFlowSource, Integer>(){

            public Integer apply(DataFlowSource it) {
                return ObjectLangProcessGenerator.this._processModelGenerationLanguage.getRight((Node)it);
            }
        };
        return (DataFlowSource)IterableExtensions.last((Iterable)IterableExtensions.sortBy((Iterable)this._graphModelExtension.find((ModelElementContainer)this.process, DataFlowSource.class), (Functions.Function1)_function));
    }

    public boolean hasBeenCreated(ObjectDef objDef) {
        return this.objCrt_on_port.containsKey(objDef.getCreation());
    }

    public String debug(String msg) {
        String _xifexpression = null;
        return _xifexpression;
    }

    public String info(String msg) {
        String _simpleName = this.getClass().getSimpleName();
        String _plus = "[" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "] ";
        String _plus_2 = String.valueOf(_plus_1) + msg;
        return (String)InputOutput.println((Object)_plus_2);
    }

    public void error(String msg) {
        String _simpleName = this.getClass().getSimpleName();
        String _plus = "[" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "] ";
        String _plus_2 = String.valueOf(_plus_1) + msg;
        System.err.println(_plus_2);
    }

    public SIB generateObjectCreation(EObject objCrt) {
        if (objCrt instanceof ObjectCreation) {
            return this._generateObjectCreation((ObjectCreation)objCrt);
        }
        if (objCrt instanceof ObjectDef) {
            return this._generateObjectCreation((ObjectDef)objCrt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(objCrt).toString());
    }

    public SIB generateObjectCreation(EObject objInst, Object attributeDefs) {
        if (objInst instanceof ObjectInstantiation && attributeDefs instanceof Iterable) {
            return this._generateObjectCreation((ObjectInstantiation)objInst, (Iterable<AttributeDef>)((Iterable)attributeDefs));
        }
        if (objInst instanceof ProcessOutput && attributeDefs instanceof Iterable) {
            return this._generateObjectCreation((ProcessOutput)objInst, (Iterable<AttributeDef>)((Iterable)attributeDefs));
        }
        if (objInst instanceof ObjectDef && attributeDefs instanceof ObjectInstantiation) {
            return this._generateObjectCreation((ObjectDef)objInst, (ObjectInstantiation)attributeDefs);
        }
        if (objInst instanceof ObjectDef && attributeDefs instanceof ProcessOutput) {
            return this._generateObjectCreation((ObjectDef)objInst, (ProcessOutput)attributeDefs);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(objInst, attributeDefs).toString());
    }

    public Container generatePrimitiveSetter(ObjectCreation objCrt, AttributeDef attrDef, PrimitiveAttributeValueDef valueDef) {
        if (valueDef instanceof BooleanAttributeValueDef) {
            return this._generatePrimitiveSetter(objCrt, attrDef, (BooleanAttributeValueDef)valueDef);
        }
        if (valueDef instanceof IntegerAttributeValueDef) {
            return this._generatePrimitiveSetter(objCrt, attrDef, (IntegerAttributeValueDef)valueDef);
        }
        if (valueDef instanceof RealAttributeValueDef) {
            return this._generatePrimitiveSetter(objCrt, attrDef, (RealAttributeValueDef)valueDef);
        }
        if (valueDef instanceof TextAttributeValueDef) {
            return this._generatePrimitiveSetter(objCrt, attrDef, (TextAttributeValueDef)valueDef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(objCrt, attrDef, valueDef).toString());
    }

    public OutputPort getValueObjectCreatedPort(AttributeValueDef valueDef) {
        if (valueDef instanceof AttributeValueReferenceDef) {
            return this._getValueObjectCreatedPort((AttributeValueReferenceDef)valueDef);
        }
        if (valueDef instanceof ObjectCreation) {
            return this._getValueObjectCreatedPort((ObjectCreation)valueDef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(valueDef).toString());
    }

    public Variable generateInputVariable(SIB sib, InputPort inputPort) {
        if (inputPort instanceof ComplexInputPort) {
            return this._generateInputVariable(sib, (ComplexInputPort)inputPort);
        }
        if (inputPort instanceof PrimitiveInputPort) {
            return this._generateInputVariable(sib, (PrimitiveInputPort)inputPort);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(sib, inputPort).toString());
    }
}

