/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class PairwiseIterable<L, R>
implements Iterable<Pair<L, R>> {
    private final Iterable<L> left;
    private final Iterable<R> right;
    private final Fill fill;

    public PairwiseIterable(Iterable<L> left, Iterable<R> right) {
        this.left = left;
        this.right = right;
        this.fill = Fill.BOTH;
    }

    public PairwiseIterable(Iterable<L> left, Iterable<R> right, Fill fill) {
        this.left = left;
        this.right = right;
        this.fill = fill;
    }

    @Override
    public Iterator<Pair<L, R>> iterator() {
        return new PairwiseIterator(this);
    }

    public static enum Fill {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }

    @Data
    public static class Pair<L, R> {
        private final L left;
        private final R right;
        private final boolean leftIsEmpty;
        private final boolean rightIsEmpty;
        private final int index;

        public Pair(L left, R right, boolean leftIsEmpty, boolean rightIsEmpty, int index) {
            this.left = left;
            this.right = right;
            this.leftIsEmpty = leftIsEmpty;
            this.rightIsEmpty = rightIsEmpty;
            this.index = index;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            result = 31 * result + (this.leftIsEmpty ? 1231 : 1237);
            result = 31 * result + (this.rightIsEmpty ? 1231 : 1237);
            return 31 * result + this.index;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.right == null ? other.right != null : !this.right.equals(other.right)) {
                return false;
            }
            if (other.leftIsEmpty != this.leftIsEmpty) {
                return false;
            }
            if (other.rightIsEmpty != this.rightIsEmpty) {
                return false;
            }
            return other.index == this.index;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("left", this.left);
            b.add("right", this.right);
            b.add("leftIsEmpty", (Object)this.leftIsEmpty);
            b.add("rightIsEmpty", (Object)this.rightIsEmpty);
            b.add("index", (Object)this.index);
            return b.toString();
        }

        @Pure
        public L getLeft() {
            return this.left;
        }

        @Pure
        public R getRight() {
            return this.right;
        }

        @Pure
        public boolean isLeftIsEmpty() {
            return this.leftIsEmpty;
        }

        @Pure
        public boolean isRightIsEmpty() {
            return this.rightIsEmpty;
        }

        @Pure
        public int getIndex() {
            return this.index;
        }
    }

    public static class PairwiseIterator<L, R>
    implements Iterator<Pair<L, R>> {
        private final Iterator<L> left;
        private final Iterator<R> right;
        private final Fill fill;
        private int index;

        public PairwiseIterator(PairwiseIterable<L, R> iterable) {
            this.left = iterable.left.iterator();
            this.right = iterable.right.iterator();
            this.fill = iterable.fill;
            this.index = -1;
        }

        @Override
        public boolean hasNext() {
            boolean _switchResult = false;
            Fill fill = this.fill;
            if (fill != null) {
                switch (fill) {
                    case NONE: {
                        _switchResult = this.left.hasNext() && this.right.hasNext();
                        break;
                    }
                    case LEFT: {
                        _switchResult = this.left.hasNext();
                        break;
                    }
                    case RIGHT: {
                        _switchResult = this.right.hasNext();
                        break;
                    }
                    case BOTH: {
                        _switchResult = this.left.hasNext() || this.right.hasNext();
                        break;
                    }
                }
            }
            return _switchResult;
        }

        @Override
        public Pair<L, R> next() {
            boolean _not;
            Pair<Object, Object> _xblockexpression = null;
            boolean _hasNext = this.hasNext();
            boolean bl = _not = !_hasNext;
            if (_not) {
                throw new NoSuchElementException();
            }
            boolean leftHasNext = this.left.hasNext();
            boolean rightHasNext = this.right.hasNext();
            Object _xifexpression = null;
            _xifexpression = leftHasNext ? (Object)this.left.next() : null;
            Object leftItem = _xifexpression;
            Object _xifexpression_1 = null;
            _xifexpression_1 = rightHasNext ? (Object)this.right.next() : null;
            Object rightItem = _xifexpression_1;
            int _index = this.index;
            this.index = _index + 1;
            _xblockexpression = new Pair<Object, Object>(leftItem, rightItem, leftHasNext, rightHasNext, this.index);
            return _xblockexpression;
        }
    }
}

