/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class CrossProductIterable<L, R>
implements Iterable<Pair<L, R>> {
    private final Iterable<L> left;
    private final Iterable<R> right;

    public CrossProductIterable(Iterable<L> left, Iterable<R> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Iterator<Pair<L, R>> iterator() {
        return new CrossProductIterator(this);
    }

    public static class CrossProductIterator<L, R>
    implements Iterator<Pair<L, R>> {
        private final Iterable<L> leftIterable;
        private final Iterable<R> rightIterable;
        private Iterator<L> leftIterator;
        private Iterator<R> rightIterator;
        private int index;
        private int leftIndex;
        private int rightIndex;
        private L leftItem;
        private R rightItem;
        private final boolean isEmpty;

        public CrossProductIterator(CrossProductIterable<L, R> iterable) {
            this.leftIterable = iterable.left;
            this.rightIterable = iterable.right;
            this.leftIterator = this.leftIterable.iterator();
            this.rightIterator = this.rightIterable.iterator();
            this.index = -1;
            this.leftIndex = -1;
            this.rightIndex = -1;
            this.leftItem = null;
            this.rightItem = null;
            this.isEmpty = !this.leftIterator.hasNext() || !this.rightIterator.hasNext();
        }

        @Override
        public boolean hasNext() {
            return !this.isEmpty && (this.leftIterator.hasNext() || this.rightIterator.hasNext());
        }

        @Override
        public Pair<L, R> next() {
            boolean _not;
            Pair<L, R> _xblockexpression = null;
            boolean _hasNext = this.hasNext();
            boolean bl = _not = !_hasNext;
            if (_not) {
                throw new NoSuchElementException();
            }
            if (this.index == -1) {
                int _index = this.index;
                this.index = _index + 1;
                int _leftIndex = this.leftIndex;
                this.leftIndex = _leftIndex + 1;
                int _rightIndex = this.rightIndex;
                this.rightIndex = _rightIndex + 1;
                this.leftItem = this.leftIterator.next();
                this.rightItem = this.rightIterator.next();
            } else {
                boolean _not_1;
                boolean _hasNext_1 = this.rightIterator.hasNext();
                boolean bl2 = _not_1 = !_hasNext_1;
                if (_not_1) {
                    this.leftItem = this.leftIterator.next();
                    int _leftIndex_1 = this.leftIndex;
                    this.leftIndex = _leftIndex_1 + 1;
                    this.rightIterator = this.rightIterable.iterator();
                    this.rightIndex = -1;
                }
                this.rightItem = this.rightIterator.next();
                int _rightIndex_1 = this.rightIndex;
                this.rightIndex = _rightIndex_1 + 1;
                int _index_1 = this.index;
                this.index = _index_1 + 1;
            }
            _xblockexpression = new Pair<L, R>(this.leftItem, this.rightItem, this.index, this.leftIndex, this.rightIndex);
            return _xblockexpression;
        }
    }

    @Data
    public static class Pair<L, R> {
        private final L left;
        private final R right;
        private final int index;
        private final int leftIndex;
        private final int rightIndex;

        public Pair(L left, R right, int index, int leftIndex, int rightIndex) {
            this.left = left;
            this.right = right;
            this.index = index;
            this.leftIndex = leftIndex;
            this.rightIndex = rightIndex;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            result = 31 * result + this.index;
            result = 31 * result + this.leftIndex;
            return 31 * result + this.rightIndex;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.right == null ? other.right != null : !this.right.equals(other.right)) {
                return false;
            }
            if (other.index != this.index) {
                return false;
            }
            if (other.leftIndex != this.leftIndex) {
                return false;
            }
            return other.rightIndex == this.rightIndex;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("left", this.left);
            b.add("right", this.right);
            b.add("index", (Object)this.index);
            b.add("leftIndex", (Object)this.leftIndex);
            b.add("rightIndex", (Object)this.rightIndex);
            return b.toString();
        }

        @Pure
        public L getLeft() {
            return this.left;
        }

        @Pure
        public R getRight() {
            return this.right;
        }

        @Pure
        public int getIndex() {
            return this.index;
        }

        @Pure
        public int getLeftIndex() {
            return this.leftIndex;
        }

        @Pure
        public int getRightIndex() {
            return this.rightIndex;
        }
    }
}

