/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.test.performance;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.event.hub.Context;
import de.jabc.cinco.meta.core.event.hub.impl.CompositeContext;
import de.jabc.cinco.meta.core.event.hub.impl.RegexContext;
import de.jabc.cinco.meta.core.event.util.CrossProductIterable;
import de.jabc.cinco.meta.core.event.util.EventCoreExtension;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Before;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="performance")
public class ContextPerformanceTest {
    @Extension
    private EventCoreExtension _eventCoreExtension = new EventCoreExtension();
    private static final int noOfTests = 4;
    private static final int repetitions = 1000000;
    private static final int maxProgress = 4000000;
    private static long timer;
    private static int progress;
    private static String resultText;
    private static String[] testData;
    private static CompositeContext[] compositeContexts;
    private static RegexContext[] regexContexts;

    @BeforeAll
    public static void beforeAll() {
        progress = 0;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("================================================================");
        _builder.newLine();
        _builder.append("ContextPerformanceTest results:");
        _builder.newLine();
        resultText = _builder.toString();
        testData = new String[]{"hello.world", "hello.disney.world", "hello.*.world", "hello.**.world", "hell*.***..world*.**"};
        Functions.Function1<String, CompositeContext> _function = new Functions.Function1<String, CompositeContext>(){

            public CompositeContext apply(String it) {
                return new CompositeContext(it);
            }
        };
        compositeContexts = (CompositeContext[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)testData)), (Functions.Function1)_function), CompositeContext.class);
        Functions.Function1<String, RegexContext> _function_1 = new Functions.Function1<String, RegexContext>(){

            public RegexContext apply(String it) {
                String _replaceAll = it.replaceAll("\\*", "\\\\*");
                return new RegexContext(_replaceAll);
            }
        };
        regexContexts = (RegexContext[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)testData)), (Functions.Function1)_function_1), RegexContext.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("================================================================");
        _builder_1.newLine();
        _builder_1.append("ContextPerformanceTest progress:");
        _builder_1.newLine();
        _builder_1.append("----------------------------------------------------------------");
        _builder_1.newLine();
        InputOutput.print((Object)_builder_1.toString());
    }

    @Before
    public void before() {
        this.resetTimer();
    }

    @AfterAll
    public static void afterAll() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(resultText);
        _builder.newLineIfNotEmpty();
        _builder.append("================================================================");
        _builder.newLine();
        InputOutput.println((Object)_builder.toString());
    }

    @Test
    public void testConstructor() {
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                new CompositeContext(it);
            }
        };
        Pair<String, Long> _repeatConstructor = this.repeatConstructor("CompositeContext", (Procedures.Procedure1<? super String>)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                String _replaceAll = it.replaceAll("\\*", "\\\\*");
                new RegexContext(_replaceAll);
            }
        };
        Pair<String, Long> _repeatConstructor_1 = this.repeatConstructor("RegexContext", (Procedures.Procedure1<? super String>)_function_1);
        Map<String, Long> map = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_repeatConstructor, _repeatConstructor_1}));
        int _size = ((List)Conversions.doWrapArray((Object)testData)).size();
        int _multiply = _size * 1000000;
        this.appendResults("testConstructor", _multiply, map);
    }

    @Test
    public void testMatches() {
        Pair<String, Long> _repeatMatches = this.repeatMatches("CompositeContext", (Iterable)Conversions.doWrapArray((Object)compositeContexts));
        Pair<String, Long> _repeatMatches_1 = this.repeatMatches("RegexContext", (Iterable)Conversions.doWrapArray((Object)regexContexts));
        Map<String, Long> map = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_repeatMatches, _repeatMatches_1}));
        int _size = ((List)Conversions.doWrapArray((Object)testData)).size();
        int _size_1 = ((List)Conversions.doWrapArray((Object)testData)).size();
        int _multiply = _size * _size_1;
        int _multiply_1 = _multiply * 1000000;
        this.appendResults("testMatches", _multiply_1, map);
    }

    private Pair<String, Long> repeatConstructor(String name, Procedures.Procedure1<? super String> constructor) {
        this.resetTimer();
        int i = 0;
        while (i <= 1000000) {
            String[] stringArray = testData;
            int n = testData.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)i);
                _builder.append(".");
                _builder.append(str);
                constructor.apply((Object)_builder.toString());
                ++n2;
            }
            this.printProgress();
            ++i;
        }
        long _time = this.getTime();
        return Pair.of((Object)name, (Object)_time);
    }

    private Pair<String, Long> repeatMatches(String name, Iterable<? extends Context> contexts) {
        this.resetTimer();
        int i = 0;
        while (i <= 1000000) {
            CrossProductIterable<? extends Context, ? extends Context> _crossProduct = this._eventCoreExtension.crossProduct(contexts);
            for (CrossProductIterable.Pair<? extends Context, ? extends Context> pair : _crossProduct) {
                Context _left = pair.getLeft();
                Context _right = pair.getRight();
                this._eventCoreExtension.operator_spaceship(_left, _right);
            }
            this.printProgress();
            ++i;
        }
        long _time = this.getTime();
        return Pair.of((Object)name, (Object)_time);
    }

    private void resetTimer() {
        timer = System.currentTimeMillis();
    }

    private long getTime() {
        long _currentTimeMillis = System.currentTimeMillis();
        return _currentTimeMillis - timer;
    }

    private void printProgress() {
        long _minus;
        long pausedTimer = this.getTime();
        int _progress = progress;
        if (100 * (progress = _progress + 1) % 4000000 == 0) {
            int progressPercent = 100 * progress / 4000000;
            StringConcatenation _builder = new StringConcatenation();
            if (progressPercent < 10) {
                _builder.append(" ");
            }
            _builder.append((Object)progressPercent);
            _builder.append("% ");
            InputOutput.print((Object)_builder.toString());
        }
        if (10 * progress % 4000000 == 0) {
            InputOutput.println();
        }
        long _currentTimeMillis = System.currentTimeMillis();
        timer = _minus = _currentTimeMillis - pausedTimer;
    }

    private int percent(long a, long b) {
        double _doubleValue = Long.valueOf(a).doubleValue();
        double _doubleValue_1 = Long.valueOf(b).doubleValue();
        double _divide = _doubleValue / _doubleValue_1;
        double _multiply = _divide * 100.0;
        return (int)_multiply;
    }

    private String justifyBefore(String str, int length) {
        StringConcatenation _builder = new StringConcatenation();
        int _length = str.length();
        int _minus = length - _length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append(" ");
        }
        _builder.append(str);
        return _builder.toString();
    }

    private String justifyAfter(String str, int length) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(str);
        int _length = str.length();
        int _minus = length - _length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append(" ");
        }
        return _builder.toString();
    }

    private void appendResults(String name, int iterations, Map<String, Long> map) {
        Functions.Function1<String, Integer> _function = new Functions.Function1<String, Integer>(){

            public Integer apply(String it) {
                return it.length();
            }
        };
        int longestName = Math.max(20, (Integer)IterableExtensions.max((Iterable)IterableExtensions.map(map.keySet(), (Functions.Function1)_function)));
        Functions.Function1<Long, Integer> _function_1 = new Functions.Function1<Long, Integer>(){

            public Integer apply(Long it) {
                return it.toString().length();
            }
        };
        int longestTime = Math.max(Integer.valueOf(iterations).toString().length(), (Integer)IterableExtensions.max((Iterable)IterableExtensions.map(map.values(), (Functions.Function1)_function_1)));
        Long minRuntime = (Long)IterableExtensions.min(map.values());
        String _resultText = resultText;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("----------------------------------------------------------------");
        _builder.newLine();
        _builder.append(name);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _justifyAfter = this.justifyAfter("Iterations per class", longestName);
        _builder.append(_justifyAfter, "\t");
        _builder.append(" ");
        _builder.append((Object)iterations, "\t");
        _builder.newLineIfNotEmpty();
        Set<Map.Entry<String, Long>> _entrySet = map.entrySet();
        for (Map.Entry<String, Long> it : _entrySet) {
            _builder.append("\t");
            String _justifyAfter_1 = this.justifyAfter(it.getKey(), longestName);
            _builder.append(_justifyAfter_1, "\t");
            _builder.append(" ");
            String _justifyBefore = this.justifyBefore(it.getValue().toString(), longestTime);
            _builder.append(_justifyBefore, "\t");
            _builder.append(" ms (");
            int _percent = this.percent(it.getValue(), minRuntime);
            _builder.append((Object)_percent, "\t");
            _builder.append(" %)");
            Long _value = it.getValue();
            boolean _equals = Objects.equal((Object)minRuntime, (Object)_value);
            if (_equals) {
                _builder.append(" - BEST");
            }
            _builder.newLineIfNotEmpty();
        }
        resultText = String.valueOf(_resultText) + _builder;
    }
}

