/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.test;

import de.jabc.cinco.meta.core.event.hub.Context;
import de.jabc.cinco.meta.core.event.hub.EventHub;
import de.jabc.cinco.meta.core.event.hub.Subscriber;
import de.jabc.cinco.meta.core.event.hub.impl.CompositeContext;
import de.jabc.cinco.meta.core.event.hub.impl.PayloadSubscriber;
import de.jabc.cinco.meta.core.event.hub.impl.SimpleSubscriber;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubscriberTest {
    private static final List<String> IDENTIFIERS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"*", "hello", "hello.*", "hello.world", "hello.*.*", "hello.*.world", "hello.my.world", "hello.disney.world"}));
    private List<Subscriber> subscribers;

    @BeforeEach
    public void before() {
        Consumer<Subscriber> _function = new Consumer<Subscriber>(){

            @Override
            public void accept(Subscriber it) {
                it.unsubscribe();
            }
        };
        ((List)Conversions.doWrapArray((Object)EventHub.getInstance().getSubscribers())).forEach(_function);
        this.subscribers = CollectionLiterals.newArrayList();
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(final String value) {
                CompositeContext _compositeContext = new CompositeContext(value);
                SubscriberTest.this.subscribers.add(new Subscriber(_compositeContext){

                    @Override
                    public void execute(Context receivedContext) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("anonomous Subscriber(\"");
                        _builder.append(value);
                        _builder.append("\") received ");
                        _builder.append((Object)receivedContext);
                        InputOutput.println((Object)_builder.toString());
                    }
                });
                Procedures.Procedure1<Context> _function = new Procedures.Procedure1<Context>(){

                    public void apply(Context receivedContext) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("    ");
                        _builder.append("SimpleSubscriber(\"");
                        _builder.append(value, "    ");
                        _builder.append("\") received ");
                        _builder.append((Object)receivedContext, "    ");
                        InputOutput.println((Object)_builder.toString());
                    }
                };
                SimpleSubscriber<Context> _simpleSubscriber = new SimpleSubscriber<Context>(value, _function);
                SubscriberTest.this.subscribers.add(_simpleSubscriber);
                Functions.Function1<Object, String> _function_1 = new Functions.Function1<Object, String>(){

                    public String apply(Object receivedPayload) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("   ");
                        _builder.append("PayloadSubscriber(\"");
                        _builder.append(value, "   ");
                        _builder.append("\") received ");
                        _builder.append(receivedPayload, "   ");
                        return (String)InputOutput.println((Object)_builder.toString());
                    }
                };
                PayloadSubscriber<Object, String> _payloadSubscriber = new PayloadSubscriber<Object, String>(value, _function_1);
                SubscriberTest.this.subscribers.add(_payloadSubscriber);
            }
        };
        IDENTIFIERS.forEach(_function_1);
    }

    @Test
    public void testSubscribeAndUnsubscribe() {
        final EventHub hub = EventHub.getInstance();
        Consumer<Subscriber> _function = new Consumer<Subscriber>(){

            @Override
            public void accept(Subscriber sub) {
                Assertions.assertFalse((boolean)sub.isSubscribed());
                Assertions.assertFalse((boolean)hub.hasSubscriber(sub));
                Assertions.assertTrue((boolean)sub.subscribe());
                Assertions.assertFalse((boolean)sub.subscribe());
                Assertions.assertTrue((boolean)sub.isSubscribed());
                Assertions.assertTrue((boolean)hub.hasSubscriber(sub));
                Assertions.assertTrue((boolean)sub.unsubscribe());
                Assertions.assertFalse((boolean)sub.unsubscribe());
                Assertions.assertFalse((boolean)sub.isSubscribed());
                Assertions.assertFalse((boolean)hub.hasSubscriber(sub));
            }
        };
        this.subscribers.forEach(_function);
    }
}

