/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.test;

import de.jabc.cinco.meta.core.event.hub.Context;
import de.jabc.cinco.meta.core.event.hub.EventHub;
import de.jabc.cinco.meta.core.event.hub.Subscriber;
import de.jabc.cinco.meta.core.event.hub.impl.CompositeContext;
import de.jabc.cinco.meta.core.event.hub.impl.PayloadContext;
import de.jabc.cinco.meta.core.event.util.EventCoreExtension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventHubTest {
    @Extension
    private EventCoreExtension _eventCoreExtension = new EventCoreExtension();
    private static ArrayList<Subscriber> expectedOrder;
    private static ArrayList<Subscriber> actualOrder;
    private static int expectedPayload;

    @Test
    public void testSubscribeNotifyUnsubscribe() {
        this.testSubscribe(null);
        this.testSubscribe("");
        Subscriber abc = this.testSubscribe("a.b.c");
        Subscriber abcd = this.testSubscribe("a.b.c.d");
        Subscriber abx = this.testSubscribe("a.b.x");
        Subscriber ab_ = this.testSubscribe("a.b.*");
        Subscriber a_c = this.testSubscribe("a.*.c");
        this.testNotify(null, new Subscriber[0]);
        this.testNotify("", new Subscriber[0]);
        this.testNotify("hello.world", new Subscriber[0]);
        this.testNotify("a.b.c", abc, ab_, a_c);
        this.testNotify("a.b.c.d", abcd);
        this.testNotify("a.b.x", abx, ab_);
        this.testNotify("a.b.*", abc, abx, ab_, a_c);
        this.testNotify("a.*.c", abc, ab_, a_c);
        this.testUnsubscribe(abc);
        this.testUnsubscribe(abx);
        this.testNotify(null, new Subscriber[0]);
        this.testNotify("", new Subscriber[0]);
        this.testNotify("hello.world", new Subscriber[0]);
        this.testNotify("a.b.c", ab_, a_c);
        this.testNotify("a.b.c.d", abcd);
        this.testNotify("a.b.x", ab_);
        this.testNotify("a.b.*", ab_, a_c);
        this.testNotify("a.*.c", ab_, a_c);
    }

    @Test
    public void testNotifyFirst() {
        actualOrder = CollectionLiterals.newArrayList();
        CompositeContext context = new CompositeContext("hello.world");
        int highestPrioritiy = Integer.MIN_VALUE;
        Subscriber highestSub = null;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, 100, true);
        for (Integer i : _doubleDotLessThan) {
            int priority = ThreadLocalRandom.current().nextInt();
            Subscriber sub = new Subscriber(context, priority){

                @Override
                public void execute(Context context) {
                    actualOrder.add(this);
                }
            };
            sub.subscribe();
            if (priority <= highestPrioritiy) continue;
            highestPrioritiy = priority;
            highestSub = sub;
        }
        Assertions.assertFalse((boolean)this._eventCoreExtension.notifyFirst("bye.bye"));
        Assertions.assertTrue((boolean)this._eventCoreExtension.notifyFirst(context));
        Assertions.assertEquals((int)1, (int)actualOrder.size());
        Assertions.assertEquals(highestSub, (Object)IterableExtensions.head(actualOrder));
    }

    private Subscriber testSubscribe(String context) {
        CompositeContext compositeContext = new CompositeContext(context);
        int randomPriority = ThreadLocalRandom.current().nextInt();
        Subscriber sub = new Subscriber(compositeContext, randomPriority){

            @Override
            public void execute(Context context) {
                Assertions.assertNotNull((Object)context);
                Assertions.assertTrue((boolean)(context instanceof PayloadContext));
                PayloadContext payloadContext = (PayloadContext)context;
                Assertions.assertTrue((boolean)payloadContext.hasPayload());
                Object _payload = payloadContext.getPayload();
                Assertions.assertTrue((boolean)(_payload instanceof Integer));
                Object _payload_1 = payloadContext.getPayload();
                Assertions.assertEquals((int)expectedPayload, (Integer)((Integer)_payload_1));
                actualOrder.add(this);
            }
        };
        Assertions.assertFalse((boolean)sub.isSubscribed());
        Assertions.assertFalse((boolean)EventHub.getInstance().hasSubscriber(sub));
        Assertions.assertTrue((boolean)sub.subscribe());
        Assertions.assertTrue((boolean)sub.isSubscribed());
        Assertions.assertTrue((boolean)EventHub.getInstance().hasSubscriber(sub));
        return sub;
    }

    private void testUnsubscribe(Subscriber sub) {
        Assertions.assertTrue((boolean)sub.isSubscribed());
        Assertions.assertTrue((boolean)EventHub.getInstance().hasSubscriber(sub));
        Assertions.assertTrue((boolean)sub.unsubscribe());
        Assertions.assertFalse((boolean)sub.isSubscribed());
        Assertions.assertFalse((boolean)EventHub.getInstance().hasSubscriber(sub));
    }

    private void testNotify(String context, Subscriber ... expectedSubscribers) {
        expectedOrder = CollectionLiterals.newArrayList();
        actualOrder = CollectionLiterals.newArrayList();
        expectedPayload = ThreadLocalRandom.current().nextInt();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)expectedSubscribers)));
        boolean _not = !_isNullOrEmpty;
        Assertions.assertEquals((Object)_not, (Object)this._eventCoreExtension.notify(context, expectedPayload));
        Consumer<Subscriber> _function = new Consumer<Subscriber>(){

            @Override
            public void accept(Subscriber sub) {
                expectedOrder.add(sub);
            }
        };
        ((List)Conversions.doWrapArray((Object)expectedSubscribers)).forEach(_function);
        Comparator<Subscriber> _function_1 = new Comparator<Subscriber>(){

            @Override
            public int compare(Subscriber left, Subscriber right) {
                return right.getPriority().compareTo(left.getPriority());
            }
        };
        expectedOrder.sort(_function_1);
        Assertions.assertEquals((int)expectedOrder.size(), (int)actualOrder.size());
        Assertions.assertEquals(expectedOrder, actualOrder);
    }
}

