/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.test;

import de.jabc.cinco.meta.core.event.hub.impl.CompositeContext;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CompositeContextTest {
    @Test
    public void testConstructor() {
        CompositeContext empty = new CompositeContext(null);
        CompositeContext abc = new CompositeContext("a.b.c");
        CompositeContext ab_ = new CompositeContext("a.b.*");
        this.doesEqualCon(empty, empty);
        this.doesNotEqualCon(empty, abc);
        this.doesEqualCon(abc, abc);
        this.doesNotEqualCon(abc, ab_);
        this.doesEqualStr(empty, null);
        this.doesEqualStr(empty, "");
        this.doesEqualStr(empty, ".");
        this.doesEqualStr(empty, "..");
        this.doesEqualStr(empty, null, null);
        this.doesEqualStr(empty, null, "");
        this.doesEqualStr(empty, null, ".");
        this.doesEqualStr(empty, null, "..");
        this.doesEqualStr(empty, "", null);
        this.doesEqualStr(empty, "", "");
        this.doesEqualStr(empty, "", ".");
        this.doesEqualStr(empty, "", "..");
        this.doesEqualStr(empty, ".", null);
        this.doesEqualStr(empty, ".", "");
        this.doesEqualStr(empty, ".", ".");
        this.doesEqualStr(empty, ".", "..");
        this.doesEqualStr(empty, "..", null);
        this.doesEqualStr(empty, "..", "");
        this.doesEqualStr(empty, "..", ".");
        this.doesEqualStr(empty, "..", "..");
        this.doesEqualStr(abc, "a", "b", "c");
        this.doesEqualStr(abc, "a.b", "c");
        this.doesEqualStr(abc, "a.b.", "c");
        this.doesEqualStr(abc, "a..b", ".c");
        this.doesEqualStr(abc, "a.b.", null, ".c");
        this.doesEqualStr(abc, "a.b.", "", ".c");
    }

    @Test
    public void testMatches() {
        this.doesMatch("a.b.c", "a.b.c");
        this.doesNotMatch("a.b.c", "a.b.d");
        this.doesMatch("a.b.*", "a.b.c");
        this.doesMatch("a.b.c", "a.b.*");
        this.doesMatch("a.*.c", "a.b.c");
        this.doesMatch("a.b.c", "a.*.c");
        this.doesNotMatch("a.*", "a.b.c");
        this.doesNotMatch("a.b.c", "a.*");
        this.doesNotMatch("a.*.b", "a.b");
        this.doesNotMatch("a.b", "a.*.b");
        this.doesNotMatch("a.b.c", "a.b");
        this.doesNotMatch("a.b", "a.b.c");
        this.doesNotMatch("a.b.*", "a.b");
        this.doesNotMatch("a.b", "a.b.*");
        this.doesNotMatch("a.b.c", "");
        this.doesNotMatch("", "a.b.c");
        this.doesNotMatch("*", "");
        this.doesNotMatch("", "*");
    }

    @Test
    public void testAppend() {
        CompositeContext empty = new CompositeContext(null);
        CompositeContext abc = new CompositeContext("a.b.c");
        CompositeContext abcd = abc.append("d");
        CompositeContext abcdef = abc.append("d.e", "f");
        CompositeContext abcabcd = abc.append((String[])Conversions.unwrapArray((Object)abcd, String.class));
        CompositeContext abcabcdabcdef = abc.append(abcd.getIdentifier(), abcdef.getIdentifier());
        this.doesEqualStr(abc, "a.b.c");
        this.doesEqualStr(abcd, "a.b.c.d");
        this.doesEqualStr(abcdef, "a.b.c.d.e.f");
        this.doesEqualStr(abcabcd, "a.b.c.a.b.c.d");
        this.doesEqualStr(abcabcdabcdef, "a.b.c.a.b.c.d.a.b.c.d.e.f");
        this.doesEqualCon(abcabcdabcdef, abc.append("a.b.c.d", null, "a.b.c.d.e.f"));
        this.doesEqualCon(abcabcdabcdef, abc.append("a.b.c.d", "", "a.b.c.d.e.f"));
        this.doesEqualCon(abcabcdabcdef, abc.append("a..b.c.d.", "", ".a.b.", null, "c..d.e.f."));
        this.doesEqualCon(abcabcdabcdef, abc.append(abcd.getIdentifier(), null, abcdef.getIdentifier()));
        this.doesEqualCon(abcabcdabcdef, abc.append(abcd.getIdentifier(), empty.getIdentifier(), abcdef.getIdentifier()));
    }

    @Test
    public void testIterator() {
        List<String> abc = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"a", "b", "c"}));
        this.doesEqualIte(abc, "a.b.c");
        this.doesEqualIte(abc, "a", "b", "c");
        this.doesEqualIte(abc, "a.b", "c");
        this.doesEqualIte(abc, "a.b.", "c");
        this.doesEqualIte(abc, "a..b", ".c");
        this.doesEqualIte(abc, "a.b.", null, ".c");
        this.doesEqualIte(abc, "a.b.", "", ".c");
        this.isEmpty(null);
        this.isEmpty("");
        this.isNotEmpty("*");
        this.isNotEmpty("a.b.c");
        this.isNotEmpty("a.b.c", "*");
        this.isNotEmpty("a.b.c", null, "*");
        this.isNotEmpty("a..b", "", ".c.", null, "*.");
        this.isLength(0, null);
        this.isLength(0, "");
        this.isLength(1, "*");
        this.isLength(3, "a.b.c");
        this.isLength(4, "a.b.c", "*");
        this.isLength(4, "a.b.c", null, "*");
        this.isLength(4, "a..b", "", ".c.", null, "*.");
        final CompositeContext abc_ = new CompositeContext("a..b", "", ".c.", null, "*.");
        Executable _function = new Executable(){

            public void execute() throws Throwable {
                abc_.get(-1);
            }
        };
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)_function);
        Assertions.assertEquals((Object)"a", (Object)abc_.get(0));
        Assertions.assertEquals((Object)"b", (Object)abc_.get(1));
        Assertions.assertEquals((Object)"c", (Object)abc_.get(2));
        Assertions.assertEquals((Object)"*", (Object)abc_.get(3));
        Executable _function_1 = new Executable(){

            public void execute() throws Throwable {
                abc_.get(4);
            }
        };
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)_function_1);
    }

    @Test
    public void testGetIdentifier() {
        this.isString("", null);
        this.isString("", "");
        this.isString("a.b.c", "a", "b", "c");
        this.isString("a.b.c", "a.b.c");
        this.isString("a.b.c.*", "a.b.c", "*");
        this.isString("a.b.c.*", "a.b.c", null, "*");
        this.isString("a.b.c.*", "a.b", "", ".c", null, "*");
        this.isString("a.b.c.*", ".a..b.", ".", ".c", null, ".*");
    }

    private void doesEqualStr(CompositeContext left, String ... right) {
        CompositeContext r = new CompositeContext(right);
        boolean _equals = left.operator_equals(r);
        Assertions.assertTrue((boolean)_equals);
        Assertions.assertTrue((boolean)left.equals(r));
        boolean _equals_1 = r.operator_equals(left);
        Assertions.assertTrue((boolean)_equals_1);
        Assertions.assertTrue((boolean)r.equals(left));
    }

    private void doesEqualCon(CompositeContext left, CompositeContext right) {
        boolean _equals = left.operator_equals(right);
        Assertions.assertTrue((boolean)_equals);
        Assertions.assertTrue((boolean)left.equals(right));
        boolean _equals_1 = right.operator_equals(left);
        Assertions.assertTrue((boolean)_equals_1);
        Assertions.assertTrue((boolean)right.equals(left));
    }

    private void doesNotEqualCon(CompositeContext left, CompositeContext right) {
        boolean _equals = left.operator_equals(right);
        Assertions.assertFalse((boolean)_equals);
        Assertions.assertFalse((boolean)left.equals(right));
        boolean _equals_1 = right.operator_equals(left);
        Assertions.assertFalse((boolean)_equals_1);
        Assertions.assertFalse((boolean)right.equals(left));
    }

    private void doesEqualIte(Iterable<String> left, String ... right) {
        CompositeContext _compositeContext = new CompositeContext(right);
        Assertions.assertIterableEquals(left, (Iterable)_compositeContext);
    }

    private void isEmpty(String ... context) {
        Assertions.assertTrue((boolean)new CompositeContext(context).isEmpty());
    }

    private void isNotEmpty(String ... context) {
        Assertions.assertFalse((boolean)new CompositeContext(context).isEmpty());
    }

    private void isLength(int length, String ... context) {
        Assertions.assertEquals((int)length, (int)new CompositeContext(context).length());
    }

    private void isString(String str, String ... context) {
        Assertions.assertEquals((Object)str, (Object)new CompositeContext(context).getIdentifier());
    }

    private void doesMatch(String left, String right) {
        CompositeContext l = new CompositeContext(left);
        CompositeContext r = new CompositeContext(right);
        Assertions.assertTrue((boolean)l.matches(r));
        Assertions.assertTrue((boolean)r.matches(l));
    }

    private void doesNotMatch(String left, String right) {
        CompositeContext l = new CompositeContext(left);
        CompositeContext r = new CompositeContext(right);
        Assertions.assertFalse((boolean)l.matches(r));
        Assertions.assertFalse((boolean)r.matches(l));
    }
}

