/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.hub.impl;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.event.hub.Subscriber;
import de.jabc.cinco.meta.core.event.hub.impl.CompositeContext;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors(value={AccessorType.PUBLIC_GETTER})
public class PayloadContext<P, R>
extends CompositeContext {
    private final P payload;
    private Map<Subscriber, R> results;

    public PayloadContext(String identifiers, P payload) {
        super(identifiers);
        this.payload = payload;
    }

    public PayloadContext(String[] identifiers, P payload) {
        super(identifiers);
        this.payload = payload;
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public boolean hasResult() {
        return this.results != null && !this.results.isEmpty();
    }

    public boolean addResult(Subscriber sub, R result) {
        boolean _containsKey;
        if (this.results == null) {
            this.results = CollectionLiterals.newLinkedHashMap();
        }
        if (_containsKey = this.results.containsKey(sub)) {
            return false;
        }
        this.results.put(sub, result);
        return true;
    }

    public R getFirstResult() {
        boolean _hasResult = this.hasResult();
        if (_hasResult) {
            Subscriber highestPrioSub = (Subscriber)IterableExtensions.max(this.results.keySet(), Subscriber.getPriorityComparator());
            return this.results.get(highestPrioSub);
        }
        return null;
    }

    @Override
    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = this.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append("(");
        String _debugString = this.debugString(this.getIdentifier());
        _builder.append(_debugString);
        _builder.append(", ");
        String _debugString_1 = this.debugString(this.payload);
        _builder.append(_debugString_1);
        _builder.append(")");
        return _builder.toString();
    }

    private String debugString(Object obj) {
        StringConcatenation _builder;
        String _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)obj, null)) {
            _matched = true;
            _switchResult = "null";
        }
        if (!_matched && obj instanceof String) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("\"");
            _builder.append((String)obj);
            _builder.append("\"");
            _switchResult = _builder.toString();
        }
        if (!_matched && obj instanceof Character) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("'");
            _builder.append((Object)((Character)obj));
            _builder.append("'");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            if (obj instanceof Integer) {
                _matched = true;
            }
            if (!_matched && obj instanceof Long) {
                _matched = true;
            }
            if (!_matched && obj instanceof Double) {
                _matched = true;
            }
            if (!_matched && obj instanceof Float) {
                _matched = true;
            }
            if (!_matched && obj instanceof Short) {
                _matched = true;
            }
            if (!_matched && obj instanceof Boolean) {
                _matched = true;
            }
            if (_matched) {
                _builder = new StringConcatenation();
                _builder.append(obj);
                _switchResult = _builder.toString();
            }
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _simpleName = obj.getClass().getSimpleName();
            _builder_1.append(_simpleName);
            _builder_1.append("(");
            String _string = obj.toString();
            _builder_1.append(_string);
            _builder_1.append(")");
            _switchResult = _builder_1.toString();
        }
        return _switchResult;
    }

    @Pure
    public P getPayload() {
        return this.payload;
    }

    @Pure
    public Map<Subscriber, R> getResults() {
        return this.results;
    }
}

