/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.hub;

import de.jabc.cinco.meta.core.event.hub.Context;
import de.jabc.cinco.meta.core.event.hub.EventHub;
import de.jabc.cinco.meta.core.event.hub.Priority;
import java.util.Comparator;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Accessors(value={AccessorType.PUBLIC_GETTER})
public abstract class Subscriber {
    public static final int DEFAULT_PRIORITY = 0;
    private final Context context;
    private final Priority priority;

    public Subscriber(Context context, int priority) {
        Priority _priority;
        if (context == null) {
            throw new NullPointerException("context may not be null.");
        }
        this.context = context;
        this.priority = _priority = new Priority(priority);
    }

    public Subscriber(Context context) {
        this(context, 0);
    }

    public boolean isSubscribed() {
        return EventHub.getInstance().hasSubscriber(this);
    }

    public boolean subscribe() {
        return EventHub.getInstance().subscribe(this);
    }

    public boolean unsubscribe() {
        return EventHub.getInstance().unsubscribe(this);
    }

    public boolean isNotifiedBy(Context receivedContext) {
        return receivedContext.matches(this.context);
    }

    public abstract void execute(Context var1);

    public static Comparator<Subscriber> getPriorityComparator() {
        Comparator<Subscriber> _function = new Comparator<Subscriber>(){

            @Override
            public int compare(Subscriber left, Subscriber right) {
                return left.priority.compareTo(right.priority);
            }
        };
        return _function;
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        String _className = this.getClassName();
        _builder.append(_className);
        _builder.append("(");
        _builder.append((Object)this.context);
        _builder.append(", ");
        _builder.append((Object)this.priority);
        _builder.append(")");
        return _builder.toString();
    }

    private String getClassName() {
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.getClass().getSimpleName());
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("anonymous ");
            String _simpleName = this.getClass().getSuperclass().getSimpleName();
            _builder.append(_simpleName);
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = this.getClass().getSimpleName();
        }
        return _xifexpression;
    }

    @Pure
    public Context getContext() {
        return this.context;
    }

    @Pure
    public Priority getPriority() {
        return this.priority;
    }
}

