/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.event.hub;

import de.jabc.cinco.meta.core.event.hub.Context;
import de.jabc.cinco.meta.core.event.hub.Subscriber;
import de.jabc.cinco.meta.core.event.util.EventCoreExtension;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EventHub {
    @Extension
    private EventCoreExtension _eventCoreExtension = new EventCoreExtension();
    private static EventHub instance;
    private final SortedSet<Subscriber> subscribers = CollectionLiterals.newTreeSet(Subscriber.getPriorityComparator().reversed());

    private EventHub() {
        this._eventCoreExtension.setLogging(false);
    }

    public static EventHub getInstance() {
        if (instance == null) {
            EventHub _eventHub;
            instance = _eventHub = new EventHub();
        }
        return instance;
    }

    public Subscriber[] getSubscribers() {
        return (Subscriber[])Conversions.unwrapArray(this.subscribers, Subscriber.class);
    }

    public boolean hasSubscriber(Subscriber subscriber) {
        return this.subscribers.contains(subscriber);
    }

    public boolean subscribe(Subscriber subscriber) {
        boolean _hasSubscriber = this.hasSubscriber(subscriber);
        if (_hasSubscriber) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Subscriber already subscribed: ");
            Context _context = subscriber.getContext();
            _builder.append((Object)_context);
            this._eventCoreExtension.err(this, (CharSequence)_builder);
            return false;
        }
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, 1000000, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _add = this.subscribers.add(subscriber);
            if (_add) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("New subscriber: ");
                Context _context_1 = subscriber.getContext();
                _builder_1.append((Object)_context_1);
                this._eventCoreExtension.log(this, (CharSequence)_builder_1);
                return true;
            }
            subscriber.getPriority().shuffle();
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Failed to subscribe: ");
        Context _context_2 = subscriber.getContext();
        _builder_2.append((Object)_context_2);
        this._eventCoreExtension.err(this, (CharSequence)_builder_2);
        return false;
    }

    public boolean unsubscribe(Subscriber subscriber) {
        boolean _not;
        boolean _hasSubscriber = this.hasSubscriber(subscriber);
        boolean bl = _not = !_hasSubscriber;
        if (_not) {
            return false;
        }
        boolean _remove = this.subscribers.remove(subscriber);
        return _remove;
    }

    public boolean notify(final Context context) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Notifying: ");
        _builder.append((Object)context);
        this._eventCoreExtension.log(this, (CharSequence)_builder);
        Functions.Function1<Subscriber, Boolean> _function = new Functions.Function1<Subscriber, Boolean>(){

            public Boolean apply(Subscriber it) {
                return it.isNotifiedBy(context);
            }
        };
        Iterable notifiedSubscribers = IterableExtensions.filter(this.subscribers, (Functions.Function1)_function);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)notifiedSubscribers);
        if (_isNullOrEmpty) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("No subscriber was notified");
            this._eventCoreExtension.log(this, (CharSequence)_builder_1);
            return false;
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        int _size = IterableExtensions.size((Iterable)notifiedSubscribers);
        _builder_2.append((Object)_size);
        _builder_2.append(" subscriber");
        int _size_1 = IterableExtensions.size((Iterable)notifiedSubscribers);
        boolean bl = _notEquals = _size_1 != 1;
        if (_notEquals) {
            _builder_2.append("s");
        }
        _builder_2.append(" will be notified");
        this._eventCoreExtension.log(this, (CharSequence)_builder_2);
        Consumer<Subscriber> _function_1 = new Consumer<Subscriber>(){

            @Override
            public void accept(Subscriber it) {
                it.execute(context);
            }
        };
        notifiedSubscribers.forEach(_function_1);
        return true;
    }

    public boolean notifyFirst(final Context context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Notifying first: ");
        _builder.append((Object)context);
        this._eventCoreExtension.log(this, (CharSequence)_builder);
        Functions.Function1<Subscriber, Boolean> _function = new Functions.Function1<Subscriber, Boolean>(){

            public Boolean apply(Subscriber it) {
                return it.isNotifiedBy(context);
            }
        };
        Subscriber notifiedSubscriber = (Subscriber)IterableExtensions.findFirst(this.subscribers, (Functions.Function1)_function);
        if (notifiedSubscriber == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("No subscriber was notified");
            this._eventCoreExtension.log(this, (CharSequence)_builder_1);
            return false;
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("1 subscriber will be notified");
        this._eventCoreExtension.log(this, (CharSequence)_builder_2);
        notifiedSubscriber.execute(context);
        return true;
    }

    public String toString() {
        String _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.subscribers);
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            String _simpleName = this.getClass().getSimpleName();
            _builder.append(_simpleName);
            _builder.append("()");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _simpleName_1 = this.getClass().getSimpleName();
            _builder_1.append(_simpleName_1);
            _builder_1.append("(");
            _builder_1.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (Subscriber sub : this.subscribers) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_1.appendImmediate((Object)",", "\t");
                }
                _builder_1.append("\t");
                _builder_1.append((Object)sub, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append(")");
            _builder_1.newLine();
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }
}

