/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.utils;

import de.jabc.cinco.meta.plugin.mcam.runtime.views.McamView;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.McamPage;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;

public class ResourceChangeListener
implements IResourceChangeListener {
    private final McamView<?> view;
    private Set<ListenerEvents> actualEvents;

    public ResourceChangeListener(McamView view) {
        this.view = view;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Object obj;
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IFile iFile = this.getIFileFromDelta(delta);
        if (iFile == null) {
            return;
        }
        this.getActualListenerEvents(event);
        HashSet<ListenerEvents> retainSet = new HashSet<ListenerEvents>();
        retainSet.add(ListenerEvents.CONTENT_CHANGE);
        retainSet.retainAll(this.actualEvents);
        if (retainSet.size() < 1) {
            return;
        }
        String pageId = this.view.getPageId((IResource)iFile);
        if (pageId != null && (obj = this.view.getPageMap().get(pageId)) instanceof McamPage) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((McamPage)obj).reload();
                    ResourceChangeListener.this.view.refreshView();
                }
            });
        }
    }

    private void getActualListenerEvents(IResourceChangeEvent event) {
        this.actualEvents = new HashSet<ListenerEvents>();
        switch (event.getType()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 16: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                    break;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private IFile getIFileFromDelta(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        if (iResourceDeltaArray.length != 0) {
            IResourceDelta child = iResourceDeltaArray[0];
            IResource res = child.getResource();
            if (res instanceof IFile) {
                IFile file = (IFile)res;
                return file;
            }
            return this.getIFileFromDelta(child);
        }
        return null;
    }

    public class DeltaPrinter
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: {
                    ResourceChangeListener.this.actualEvents.add(ListenerEvents.ADDED);
                    break;
                }
                case 2: {
                    ResourceChangeListener.this.actualEvents.add(ListenerEvents.REMOVED);
                    break;
                }
                case 4: {
                    int flags = delta.getFlags();
                    if ((flags & 0x100) == 0) break;
                    ResourceChangeListener.this.actualEvents.add(ListenerEvents.CONTENT_CHANGE);
                }
            }
            return true;
        }
    }

    public static enum ListenerEvents {
        ADDED,
        REMOVED,
        CONTENT_CHANGE;

    }
}

