/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.utils;

import graphmodel.GraphModel;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class EclipseUtils {
    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWizard getWizard(String id) {
        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
        }
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
        }
        try {
            if (descriptor != null) {
                IWorkbenchWizard wizard = descriptor.createWizard();
                return wizard;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IEditorPart openEditor(GraphModel model) {
        IEditorPart iEditor = null;
        URI uri = EcoreUtil.getURI((EObject)model);
        IFile iFile = null;
        Path path = null;
        if (uri.toPlatformString(true) != null) {
            path = new Path(uri.toPlatformString(true));
        }
        if (uri.toFileString() != null) {
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
            path = new Path(newFile.getFullPath().toOSString());
        }
        if (path != null) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            iEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)iFile);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return iEditor;
    }

    public static void runBusy(Runnable runnable) {
        BusyIndicator.showWhile((Display)EclipseUtils.getDisplay(), (Runnable)runnable);
    }

    public static IFile getIFile(IEditorPart editor) {
        return (IFile)editor.getEditorInput().getAdapter(IFile.class);
    }

    public static Resource getResource(IEditorPart editor) {
        EditingDomain ed = EclipseUtils.getEditingDomain(editor);
        if (ed != null) {
            return (Resource)ed.getResourceSet().getResources().get(0);
        }
        return null;
    }

    public static EditingDomain getEditingDomain(IEditorPart editor) {
        return editor instanceof DiagramEditor ? ((DiagramEditor)editor).getEditingDomain() : (editor instanceof IEditingDomainProvider ? ((IEditingDomainProvider)editor).getEditingDomain() : null);
    }

    public static File getFile(IFile iFile) {
        String path = iFile.getRawLocation().toOSString();
        return new File(path);
    }

    public static Resource getResource(IFile iFile) {
        File file = EclipseUtils.getFile(iFile);
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        return resource;
    }
}

